/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.dialog;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.runqian.base4.tool.DialogInputText;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.tool.Section;
import com.runqian.base4.util.SQLTool;
import com.runqian.datamanager.base.DataBackup;
import com.runqian.datamanager.dialog.DialogDataRecover_jBCancel_actionAdapter;
import com.runqian.datamanager.dialog.DialogDataRecover_jBRecover_actionAdapter;
import com.runqian.datamanager.dialog.DialogDataRecover_jBSelectPath_actionAdapter;
import com.runqian.datamanager.dialog.DialogDataRecover_textPath_mouseAdapter;
import com.runqian.datamanager.dialog.DialogDataRecover_this_windowAdapter;
import com.runqian.report4.ide.base.TypesEx;
import com.runqian.report4.semantics.SemanticsManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class DialogDataRecover
extends JDialog {
    BorderLayout borderLayout1;
    ButtonGroup buttonGroup1;
    Connection con;
    DataBackup[] dbs;
    GridBagLayout gridBagLayout1;
    GridBagLayout gridBagLayout2;
    GridLayout gridLayout1;
    JButton jBCancel;
    JButton jBRecover;
    JButton jBSelectPath;
    JLabel jLabel1;
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3;
    JPanel jPanel4;
    JPanel jPanel5;
    JPanel jPanel6;
    JRadioButton jRBAdd;
    JRadioButton jRBClear;
    JRadioButton jRBUpdate;
    JTextField textPath;
    TitledBorder titledBorder1;
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();

    public DialogDataRecover() {
        super(GV.appFrame, Lang.getText("dialogdatarecover.title"), true);
        this.jBRecover = new JButton();
        this.jBCancel = new JButton();
        this.jPanel3 = new JPanel();
        this.jRBAdd = new JRadioButton();
        this.jRBClear = new JRadioButton();
        this.jRBUpdate = new JRadioButton();
        this.gridLayout1 = new GridLayout();
        this.jPanel4 = new JPanel();
        this.textPath = new JTextField();
        this.jBSelectPath = new JButton();
        this.jPanel5 = new JPanel();
        this.gridBagLayout1 = new GridBagLayout();
        this.gridBagLayout2 = new GridBagLayout();
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel6 = new JPanel();
        this.borderLayout1 = new BorderLayout();
        this.jLabel1 = new JLabel();
        try {
            this.setSize(400, 190);
            this.jbInit();
            this.init();
            this.resetLangText();
            GM.setDialogDefaultButton(this, this.jBRecover, this.jBCancel);
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    private boolean arrayEqual(String[] ary1, String[] ary2) {
        if (ary1.length != ary2.length) {
            return false;
        }
        int i = 0;
        while (i < ary1.length) {
            boolean flg = false;
            int j = 0;
            while (j < ary2.length) {
                if (ary1[i].equalsIgnoreCase(ary2[j])) {
                    flg = true;
                }
                ++j;
            }
            if (!flg) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkConnection() {
        if (this.con == null) {
            String message = Lang.getText("dialogdatarecover.notconnect");
            String title = Lang.getText("public.note");
            this.showOptionDialog(message, title);
            return true;
        }
        return false;
    }

    private void doAddRecover(DataBackup db, PreparedStatement ps, Map typeMap) {
        StringBuffer sqlIns = new StringBuffer();
        StringBuffer sqlValue = new StringBuffer();
        sqlIns.append("INSERT INTO ");
        if (GM.isValidString(db.getSchema()) && GV.dsActive.isUseSchema()) {
            sqlIns.append(db.getSchema() + ".");
        }
        sqlIns.append(db.getTableName());
        sqlIns.append("( ");
        sqlValue.append(" VALUES ( ");
        int col = 0;
        while (col < db.getColNames().length) {
            String colName = db.getColNames()[col];
            if (typeMap.get(colName) != null) {
                if (col != 0) {
                    sqlIns.append(", ");
                    sqlValue.append(", ");
                }
                sqlIns.append(colName);
                sqlValue.append("? ");
            }
            ++col;
        }
        sqlIns.append(" ) ");
        sqlValue.append(" ) ");
        sqlIns.append(sqlValue.toString());
        int row = 0;
        while (row < db.getData().length) {
            try {
                ps = this.con.prepareStatement(sqlIns.toString());
                int col2 = 0;
                while (col2 < db.getColNames().length) {
                    Object o = db.getData()[row][col2];
                    String colName = db.getColNames()[col2];
                    if (typeMap.get(colName) != null) {
                        int sqlType = (Integer)typeMap.get(colName);
                        byte type = TypesEx.getDBTypeBySQLType(sqlType);
                        SQLTool.setObject(GV.dsActive.getDBType(), ps, col2 + 1, o, type);
                    }
                    ++col2;
                }
                ps.executeUpdate();
            }
            catch (SQLException ex) {}
            ++row;
        }
    }

    private boolean doClearRecover(DataBackup db, PreparedStatement ps, Map typeMap) {
        int row = 0;
        while (row < db.getData().length) {
            String colName;
            StringBuffer sqlIns = new StringBuffer();
            StringBuffer sqlWhere = new StringBuffer();
            StringBuffer sqlValue = new StringBuffer();
            StringBuffer sqlDel = new StringBuffer();
            sqlWhere.append(" WHERE ");
            sqlIns.append("INSERT INTO ");
            if (GM.isValidString(db.getSchema()) && GV.dsActive.isUseSchema()) {
                sqlIns.append(db.getSchema() + ".");
            }
            sqlIns.append(db.getTableName());
            sqlIns.append("( ");
            sqlValue.append(" VALUES ( ");
            sqlDel.append(" DELETE FROM ");
            if (GM.isValidString(db.getSchema()) && GV.dsActive.isUseSchema()) {
                sqlDel.append(db.getSchema() + ".");
            }
            sqlDel.append(db.getTableName());
            int pkCount = 0;
            int colCount = 0;
            int col = 0;
            while (col < db.getColNames().length) {
                String colName2 = db.getColNames()[col];
                if (typeMap.get(colName2) != null) {
                    if (col != 0) {
                        sqlValue.append(", ");
                        sqlIns.append(", ");
                    }
                    sqlIns.append(colName2);
                    sqlValue.append("? ");
                    if (this.isPrimaryKey(colName2, db.getPrimaryKeys())) {
                        if (pkCount != 0) {
                            sqlWhere.append(" and ");
                        }
                        ++pkCount;
                        sqlWhere.append(colName2 + " = ? ");
                    } else {
                        ++colCount;
                    }
                }
                ++col;
            }
            if (pkCount == 0) {
                GM.showException(new Exception(Lang.getText("dialogdatarecover.cantrecover")));
                return false;
            }
            sqlDel.append(sqlWhere.toString());
            sqlIns.append(" ) ");
            sqlValue.append(" ) ");
            sqlIns.append(sqlValue.toString());
            try {
                int pkIndex = 1;
                ps = this.con.prepareStatement(sqlDel.toString());
                int col2 = 0;
                while (col2 < db.getColNames().length) {
                    colName = db.getColNames()[col2];
                    Object o = db.getData()[row][col2];
                    if (typeMap.get(colName) != null) {
                        int sqlType = (Integer)typeMap.get(colName);
                        byte type = TypesEx.getDBTypeBySQLType(sqlType);
                        if (this.isPrimaryKey(colName, db.getPrimaryKeys())) {
                            SQLTool.setObject(GV.dsActive.getDBType(), ps, pkIndex, o, type);
                            ++pkIndex;
                        }
                    }
                    ++col2;
                }
                ps.executeUpdate();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            try {
                ps = this.con.prepareStatement(sqlIns.toString());
                int col3 = 0;
                while (col3 < db.getColNames().length) {
                    Object o = db.getData()[row][col3];
                    colName = db.getColNames()[col3];
                    if (typeMap.get(colName) != null) {
                        int sqlType = (Integer)typeMap.get(colName);
                        byte type = TypesEx.getDBTypeBySQLType(sqlType);
                        SQLTool.setObject(GV.dsActive.getDBType(), ps, col3 + 1, o, type);
                    }
                    ++col3;
                }
                ps.executeUpdate();
            }
            catch (SQLException ex) {
                GM.showException(ex);
            }
            ++row;
        }
        return true;
    }

    private boolean doUpdataRecover(DataBackup db, PreparedStatement ps, Map typeMap) {
        int row = 0;
        while (row < db.getData().length) {
            StringBuffer sqlUpd = new StringBuffer();
            StringBuffer sqlWhere = new StringBuffer();
            StringBuffer sqlIns = new StringBuffer();
            StringBuffer sqlValue = new StringBuffer();
            sqlWhere.append(" WHERE ");
            sqlUpd.append("UPDATE ");
            if (GM.isValidString(db.getSchema()) && GV.dsActive.isUseSchema()) {
                sqlUpd.append(db.getSchema() + ".");
            }
            sqlUpd.append(db.getTableName());
            sqlUpd.append(" SET ");
            sqlIns.append("INSERT INTO ");
            if (GM.isValidString(db.getSchema()) && GV.dsActive.isUseSchema()) {
                sqlIns.append(db.getSchema() + ".");
            }
            sqlIns.append(db.getTableName());
            sqlIns.append("( ");
            sqlValue.append(" VALUES ( ");
            int colCount = 0;
            int pkCount = 0;
            int col = 0;
            while (col < db.getColNames().length) {
                String colName = db.getColNames()[col];
                if (typeMap.get(colName) != null) {
                    if (col != 0) {
                        sqlValue.append(", ");
                        sqlIns.append(", ");
                    }
                    sqlIns.append(colName);
                    sqlValue.append("? ");
                    if (this.isPrimaryKey(colName, db.getPrimaryKeys())) {
                        if (pkCount != 0) {
                            sqlWhere.append(" and ");
                        }
                        ++pkCount;
                        sqlWhere.append(colName + " = ?");
                    } else {
                        if (colCount != 0) {
                            sqlUpd.append(" , ");
                        }
                        ++colCount;
                        sqlUpd.append(colName + " = ? ");
                    }
                }
                ++col;
            }
            if (pkCount == 0) {
                GM.showException(new Exception(Lang.getText("dialogdatarecover.cantrecover")));
                return false;
            }
            sqlUpd.append(sqlWhere.toString());
            sqlIns.append(" ) ");
            sqlValue.append(" ) ");
            sqlIns.append(sqlValue.toString());
            try {
                ps = this.con.prepareStatement(sqlUpd.toString());
                int colIndex = 1;
                int pkIndex = colCount + 1;
                int col2 = 0;
                while (col2 < db.getColNames().length) {
                    Object o = db.getData()[row][col2];
                    String colName = db.getColNames()[col2];
                    if (typeMap.get(colName) != null) {
                        int sqlType = (Integer)typeMap.get(colName);
                        byte type = TypesEx.getDBTypeBySQLType(sqlType);
                        if (this.isPrimaryKey(colName, db.getPrimaryKeys())) {
                            SQLTool.setObject(GV.dsActive.getDBType(), ps, pkIndex, o, type);
                            ++pkIndex;
                        } else {
                            SQLTool.setObject(GV.dsActive.getDBType(), ps, colIndex, o, type);
                            ++colIndex;
                        }
                    }
                    ++col2;
                }
                ps.executeUpdate();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            try {
                ps = this.con.prepareStatement(sqlIns.toString());
                int col3 = 0;
                while (col3 < db.getColNames().length) {
                    Object o = db.getData()[row][col3];
                    String colName = db.getColNames()[col3];
                    if (typeMap.get(colName) != null) {
                        int sqlType = (Integer)typeMap.get(colName);
                        byte type = TypesEx.getDBTypeBySQLType(sqlType);
                        SQLTool.setObject(GV.dsActive.getDBType(), ps, col3 + 1, o, type);
                    }
                    ++col3;
                }
                ps.executeUpdate();
            }
            catch (SQLException ex) {}
            ++row;
        }
        return true;
    }

    private void getConnection() {
        if (GV.dsActive == null) {
            return;
        }
        try {
            this.con = GV.dsActive.getConnection();
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDataBackups(File file) {
        FileInputStream out = null;
        ObjectInputStream stream = null;
        try {
            out = new FileInputStream(file);
            stream = new ObjectInputStream(out);
            DataBackup[] db = (DataBackup[])stream.readObject();
            this.dbs = db;
        }
        catch (Exception e) {
            GM.showException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ex1) {
                }
            }
        }
    }

    private Vector getPrimaryKeys(String schema, String tableName) {
        Vector<String> vec = new Vector<String>();
        try {
            DatabaseMetaData dbmd = this.con.getMetaData();
            if (dbmd == null) {
                return null;
            }
            if (!GM.isValidString(schema)) {
                schema = null;
            }
            ResultSet rs = dbmd.getPrimaryKeys(this.con.getCatalog(), schema, tableName);
            while (rs.next()) {
                String primaryKey = rs.getString("COLUMN_NAME");
                vec.addElement(primaryKey);
            }
            rs.close();
        }
        catch (Exception e) {}
        return vec;
    }

    private void init() {
        this.jRBUpdate.setSelected(true);
        this.getConnection();
    }

    private boolean isDBColName(String colName, DataBackup db) {
        String[] colNames = db.getColNames();
        int i = 0;
        while (i < colNames.length) {
            if (colNames[i].equalsIgnoreCase(colName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isPrimaryKey(String colName, String[] pk) {
        int i = 0;
        while (i < pk.length) {
            if (pk[i].equals(colName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBRecover_actionPerformed(ActionEvent e) {
        this.recover();
    }

    void jBSelectPath_actionPerformed(ActionEvent e) {
        this.readFile();
    }

    private void jbInit() throws Exception {
        this.jBSelectPath.setMargin(new Insets(2, 2, 2, 2));
        this.jBSelectPath.setPreferredSize(new Dimension(45, 25));
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "\u8bf7\u9009\u62e9\u6062\u590d\u7684\u65b9\u5f0f");
        this.jPanel2.setLayout((LayoutManager)this.verticalFlowLayout1);
        this.jBRecover.setMnemonic('R');
        this.jBRecover.setText("\u6062\u590d(R)");
        this.jBRecover.addActionListener(new DialogDataRecover_jBRecover_actionAdapter(this));
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u5173\u95ed(C)");
        this.jBCancel.addActionListener(new DialogDataRecover_jBCancel_actionAdapter(this));
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jRBAdd.setText("\u589e\u91cf\u6062\u590d");
        this.jRBClear.setText("\u6e05\u7a7a\u6062\u590d");
        this.jRBUpdate.setText("\u66f4\u65b0\u6062\u590d");
        this.jPanel3.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setRows(2);
        this.jPanel4.setLayout(this.gridBagLayout2);
        this.jBSelectPath.setText("...");
        this.jBSelectPath.addActionListener(new DialogDataRecover_jBSelectPath_actionAdapter(this));
        this.jPanel5.setLayout(this.borderLayout1);
        this.jPanel3.setBorder(this.titledBorder1);
        this.jPanel3.setDebugGraphicsOptions(0);
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("\u8bf7\u8f93\u5165\u6062\u590d\u6587\u4ef6\u7684\u8def\u5f84");
        this.jPanel3.add((Component)this.jRBUpdate, null);
        this.jPanel3.add((Component)this.jRBClear, null);
        this.jPanel3.add((Component)this.jRBAdd, null);
        this.jPanel1.add((Component)this.jPanel3, GM.getGBC(1, 1, true));
        this.jPanel1.add((Component)this.jPanel4, GM.getGBC(2, 1, true));
        this.jPanel4.add((Component)this.jBSelectPath, GM.getGBC(1, 2));
        this.jPanel4.add((Component)this.jLabel1, GM.getGBC(1, 1, true));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.getContentPane().add((Component)this.jPanel2, "East");
        this.jPanel2.add((Component)this.jBRecover, null);
        this.jPanel2.add((Component)this.jBCancel, null);
        this.jPanel1.add((Component)this.jPanel5, GM.getGBC(3, 1, true));
        this.jPanel5.add((Component)this.textPath, "Center");
        this.jPanel1.add((Component)this.jPanel6, GM.getGBC(4, 1, true, true));
        this.addWindowListener(new DialogDataRecover_this_windowAdapter(this));
        this.textPath.addMouseListener(new DialogDataRecover_textPath_mouseAdapter(this));
        this.buttonGroup1.add(this.jRBUpdate);
        this.buttonGroup1.add(this.jRBClear);
        this.buttonGroup1.add(this.jRBAdd);
    }

    private void readFile() {
        File file = GM.dialogSelectFile("dat", GV.lastDirectory, "", "");
        if (file == null || !file.isFile()) {
            return;
        }
        this.textPath.setText(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover() {
        String text = this.textPath.getText();
        if (!GM.isValidString(text)) {
            JOptionPane.showMessageDialog(this, Lang.getText("dialogdatarecover.selectfile"), Lang.getText("public.error"), 2);
            return;
        }
        if (!this.showOptionDialog(Lang.getText("dialogdatarecover.queryrecover"), Lang.getText("dialogdatarecover.confirmrecover"))) {
            return;
        }
        try {
            File file = new File(text);
            if (file == null || !file.isFile()) {
                JOptionPane.showMessageDialog(this, Lang.getText("dialogdatarecover.file") + text + Lang.getText("dialogdatarecover.notexist"), Lang.getText("public.error"), 2);
                return;
            }
            this.getDataBackups(file);
        }
        catch (Exception e) {
            GM.showException(e);
            return;
        }
        if (this.checkConnection()) {
            return;
        }
        if (GV.dsActive.getDBType() == 7 && (this.jRBUpdate.isSelected() || this.jRBClear.isSelected())) {
            JOptionPane.showMessageDialog(this, "ACCESS\u6570\u636e\u5e93\u65e0\u6cd5\u66f4\u65b0\u6062\u590d\u548c\u6e05\u7a7a\u6062\u590d.");
            System.err.println("The JDBC interface of the current database doesn't implement DatabaseMetaData.getPrimaryKeys().");
            return;
        }
        if (this.dbs == null || this.dbs.length == 0) {
            return;
        }
        Statement ps = null;
        try {
            this.con.setAutoCommit(false);
            int count = 0;
            StringBuffer message = new StringBuffer();
            message.append(Lang.getText("dialogdatarecover.table"));
            int i = 0;
            while (i < this.dbs.length) {
                HashMap<String, Integer> typeMap = new HashMap<String, Integer>();
                String dbName = this.dbs[i].getTableName();
                String schema = this.dbs[i].getSchema();
                String[] pk = this.dbs[i].getPrimaryKeys();
                DatabaseMetaData dbmd = this.con.getMetaData();
                ResultSet rs = dbmd.getColumns(this.con.getCatalog(), schema, dbName, null);
                while (rs.next()) {
                    String colName = rs.getString("COLUMN_NAME");
                    if (!this.isDBColName(colName, this.dbs[i])) continue;
                    int sqlType = rs.getInt("DATA_TYPE");
                    typeMap.put(colName, new Integer(sqlType));
                }
                Object[][] data = this.dbs[i].getData();
                if (data == null) {
                    JOptionPane.showMessageDialog(this, Lang.getText("dialogdatarecover.nodata"), Lang.getText("public.error"), 2);
                    return;
                }
                Vector dbPKVec = this.getPrimaryKeys(schema, dbName);
                Section dbPKSec = new Section(dbPKVec);
                String[] dbPK = dbPKSec.toStringArray();
                if (!this.arrayEqual(pk, dbPK) && (this.jRBUpdate.isSelected() || this.jRBClear.isSelected())) {
                    JOptionPane.showMessageDialog(this, Lang.getText("dialogdatarecover.pknotequal"), Lang.getText("public.error"), 2);
                    return;
                }
                boolean successful = true;
                if (this.jRBUpdate.isSelected()) {
                    successful = this.doUpdataRecover(this.dbs[i], (PreparedStatement)ps, typeMap);
                } else if (this.jRBClear.isSelected()) {
                    successful = this.doClearRecover(this.dbs[i], (PreparedStatement)ps, typeMap);
                } else if (this.jRBAdd.isSelected()) {
                    this.doAddRecover(this.dbs[i], (PreparedStatement)ps, typeMap);
                }
                this.con.commit();
                if (successful) {
                    if (count > 0) {
                        message.append(" , ");
                    }
                    ++count;
                    message.append(dbName);
                }
                ++i;
            }
            if (count > 0) {
                message.append(Lang.getText("dialogdatarecover.isrecoverd"));
                DialogInputText dit = new DialogInputText((Frame)GV.appFrame, Lang.getText("dialogdatarecover.recoversucceed"));
                dit.setText(message.toString());
                dit.show();
            }
        }
        catch (Exception e) {
            GM.showException(e);
            try {
                this.con.rollback();
            }
            catch (SQLException ex) {
            }
        }
        finally {
            try {
                this.con.setAutoCommit(true);
            }
            catch (SQLException ex2) {}
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex1) {
                }
            }
        }
    }

    private void resetLangText() {
        this.titledBorder1.setTitle(Lang.getText("dialogdatarecover.recovertype"));
        this.jBRecover.setText(Lang.getText("button.recover"));
        this.jBCancel.setText(Lang.getText("button.close"));
        this.jRBAdd.setText(Lang.getText("dialogdatarecover.add"));
        this.jRBClear.setText(Lang.getText("dialogdatarecover.clear"));
        this.jRBUpdate.setText(Lang.getText("dialogdatarecover.update"));
        this.jLabel1.setText(Lang.getText("dialogdatarecover.inputpath"));
    }

    public void setViewManager(SemanticsManager viewManager) {
    }

    private boolean showOptionDialog(String message, String title) {
        Object[] options = new Object[]{Lang.getText("dialogdatarecover.ok"), Lang.getText("dialogdatarecover.cancel")};
        int option = JOptionPane.showOptionDialog(null, message, title, -1, 2, null, options, options[0]);
        return option == 0;
    }

    void textPath_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.readFile();
        }
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }
}

