/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.dialog;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.runqian.base4.swing.JListEx;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.tool.Section;
import com.runqian.datamanager.base.DataBackup;
import com.runqian.datamanager.dialog.DialogSelectColumns_jBAdd_actionAdapter;
import com.runqian.datamanager.dialog.DialogSelectColumns_jBAll_actionAdapter;
import com.runqian.datamanager.dialog.DialogSelectColumns_jBCancel_actionAdapter;
import com.runqian.datamanager.dialog.DialogSelectColumns_jBClear_actionAdapter;
import com.runqian.datamanager.dialog.DialogSelectColumns_jBDelete_actionAdapter;
import com.runqian.datamanager.dialog.DialogSelectColumns_jBEdit_actionAdapter;
import com.runqian.datamanager.dialog.DialogSelectColumns_jBOK_actionAdapter;
import com.runqian.datamanager.dialog.DialogSelectColumns_listAvailable_mouseAdapter;
import com.runqian.datamanager.dialog.DialogSelectColumns_listSelected_mouseAdapter;
import com.runqian.datamanager.dialog.DialogSelectColumns_textFilter_mouseAdapter;
import com.runqian.datamanager.dialog.DialogSelectColumns_this_windowAdapter;
import com.runqian.report4.ide.dialog.DialogExpEditor;
import com.runqian.report4.model.SemanticsParser;
import com.runqian.report4.semantics.TableView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DialogSelectColumns
extends JDialog {
    private boolean availableSelected = false;
    BorderLayout borderLayout1;
    BorderLayout borderLayout2;
    private byte curType = 0;
    private DataBackup db;
    private byte dragIn = 1;
    private byte dragOut = 0;
    GridBagLayout gridBagLayout1;
    GridBagLayout gridBagLayout2;
    GridBagLayout gridBagLayout3;
    GridBagLayout gridBagLayout4;
    JButton jBAdd;
    JButton jBAll;
    JButton jBCancel;
    JButton jBClear;
    JButton jBDelete;
    JButton jBEdit;
    JButton jBOK;
    JLabel jLabel2;
    JLabel jLabel3;
    JPanel jPanel1;
    JPanel jPanel2;
    JPanel jPanel3;
    JPanel jPanel4;
    JPanel jPanel5;
    JPanel jPanel6;
    JPanel jPanel7;
    JPanel jPanel8;
    JPanel jPanel9;
    JScrollPane jScrollPane1;
    JScrollPane jScrollPane2;
    JScrollPane jScrollPane3;
    JListEx listAvailable;
    JListEx listSelected;
    private int m_option = 2;
    private byte otherPlace = (byte)2;
    JTextArea textFilter;
    private TableView tv;
    VerticalFlowLayout verticalFlowLayout1;
    VerticalFlowLayout verticalFlowLayout2;

    public DialogSelectColumns() {
        super(GV.appFrame, Lang.getText("dialogselectcolumns.title"), true);
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jBCancel = new JButton();
        this.jBOK = new JButton();
        this.verticalFlowLayout1 = new VerticalFlowLayout();
        this.jScrollPane1 = new JScrollPane();
        this.listAvailable = new JListEx();
        this.borderLayout1 = new BorderLayout();
        this.jScrollPane2 = new JScrollPane();
        this.listSelected = new JListEx();
        this.borderLayout2 = new BorderLayout();
        this.jBAdd = new JButton();
        this.jBDelete = new JButton();
        this.jBAll = new JButton();
        this.jBClear = new JButton();
        this.verticalFlowLayout2 = new VerticalFlowLayout();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.gridBagLayout1 = new GridBagLayout();
        this.gridBagLayout2 = new GridBagLayout();
        this.jBEdit = new JButton();
        this.jPanel7 = new JPanel();
        this.gridBagLayout3 = new GridBagLayout();
        this.jScrollPane3 = new JScrollPane();
        this.textFilter = new JTextArea();
        this.jPanel8 = new JPanel();
        this.jPanel9 = new JPanel();
        this.gridBagLayout4 = new GridBagLayout();
        try {
            this.setSize(540, 380);
            this.jbInit();
            this.resetLangText();
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    private void add() {
        Vector selected = this.getSelectColumns(this.listAvailable);
        if (selected == null) {
            return;
        }
        int i = 0;
        while (i < selected.size()) {
            if (!this.isExist((String)selected.get(i))) {
                this.listSelected.data.addElement((String)selected.get(i));
            }
            ++i;
        }
    }

    private void delete() {
        int[] indices = this.listSelected.getSelectedIndices();
        if (indices == null) {
            return;
        }
        int i = indices.length - 1;
        while (i >= 0) {
            String title = (String)this.listSelected.data.get(indices[i]);
            if (title.startsWith(Lang.getText("dialogselectcolumns.primarykey"))) {
                JOptionPane.showMessageDialog(this, Lang.getText("dialogselectcolumns.needpk"), Lang.getText("public.error"), 2);
            } else {
                this.listSelected.data.remove(indices[i]);
            }
            --i;
        }
    }

    private void editFilter() {
        String exp = this.textFilter.getText();
        HashMap map = new HashMap();
        int i = 0;
        while (i < this.tv.getColCount()) {
            map.put(this.tv.getColInfo(i).getColTitle(), new Vector());
            ++i;
        }
        DialogExpEditor dee = new DialogExpEditor();
        dee.setEditingType(2);
        if (exp == null) {
            exp = "";
        }
        dee.setExpression("=" + exp);
        dee.setDataMap(map);
        dee.setDataSrcName(this.tv.getDataSourceName());
        dee.setUseDataSet(false);
        dee.setColTypes(GV.getViewColTypes(this.tv, map));
        dee.init();
        dee.show();
        if (dee.getOption() == 0) {
            exp = dee.getExpression();
            if (exp.length() > 0) {
                exp = exp.substring(1);
            }
            this.textFilter.setText(exp);
        }
    }

    private Cursor getCur(int type) {
        Image im = null;
        if (type == this.dragIn) {
            im = GM.getImageIcon("/com/runqian/base4/tool/img/delete24.gif").getImage();
        } else if (type == this.dragOut) {
            im = GM.getImageIcon("/com/runqian/base4/tool/img/dnd_cursor1.gif").getImage();
        } else if (type == this.otherPlace) {
            im = GM.getImageIcon("/com/runqian/base4/tool/img/dnd-nodrop.gif").getImage();
        }
        Cursor cur = Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(0, 0), "cur");
        return cur;
    }

    public DataBackup getDataBackup() {
        return this.db;
    }

    public int getOption() {
        return this.m_option;
    }

    private Vector getSelectColumns(JListEx list) {
        String selected = list.selectedItems();
        if (!GM.isValidString(selected)) {
            return null;
        }
        int[] indexes = list.getSelectedIndices();
        Vector v = new Vector();
        int i = 0;
        while (i < indexes.length) {
            v.add(list.data.get(indexes[i]));
            ++i;
        }
        return v;
    }

    private Transferable getTransferable() {
        String dragValue = this.listAvailable.selectedItems();
        if (!GM.isValidString(dragValue)) {
            return null;
        }
        return new StringSelection(dragValue);
    }

    private void initButton(JButton button) {
        button.setMargin(new Insets(2, 2, 2, 2));
        button.setPreferredSize(new Dimension(35, 22));
    }

    private boolean isExist(String title) {
        String selected = this.listSelected.totalItems();
        Section sec = new Section(selected);
        Vector vSelected = sec.toVector();
        int i = 0;
        while (i < vSelected.size()) {
            if (vSelected.get(i).equals(title)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isPrimaryKey(String colName) {
        String[] pks = this.db.getPrimaryKeys();
        int i = 0;
        while (i < pks.length) {
            if (pks[i].equals(colName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void jBAdd_actionPerformed(ActionEvent e) {
        this.add();
    }

    void jBAll_actionPerformed(ActionEvent e) {
        this.listSelected.setListData(this.listAvailable.totalItems());
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBClear_actionPerformed(ActionEvent e) {
        this.listSelected.setListData("");
        String[] pks = this.db.getPrimaryKeys();
        if (pks == null) {
            return;
        }
        int i = 0;
        while (i < pks.length) {
            String title = this.tv.getColInfoByColName(pks[i]).getColTitle();
            if (this.isPrimaryKey(pks[i])) {
                title = Lang.getText("dialogselectcolumns.primarykey") + title;
            }
            this.listSelected.data.addElement(title);
            ++i;
        }
    }

    void jBDelete_actionPerformed(ActionEvent e) {
        this.delete();
    }

    void jBEdit_actionPerformed(ActionEvent e) {
        this.editFilter();
    }

    void jBOK_actionPerformed(ActionEvent e) {
        Vector cols = this.getSelectColumns(this.listSelected);
        if (cols != null) {
            String[] colNames = new String[cols.size()];
            int i = 0;
            while (i < cols.size()) {
                String colName;
                String title = (String)cols.get(i);
                if (title.startsWith(Lang.getText("dialogselectcolumns.primarykey"))) {
                    title = title.substring(Lang.getText("dialogselectcolumns.primarykey").length());
                }
                colNames[i] = colName = this.tv.getColInfo(title).getColName();
                ++i;
            }
            this.db.setColNames(colNames);
        }
        String filter = SemanticsParser.replaceColumnTitle(this.textFilter.getText(), this.tv);
        this.db.setFilterExp(filter);
        this.m_option = 0;
        GM.setWindowDimension(this);
        this.dispose();
    }

    private void jbInit() throws Exception {
        this.jBEdit.setMargin(new Insets(2, 2, 2, 2));
        this.jBEdit.setPreferredSize(new Dimension(85, 30));
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new DialogSelectColumns_jBCancel_actionAdapter(this));
        this.jBOK.setMnemonic('O');
        this.jBOK.setSelected(false);
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogSelectColumns_jBOK_actionAdapter(this));
        this.jPanel5.setLayout((LayoutManager)this.verticalFlowLayout1);
        this.jPanel6.setLayout(this.gridBagLayout2);
        this.jPanel2.setLayout(this.borderLayout1);
        this.jPanel3.setLayout(this.borderLayout2);
        this.jBAdd.setText(">");
        this.initButton(this.jBAdd);
        this.jBAdd.addActionListener(new DialogSelectColumns_jBAdd_actionAdapter(this));
        this.jBDelete.setToolTipText("");
        this.jBDelete.setText("<");
        this.initButton(this.jBDelete);
        this.jBDelete.addActionListener(new DialogSelectColumns_jBDelete_actionAdapter(this));
        this.jBAll.setText(">>");
        this.initButton(this.jBAll);
        this.jBAll.addActionListener(new DialogSelectColumns_jBAll_actionAdapter(this));
        this.jBClear.setText("<<");
        this.initButton(this.jBClear);
        this.jBClear.addActionListener(new DialogSelectColumns_jBClear_actionAdapter(this));
        this.jPanel4.setLayout((LayoutManager)this.verticalFlowLayout2);
        this.verticalFlowLayout2.setAlignment(1);
        this.jLabel2.setText("\u53ef\u9009\u7684\u5b57\u6bb5");
        this.jLabel3.setText("\u9009\u51fa\u7684\u5b57\u6bb5");
        this.jBEdit.setText("\u7f16\u8f91\u8fc7\u6ee4\u6761\u4ef6");
        this.jBEdit.addActionListener(new DialogSelectColumns_jBEdit_actionAdapter(this));
        this.jPanel7.setLayout(this.gridBagLayout3);
        this.jScrollPane3.setPreferredSize(new Dimension(90, 70));
        this.textFilter.setPreferredSize(new Dimension(84, 18));
        this.jPanel8.setLayout(this.gridBagLayout4);
        this.getContentPane().add((Component)this.jPanel5, "East");
        this.jPanel5.add((Component)this.jBOK, null);
        this.jPanel5.add((Component)this.jBCancel, null);
        this.jPanel6.add((Component)this.jScrollPane3, GM.getGBC(1, 2, true, true));
        this.jScrollPane3.getViewport().add((Component)this.textFilter, null);
        this.jPanel6.add((Component)this.jPanel8, GM.getGBC(1, 1, false, true));
        this.jPanel8.add((Component)this.jPanel9, GM.getGBC(2, 1, false, true));
        this.jPanel8.add((Component)this.jBEdit, GM.getGBC(1, 1));
        this.getContentPane().add((Component)this.jPanel7, "Center");
        this.jPanel7.add((Component)this.jPanel1, GM.getGBC(1, 1, true, true));
        this.jPanel7.add((Component)this.jPanel6, GM.getGBC(2, 1, true, true));
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.jPanel2.add((Component)this.jLabel2, "North");
        this.jPanel1.add((Component)this.jPanel4, GM.getGBC(1, 2));
        this.jScrollPane1.getViewport().add((Component)this.listAvailable, null);
        this.jPanel1.add((Component)this.jPanel2, GM.getGBC(1, 1, true, true));
        this.jPanel3.add((Component)this.jScrollPane2, "Center");
        this.jPanel3.add((Component)this.jLabel3, "North");
        this.jScrollPane2.getViewport().add((Component)this.listSelected, null);
        this.jPanel4.add((Component)this.jBAdd, null);
        this.jPanel4.add((Component)this.jBDelete, null);
        this.jPanel4.add((Component)this.jBAll, null);
        this.jPanel4.add((Component)this.jBClear, null);
        this.jPanel1.add((Component)this.jPanel3, GM.getGBC(1, 3, true, true));
        this.addWindowListener(new DialogSelectColumns_this_windowAdapter(this));
        this.listSelected.addMouseListener(new DialogSelectColumns_listSelected_mouseAdapter(this));
        this.listAvailable.addMouseListener(new DialogSelectColumns_listAvailable_mouseAdapter(this));
        this.textFilter.addMouseListener(new DialogSelectColumns_textFilter_mouseAdapter(this));
        DragGestureListener dglAvailabel = new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dge) {
                try {
                    DialogSelectColumns.this.availableSelected = true;
                    DialogSelectColumns.this.curType = DialogSelectColumns.this.dragOut;
                    Transferable tf = DialogSelectColumns.this.getTransferable();
                    if (tf != null) {
                        dge.startDrag(DialogSelectColumns.this.getCur(DialogSelectColumns.this.curType), tf);
                    }
                }
                catch (Exception x) {
                }
            }
        };
        DragSource ds = DragSource.getDefaultDragSource();
        ds.createDefaultDragGestureRecognizer(this.listAvailable, 1, dglAvailabel);
        DragGestureListener dglSelected = new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dge) {
                try {
                    if (!GM.isValidString(DialogSelectColumns.this.listSelected.totalItems())) {
                        return;
                    }
                    DialogSelectColumns.this.availableSelected = false;
                    DialogSelectColumns.this.curType = DialogSelectColumns.this.otherPlace;
                    StringSelection tf = new StringSelection("");
                    dge.startDrag(DialogSelectColumns.this.getCur(DialogSelectColumns.this.curType), tf);
                }
                catch (Exception x) {
                    GM.showException(x);
                }
            }
        };
        ds.createDefaultDragGestureRecognizer(this.listSelected, 2, dglSelected);
        DropTargetListener dtlBack = new DropTargetListener(){

            public void dragEnter(DropTargetDragEvent dtde) {
            }

            public void dragExit(DropTargetEvent dte) {
            }

            public void dragOver(DropTargetDragEvent dtde) {
            }

            public void drop(DropTargetDropEvent dtde) {
                if (!DialogSelectColumns.this.availableSelected) {
                    DialogSelectColumns.this.delete();
                }
            }

            public void dropActionChanged(DropTargetDragEvent dtde) {
            }
        };
        DropTarget dt = new DropTarget(this.listAvailable, dtlBack);
        this.listAvailable.setDropTarget(dt);
    }

    void listAvailable_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.add();
        }
    }

    void listSelected_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.delete();
        }
    }

    private void resetLangText() {
        this.jBCancel.setText(Lang.getText("button.cancel"));
        this.jBOK.setText(Lang.getText("button.ok"));
        this.jLabel2.setText(Lang.getText("dialogselectcolumns.availablecolumn"));
        this.jLabel3.setText(Lang.getText("dialogselectcolumns.selectedcolumn"));
        this.jBEdit.setText(Lang.getText("dialogselectcolumns.editfilter"));
    }

    public void setConfig(DataBackup db, TableView tv) {
        this.db = db;
        this.tv = tv;
        String filter = SemanticsParser.replaceColumnName(db.getFilterExp(), tv);
        this.textFilter.setText(filter);
        int i = 0;
        while (i < tv.getColCount()) {
            String colTitle = tv.getColInfo(i).getColTitle();
            if (tv.getColInfo(i).isPrimaryKey()) {
                colTitle = Lang.getText("dialogselectcolumns.primarykey") + colTitle;
            }
            this.listAvailable.data.addElement(colTitle);
            ++i;
        }
        String[] colNames = db.getColNames();
        if (colNames == null) {
            return;
        }
        int i2 = 0;
        while (i2 < colNames.length) {
            String colTitle = tv.getColInfoByColName(colNames[i2]).getColTitle();
            if (this.isPrimaryKey(colNames[i2])) {
                colTitle = Lang.getText("dialogselectcolumns.primarykey") + colTitle;
            }
            this.listSelected.data.addElement(colTitle);
            ++i2;
        }
    }

    void textFilter_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.editFilter();
        }
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }
}

