/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.dialog;

import com.runqian.base4.swing.JComboBoxEx;
import com.runqian.base4.swing.VFlowLayout;
import com.runqian.base4.tool.GC;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.datamanager.base.PanelViewProperty;
import com.runqian.datamanager.dialog.DialogViewProperty_jBCancel_actionAdapter;
import com.runqian.datamanager.dialog.DialogViewProperty_jBOK_actionAdapter;
import com.runqian.datamanager.dialog.DialogViewProperty_jBSQL_actionAdapter;
import com.runqian.datamanager.dialog.DialogViewProperty_jCBSchema_actionAdapter;
import com.runqian.datamanager.dialog.DialogViewProperty_jTFBegin_mouseAdapter;
import com.runqian.datamanager.dialog.DialogViewProperty_jTFEnd_mouseAdapter;
import com.runqian.datamanager.dialog.DialogViewProperty_this_windowAdapter;
import com.runqian.datamanager.ide.GVData;
import com.runqian.report4.ide.dialog.DialogSQLDataSet;
import com.runqian.report4.semantics.CustomView;
import com.runqian.report4.semantics.ProcView;
import com.runqian.report4.semantics.SQLView;
import com.runqian.report4.semantics.TableView;
import com.runqian.report4.semantics.View;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class DialogViewProperty
extends JDialog {
    GridBagLayout gridBagLayout1;
    JButton jBCancel;
    JButton jBOK;
    JButton jBSQL;
    JComboBoxEx jCBDataSource;
    JComboBox jCBSchema;
    JComboBoxEx jCBTableName;
    JLabel jLabel1;
    JLabel jLabel2;
    JLabel jLabel3;
    JLabel jLabel5;
    JLabel jLabelBegin;
    JLabel jLabelEnd;
    JPanel jPanel1;
    JPanel jPanelRow;
    JTextField jTFBegin;
    JTextField jTFEnd;
    JTextField jTFName;
    JTextPane jTPSql;
    JLabel lbSql;
    JLabel lbTableName;
    private int m_option = -1;
    private String oldName;
    JPanel panel1 = new JPanel();
    JScrollPane spSql;
    private View view;
    private String[] viewNames;

    public DialogViewProperty(String[] viewNames) {
        super(GV.appFrame, Lang.getText("dialogviewproperty.title"), true);
        this.jBOK = new JButton();
        this.jBCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.jCBTableName = new JComboBoxEx();
        this.jLabel2 = new JLabel();
        this.lbSql = new JLabel();
        this.jCBSchema = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jCBDataSource = new JComboBoxEx();
        this.jTPSql = new JTextPane();
        this.spSql = new JScrollPane(this.jTPSql);
        this.jTFName = new JTextField();
        this.lbTableName = new JLabel();
        this.jLabel5 = new JLabel();
        this.gridBagLayout1 = new GridBagLayout();
        this.jLabelBegin = new JLabel();
        this.jTFBegin = new JTextField();
        this.jLabelEnd = new JLabel();
        this.jTFEnd = new JTextField();
        this.jPanelRow = new JPanel();
        this.jBSQL = new JButton();
        this.jLabel3 = new JLabel();
        this.viewNames = viewNames;
        try {
            this.jbInit();
            this.init();
            this.resetLangText();
            this.setSize(400, 300);
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Exception x) {
            GM.showException(x);
        }
    }

    private boolean containsName(String name) {
        int i = 0;
        while (i < this.viewNames.length) {
            if (this.viewNames[i].equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void disableProperty() {
        this.jCBDataSource.setEnabled(false);
        this.jCBSchema.setEnabled(false);
        this.jCBTableName.setEnabled(false);
        this.setTPEnabled(false);
    }

    public int getOption() {
        return this.m_option;
    }

    public View getView() {
        String newName = this.jTFName.getText();
        this.view.setViewName(newName);
        this.view.setBeginRow(this.jTFBegin.getText());
        this.view.setEndRow(this.jTFEnd.getText());
        if (this.view instanceof TableView) {
            TableView tv = (TableView)this.view;
            tv.setDataSourceName((String)this.jCBDataSource.getSelectedItem());
            String schema = null;
            if (GM.isValidString(this.jCBSchema.getSelectedItem()) && !this.jCBSchema.getSelectedItem().equals(GC.SCHME_ALL)) {
                schema = (String)this.jCBSchema.getSelectedItem();
            }
            tv.setSchema(schema);
            tv.setTableName((String)this.jCBTableName.getSelectedItem());
        } else if (this.view instanceof SQLView) {
            SQLView sv = (SQLView)this.view;
            sv.setDataSourceName((String)this.jCBDataSource.getSelectedItem());
            sv.setSQL(this.jTPSql.getText());
            PanelViewProperty.resetArgs(this.view, this.jTPSql.getText());
        } else if (this.view instanceof ProcView) {
            ProcView pv = (ProcView)this.view;
            pv.setDataSourceName((String)this.jCBDataSource.getSelectedItem());
            pv.setSQL(this.jTPSql.getText());
            PanelViewProperty.resetArgs(this.view, this.jTPSql.getText());
        } else if (this.view instanceof CustomView) {
            CustomView cv = (CustomView)this.view;
            cv.setDataSourceName((String)this.jCBDataSource.getSelectedItem());
            cv.setViewDataSetFactoryClass(this.jTPSql.getText());
        }
        this.view.setEditTime();
        return this.view;
    }

    private void init() {
        GV.loadSchemas(this.jCBSchema);
        this.jCBDataSource.setListData(GV.dsModel.listNames());
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        this.m_option = 2;
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBOK_actionPerformed(ActionEvent e) {
        String tip;
        String tmp;
        String newName = this.jTFName.getText();
        if (!this.oldName.equalsIgnoreCase(newName) && this.containsName(newName) || !this.containsName(this.oldName) && this.containsName(newName)) {
            JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("dialogviewproperty.viewname") + newName + Lang.getText("dialogviewproperty.exist"));
            return;
        }
        if (this.view instanceof TableView) {
            tmp = (String)this.jCBTableName.getSelectedItem();
            tip = Lang.getText("dialogviewproperty.tablename");
        } else if (this.view instanceof SQLView) {
            tmp = this.jTPSql.getText();
            tip = Lang.getText("dialogviewproperty.sqldefine");
        } else if (this.view instanceof ProcView) {
            tmp = this.jTPSql.getText();
            tip = Lang.getText("dialogviewproperty.procdefine");
        } else {
            tmp = "Builtin";
            tip = "";
        }
        if (!GM.isValidString(tmp)) {
            JOptionPane.showMessageDialog(GV.appFrame, tip + Lang.getText("dialogviewproperty.notempty"));
            return;
        }
        this.m_option = 0;
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBSQL_actionPerformed(ActionEvent e) {
        String text = this.jTPSql.getText();
        if (!text.toLowerCase().trim().startsWith("select")) {
            text = "";
        }
        DialogSQLDataSet editor = new DialogSQLDataSet();
        editor.setSQL(text);
        editor.setSemanticsManager(GVData.activeSheet.getViewManager());
        editor.show();
        if (editor.getOption() == 0) {
            this.jTPSql.setText(editor.getSQL());
        }
    }

    void jCBSchema_actionPerformed(ActionEvent e) {
        Object oldTable = this.jCBTableName.getSelectedItem();
        String schema = (String)this.jCBSchema.getSelectedItem();
        schema = GV.getRealSchema(schema);
        this.jCBTableName.setListData(GV.listSchemaTables(schema, false));
        if (this.jCBTableName.data.getSize() == 0) {
            this.jCBTableName.data.addElement(oldTable);
        }
        this.jCBTableName.setSelectedItem(oldTable);
    }

    void jTFBegin_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            PanelViewProperty.setRowText(this.jTFBegin);
        }
    }

    void jTFEnd_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            PanelViewProperty.setRowText(this.jTFEnd);
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.panel1.setLayout(new VFlowLayout());
        this.panel1.setForeground(Color.black);
        this.jBOK.setDefaultCapable(true);
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogViewProperty_jBOK_actionAdapter(this));
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.setDefaultCapable(false);
        this.jBCancel.addActionListener(new DialogViewProperty_jBCancel_actionAdapter(this));
        this.addWindowListener(new DialogViewProperty_this_windowAdapter(this));
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jCBTableName.setEditable(true);
        this.jLabel2.setText("\u6a21\u5f0f\u540d  ");
        this.lbSql.setText("SQL\u5b9a\u4e49");
        this.jCBSchema.setEditable(true);
        this.jCBSchema.addActionListener(new DialogViewProperty_jCBSchema_actionAdapter(this));
        this.jLabel1.setText("\u540d\u79f0");
        this.jCBDataSource.setEditable(true);
        this.lbTableName.setText("\u8868\u540d\u79f0");
        this.jLabel5.setText("\u6570\u636e\u6e90");
        this.jLabelBegin.setText("\u8d77\u59cb\u884c");
        this.jLabelEnd.setText("\u7ed3\u675f\u884c");
        this.jBSQL.setText("...");
        this.jBSQL.addActionListener(new DialogViewProperty_jBSQL_actionAdapter(this));
        this.jLabel3.setMaximumSize(new Dimension(4, 40));
        this.jLabel3.setPreferredSize(new Dimension(79, 55));
        this.jLabel3.setText(" ");
        this.jTFBegin.setToolTipText(PanelViewProperty.doubleClickTips);
        this.jTFEnd.setToolTipText(PanelViewProperty.doubleClickTips);
        this.jTFBegin.addMouseListener(new DialogViewProperty_jTFBegin_mouseAdapter(this));
        this.jTFEnd.addMouseListener(new DialogViewProperty_jTFEnd_mouseAdapter(this));
        this.panel1.add(this.jBOK);
        this.panel1.add(this.jBCancel);
        this.panel1.add((Component)this.jLabel3, null);
        this.panel1.add((Component)this.jBSQL, null);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jLabel1, GM.getGBC(1, 1));
        this.jPanel1.add((Component)this.jTFName, GM.getGBC(1, 2));
        this.jPanel1.add((Component)this.jLabel5, GM.getGBC(2, 1));
        this.jPanel1.add((Component)this.jCBDataSource, GM.getGBC(2, 2));
        this.jPanel1.add((Component)this.jLabel2, GM.getGBC(3, 1));
        this.jPanel1.add((Component)this.jCBSchema, GM.getGBC(3, 2));
        this.jPanel1.add((Component)this.lbTableName, GM.getGBC(4, 1));
        this.jPanel1.add((Component)this.jCBTableName, GM.getGBC(4, 2));
        GridBagConstraints gbc = GM.getGBC(5, 1, true, false, 0);
        gbc.gridwidth = 2;
        this.jPanelRow.setLayout(new GridBagLayout());
        this.jPanelRow.add((Component)this.jLabelBegin, GM.getGBC(1, 1));
        this.jPanelRow.add((Component)this.jTFBegin, GM.getGBC(1, 2, true));
        this.jPanelRow.add((Component)this.jLabelEnd, GM.getGBC(1, 3));
        this.jPanelRow.add((Component)this.jTFEnd, GM.getGBC(1, 4, true));
        this.jPanel1.add((Component)this.jPanelRow, gbc);
        this.jPanel1.add((Component)this.lbSql, GM.getGBC(6, 1));
        this.jPanel1.add((Component)this.spSql, GM.getGBC(6, 2, true, true));
        this.getContentPane().add((Component)this.panel1, "East");
    }

    private void resetLangText() {
        this.jBOK.setText(Lang.getText("button.ok"));
        this.jBCancel.setText(Lang.getText("button.cancel"));
        this.jLabel2.setText(Lang.getText("dialogviewproperty.schema"));
        this.lbSql.setText(Lang.getText("dialogviewproperty.sqldefine"));
        this.jLabel1.setText(Lang.getText("dialogviewproperty.name"));
        this.lbTableName.setText(Lang.getText("dialogviewproperty.tablename"));
        this.jLabel5.setText(Lang.getText("dialogviewproperty.datasource"));
        this.jLabelBegin.setText(Lang.getText("jlayeredpaneparameter.begin"));
        this.jLabelEnd.setText(Lang.getText("jlayeredpaneparameter.end"));
    }

    void setTPEnabled(boolean lb) {
        this.jTPSql.setEnabled(lb);
        this.jBSQL.setEnabled(lb);
        if (lb) {
            this.jTPSql.setBackground(Color.white);
        } else {
            this.jTPSql.setBackground(Color.lightGray);
        }
    }

    public void setView(View view) {
        this.view = view;
        this.oldName = view.getViewName();
        this.jTFName.setText(this.oldName);
        this.disableProperty();
        this.jTFBegin.setText(view.getBeginRow());
        this.jTFEnd.setText(view.getEndRow());
        if (view instanceof TableView) {
            TableView tv = (TableView)view;
            this.jCBDataSource.setEnabled(true);
            this.jCBDataSource.setSelectedItem(tv.getDataSourceName());
            this.jCBSchema.setEnabled(true);
            this.jCBSchema.setSelectedItem(tv.getSchema());
            this.jCBTableName.setEnabled(true);
            this.jCBTableName.setSelectedItem(tv.getTableName());
        } else if (view instanceof SQLView) {
            SQLView sv = (SQLView)view;
            this.jCBDataSource.setEnabled(true);
            this.jCBDataSource.setSelectedItem(sv.getDataSourceName());
            this.lbSql.setText(Lang.getText("dialogviewproperty.sql"));
            this.setTPEnabled(true);
            this.jTPSql.setText(sv.getSQL());
        } else if (view instanceof ProcView) {
            ProcView pv = (ProcView)view;
            this.jCBDataSource.setEnabled(true);
            this.jCBDataSource.setSelectedItem(pv.getDataSourceName());
            this.lbSql.setText(Lang.getText("dialogviewproperty.proc"));
            this.setTPEnabled(true);
            this.jBSQL.setEnabled(false);
            this.jTPSql.setText(pv.getSQL());
        } else if (view instanceof CustomView) {
            CustomView cv = (CustomView)view;
            this.jCBDataSource.setEnabled(true);
            this.jCBDataSource.setSelectedItem(cv.getDataSourceName());
            this.lbSql.setText(Lang.getText("dialogviewproperty.classname"));
            this.setTPEnabled(true);
            this.jBSQL.setEnabled(false);
            this.jTPSql.setText(cv.getViewDataSetFactoryClass());
        }
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }
}

