/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.ide;

import com.runqian.base4.tool.AppFrame;
import com.runqian.base4.tool.AppMenu;
import com.runqian.base4.tool.ConfigFile;
import com.runqian.base4.tool.GC;
import com.runqian.base4.tool.GCWindow;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.tool.Section;
import com.runqian.base4.util.Console;
import com.runqian.base4.util.ShortMap;
import com.runqian.datamanager.base.IDataSheet;
import com.runqian.datamanager.base.MenuFactory;
import com.runqian.datamanager.dialog.DialogViewCondition;
import com.runqian.datamanager.ide.FrameManager_this_windowAdapter;
import com.runqian.datamanager.ide.GVData;
import com.runqian.datamanager.ide.IToolBar;
import com.runqian.datamanager.ide.ResizeListener;
import com.runqian.datamanager.ide.SheetViewData;
import com.runqian.datamanager.ide.SheetViewManager;
import com.runqian.report4.ide.FrameMain;
import com.runqian.report4.ide.base.ConfigOptions;
import com.runqian.report4.ide.base.DataSource;
import com.runqian.report4.ide.base.DataSourceListModel;
import com.runqian.report4.ide.base.DelayConnectThread;
import com.runqian.report4.ide.base.LookAndFeelManager;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.remote.LogInfo;
import com.runqian.report4.semantics.CustomView;
import com.runqian.report4.semantics.ProcView;
import com.runqian.report4.semantics.SQLView;
import com.runqian.report4.semantics.TableView;
import com.runqian.report4.semantics.View;
import com.runqian.report4.usermodel.ViewDataSetConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class FrameManager
extends AppFrame {
    private JPanel barPanel = new JPanel();
    private AppMenu currentMenu;
    Runnable run = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object o;
            Object object = o = new Object();
            synchronized (object) {
                try {
                    o.wait();
                }
                catch (InterruptedException e) {
                }
            }
        }
    };
    private boolean runned = false;
    private boolean terminalVM = true;

    public FrameManager(String openFile, String licenseFile, boolean terminalVMwhileExit) {
        GV.autoOpenSemantic = openFile;
        this.terminalVM = terminalVMwhileExit;
        try {
            ConfigOptions.load();
            if (GM.isValidString(licenseFile)) {
                ExtCellSet.setLicenseFileName(licenseFile);
            } else if (GM.isValidString(ConfigOptions.sLicenseFile)) {
                ExtCellSet.setLicenseFileName(ConfigOptions.sLicenseFile);
            } else {
                String licFile = "defaultlicense_";
                licFile = GC.LANGUAGE == 0 ? licFile + "zh.lic" : (GC.LANGUAGE == 1 ? licFile + "tw.lic" : licFile + "en.lic");
                ExtCellSet.setLicenseFileName(licFile);
            }
            if (!this.check()) {
                return;
            }
            this.productName = Lang.getText("framemanager.runqian");
            this.setTitle(this.getFixTitle());
            if (ConfigOptions.bIdeConsole.booleanValue()) {
                GV.consoleTextArea = new JTextArea();
                new Console(GV.consoleTextArea);
            }
            GV.appFrame = this;
            if (GV.dsModel == null) {
                GV.dsModel = new DataSourceListModel();
                FrameMain.loadDataSources();
            }
            this.barPanel.setLayout(new GridLayout());
            this.changeBar(GVData.getBaseMenu(), GVData.getBaseTool());
            this.getContentPane().add((Component)this.barPanel, "North");
            this.desk = new JDesktopPane();
            this.desk.setDragMode(JDesktopPane.LIVE_DRAG_MODE);
            this.desk.revalidate();
            this.getContentPane().add((Component)this.desk, "Center");
            ImageIcon ii = GV.getLogoImage();
            if (ii != null) {
                this.setIconImage(ii.getImage());
            }
            this.pack();
            this.jbInit();
            GV.allFrames.add(this);
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage());
            this.exit();
        }
    }

    public FrameManager(String openFile) {
        this(openFile, "", true);
    }

    public void changeBar(JMenuBar menu, JToolBar tool) {
        GV.appMenu = this.currentMenu = (AppMenu)menu;
        this.setJMenuBar(menu);
        GVData.appTool = tool;
        this.barPanel.removeAll();
        this.barPanel.add(tool);
        this.validate();
    }

    public boolean closeAll() {
        JInternalFrame[] frames = this.desk.getAllFrames();
        try {
            int i = 0;
            while (i < frames.length) {
                IDataSheet ids = (IDataSheet)((Object)frames[i]);
                if (!this.closeSheet(ids)) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception x) {
            GM.showException(x);
            return false;
        }
        File f = new File(ConfigFile.FILE_PATH());
        if (f.exists()) {
            try {
                ConfigFile.getConfigFile().setAttrValue("fileDirectory", GV.lastDirectory);
                GV.dsModel.save();
                if (MenuFactory.menuUseEditStyle != null) {
                    ConfigOptions.bUseEditStyle = new Boolean(MenuFactory.menuUseEditStyle.isSelected());
                }
                ConfigOptions.save();
            }
            catch (Throwable x) {
                GM.showException(x);
            }
        }
        return true;
    }

    public boolean closeSheet(IDataSheet dataSheet) {
        if (dataSheet == null) {
            return false;
        }
        String sheetTitle = dataSheet.getSheetTitle();
        if (!dataSheet.close()) {
            return false;
        }
        GV.appMenu.removeLiveMenu(sheetTitle);
        this.desk.getDesktopManager().closeFrame((JInternalFrame)((Object)dataSheet));
        JInternalFrame[] frames = this.desk.getAllFrames();
        if (frames.length == 0) {
            this.changeBar(GVData.getBaseMenu(), GVData.getBaseTool());
            GV.appMenu.resetPrivilegeMenu();
            GVData.activeSheet = null;
        } else {
            try {
                if (frames.length > 0) {
                    this.showSheet(frames[0]);
                }
            }
            catch (Exception x) {
            }
        }
        return true;
    }

    public boolean closeSheet(String sheetTitle) throws Exception {
        return this.closeSheet((IDataSheet)((Object)this.getSheet(sheetTitle)));
    }

    public boolean exit() {
        GV.allFrames.remove(this);
        if (this.terminalVM) {
            System.exit(0);
        } else {
            this.dispose();
        }
        return false;
    }

    public JInternalFrame getActiveSheet() {
        return this.desk.getSelectedFrame();
    }

    ShortMap getButtonEnableMap() {
        return null;
    }

    public AppMenu getCurrentMenu() {
        return this.currentMenu;
    }

    public IToolBar getCurrentToolBar() {
        return (IToolBar)((Object)GVData.appTool);
    }

    ShortMap getMenuVisibleMap() {
        return null;
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.setEnabled(true);
        this.addComponentListener(new ResizeListener(this));
        this.addWindowListener(new FrameManager_this_windowAdapter(this));
    }

    public static void main(String[] args) throws Throwable {
        FrameManager rf = FrameManager.main0(args);
        rf.setVisible(true);
        rf.check();
        rf.startAutoRecent();
        rf.startAutoLogin();
    }

    public static FrameManager main0(String[] args) throws Throwable {
        FrameMain.resetInstallDirectories();
        String openSemantic = "";
        String license = "";
        String arg = "";
        String usage = "Usage: com.runqian.datamanager.ide.FrameManager <options> <semanticFile>\r\nwhere possible options include:\r\n-license  <fileName>             Specify the default license file which needed\r\n-url <remote design url address> If use remote design, specify the remote server url\r\n-user <userId>                   The user ID which will login\r\n-password <password>             The user's password\r\n-help                            Print out these messages\r\n-?                               Print out these messages\r\nwhere semanticFile option is to specify the default file to be openned";
        if (args.length == 1 && (arg = args[0]).trim().indexOf(" ") > 0) {
            Section st = new Section(arg, ' ');
            args = st.toStringArray();
        }
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                arg = args[i].toLowerCase();
                if (!arg.equalsIgnoreCase("com.runqian.datamanager.ide.FrameManager")) {
                    if (arg.startsWith("-license")) {
                        license = args[++i];
                    } else if (arg.startsWith("-url")) {
                        GV.auto_url = args[++i];
                    } else if (arg.startsWith("-user")) {
                        GV.auto_user = args[++i];
                    } else if (arg.startsWith("-password")) {
                        GV.auto_pwd = args[++i];
                    } else if (!arg.startsWith("-")) {
                        if (!GM.isValidString(openSemantic)) {
                            openSemantic = args[i];
                        }
                    } else if (arg.startsWith("-help") || arg.startsWith("-?")) {
                        System.out.println(usage);
                        System.exit(0);
                    }
                }
                ++i;
            }
        }
        ConfigOptions.load();
        GV.lastDirectory = ConfigFile.getConfigFile().getAttrValue("fileDirectory");
        LookAndFeelManager.setLookAndFeel((byte)ConfigOptions.iLookAndFeel.intValue());
        String sTmp = System.getProperty("java.version");
        String sPath = System.getProperty("java.home");
        if (sTmp.compareTo("1.4.1") < 0) {
            Lang.setCurrentType("FrameManager");
            String t1 = Lang.get("jdkerror", GV.licProviderProduct, sPath, sTmp);
            String t2 = Lang.get((byte)8, GCWindow.T_Prompt);
            JOptionPane.showMessageDialog(null, t1, t2, 0);
            System.exit(0);
        }
        FrameManager frame = new FrameManager(openSemantic, license, true);
        frame.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        frame.setExtendedState(6);
        return frame;
    }

    public JInternalFrame openSemantic(String fileName, boolean isRemote) {
        try {
            fileName = fileName.trim();
            JInternalFrame o = this.getSheet(fileName);
            if (o != null) {
                this.showSheet(o);
                return null;
            }
            if (!isRemote) {
                File f = new File(fileName);
                if (GM.isValidString(fileName) && !f.exists()) {
                    throw new Exception(Lang.getText("framemanager.openfile") + "\uff08" + fileName + "\uff09" + Lang.getText("framemanager.notexist"));
                }
                if (GM.isValidString(fileName) && !fileName.toLowerCase().endsWith("rtt")) {
                    GV.lastDirectory = f.getParent();
                }
            }
            SheetViewManager frame = new SheetViewManager(fileName, isRemote);
            Dimension d = this.desk.getSize();
            frame.setBounds(0, 0, d.width, d.height);
            frame.show();
            this.desk.add(frame);
            frame.setMaximum(true);
            frame.setSelected(true);
            if (!isRemote) {
                GV.appMenu.refreshRecentSemantic(fileName);
            }
            return frame;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public SheetViewData openSheetData(View view) {
        return (SheetViewData)this.openSheetView(view);
    }

    public JInternalFrame openSheetFile(String fileName) {
        return null;
    }

    private JInternalFrame openSheetView(View view) {
        try {
            JInternalFrame sheet = this.getSheet(SheetViewData.getTitle(view.getViewName()));
            if (sheet != null) {
                this.showSheet(sheet);
                return null;
            }
            DialogViewCondition dvc = new DialogViewCondition();
            dvc.setView(view);
            int pc = 0;
            if (view instanceof TableView) {
                TableView tv = (TableView)view;
                pc = tv.getWhereCount();
            } else if (view instanceof SQLView) {
                SQLView sv = (SQLView)view;
                pc = sv.getParamCount();
            } else if (view instanceof ProcView) {
                ProcView pv = (ProcView)view;
                pc = pv.getParamCount();
            } else if (view instanceof CustomView) {
                CustomView cv = (CustomView)view;
                pc = cv.getParamCount();
            }
            if (pc > 0) {
                dvc.show();
                if (dvc.getOption() != 0) {
                    return null;
                }
            }
            ViewDataSetConfig vConfig = dvc.getViewConfig();
            sheet = new SheetViewData(GVData.activeSheet, vConfig);
            Dimension d = this.desk.getSize();
            sheet.setBounds(0, 0, d.width, d.height);
            sheet.show();
            this.desk.add(sheet);
            sheet.setMaximum(true);
            sheet.setSelected(true);
            return sheet;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public boolean quit() {
        if (this.closeAll()) {
            this.exit();
            return true;
        }
        return false;
    }

    public void startAutoRecent() {
        try {
            if (GM.isValidString(GV.autoOpenSemantic)) {
                if (GM.isValidString(LogInfo.servUrl)) {
                    this.openSemantic(GV.autoOpenSemantic, true);
                } else {
                    this.openSemantic(GV.autoOpenSemantic);
                }
            }
        }
        catch (Exception x) {
            // empty catch block
        }
        try {
            GV.allFrames.add(this);
            DataSource ds = null;
            if (GV.dsActive != null) {
                ds = GV.dsActive;
            } else if (GM.isValidString(GV.autoConnectDSName)) {
                ds = GV.dsModel.getDataSource(GV.autoConnectDSName);
            }
            if (ds != null) {
                new DelayConnectThread(ds).start();
            }
        }
        catch (Exception x) {
        }
    }

    void this_windowActivated(WindowEvent e) {
        GV.appFrame = this;
        GV.appMenu = this.currentMenu;
        GV.appMenu.resetLiveMenu();
        GV.appMenu.resetPrivilegeMenu();
    }

    void this_windowClosing(WindowEvent e) {
        this.update(this.getGraphics());
        if (Boolean.getBoolean("com.runqian.report.c")) {
            if (!this.closeAll()) {
                return;
            }
            if (!this.runned) {
                Thread t = new Thread(this.run);
                t.start();
            }
            this.hide();
            return;
        }
        if (!this.closeAll()) {
            this.setDefaultCloseOperation(0);
            return;
        }
        this.setDefaultCloseOperation(2);
        this.quit();
    }
}

