/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.ide;

import com.runqian.base4.swing.JTableEx;
import com.runqian.base4.tool.AppMenu;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.util.ShortMap;
import com.runqian.datamanager.base.IDataSheet;
import com.runqian.datamanager.datawindow.DataWindow;
import com.runqian.datamanager.ide.FrameManager;
import com.runqian.datamanager.ide.IToolBar;
import com.runqian.datamanager.ide.MenuBase;
import com.runqian.datamanager.ide.MenuData;
import com.runqian.datamanager.ide.MenuManager;
import com.runqian.datamanager.ide.ToolBarBase;
import com.runqian.datamanager.ide.ToolBarData;
import com.runqian.datamanager.ide.ToolBarManager;
import com.runqian.report4.ide.base.TypesEx;
import com.runqian.report4.ide.dialog.DialogExpEditor;
import com.runqian.report4.model.SemanticsParser;
import com.runqian.report4.semantics.ColInfo;
import com.runqian.report4.semantics.SemanticsManager;
import com.runqian.report4.semantics.TableView;
import com.runqian.report4.semantics.View;
import java.awt.Component;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.table.TableCellEditor;

public class GVData
extends GV {
    public static IDataSheet activeSheet = null;
    public static JToolBar appTool = null;
    public static ShortMap buttonEnableMap;
    public static ShortMap buttonVisibleMap;
    public static ShortMap menuEnableMap;
    public static ShortMap menuVisibleMap;
    public static String newNamePrefix;
    private static short newViewCount;

    static {
        newViewCount = 0;
        newNamePrefix = "view_";
        menuVisibleMap = new ShortMap();
        menuEnableMap = new ShortMap();
        buttonVisibleMap = new ShortMap();
        buttonEnableMap = new ShortMap();
    }

    public static HashMap calcDWDataMap(DataWindow dw) {
        if (dw == null) {
            return null;
        }
        HashMap map = new HashMap();
        int rc = dw.getRowCount();
        int cc = dw.getColCount();
        if (rc == 0) {
            return null;
        }
        int j = 0;
        while (j < cc) {
            Vector<Object> data = new Vector<Object>();
            int i = 0;
            while (i < rc) {
                Object o = dw.getItem(i + 1, j + 1);
                data.add(o);
                ++i;
            }
            String colTitle = dw.getColInfo(j + 1).getColTitle();
            if (colTitle == null) {
                colTitle = dw.getColInfo(j + 1).getColName();
            } else if (colTitle.endsWith(" \u2191") || colTitle.endsWith(" \u2193")) {
                colTitle = colTitle.substring(0, colTitle.length() - " \u2191".length());
            }
            map.put(colTitle, data);
            ++j;
        }
        return map;
    }

    public static boolean dialogEditTableDispExp(JTableEx table, int r, int c, SemanticsManager vManager, boolean useRQ) {
        DefaultCellEditor editor;
        Component cp;
        TableCellEditor o = table.getCellEditor(r, c);
        if (o instanceof DefaultCellEditor && (cp = (editor = (DefaultCellEditor)o).getComponent()) instanceof JCheckBox) {
            return false;
        }
        Object sData = table.getValueAt(r, c);
        if (!GM.isValidString(sData)) {
            sData = "";
        }
        DialogExpEditor dee = new DialogExpEditor();
        table.acceptText();
        String exp = sData.toString();
        if (exp == null) {
            exp = "";
        }
        dee.setEditingType(1 + 2 + 4);
        dee.setExpression(exp);
        dee.setFmtStringType((byte)2);
        dee.setDataMap(GV.calcSManagerViewColMap(vManager));
        dee.setUseRQFunc(useRQ);
        dee.setSemanticsManager(activeSheet.getViewManager());
        dee.setUseDataSet(true);
        dee.init();
        dee.show();
        if (dee.getOption() == 0) {
            exp = dee.getExpression();
            if (exp.equals("=")) {
                exp = "";
            }
            table.setValueAt(exp, r, c);
            table.acceptText();
        }
        return false;
    }

    public static boolean dialogEditTableExp(JTableEx table, int r, int c, SemanticsManager vManager, boolean useRQ, String viewName, boolean replaced) {
        DefaultCellEditor editor;
        Component cp;
        TableCellEditor o = table.getCellEditor(r, c);
        if (o instanceof DefaultCellEditor && (cp = (editor = (DefaultCellEditor)o).getComponent()) instanceof JCheckBox) {
            return false;
        }
        Object sData = table.getValueAt(r, c);
        if (!GM.isValidString(sData)) {
            sData = "";
        }
        DialogExpEditor dee = new DialogExpEditor();
        table.acceptText();
        String exp = sData.toString();
        if (exp == null) {
            exp = "";
        }
        View v = vManager.getView(viewName);
        if (replaced && v != null && v instanceof TableView) {
            exp = SemanticsParser.replaceColumnName(exp, (TableView)v);
        }
        if (!useRQ && v != null) {
            dee.setDataSrcName(v.getDataSourceName());
        }
        dee.setEditingType(2);
        dee.setExpression("=" + exp);
        HashMap dataMap = GV.calcViewColDataMap(vManager, viewName);
        if (v != null && dataMap != null) {
            dee.setDataMap(dataMap);
            dee.setColTypes(GV.getViewColTypes(v, dataMap));
            if (!useRQ) {
                dee.setDataSrcName(v.getDataSourceName());
            }
        }
        dee.setUseDataSet(false);
        dee.setUseRQFunc(useRQ);
        dee.init();
        dee.show();
        if (dee.getOption() == 0) {
            exp = dee.getExpression();
            if (exp.length() > 0) {
                exp = exp.substring(1);
            }
            if (replaced && v != null && v instanceof TableView) {
                exp = SemanticsParser.replaceColumnTitle(exp, (TableView)v);
            }
            table.setValueAt(exp, r, c);
            table.acceptText();
        }
        return false;
    }

    public static boolean dialogEditTableExp(JTableEx table, int r, int c, SemanticsManager vManager, boolean useRQ) {
        DefaultCellEditor editor;
        Component cp;
        TableCellEditor o = table.getCellEditor(r, c);
        if (o instanceof DefaultCellEditor && (cp = (editor = (DefaultCellEditor)o).getComponent()) instanceof JCheckBox) {
            return false;
        }
        Object sData = table.getValueAt(r, c);
        if (!GM.isValidString(sData)) {
            sData = "";
        }
        DialogExpEditor dee = new DialogExpEditor();
        table.acceptText();
        String exp = sData.toString();
        if (exp == null) {
            exp = "";
        }
        dee.setEditingType(2);
        dee.setExpression("=" + exp);
        dee.setDataMap(GV.calcSManagerViewColMap(vManager));
        dee.setUseRQFunc(useRQ);
        dee.setUseDataSet(true);
        dee.init();
        dee.show();
        if (dee.getOption() == 0) {
            exp = dee.getExpression();
            if (exp.length() > 0) {
                exp = exp.substring(1);
            }
            table.setValueAt(exp, r, c);
            table.acceptText();
        }
        return false;
    }

    public static String generateCreateSql(View view, boolean isUseSchema) throws Exception {
        TableView tv = (TableView)view;
        String tableName = GVData.getProperTableName(tv, isUseSchema);
        StringBuffer sql = new StringBuffer();
        int count = view.getColCount();
        if (count == 0) {
            throw new Exception(Lang.getText("dialogcreatetables.cantcreate"));
        }
        sql.append("CREATE TABLE ");
        sql.append(tableName);
        sql.append("(");
        boolean hasPrimary = false;
        String primaryKeys = "";
        Vector<String> vecKeys = new Vector<String>();
        int i = 0;
        while (i < count) {
            ColInfo ci = view.getColInfo(i);
            String name = ci.getColName();
            boolean isPrimary = ci.isPrimaryKey();
            sql.append(name);
            sql.append(" ");
            sql.append(TypesEx.getColDescriptionSQL(GV.dsActive.getDBType(), ci));
            if (isPrimary) {
                vecKeys.addElement(name);
                hasPrimary = true;
            }
            if (i != count - 1 || hasPrimary) {
                sql.append(",");
            }
            ++i;
        }
        if (hasPrimary) {
            int j = 0;
            while (j < vecKeys.size()) {
                primaryKeys = primaryKeys + vecKeys.get(j);
                if (j != vecKeys.size() - 1) {
                    primaryKeys = primaryKeys + ",";
                }
                ++j;
            }
            sql.append("primary key (");
            sql.append(primaryKeys);
            sql.append(")");
        }
        sql.append(")");
        return sql.toString();
    }

    public static JMenuBar getBaseMenu() {
        GV.appMenu = new MenuBase();
        GVData.resetMenuStatus(GV.appMenu);
        return GV.appMenu;
    }

    public static JToolBar getBaseTool() {
        appTool = new ToolBarBase();
        GVData.resetToolBarStatus((IToolBar)((Object)appTool));
        return appTool;
    }

    public static JMenuBar getDataMenu() {
        GV.appMenu = new MenuData();
        GVData.resetMenuStatus(GV.appMenu);
        return GV.appMenu;
    }

    public static JToolBar getDataTool() {
        appTool = new ToolBarData();
        GVData.resetToolBarStatus((IToolBar)((Object)appTool));
        return appTool;
    }

    public static JMenuBar getEditorMenu() {
        return null;
    }

    public static FrameManager getFrameManager() {
        return (FrameManager)GV.appFrame;
    }

    public static JMenuBar getManagerMenu() {
        GV.appMenu = new MenuManager();
        GVData.resetMenuStatus(GV.appMenu);
        return GV.appMenu;
    }

    public static JToolBar getManagerTool() {
        appTool = new ToolBarManager();
        GVData.resetToolBarStatus((IToolBar)((Object)appTool));
        return appTool;
    }

    public static String getNewName(String prefix, short c) {
        return prefix + c;
    }

    public static String getNewViewName() {
        short s = newViewCount;
        newViewCount = (short)(s + 1);
        return GVData.getNewName(newNamePrefix, s);
    }

    static void resetMenuStatus(AppMenu menuBar) {
        int i = 0;
        while (i < menuVisibleMap.size()) {
            short id = menuVisibleMap.getKey(i);
            Boolean vis = (Boolean)menuVisibleMap.getValue(i);
            menuBar.setMenuIdVisible(id, vis);
            ++i;
        }
        int i2 = 0;
        while (i2 < menuEnableMap.size()) {
            short id = menuEnableMap.getKey(i2);
            Boolean en = (Boolean)menuEnableMap.getValue(i2);
            menuBar.setMenuIdEnabled(id, en);
            ++i2;
        }
    }

    static void resetToolBarStatus(IToolBar toolBar) {
        int i = 0;
        while (i < buttonVisibleMap.size()) {
            short id = buttonVisibleMap.getKey(i);
            Boolean vis = (Boolean)buttonVisibleMap.getValue(i);
            toolBar.setButtonVisible(id, vis);
            ++i;
        }
        int i2 = 0;
        while (i2 < buttonEnableMap.size()) {
            short id = buttonEnableMap.getKey(i2);
            Boolean en = (Boolean)buttonEnableMap.getValue(i2);
            toolBar.setButtonEnable(new short[]{id}, en);
            ++i2;
        }
    }
}

