/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.ide;

import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.Escape;
import com.runqian.base4.util.SQLParser;
import com.runqian.base4.util.Sentence;
import com.runqian.datamanager.base.IDataSheet;
import com.runqian.datamanager.base.MenuFactory;
import com.runqian.datamanager.datawindow.DWColInfo;
import com.runqian.datamanager.datawindow.DataWindow;
import com.runqian.datamanager.datawindow.DefaultDWListener;
import com.runqian.datamanager.dialog.DialogBatchSetData;
import com.runqian.datamanager.dialog.DialogDataSearch;
import com.runqian.datamanager.dialog.DialogDataSort;
import com.runqian.datamanager.dialog.DialogExportProperty;
import com.runqian.datamanager.dialog.DialogViewCondition;
import com.runqian.datamanager.ide.GVData;
import com.runqian.datamanager.ide.ToolBarData;
import com.runqian.report4.dataset.ColInfoBase;
import com.runqian.report4.dataset.DataSet;
import com.runqian.report4.dataset.IDataSetFactory;
import com.runqian.report4.dataset.ViewDataSetFactory;
import com.runqian.report4.ide.base.DataSource;
import com.runqian.report4.ide.base.TypesEx;
import com.runqian.report4.ide.dialog.DialogExpEditor;
import com.runqian.report4.ide.dialog.DialogInputArgument;
import com.runqian.report4.model.Matrix;
import com.runqian.report4.model.SemanticsParser;
import com.runqian.report4.semantics.BuiltinView;
import com.runqian.report4.semantics.ColInfo;
import com.runqian.report4.semantics.CustomView;
import com.runqian.report4.semantics.EditStyle;
import com.runqian.report4.semantics.EditStyleList;
import com.runqian.report4.semantics.ICustomViewDataSetFactory;
import com.runqian.report4.semantics.ProcView;
import com.runqian.report4.semantics.SQLView;
import com.runqian.report4.semantics.SemanticsManager;
import com.runqian.report4.semantics.TableView;
import com.runqian.report4.semantics.View;
import com.runqian.report4.semantics.ViewParam;
import com.runqian.report4.semantics.Where;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.ParamMetaData;
import com.runqian.report4.usermodel.ProcDataSetConfig;
import com.runqian.report4.usermodel.SQLDataSetConfig;
import com.runqian.report4.usermodel.Types;
import com.runqian.report4.usermodel.ViewDataSetConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.apache.poi2.hssf.usermodel.HSSFCell;
import org.apache.poi2.hssf.usermodel.HSSFRow;
import org.apache.poi2.hssf.usermodel.HSSFSheet;
import org.apache.poi2.hssf.usermodel.HSSFWorkbook;

public class SheetViewData
extends JInternalFrame
implements IDataSheet {
    private boolean asc = true;
    private static Connection conn;
    private DataWindow dw;
    private static boolean isDataChanged;
    private static IDataSheet rootSheet;
    private byte selectAll = 0;
    private byte selectNone = 1;
    private byte selectReverse = (byte)2;
    private Vector sort;
    private String sortCol;
    private String sql;
    private View view;
    private String where;

    static {
        isDataChanged = false;
    }

    public SheetViewData() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SheetViewData(IDataSheet rootSheet, ViewDataSetConfig vConfig) {
        super(SheetViewData.getTitle(vConfig.getViewName()), true, true, true, true);
        SheetViewData.rootSheet = rootSheet;
        this.view = GVData.activeSheet.getViewManager().getView(vConfig.getViewName());
        this.sql = SheetViewData.getViewSQL(this.view);
        this.getContentPane().setLayout(new BorderLayout());
        String[] colNames = this.getColNames();
        this.dw = this.view instanceof TableView ? new DataWindow(colNames, false, true) : new DataWindow(colNames, true, true);
        this.dw.addDataWindowListener(new DefaultDWListener(){

            public void itemChanged(DataWindow dw, int row, int col, String newValue, String oldValue) {
                SheetViewData.dataModified(true);
            }

            public void mouseClicked(DataWindow dw, MouseEvent e, int row, int col) {
                if (row < 1 && col > 0) {
                    dw.acceptText();
                    if (SheetViewData.this.sortCol != null && !dw.getColInfo(col).getColName().equals(SheetViewData.this.sortCol)) {
                        SheetViewData.this.asc = true;
                    }
                    SheetViewData.this.sortCol = dw.getColInfo(col).getColName();
                    String sort = SheetViewData.this.asc ? "asc" : "desc";
                    dw.sort(SheetViewData.this.sortCol + " " + sort);
                    SheetViewData.this.setColLabel();
                    String arrow = SheetViewData.this.asc ? " \u2191" : " \u2193";
                    dw.getColInfo(col).setColTitle(dw.getColInfo(col).getColTitle() + arrow);
                    SheetViewData.this.asc = !SheetViewData.this.asc;
                }
            }
        });
        try {
            conn = SheetViewData.getConnection(this.view.getDataSourceName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.dw.setMultSelect(true);
        this.dw.setViewDataSetConfig(vConfig, GVData.activeSheet.getViewManager());
        this.setColInfos();
        this.dw.display();
        this.getContentPane().add((Component)this.dw, "Center");
        this.repaint();
        this.addInternalFrameListener(new Listener(this));
        this.setDefaultCloseOperation(0);
    }

    static /* synthetic */ View access$400(SheetViewData x0) {
        return x0.view;
    }

    private int addRow() {
        int i = 1;
        while (i <= this.dw.getRowCount()) {
            this.dw.setRowSelected(i, false);
            ++i;
        }
        int row = this.dw.insertRow(-1);
        if (this.dw.getRowCount() > 0) {
            this.dw.setRowSelected(this.dw.getRowCount(), true);
        }
        SheetViewData.dataModified(true);
        return row;
    }

    private void batchSetData() {
        DialogBatchSetData dbsd = new DialogBatchSetData(this.view, this.dw);
        dbsd.show();
    }

    public boolean close() {
        if (isDataChanged) {
            Object[] options;
            String title;
            String message = Lang.getText("sheetviewdata.queryclose");
            int option = JOptionPane.showOptionDialog(null, message, title = Lang.getText("sheetviewdata.confirmclose"), -1, 2, null, options = new Object[]{Lang.getText("public.yes"), Lang.getText("public.no"), Lang.getText("sheetviewdata.cancel")}, options[0]);
            if (option == 2) {
                return false;
            }
            if (option == 0 && !this.save()) {
                return false;
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
            }
        }
        this.dispose();
        return true;
    }

    private String copy(boolean cut) {
        StringBuffer sb = new StringBuffer(1024);
        int rowCount = this.dw.getRowCount();
        int[] cutRows = new int[rowCount];
        int count = 0;
        int row = 1;
        while (row <= this.dw.getRowCount()) {
            if (this.dw.getRowSelected(row)) {
                String rowData = this.getRowData(row);
                sb.append(rowData);
                if (row < this.dw.getRowCount()) {
                    sb.append("\n");
                }
                cutRows[count] = row;
                ++count;
            }
            ++row;
        }
        if (cut) {
            int i = count - 1;
            while (i >= 0) {
                this.dw.deleteRow(cutRows[i]);
                --i;
            }
        }
        return sb.toString();
    }

    public static boolean createViewStructs(View view, boolean showMsg) throws Exception {
        Context context;
        block74: {
            if (view == null) {
                return false;
            }
            if (view instanceof BuiltinView) {
                return false;
            }
            context = null;
            try {
                context = GV.prepareContext(GVData.activeSheet.getViewManager());
            }
            catch (Exception e) {
                if (showMsg) {
                    GM.showException(e);
                }
                if (view instanceof CustomView) break block74;
                return false;
            }
        }
        conn = SheetViewData.getConnection(view.getDataSourceName());
        if (view instanceof CustomView) {
            CustomView cv = (CustomView)view;
            String factory = cv.getViewDataSetFactoryClass();
            if (!GM.isValidString(factory)) {
                return false;
            }
            ICustomViewDataSetFactory cvf = (ICustomViewDataSetFactory)Class.forName(factory).newInstance();
            DataSet ds = cvf.createDataSet(context, cv, false);
            if (ds == null) {
                if (showMsg) {
                    JOptionPane.showMessageDialog(null, Lang.getText("sheetviewdata.createfalse"), Lang.getText("public.error"), 2);
                }
                return false;
            }
            int c = cv.getColCount();
            int dsCount = ds.getColCount();
            int i = c - 1;
            while (i >= 0) {
                boolean b = false;
                int j = 0;
                while (j < dsCount) {
                    if (ds.getColInfo(j).getColName().equals(cv.getColInfo(i).getColName())) {
                        b = true;
                    }
                    ++j;
                }
                if (!b) {
                    cv.removeCol(i);
                }
                --i;
            }
            int viewCount = cv.getColCount();
            int i2 = 0;
            while (i2 < dsCount) {
                ColInfo ci = new ColInfo();
                ColInfoBase cib = ds.getColInfo(i2);
                boolean exist = false;
                int j = 0;
                while (j < viewCount) {
                    if (cv.getColInfo(j).getColName().equals(cib.getColName())) {
                        ci = view.getColInfo(j);
                        exist = true;
                        break;
                    }
                    ++j;
                }
                if (!exist) {
                    ci.setColName(cib.getColName());
                    if (cib.getColTitle() == null) {
                        ci.setColTitle(cib.getColName());
                    } else {
                        ci.setColTitle(cib.getColTitle());
                    }
                }
                ci.setDataPrecision(cib.getDataPrecision());
                ci.setDataType(TypesEx.getDBTypeByRQType(cib.getDataType()));
                ci.setDataWidth(cib.getDataWidth());
                ci.setNullable(cib.isNullable());
                ci.setPrimaryKey(cib.isPrimaryKey());
                if (!exist) {
                    cv.addColInfo(ci);
                }
                ++i2;
            }
            view = cv;
            return true;
        }
        if (view instanceof TableView) {
            DataSource dsrc;
            TableView tv = (TableView)view;
            SQLDataSetConfig config = new SQLDataSetConfig();
            String fullName = tv.getTableName();
            String schema = tv.getSchema();
            int index = fullName.indexOf(".");
            String tableName = fullName;
            if (index > 0) {
                tableName = fullName.substring(index + 1);
                schema = fullName.substring(0, index);
            }
            config.setDataSourceName(view.getDataSourceName());
            config.setBeginRow(view.getBeginRow());
            config.setEndRow(view.getEndRow());
            config.setName(tableName);
            config.setSchema(schema);
            DataSource tmpDs = null;
            if (GM.isValidString(view.getDataSourceName())) {
                tmpDs = GV.dsModel.getDataSource(view.getDataSourceName());
            } else if (GM.isValidString(context.getDefDataSourceName())) {
                tmpDs = GV.dsModel.getDataSource(context.getDefDataSourceName());
            }
            if (tmpDs == null) {
                if (showMsg) {
                    JOptionPane.showMessageDialog(null, Lang.getText("sheetviewdata.notconnect") + "[ " + view.getDataSourceName() + " ].", Lang.getText("public.note"), 2);
                }
                return false;
            }
            fullName = tmpDs.isUseSchema() && GM.isValidString(schema) ? schema + "." + tableName : tableName;
            String sql = "select * from " + fullName;
            config.setSQL(sql);
            String factory = config.getFactoryClass();
            IDataSetFactory dsf = (IDataSetFactory)Class.forName(factory).newInstance();
            DataSet ds = dsf.createDataSet(context, config, false);
            if (ds == null) {
                if (showMsg) {
                    JOptionPane.showMessageDialog(null, Lang.getText("sheetviewdata.notfound") + "[ " + tv.getTableName() + " ].", Lang.getText("public.error"), 2);
                }
                return false;
            }
            int c = tv.getColCount();
            int dsCount = ds.getColCount();
            int i = c - 1;
            while (i >= 0) {
                boolean b = false;
                int j = 0;
                while (j < dsCount) {
                    if (ds.getColInfo(j).getColName().equals(tv.getColInfo(i).getColName())) {
                        b = true;
                    }
                    ++j;
                }
                if (!b) {
                    tv.removeCol(i);
                }
                --i;
            }
            int viewCount = tv.getColCount();
            int i3 = 0;
            while (i3 < dsCount) {
                ColInfo ci = new ColInfo();
                ColInfoBase cib = ds.getColInfo(i3);
                boolean exist = false;
                int j = 0;
                while (j < viewCount) {
                    if (tv.getColInfo(j).getColName().equals(cib.getColName())) {
                        ci = view.getColInfo(j);
                        exist = true;
                        break;
                    }
                    ++j;
                }
                if (!exist) {
                    ci.setColName(cib.getColName());
                    if (!GM.isValidString(cib.getColTitle())) {
                        ci.setColTitle(cib.getColName());
                    } else {
                        ci.setColTitle(cib.getColTitle());
                    }
                }
                ci.setDataPrecision(cib.getDataPrecision());
                ci.setDataType(TypesEx.getDBTypeByRQType(cib.getDataType()));
                ci.setDataWidth(cib.getDataWidth());
                ci.setNullable(cib.isNullable());
                ci.setPrimaryKey(cib.isPrimaryKey());
                if (!exist) {
                    tv.addColInfo(ci);
                }
                ++i3;
            }
            SheetViewData.setTableTitle(tv);
            String dsName = tv.getDataSourceName();
            if (!GM.isValidString(dsName)) {
                dsName = GV.dsActive.getName();
            }
            if ((dsrc = GV.dsModel.getDataSource(dsName)).getDBType() != 7) {
                Connection conn = dsrc.getConnection();
                DatabaseMetaData dbmd = conn.getMetaData();
                ResultSet rs = dbmd.getPrimaryKeys(conn.getCatalog(), GV.getProperTableSchema(tv, dsrc.isUseSchema()), GV.getProperTableName(tv, false));
                while (rs.next()) {
                    String colName = rs.getString("COLUMN_NAME");
                    tv.getColInfoByColName(colName).setPrimaryKey(true);
                }
            }
            view = tv;
            return true;
        }
        if (view instanceof SQLView) {
            SQLView sv = (SQLView)view;
            SQLDataSetConfig config = new SQLDataSetConfig();
            config.setSQL(sv.getSQL());
            config.setDataSourceName(sv.getDataSourceName());
            config.setBeginRow(sv.getBeginRow());
            config.setEndRow(sv.getEndRow());
            int i = 0;
            while (i < sv.getParamCount()) {
                ViewParam vp = sv.getParam(i);
                config.addParam(vp.getDefValue(), (byte)0);
                ++i;
            }
            String factory = config.getFactoryClass();
            IDataSetFactory dsf = (IDataSetFactory)Class.forName(factory).newInstance();
            DataSet ds = dsf.createDataSet(context, config, false);
            if (ds == null) {
                if (showMsg) {
                    JOptionPane.showMessageDialog(null, Lang.getText("sheetviewdata.createfalse"), Lang.getText("public.error"), 2);
                }
                return false;
            }
            int c = sv.getColCount();
            int dsCount = ds.getColCount();
            int i4 = c - 1;
            while (i4 >= 0) {
                boolean b = false;
                int j = 0;
                while (j < dsCount) {
                    if (ds.getColInfo(j).getColName().equals(sv.getColInfo(i4).getColName())) {
                        b = true;
                    }
                    ++j;
                }
                if (!b) {
                    sv.removeCol(i4);
                }
                --i4;
            }
            int viewCount = sv.getColCount();
            int i5 = 0;
            while (i5 < dsCount) {
                ColInfo ci = new ColInfo();
                ColInfoBase cib = ds.getColInfo(i5);
                boolean exist = false;
                int j = 0;
                while (j < viewCount) {
                    if (sv.getColInfo(j).getColName().equals(cib.getColName())) {
                        ci = view.getColInfo(j);
                        exist = true;
                        break;
                    }
                    ++j;
                }
                if (!exist) {
                    ci.setColName(cib.getColName());
                    if (cib.getColTitle() == null) {
                        ci.setColTitle(cib.getColName());
                    } else {
                        ci.setColTitle(cib.getColTitle());
                    }
                }
                ci.setDataPrecision(cib.getDataPrecision());
                ci.setDataType(TypesEx.getDBTypeByRQType(cib.getDataType()));
                ci.setDataWidth(cib.getDataWidth());
                ci.setNullable(cib.isNullable());
                ci.setPrimaryKey(cib.isPrimaryKey());
                if (!exist) {
                    sv.addColInfo(ci);
                }
                ++i5;
            }
            view = sv;
            return true;
        }
        if (view instanceof ProcView) {
            ProcView pv = (ProcView)view;
            ProcDataSetConfig config = new ProcDataSetConfig();
            config.setSQL(pv.getSQL());
            config.setDataSourceName(pv.getDataSourceName());
            config.setBeginRow(pv.getBeginRow());
            config.setEndRow(pv.getEndRow());
            int i = 0;
            while (i < pv.getParamCount()) {
                ViewParam vp = pv.getParam(i);
                byte type = vp.getType();
                byte mode = 0;
                if (type == 101) {
                    mode = 1;
                }
                config.addParam(vp.getDefValue(), type, mode, "");
                ++i;
            }
            String factory = config.getFactoryClass();
            IDataSetFactory dsf = (IDataSetFactory)Class.forName(factory).newInstance();
            DataSet ds = dsf.createDataSet(context, config, false);
            if (ds == null) {
                if (showMsg) {
                    JOptionPane.showMessageDialog(null, Lang.getText("sheetviewdata.createfalse"), Lang.getText("public.error"), 2);
                }
                return false;
            }
            int c = pv.getColCount();
            int dsCount = ds.getColCount();
            int i6 = c - 1;
            while (i6 >= 0) {
                boolean b = false;
                int j = 0;
                while (j < dsCount) {
                    if (ds.getColInfo(j).getColName().equals(pv.getColInfo(i6).getColName())) {
                        b = true;
                    }
                    ++j;
                }
                if (!b) {
                    pv.removeCol(i6);
                }
                --i6;
            }
            int viewCount = pv.getColCount();
            int i7 = 0;
            while (i7 < dsCount) {
                ColInfo ci = new ColInfo();
                ColInfoBase cib = ds.getColInfo(i7);
                boolean exist = false;
                int j = 0;
                while (j < viewCount) {
                    if (pv.getColInfo(j).getColName().equals(cib.getColName())) {
                        ci = view.getColInfo(j);
                        exist = true;
                        break;
                    }
                    ++j;
                }
                if (!exist) {
                    ci.setColName(cib.getColName());
                    if (cib.getColTitle() == null) {
                        ci.setColTitle(cib.getColName());
                    } else {
                        ci.setColTitle(cib.getColTitle());
                    }
                }
                ci.setDataPrecision(cib.getDataPrecision());
                ci.setDataType(TypesEx.getDBTypeByRQType(cib.getDataType()));
                ci.setDataWidth(cib.getDataWidth());
                ci.setNullable(cib.isNullable());
                ci.setPrimaryKey(cib.isPrimaryKey());
                if (!exist) {
                    pv.addColInfo(ci);
                }
                ++i7;
            }
            view = pv;
            return true;
        }
        return false;
    }

    public static void dataModified(boolean changed) {
        isDataChanged = changed;
        GV.appMenu.setEnable(new short[]{5020}, changed);
        ((ToolBarData)GVData.appTool).setEnable((short)5020, changed);
    }

    public Object executeCmd(short cmd) {
        if (this.view.getColCount() == 0) {
            return null;
        }
        int row = 1;
        if (this.dw.getActiveCell() != null) {
            row = this.dw.getActiveCell().getRow();
        }
        switch (cmd) {
            case 5301: {
                this.retrieve();
                break;
            }
            case 5226: {
                int i = 1;
                while (i <= this.dw.getRowCount()) {
                    this.dw.setRowSelected(i, false);
                    ++i;
                }
                this.dw.insertRow(row);
                this.dw.setRowSelected(row, true);
                SheetViewData.dataModified(true);
                break;
            }
            case 5225: {
                this.addRow();
                break;
            }
            case 5230: {
                if (this.dw.getRowCount() == 0) break;
                int option = JOptionPane.showOptionDialog(this, Lang.getText("sheetviewmanager.querydelete"), Lang.getText("public.delete"), 0, 3, null, new String[]{Lang.getText("public.yes"), Lang.getText("public.no")}, Lang.getText("public.no"));
                if (option != 0) {
                    return null;
                }
                this.dw.deleteSelectedRows();
                if (this.dw.getActiveCell() != null) {
                    this.dw.setRowSelected(this.dw.getActiveCell().getRow(), true);
                }
                SheetViewData.dataModified(true);
                break;
            }
            case 5220: {
                this.select(this.selectAll);
                break;
            }
            case 5235: {
                String copyData = this.copy(false);
                GM.clipBoard(copyData);
                break;
            }
            case 5240: {
                String cutData = this.copy(true);
                GM.clipBoard(cutData);
                if (cutData == null) break;
                SheetViewData.dataModified(true);
                break;
            }
            case 5245: {
                String pasteData = GM.clipBoard();
                this.paste(pasteData);
                if (pasteData == null) break;
                SheetViewData.dataModified(true);
                break;
            }
            case 5250: {
                break;
            }
            case 5270: {
                break;
            }
            case 5290: {
                this.select(this.selectNone);
                break;
            }
            case 5291: {
                this.select(this.selectReverse);
                break;
            }
            case 5310: {
                this.query();
                break;
            }
            case 5315: {
                break;
            }
            case 5320: {
                this.sort();
                break;
            }
            case 5335: {
                this.search();
                break;
            }
            case 5340: {
                this.replace();
                break;
            }
            case 5325: {
                this.importData();
                break;
            }
            case 5330: {
                this.exportData();
                break;
            }
            case 5345: {
                this.batchSetData();
                break;
            }
            case 5350: {
                break;
            }
            case 5355: {
                this.dw.reset();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Matrix executeSQL(String sql) {
        PreparedStatement ps;
        block12: {
            ps = null;
            if (conn != null) break block12;
            Matrix matrix = null;
            Object var9_5 = null;
            if (ps == null) return matrix;
            try {
                ps.close();
                return matrix;
            }
            catch (SQLException ex1) {
            }
            return matrix;
        }
        ps = conn.prepareStatement(sql);
        ResultSet rs = ps.executeQuery(sql);
        ResultSetMetaData rsmd = rs.getMetaData();
        Matrix matrix = new Matrix();
        int cc = rsmd.getColumnCount();
        int r = 0;
        matrix.addCols(cc);
        while (rs.next()) {
            matrix.addRow();
            int c = 0;
            while (c < cc) {
                matrix.set(r, c, rs.getString(c + 1));
                ++c;
            }
            ++r;
        }
        Matrix matrix2 = matrix;
        Object var9_6 = null;
        if (ps == null) return matrix2;
        try {
            ps.close();
            return matrix2;
        }
        catch (SQLException ex1) {
        }
        return matrix2;
        catch (Exception ex) {
            try {
                GM.showException(ex);
                Object var9_7 = null;
                if (ps == null) return null;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (ps == null) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ex1) {
                }
                throw throwable;
            }
            try {
                ps.close();
                return null;
            }
            catch (SQLException ex1) {
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void exportData() {
        File file;
        String types = "xls,txt";
        if (this.view instanceof TableView) {
            types = types + ",sql";
        }
        if ((file = GM.dialogSelectFile(types, GV.lastDirectory, null, "")) == null) {
            return;
        }
        DialogExportProperty dep = new DialogExportProperty();
        dep.show();
        if (dep.getOption() != 0) {
            return;
        }
        boolean exportTitle = dep.exportTitle();
        boolean exportDisp = dep.exportDisp();
        String fileName = file.getName();
        int rowCount = this.dw.getRowCount();
        int colCount = this.dw.getColCount();
        if (fileName.endsWith(".txt")) {
            int i;
            StringBuffer sb = new StringBuffer();
            if (exportTitle) {
                i = 1;
                while (i <= colCount) {
                    String title = this.dw.getColInfo(i).getColTitle();
                    sb.append(title);
                    if (i != colCount) {
                        sb.append("\t");
                    } else {
                        sb.append("\r\n");
                    }
                    ++i;
                }
            }
            i = 1;
            while (i <= rowCount) {
                int j = 1;
                while (j <= colCount) {
                    String value = "";
                    value = exportDisp ? this.dw.getCellText(this.dw.getItem(i, j), this.dw.getColInfo(j)) : (this.dw.getItem(i, j) != null ? String.valueOf(this.dw.getItem(i, j)) : "");
                    sb.append(value);
                    if (j != colCount) {
                        sb.append("\t");
                    } else {
                        sb.append("\r\n");
                    }
                    ++j;
                }
                ++i;
            }
            FileWriter writer = null;
            writer = new FileWriter(file);
            writer.write(sb.toString());
            Object var14_27 = null;
            if (writer == null) return;
            try {
                writer.close();
                return;
            }
            catch (IOException ex3) {
                GM.showException(ex3);
            }
            return;
            {
                catch (Exception ex) {
                    GM.showException(ex);
                    Object var14_28 = null;
                    if (writer == null) return;
                    try {
                        writer.close();
                        return;
                    }
                    catch (IOException ex3) {
                        GM.showException(ex3);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var14_29 = null;
                if (writer == null) throw throwable;
                try {
                    writer.close();
                    throw throwable;
                }
                catch (IOException ex3) {
                    GM.showException(ex3);
                }
                throw throwable;
            }
        }
        if (fileName.endsWith(".xls")) {
            FileOutputStream out = null;
            FileInputStream in = null;
            try {
                HSSFWorkbook wb;
                if (file.isFile()) {
                    in = new FileInputStream(file.getAbsolutePath());
                    wb = new HSSFWorkbook((InputStream)in);
                    if (in != null) {
                        in.close();
                    }
                    int i = wb.getNumberOfSheets() - 1;
                    while (i >= 0) {
                        wb.removeSheetAt(i);
                        --i;
                    }
                } else {
                    wb = new HSSFWorkbook();
                }
                HSSFSheet sheet = wb.createSheet();
                out = new FileOutputStream(file);
                if (exportTitle) {
                    HSSFRow row = sheet.createRow(0);
                    int i = 0;
                    while (i < colCount) {
                        HSSFCell cell = row.createCell((short)i);
                        cell.setCellValue(this.dw.getColInfo(i + 1).getColTitle());
                        ++i;
                    }
                }
                int i = 0;
                while (i < rowCount) {
                    HSSFRow row = exportTitle ? sheet.createRow(i + 1) : sheet.createRow(i);
                    int j = 0;
                    while (j < colCount) {
                        HSSFCell cell = row.createCell((short)j);
                        String value = "";
                        value = exportDisp ? this.dw.getCellText(this.dw.getItem(i + 1, j + 1), this.dw.getColInfo(j + 1)) : (this.dw.getItem(i + 1, j + 1) != null ? String.valueOf(this.dw.getItem(i + 1, j + 1)) : "");
                        cell.setCellValue(value);
                        ++j;
                    }
                    ++i;
                }
                wb.write((OutputStream)out);
                return;
            }
            catch (Exception ex1) {
                GM.showException(ex1);
                return;
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ex2) {
                    GM.showException(ex2);
                }
            }
        }
        if (!fileName.endsWith(".sql")) return;
        if (!(this.view instanceof TableView)) {
            return;
        }
        TableView tv = (TableView)this.view;
        StringBuffer sb = new StringBuffer();
        String tableName = tv.getTableName();
        String schema = tv.getSchema();
        int pos = tableName.lastIndexOf(".");
        if (pos > 0) {
            schema = tableName.substring(0, pos);
            tableName = tableName.substring(pos + 1);
        }
        if (GV.dsActive.isUseSchema()) {
            tableName = schema + "." + tableName;
        }
        sb.append("CREATE TABLE " + tableName + " (\r\n");
        int i = 1;
        while (i <= colCount) {
            DWColInfo ci = this.dw.getColInfo(i);
            sb.append("\t");
            sb.append(ci.getColName());
            sb.append(" ");
            sb.append(TypesEx.getColDescriptionSQL(GV.dsActive.getDBType(), ci));
            if (i != colCount) {
                sb.append(",");
                sb.append("\r\n");
            }
            ++i;
        }
        sb.append(");\r\n");
        int i2 = 1;
        while (i2 <= rowCount) {
            sb.append("INSERT INTO " + tableName + " VALUES (\r\n");
            int j = 1;
            while (j <= colCount) {
                Object o = this.dw.getItem(i2, j);
                String sType = this.dw.getColInfo(j).getDataDescription();
                if (GM.isValidString(sType)) {
                    if (sType.startsWith("char") || sType.startsWith("varchar")) {
                        if (GM.isValidString(o)) {
                            o = Escape.addEscAndQuote(o.toString());
                        }
                    } else if ((sType.startsWith("datetime") || sType.startsWith("timestamp") || sType.startsWith("date")) && o != null) {
                        o = Escape.addEscAndQuote(o.toString());
                    }
                } else if (this.dw.getColInfo(j).getDataType() == 11) {
                    if (GM.isValidString(o)) {
                        o = Escape.addEscAndQuote(o.toString());
                    }
                } else if (this.dw.getColInfo(j).getDataType() == 10 && o != null) {
                    o = Escape.addEscAndQuote(o.toString());
                }
                sb.append("\t" + o);
                if (j != colCount) {
                    sb.append(",");
                    sb.append("\r\n");
                }
                ++j;
            }
            sb.append(");\r\n");
            ++i2;
        }
        FileWriter writer = null;
        writer = new FileWriter(file);
        writer.write(sb.toString());
        Object var21_54 = null;
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException ex3) {
            GM.showException(ex3);
        }
        return;
        {
            catch (Exception ex) {
                GM.showException(ex);
                Object var21_55 = null;
                if (writer == null) return;
                try {
                    writer.close();
                    return;
                }
                catch (IOException ex3) {
                    GM.showException(ex3);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var21_56 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException ex3) {
                GM.showException(ex3);
            }
            throw throwable;
        }
    }

    private String[] getColNames() {
        int count = this.view.getColCount();
        String[] colNames = new String[count];
        int i = 0;
        while (i < count) {
            colNames[i] = this.view.getColInfo(i).getColName();
            ++i;
        }
        return colNames;
    }

    private static Connection getConnection(String dsName) throws Exception {
        if (GM.isValidString(dsName) && GV.dsModel != null) {
            DataSource ds = GV.dsModel.getDataSource(dsName);
            if (ds != null) {
                return ds.getConnection();
            }
        } else if (GV.dsActive != null) {
            return GV.dsActive.getConnection();
        }
        return null;
    }

    private Object getDWEditStyle(String styleName) throws Exception {
        SemanticsManager vManager = this.getViewManager();
        if (vManager == null) {
            return null;
        }
        EditStyleList sList = vManager.getEditStyleList();
        if (sList == null) {
            return null;
        }
        int i = 0;
        while (i < sList.size()) {
            EditStyle style = sList.get(i);
            String name = style.getName();
            if (name.equals(styleName)) {
                Object semanticObject = style.getEditConfig();
                return GV.SemanticEditStyle2DWObject(semanticObject, vManager, GV.prepareContext(vManager));
            }
            ++i;
        }
        return null;
    }

    private String getOrder() {
        StringBuffer order = new StringBuffer();
        if (this.sort != null && this.sort.size() != 0) {
            int i = 0;
            while (i < this.sort.size()) {
                String temp;
                if (i % 2 == 0 && i / 2 != 0) {
                    order.append(",");
                }
                temp = (temp = this.sort.get(i).toString()).equals("true") ? " asc" : (temp.equals("false") ? " desc" : this.view.getColInfo(temp).getColName());
                order.append(temp);
                ++i;
            }
            return order.toString();
        }
        return null;
    }

    public IDataSheet getRootSheet() {
        return rootSheet;
    }

    private String getRowData(int row) {
        if (row < 1) {
            return "";
        }
        int rowCount = this.dw.getRowCount();
        if (row > rowCount) {
            return "";
        }
        int colCount = this.dw.getColCount();
        StringBuffer rowData = new StringBuffer(1024);
        int col = 1;
        while (col <= colCount) {
            Object item = this.dw.getItem(row, col);
            if (item == null) {
                item = "";
            }
            rowData.append(item.toString());
            if (col < colCount) {
                rowData.append("\t");
            }
            ++col;
        }
        return rowData.toString();
    }

    public String getSheetTitle() {
        return SheetViewData.getTitle(this.view.getViewName());
    }

    public static String getTitle(String viewName) {
        return Lang.getText("sheetviewdata.title") + viewName;
    }

    public static DataSet getViewDataSet(View view, boolean retrieve, boolean showMsg) {
        Context context;
        block24: {
            if (view == null) {
                return null;
            }
            context = null;
            try {
                context = GV.prepareContext(GVData.activeSheet.getViewManager());
            }
            catch (Exception e) {
                if (showMsg) {
                    GM.showException(e);
                }
                if (view instanceof CustomView) break block24;
                return null;
            }
        }
        try {
            DataSet ds;
            String factory;
            DialogViewCondition dvc = new DialogViewCondition();
            dvc.setView(view);
            int pc = 0;
            if (view instanceof TableView) {
                TableView tv = (TableView)view;
                pc = tv.getWhereCount();
            } else if (view instanceof SQLView) {
                SQLView sv = (SQLView)view;
                pc = sv.getParamCount();
            } else if (view instanceof ProcView) {
                ProcView pv = (ProcView)view;
                pc = pv.getParamCount();
            } else if (view instanceof CustomView) {
                CustomView cv = (CustomView)view;
                pc = cv.getParamCount();
            }
            if (pc > 0) {
                dvc.show();
                if (dvc.getOption() != 0) {
                    return null;
                }
            }
            ViewDataSetConfig config = dvc.getViewConfig();
            config.setDataSourceName(view.getDataSourceName());
            SemanticsManager vManager = GVData.activeSheet.getViewManager();
            if (vManager == null) {
                return null;
            }
            ParamMetaData paras = SemanticsParser.parseParameter(vManager, config);
            if (paras != null && paras.getParamCount() != 0) {
                DialogInputArgument dia = new DialogInputArgument(GVData.activeSheet.getViewManager(), context);
                dia.setParam(paras);
                dia.show();
                if (dia.getOption() != 0) {
                    return null;
                }
                HashMap values = dia.getParamValue();
                Iterator it = values.keySet().iterator();
                while (it.hasNext()) {
                    String paraName = (String)it.next();
                    byte type = paras.getParam(paraName).getDataType();
                    String value = (String)values.get(paraName);
                    context.setParamValue(paraName, Types.getProperData(type, value));
                }
            }
            if (view instanceof CustomView) {
                CustomView cv = (CustomView)view;
                factory = cv.getViewDataSetFactoryClass();
                if (!GM.isValidString(factory)) {
                    return null;
                }
                ICustomViewDataSetFactory cvdsf = (ICustomViewDataSetFactory)Class.forName(factory).newInstance();
                ds = cvdsf.createDataSet(context, config, retrieve);
            } else {
                DataSource dsrc;
                factory = config.getFactoryClass();
                ViewDataSetFactory dsf = (ViewDataSetFactory)Class.forName(factory).newInstance();
                String dsName = view.getDataSourceName();
                if (!GM.isValidString(dsName)) {
                    dsName = context.getDefDataSourceName();
                }
                boolean useSchema = true;
                if (GV.dsModel != null && (dsrc = GV.dsModel.getDataSource(dsName)) != null) {
                    useSchema = dsrc.isUseSchema();
                }
                ds = dsf.createDataSet(context, config, retrieve, useSchema);
            }
            return ds;
        }
        catch (Exception ex) {
            GM.showException(ex);
            return null;
        }
    }

    public SemanticsManager getViewManager() {
        return rootSheet.getViewManager();
    }

    private static String getViewSQL(View view) {
        String s;
        int count;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        if (view == null) {
            return null;
        }
        String viewName = view.getViewName();
        if (view instanceof TableView) {
            TableView table = (TableView)view;
            viewName = table.getTableName();
        }
        if ((count = view.getColCount()) == 0) {
            return null;
        }
        int i = 0;
        while (i < count) {
            ColInfo ci = view.getColInfo(i);
            if (i != 0) {
                sql.append(",");
            }
            sql.append(ci.getColName());
            ++i;
        }
        sql.append(" FROM ");
        if (view instanceof TableView) {
            DataSource dsrc;
            String dsName;
            TableView tv = (TableView)view;
            String fullName = tv.getTableName();
            String schema = tv.getSchema();
            int index = fullName.indexOf(".");
            String tableName = fullName;
            if (index > 0) {
                tableName = fullName.substring(index + 1);
                schema = fullName.substring(0, index);
            }
            if (!GM.isValidString(dsName = view.getDataSourceName()) && GV.dsActive != null) {
                dsName = GV.dsActive.getName();
            }
            if (GM.isValidString(dsName) && (dsrc = GV.dsModel.getDataSource(dsName)) != null && dsrc.isUseSchema() && GM.isValidString(schema)) {
                tableName = schema + "." + tableName;
            }
            sql.append(tableName);
            s = sql.toString();
            int i2 = 0;
            while (i2 < tv.getWhereCount()) {
                Where where = tv.getWhere(i2);
                s = SQLParser.mergeWhere(s, where.getWhere());
                ++i2;
            }
        } else {
            sql.append(viewName);
            s = sql.toString();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void importData() {
        block62: {
            file = GM.dialogSelectFile("xls,txt", GV.lastDirectory, null, "");
            if (file == null) {
                return;
            }
            fileName = file.getName();
            data = null;
            withTitle = false;
            if (fileName.endsWith(".xls")) {
                fis = null;
                try {
                    fis = new FileInputStream(file.getAbsolutePath());
                    wb = new HSSFWorkbook((InputStream)fis);
                    if (fis != null) {
                        fis.close();
                    }
                    if ((sheetCount = wb.getNumberOfSheets()) == 0) {
                        throw new Exception(Lang.getText("public.file") + "[ " + fileName + " ]" + Lang.getText("sheetviewdata.nodata"));
                    }
                    sheet = wb.getSheetAt(0);
                    rowCount = sheet.getLastRowNum() + 1;
                    if (rowCount <= 0) {
                        throw new Exception(Lang.getText("public.file") + "[ " + fileName + " ]" + Lang.getText("sheetviewdata.nodata"));
                    }
                    colCount = (short)(sheet.getRow(0).getLastCellNum() + 1);
                    data = new Object[rowCount][colCount];
                    r = 0;
                    while (r < rowCount) {
                        row = sheet.getRow(r);
                        c = 0;
                        while (c < colCount) {
                            cell = row.getCell(c);
                            if (cell != null) {
                                dataType = cell.getCellType();
                                value = null;
                                switch (dataType) {
                                    case 3: {
                                        break;
                                    }
                                    case 4: {
                                        value = new Boolean(cell.getBooleanCellValue());
                                        break;
                                    }
                                    case 5: {
                                        value = new Byte(cell.getErrorCellValue());
                                        break;
                                    }
                                    case 0: {
                                        value = new Double(cell.getNumericCellValue());
                                        break;
                                    }
                                    case 1: {
                                        value = cell.getStringCellValue();
                                        break;
                                    }
                                    case 2: {
                                        if (GM.isValidString(cell.getStringCellValue())) {
                                            value = cell.getStringCellValue();
                                            break;
                                        }
                                        if (cell.getNumericCellValue() != NaN) {
                                            value = new Double(cell.getNumericCellValue());
                                            break;
                                        }
                                        value = "";
                                        break;
                                    }
                                    default: {
                                        value = cell.getStringCellValue();
                                    }
                                }
                                if (r == 0 && GM.isValidString(value) && this.view.getColInfo((String)value) != null) {
                                    data = new Object[rowCount - 1][colCount];
                                    withTitle = true;
                                    break;
                                }
                                if (withTitle) {
                                    data[r - 1][c] = value;
                                } else {
                                    data[r][c] = value;
                                }
                            }
                            c = (short)(c + 1);
                        }
                        ++r;
                    }
                    var18_32 = null;
                    ** if (fis == null) goto lbl-1000
                }
                catch (Throwable var17_36) {
                    var18_33 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ex1) {
                        }
                    }
                    throw var17_36;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        fis.close();
                    }
                    catch (IOException ex1) {
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block62;
                    catch (Exception e) {
                        GM.showException(e);
                        var18_32 = null;
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException ex1) {
                            }
                        }
                        break block62;
                    }
                }
            }
            if (fileName.endsWith(".txt")) {
                reader = null;
                try {
                    reader = new FileReader(file);
                    sb = new StringBuffer();
                    while ((temp = reader.read()) != -1) {
                        sb.append((char)sheet);
                    }
                    value = sb.toString();
                    rows = value.split("\r\n");
                    rowCount = rows.length;
                    if (rowCount <= 0) {
                        throw new Exception(Lang.getText("public.file") + "[ " + fileName + " ]" + Lang.getText("sheetviewdata.nodata"));
                    }
                    colCount = 0;
                    i = 0;
                    while (i < rowCount) {
                        cols = rows[i].split("\t");
                        colCount = cols.length > colCount ? cols.length : colCount;
                        ++i;
                    }
                    data = new Object[rowCount][colCount];
                    i = 0;
                    while (i < rowCount) {
                        cols = rows[i].split("\t");
                        j = 0;
                        while (j < cols.length) {
                            if (i == 0 && GM.isValidString(cols[j]) && this.view.getColInfo(cols[j]) != null) {
                                data = new Object[rowCount - 1][colCount];
                                withTitle = true;
                                break;
                            }
                            if (withTitle) {
                                data[i - 1][j] = cols[j];
                            } else {
                                data[i][j] = cols[j];
                            }
                            ++j;
                        }
                        ++i;
                    }
                    var21_37 = null;
                    ** if (reader == null) goto lbl-1000
                }
                catch (Throwable var20_41) {
                    var21_38 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ex2) {
                        }
                    }
                    throw var20_41;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        reader.close();
                    }
                    catch (IOException ex2) {
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block62;
                    catch (Exception ex) {
                        GM.showException(ex);
                        var21_37 = null;
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException ex2) {
                            }
                        }
                    }
                }
            }
        }
        if (data != null) {
            showMessage = true;
            i = 0;
            while (i < data.length) {
                row = this.addRow();
                colCount = ((void)data[i]).length > this.dw.getColCount() ? this.dw.getColCount() : ((void)data[i]).length;
                j = 0;
                while (j < colCount) {
                    block63: {
                        try {
                            o = Types.getProperData(this.view.getColInfo(j).getDataType(), String.valueOf(data[i][j]));
                            this.dw.setItem(row, j + 1, o);
                        }
                        catch (Exception ex3) {
                            if (!showMessage) break block63;
                            opts = new String[]{"\u5ffd\u7565", "\u5168\u90e8\u5ffd\u7565", "\u53d6\u6d88"};
                            option = JOptionPane.showOptionDialog(this, ex3.getMessage(), "", 1, 0, null, opts, opts[0]);
                            switch (option) {
                                case 0: {
                                }
                                case 1: {
                                    showMessage = false;
                                }
                                case 2: {
                                    return;
                                }
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(0);
    }

    private int paste(String pasteData) {
        if (!GM.isValidString(pasteData)) {
            return -1;
        }
        int startRow = 0;
        int startCol = 0;
        int r = 0;
        if (this.dw.getActiveCell() != null) {
            startRow = this.dw.getActiveCell().getRow();
            startCol = this.dw.getActiveCell().getCol();
        }
        if (startRow < 1) {
            startRow = this.dw.getRowCount() + 1;
        }
        if (startCol < 1) {
            startCol = 1;
        }
        pasteData = Sentence.replace(pasteData, "\r\n", "\r", 1);
        pasteData = Sentence.replace(pasteData, "\n", "\r", 1);
        ArgumentTokenizer rows = new ArgumentTokenizer(pasteData, '\r');
        while (rows.hasMoreTokens()) {
            String rowData = rows.nextToken();
            if (!GM.isValidString(rowData)) continue;
            if (startRow > this.dw.getRowCount()) {
                startRow = this.dw.insertRow(startRow);
            }
            int col = startCol;
            int colCount = this.dw.getColCount();
            ArgumentTokenizer items = new ArgumentTokenizer(rowData, '\t');
            while (items.hasMoreTokens()) {
                String item = items.nextToken();
                this.dw.setItem(startRow, col, (Object)item);
                if (++col > colCount) break;
            }
            ++startRow;
            ++r;
        }
        return r;
    }

    private void query() {
        String title;
        String message;
        if (isDataChanged && !this.showOptionDialog(message = Lang.getText("sheetviewdata.querymessage"), title = Lang.getText("sheetviewdata.confirmquery"))) {
            return;
        }
        if (this.view instanceof TableView) {
            HashMap map = GVData.calcDWDataMap(this.dw);
            if (map == null) {
                map = GV.calcViewColDataMap(GVData.activeSheet.getViewManager(), this.view.getViewName());
            }
            DialogExpEditor dee = new DialogExpEditor();
            dee.setEditingType(2);
            dee.setDataMap(map);
            if (this.view != null) {
                dee.setDataSrcName(this.view.getDataSourceName());
            }
            if (this.where == null) {
                this.where = "";
            }
            this.where = SemanticsParser.replaceColumnName(this.where, (TableView)this.view);
            dee.setExpression("=" + this.where);
            dee.setUseDataSet(false);
            dee.setUseRQFunc(false);
            dee.setColTypes(GV.getViewColTypes(this.view, map));
            dee.init();
            dee.show();
            if (dee.getOption() != 0) {
                return;
            }
            this.where = dee.getExpression();
            this.where = SemanticsParser.replaceColumnTitle(this.where, (TableView)this.view);
            if (this.where.length() > 0) {
                this.where = this.where.substring(1);
            }
            this.sql = !GM.isValidString(this.where) ? SheetViewData.getViewSQL(this.view) : SQLParser.modify(this.sql, 2, this.where);
            try {
                Context context = GV.prepareContext(GVData.activeSheet.getViewManager());
                String order = this.getOrder();
                if (order != null) {
                    this.sql = SQLParser.modify(this.sql, 5, order);
                }
                this.dw.setSql(this.sql);
                this.dw.retrieve(context, context.getDefDataSourceName());
                this.setColInfos();
                this.dw.display();
            }
            catch (Exception e) {
                GM.showException(e);
            }
        }
    }

    public boolean remoteSaveAs() {
        return false;
    }

    private void replace() {
        DialogDataSearch dds = new DialogDataSearch(this, this.dw, false);
        dds.show();
    }

    private void retrieve() {
        Context context;
        block7: {
            String order;
            if (isDataChanged && !this.showOptionDialog(Lang.getText("sheetviewdata.queryretrieve"), Lang.getText("sheetviewdata.confirmretrieve"))) {
                return;
            }
            if (this.view instanceof TableView && (order = this.getOrder()) != null) {
                this.sql = SQLParser.modify(this.sql, 5, order);
            }
            context = null;
            try {
                context = GV.prepareContext(GVData.activeSheet.getViewManager());
            }
            catch (Exception e) {
                GM.showException(e);
                if (this.view instanceof CustomView || this.view instanceof BuiltinView) break block7;
                return;
            }
        }
        if (context != null) {
            try {
                this.dw.retrieve(context);
            }
            catch (Exception ex) {
                GM.showException(ex);
            }
        }
    }

    public boolean save() {
        if (this.view instanceof TableView && conn == null) {
            JOptionPane.showMessageDialog(null, Lang.getText("sheetviewdata.notconnect") + ".", Lang.getText("public.note"), 2);
            return false;
        }
        if (!(this.view instanceof TableView)) {
            return false;
        }
        try {
            this.dw.update(conn);
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
        SheetViewData.dataModified(false);
        return true;
    }

    public boolean saveAs() {
        return true;
    }

    private void search() {
        DialogDataSearch dds = new DialogDataSearch(this, this.dw, true);
        dds.show();
    }

    private void select(byte selectMode) {
        int row = 1;
        while (row <= this.dw.getRowCount()) {
            boolean selected = this.dw.getRowSelected(row);
            if (selectMode == this.selectAll) {
                this.dw.setRowSelected(row, true);
            } else if (selectMode == this.selectNone) {
                this.dw.setRowSelected(row, false);
            } else if (selectMode == this.selectReverse) {
                this.dw.setRowSelected(row, !selected);
            }
            ++row;
        }
        this.dw.repaint();
    }

    private void setColInfos() {
        try {
            int i = 0;
            while (i < this.view.getColCount()) {
                EditStyleList sList;
                String colName = this.view.getColInfo(i).getColName();
                DWColInfo ci = this.dw.getColInfo(colName);
                ci.setPrimaryKey(this.view.getColInfo(i).isPrimaryKey());
                ci.setColTitle(this.view.getColInfo(i).getColTitle());
                ci.setDataDescription(this.view.getColInfo(i).getDataDescription());
                ci.setDataPrecision(this.view.getColInfo(i).getDataPrecision());
                ci.setDataType(this.view.getColInfo(i).getDataType());
                ci.setDataWidth(this.view.getColInfo(i).getDataWidth());
                String styleName = this.view.getColInfo(i).getEditStyleName();
                if (styleName != null && (sList = GVData.activeSheet.getViewManager().getEditStyleList()) != null) {
                    int j = 0;
                    while (j < sList.size()) {
                        EditStyle style = sList.get(j);
                        String name = style.getName();
                        if (name.equals(styleName)) {
                            ci.setFormat(style.getDispFormat());
                            Object dwStyle = this.getDWEditStyle(styleName);
                            if (dwStyle != null && MenuFactory.menuUseEditStyle.isSelected()) {
                                ci.setEditConfig(dwStyle);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void setColLabel() {
        int i = 0;
        while (i < this.view.getColCount()) {
            String colName = this.view.getColInfo(i).getColName();
            String colTitle = this.view.getColInfo(i).getColTitle();
            DWColInfo ci = this.dw.getColInfo(colName);
            ci.setColTitle(colTitle);
            ++i;
        }
    }

    private static void setTableTitle(TableView view) {
        String title;
        Matrix rs;
        if (GV.dsActive == null) {
            return;
        }
        String sql = null;
        String tableName = view.getTableName();
        int dot = tableName.indexOf(".");
        if (dot > 0) {
            tableName = tableName.substring(dot + 1);
        }
        switch (GV.dsActive.getDBType()) {
            case 1: {
                sql = "SELECT user_tab_comments.comments FROM user_tab_comments WHERE UPPER(user_tab_comments.table_name)='" + tableName + "'";
                break;
            }
            case 2: {
                break;
            }
        }
        if (sql != null && (rs = SheetViewData.executeSQL(sql)) != null && GM.isValidString(title = (String)rs.get(0, 0))) {
            view.setViewName(title);
        }
        switch (GV.dsActive.getDBType()) {
            case 1: {
                sql = "SELECT all_tab_columns.column_name AS name, all_col_comments.comments AS comments  FROM all_tab_columns,all_col_comments  WHERE UPPER(all_tab_columns.table_name) ='" + tableName + "' AND" + " all_tab_columns.table_name = all_col_comments.table_name AND" + " all_tab_columns.column_name = all_col_comments.column_name" + " ORDER BY all_tab_columns.column_id";
                break;
            }
            case 2: {
                break;
            }
        }
        if (sql != null && (rs = SheetViewData.executeSQL(sql)) != null) {
            try {
                int i = 0;
                while (i < rs.getRowSize()) {
                    String colName = (String)rs.get(i, 0);
                    String colTitle = (String)rs.get(i, 1);
                    if (GM.isValidString(colTitle)) {
                        ColInfo ci = view.getColInfoByColName(colName);
                        ci.setColTitle(colTitle);
                    }
                    ++i;
                }
            }
            catch (Exception x) {
            }
        }
    }

    public boolean showOptionDialog(String message, String title) {
        Object[] options = new Object[]{Lang.getText("sheetviewdata.ok"), Lang.getText("sheetviewdata.cancel")};
        int option = JOptionPane.showOptionDialog(null, message, title, -1, 2, null, options, options[0]);
        return option == 0;
    }

    private void sort() {
        String title;
        String message;
        if (isDataChanged && !this.showOptionDialog(message = Lang.getText("sheetviewdata.querysort"), title = Lang.getText("sheetviewdata.confirmsort"))) {
            return;
        }
        if (this.view instanceof TableView) {
            DialogDataSort dds = new DialogDataSort(this.dw);
            dds.setSort(this.sort);
            dds.show();
            if (dds.getOption() != 0) {
                return;
            }
            Vector v = dds.getSort();
            if (v == null || v.size() == 0) {
                if (this.sort != null && this.sort.size() != 0) {
                    this.sort = new Vector();
                    this.retrieve();
                }
                return;
            }
            this.sort = v;
            try {
                Context context = GV.prepareContext(GVData.activeSheet.getViewManager());
                String order = this.getOrder();
                if (order != null) {
                    this.sql = SQLParser.modify(this.sql, 5, order);
                }
                this.dw.setSql(this.sql);
                this.dw.retrieve(context, context.getDefDataSourceName());
                this.setColInfos();
                this.dw.display();
            }
            catch (Exception ex) {
                GM.showException(ex);
            }
        }
    }

    class Listener
    extends InternalFrameAdapter {
        IDataSheet sheet;

        public Listener(SheetViewData parent) {
            this.sheet = parent;
        }

        static /* synthetic */ SheetViewData access$300(Listener x0) {
            return x0.SheetViewData.this;
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    GVData.activeSheet = this.this$1.sheet;
                    GVData.getFrameManager().changeBar(GVData.getDataMenu(), GVData.getDataTool());
                    GV.appMenu.addLiveMenu(this.this$1.sheet.getSheetTitle());
                    SheetViewData.dataModified(false);
                    if (!(SheetViewData.access$400(Listener.access$300(this.this$1)) instanceof TableView)) {
                        GV.appMenu.setEnable(new short[]{5310, 5320, 5225, 5230, 5340, 5235, 5245, 5240}, false);
                        ((ToolBarData)GVData.appTool).setEnable((short)5320, false);
                        ((ToolBarData)GVData.appTool).setEnable((short)5225, false);
                        ((ToolBarData)GVData.appTool).setEnable((short)5230, false);
                        ((ToolBarData)GVData.appTool).setEnable((short)5340, false);
                        ((ToolBarData)GVData.appTool).setEnable((short)5235, false);
                        ((ToolBarData)GVData.appTool).setEnable((short)5245, false);
                        ((ToolBarData)GVData.appTool).setEnable((short)5226, false);
                    }
                }
            });
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            GVData.getFrameManager().closeSheet(this.sheet);
        }
    }
}

