/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.ide;

import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.datamanager.base.IDataSheet;
import com.runqian.datamanager.base.JListDataPipe;
import com.runqian.datamanager.base.PanelDataPipe;
import com.runqian.datamanager.base.PanelViewEditor;
import com.runqian.datamanager.base.TableEditStyle;
import com.runqian.datamanager.base.TableOuterParam;
import com.runqian.datamanager.dialog.DialogExecDataPipe;
import com.runqian.datamanager.dialog.DialogViewProperty;
import com.runqian.datamanager.ide.GVData;
import com.runqian.datamanager.ide.MenuManager;
import com.runqian.datamanager.ide.MenuManagerPop;
import com.runqian.datamanager.ide.SheetViewData;
import com.runqian.datamanager.ide.ToolBarManager;
import com.runqian.datamanager.ide.TransferableSemantics;
import com.runqian.report4.dataset.ColInfoBase;
import com.runqian.report4.dataset.DataSet;
import com.runqian.report4.ide.base.ConfigOptions;
import com.runqian.report4.ide.base.JPanelSemantics;
import com.runqian.report4.ide.base.SemanticsTreeNode;
import com.runqian.report4.ide.base.SemanticsTreeRender;
import com.runqian.report4.remote.Const;
import com.runqian.report4.remote.LogInfo;
import com.runqian.report4.remote.Response;
import com.runqian.report4.remote.dialog.DialogRemoteOpen;
import com.runqian.report4.semantics.BuiltinView;
import com.runqian.report4.semantics.ColInfo;
import com.runqian.report4.semantics.CustomView;
import com.runqian.report4.semantics.DataPipe;
import com.runqian.report4.semantics.DataPipeList;
import com.runqian.report4.semantics.EditStyle;
import com.runqian.report4.semantics.EditStyleList;
import com.runqian.report4.semantics.OuterParam;
import com.runqian.report4.semantics.ParamList;
import com.runqian.report4.semantics.ProcView;
import com.runqian.report4.semantics.SQLView;
import com.runqian.report4.semantics.SemanticsManager;
import com.runqian.report4.semantics.TableView;
import com.runqian.report4.semantics.View;
import com.runqian.report4.semantics.ViewList;
import com.runqian.report4.usermodel.Types;
import com.zfqjava.swing.JListView;
import com.zfqjava.swing.cell.DefaultCellEditor;
import com.zfqjava.swing.cell.DefaultCellRenderer;
import com.zfqjava.swing.model.ColumnSorter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.transform.stream.StreamResult;

public class SheetViewManager
extends JInternalFrame
implements IDataSheet {
    private final String TYPE_BUILTIN;
    private final String TYPE_CUSTOM;
    private final String TYPE_DATAPIPE;
    private final String TYPE_EDITSTYLE;
    private final String TYPE_OUTERPARAM;
    private final String TYPE_PROC;
    private final String TYPE_SQL;
    private final String TYPE_TABLE;
    private final String TYPE_VIEW = Lang.getText("sheetviewmanager.view");
    static final String[] colNames = new String[]{Lang.getText("sheetviewmanager.name"), Lang.getText("sheetviewmanager.description"), Lang.getText("sheetviewmanager.type"), Lang.getText("sheetviewmanager.modifytime")};
    private PanelDataPipe dataPipe;
    private TableEditStyle editStyle;
    private String fileName;
    private boolean isDataChanged = false;
    private boolean isRemote = false;
    private JListDataPipe listDataPipe;
    private JListView listView;
    private JTree mTree;
    private DefaultTreeModel mTreeModel;
    private String oldFileName;
    SemanticsTreeNode oldNode = null;
    private TableOuterParam outerParam;
    private boolean saveLocal = false;
    private JSplitPane splitPane;
    private SemanticsManager vManager;
    private PanelViewEditor viewEditor;

    public SheetViewManager(String fileName, boolean isRemote) throws Exception {
        super(fileName, true, true, true, true);
        this.TYPE_TABLE = Lang.getText("sheetviewmanager.table");
        this.TYPE_SQL = Lang.getText("sheetviewmanager.sql");
        this.TYPE_PROC = Lang.getText("sheetviewmanager.proc");
        this.TYPE_BUILTIN = Lang.getText("sheetviewmanager.builtin");
        this.TYPE_CUSTOM = Lang.getText("sheetviewmanager.custom");
        this.TYPE_EDITSTYLE = Lang.getText("sheetviewmanager.editstyle");
        this.TYPE_OUTERPARAM = Lang.getText("sheetviewmanager.outerparam");
        this.TYPE_DATAPIPE = Lang.getText("sheetviewmanager.pipe");
        this.splitPane = new JSplitPane();
        this.mTreeModel = new DefaultTreeModel(new SemanticsTreeNode(""));
        this.mTree = new JTree(this.mTreeModel);
        this.listView = new JListView();
        this.listDataPipe = new JListDataPipe(){

            protected void tableDataPipe_mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DataPipe[] pipes = SheetViewManager.this.listDataPipe.getSelectedPipes();
                    if (pipes == null || pipes.length != 1) {
                        return;
                    }
                    String objName = pipes[0].getName();
                    SheetViewManager.this.refreshView(objName);
                }
            }
        };
        this.viewEditor = new PanelViewEditor(){

            public void editChanged() {
                if (SheetViewManager.this.oldNode != null) {
                    View view = (View)SheetViewManager.this.oldNode.getUserObject();
                    SheetViewManager.this.oldNode.setName(view.getViewName());
                    SheetViewManager.this.mTreeModel.nodeStructureChanged(SheetViewManager.this.oldNode);
                }
                SheetViewManager.this.dataModified(true);
            }
        };
        this.editStyle = new TableEditStyle(){

            public void editChanged() {
                SheetViewManager.this.dataModified(true);
            }
        };
        this.outerParam = new TableOuterParam(){

            public void editChanged() {
                SheetViewManager.this.dataModified(true);
            }
        };
        this.dataPipe = new PanelDataPipe(){

            public void editChanged() {
                if (SheetViewManager.this.oldNode != null) {
                    if (!GM.isValidString(SheetViewManager.this.dataPipe.getName())) {
                        return;
                    }
                    SheetViewManager.this.oldNode.setName(SheetViewManager.this.dataPipe.getName());
                    SheetViewManager.this.mTreeModel.nodeStructureChanged(SheetViewManager.this.oldNode);
                }
                SheetViewManager.this.dataModified(true);
            }
        };
        this.fileName = fileName;
        this.oldFileName = fileName;
        this.isRemote = isRemote;
        this.setTitle(this.fileName);
        this.vManager = new SemanticsManager();
        if (!GM.isValidString(fileName)) {
            this.fileName = GVData.getNewViewName();
            this.setTitle(this.fileName);
        } else {
            if (!GM.isValidString(fileName)) {
                JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("sheetviewmanager.opensemantics") + fileName + Lang.getText("sheetviewmanager.faild"));
                throw new Exception();
            }
            if (!JPanelSemantics.loadSemanticFile(this.vManager, fileName)) {
                throw new Exception();
            }
        }
        this.init();
        this.mTree.setBorder(BorderFactory.createBevelBorder(1));
        this.listView.setBorder(BorderFactory.createBevelBorder(1));
        this.listDataPipe.setBorder(BorderFactory.createBevelBorder(1));
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(6);
        this.splitPane.setOrientation(1);
        this.splitPane.add((Component)new JScrollPane(this.mTree), "left");
        this.splitPane.add((Component)this.listView, "right");
        int splitPos = new Double(0.25 * Toolkit.getDefaultToolkit().getScreenSize().getWidth()).intValue();
        this.splitPane.setDividerLocation(splitPos);
        this.addInternalFrameListener(new Listener(this));
        this.setDefaultCloseOperation(0);
        this.refreshView(null);
    }

    public SheetViewManager(String fileName) throws Exception {
        this(fileName, false);
    }

    static /* synthetic */ boolean access$600(SheetViewManager x0) {
        return x0.isDataChanged;
    }

    private boolean addSemanticObject() {
        String newName;
        block40: {
            block39: {
                String objectType;
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                View view;
                                block27: {
                                    block34: {
                                        block33: {
                                            block32: {
                                                block31: {
                                                    block30: {
                                                        block29: {
                                                            block28: {
                                                                block26: {
                                                                    block25: {
                                                                        newName = "";
                                                                        Object o = this.oldNode.getUserObject();
                                                                        objectType = "";
                                                                        if (o instanceof String) {
                                                                            objectType = (String)o;
                                                                        }
                                                                        view = null;
                                                                        if (objectType == this.TYPE_TABLE) break block25;
                                                                        if (this.oldNode.getType() != 1) break block26;
                                                                    }
                                                                    view = new TableView();
                                                                    break block27;
                                                                }
                                                                if (objectType == this.TYPE_SQL) break block28;
                                                                if (this.oldNode.getType() != 3) break block29;
                                                            }
                                                            view = new SQLView();
                                                            break block27;
                                                        }
                                                        if (objectType == this.TYPE_PROC) break block30;
                                                        if (this.oldNode.getType() != 2) break block31;
                                                    }
                                                    view = new ProcView();
                                                    break block27;
                                                }
                                                if (objectType == this.TYPE_BUILTIN) break block32;
                                                if (this.oldNode.getType() != 4) break block33;
                                            }
                                            view = new BuiltinView();
                                            break block27;
                                        }
                                        if (objectType == this.TYPE_CUSTOM) break block34;
                                        if (this.oldNode.getType() != 5) break block27;
                                    }
                                    view = new CustomView();
                                }
                                if (view != null) {
                                    DialogViewProperty dvp = new DialogViewProperty(this.vManager.listViewNames());
                                    ViewList vl = this.vManager.getViewList();
                                    if (vl == null) {
                                        vl = new ViewList();
                                        this.vManager.setViewList(vl);
                                    }
                                    newName = this.getNewName(vl);
                                    view.setViewName(newName);
                                    dvp.setView(view);
                                    dvp.show();
                                    if (dvp.getOption() != 0) {
                                        return false;
                                    }
                                    view = dvp.getView();
                                    newName = view.getViewName();
                                    try {
                                        SheetViewData.createViewStructs(view, false);
                                    }
                                    catch (Exception ex) {
                                        GM.showException(ex);
                                    }
                                    if (vl == null) {
                                        vl = new ViewList();
                                        this.vManager.setViewList(vl);
                                    }
                                    vl.addView(view);
                                }
                                if (objectType == this.TYPE_EDITSTYLE) break block35;
                                if (this.oldNode.getType() != 11) break block36;
                            }
                            this.editStyle.addRow();
                            return true;
                        }
                        if (objectType == this.TYPE_OUTERPARAM) break block37;
                        if (this.oldNode.getType() != 12) break block38;
                    }
                    this.outerParam.addRow();
                    return true;
                }
                if (objectType == this.TYPE_DATAPIPE) break block39;
                if (this.oldNode.getType() != 71) break block40;
            }
            DataPipe dp = new DataPipe();
            newName = this.getNewName(this.vManager.getDataPipeList() == null ? new DataPipeList() : this.vManager.getDataPipeList());
            dp.setName(newName);
            DataPipeList dpl = this.vManager.getDataPipeList();
            if (dpl == null) {
                dpl = new DataPipeList();
            }
            dpl.add(dp);
            this.vManager.setDataPipeList(dpl);
        }
        if (GM.isValidString(newName)) {
            this.refreshView(newName);
        }
        return true;
    }

    public void adjustNewFileEnv(String oldFile, String newFile) {
        GV.appMenu.removeLiveMenu(oldFile);
        GV.appMenu.addLiveMenu(newFile);
        this.fileName = newFile;
        this.setTitle(newFile);
        this.refreshView(null);
    }

    public boolean close() {
        boolean closed = this.isSaved();
        if (closed) {
            this.dispose();
        }
        return closed;
    }

    private boolean copy(boolean isTreeNode) {
        isTreeNode = true;
        Vector<Object> objs = new Vector<Object>();
        if (isTreeNode) {
            if (this.oldNode == null) {
                return false;
            }
            TreePath[] selPath = this.mTree.getSelectionPaths();
            int i = 0;
            while (i < selPath.length) {
                SemanticsTreeNode sNode = (SemanticsTreeNode)selPath[i].getLastPathComponent();
                objs.add(sNode.getUserObject());
                ++i;
            }
            TransferableSemantics ts = new TransferableSemantics(objs);
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents(ts, null);
        } else {
            Object[] ids;
            if (this.oldNode != null) {
                if (this.oldNode.getType() == 0) {
                    if (this.oldNode.getUserObject() == this.TYPE_EDITSTYLE) {
                        this.editStyle.clipBoard();
                        return true;
                    }
                    if (this.oldNode.getUserObject() == this.TYPE_OUTERPARAM) {
                        this.outerParam.clipBoard();
                        return true;
                    }
                }
            }
            if ((ids = this.listView.getSelectedValues()) == null) {
                return false;
            }
            int i = 0;
            while (i < ids.length) {
                objs.addElement(ids[i]);
                ++i;
            }
            TransferableSemantics ts = new TransferableSemantics(objs);
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents(ts, null);
        }
        return true;
    }

    private int countSubNodes(SemanticsTreeNode node) {
        ViewList vList;
        Object o = node.getUserObject();
        if (!(o instanceof String)) {
            return 0;
        }
        String cat = (String)o;
        int c = 0;
        if (cat.equals(this.TYPE_EDITSTYLE)) {
            EditStyleList esl = this.vManager.getEditStyleList();
            c = esl == null ? 0 : esl.size();
        }
        if (cat.equals(this.TYPE_OUTERPARAM)) {
            ParamList pl = this.vManager.getParamList();
            c = pl == null ? (c += 0) : (c += pl.getParamCount());
        }
        if ((vList = this.vManager.getViewList()) == null) {
            c += 0;
        } else if (node.isRoot()) {
            c += vList.getViewCount();
        } else {
            if (node.getUserObject() == this.TYPE_VIEW) {
                return vList.getViewCount();
            }
            int i = 0;
            while (i < vList.getViewCount()) {
                View v = vList.getView(i);
                if (cat.equals(this.TYPE_TABLE) && v instanceof TableView || cat.equals(this.TYPE_BUILTIN) && v instanceof BuiltinView || cat.equals(this.TYPE_CUSTOM) && v instanceof CustomView || cat.equals(this.TYPE_SQL) && v instanceof SQLView || cat.equals(this.TYPE_PROC) && v instanceof ProcView) {
                    ++c;
                }
                ++i;
            }
        }
        return c;
    }

    private boolean createViewStructure() {
        if (this.oldNode == null) {
            return false;
        }
        if (this.oldNode.getLevel() != 3) {
            return false;
        }
        View view = (View)this.oldNode.getUserObject();
        try {
            boolean isCreated = SheetViewData.createViewStructs(view, true);
            if (isCreated) {
                this.refreshView(this.oldNode.getName());
                return true;
            }
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
        return false;
    }

    public void dataModified(boolean changed) {
        this.isDataChanged = changed;
        GV.appMenu.setEnable(new short[]{5020}, this.isDataChanged);
        ((ToolBarManager)GVData.appTool).setEnable((short)5020, this.isDataChanged);
    }

    /*
     * Unable to fully structure code
     */
    private boolean delSemanticObject(boolean isTreeNode) {
        block30: {
            block29: {
                nextNode = null;
                if (!isTreeNode) break block29;
                if (this.oldNode == null) {
                    return false;
                }
                dpl = this.vManager.getDataPipeList();
                switch (this.oldNode.getType()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (!this.sureDelete()) {
                            return false;
                        }
                        vl = this.vManager.getViewList();
                        vl.removeView((View)this.oldNode.getUserObject());
                        v = this.getNextView(this.oldNode.getType());
                        if (v != null) {
                            nextNode = v.getViewName();
                            break;
                        }
                        nextNode = (String)((SemanticsTreeNode)this.oldNode.getParent()).getUserObject();
                        break;
                    }
                    case 71: {
                        if (!this.sureDelete()) {
                            return false;
                        }
                        dpl.remove(this.oldNode.getName());
                        if (dpl.size() > 0) {
                            nextNode = dpl.get(0).getName();
                            break;
                        }
                        nextNode = (String)((SemanticsTreeNode)this.oldNode.getParent()).getUserObject();
                        break;
                    }
                    default: {
                        selectedItems = this.listView.getSelectedValues();
                        if (selectedItems.length <= 0) ** GOTO lbl47
                        if (!this.sureDelete()) {
                            return false;
                        }
                        list = this.vManager.getViewList();
                        i = 0;
                        while (i < selectedItems.length) {
                            o = selectedItems[i];
                            if (o instanceof View) {
                                list.removeView((View)o);
                            }
                            ++i;
                        }
                        break block30;
lbl47:
                        // 1 sources

                        if (this.oldNode.getType() != 0 || this.oldNode.getUserObject() != this.TYPE_DATAPIPE) ** GOTO lbl63
                        dps = this.listDataPipe.getSelectedPipes();
                        if (dps.length > 0) {
                            if (!this.sureDelete()) {
                                return false;
                            }
                            i = 0;
                            while (i < dps.length) {
                                dpl.remove(dps[i].getName());
                                ++i;
                            }
                            this.listDataPipe.removeSelectedPipes();
                            break;
                        }
                        break block30;
lbl63:
                        // 1 sources

                        JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("sheetviewmanager.selectview"));
                        return false;
                    }
                }
                break block30;
            }
            if (this.oldNode != null) {
                if (this.oldNode.getType() == 0) {
                    if (this.oldNode.getUserObject() == this.TYPE_EDITSTYLE) {
                        if (!this.sureDelete()) {
                            return false;
                        }
                        this.editStyle.deleteRows();
                        return true;
                    }
                    if (this.oldNode.getUserObject() == this.TYPE_OUTERPARAM) {
                        if (!this.sureDelete()) {
                            return false;
                        }
                        this.outerParam.deleteRows();
                        return true;
                    }
                }
            }
            if ((selectedItems = this.listView.getSelectedValues()).length > 0) {
                if (!this.sureDelete()) {
                    return false;
                }
                esl = this.vManager.getEditStyleList();
                pl = this.vManager.getParamList();
                i = 0;
                while (i < selectedItems.length) {
                    o = selectedItems[i];
                    if (o instanceof EditStyle) {
                        esl.remove(((EditStyle)o).getName());
                    } else if (o instanceof OuterParam) {
                        pl.removeParam(((OuterParam)o).getParamName());
                    } else {
                        return false;
                    }
                    ++i;
                }
            } else {
                return false;
            }
        }
        this.refreshView(nextNode);
        return true;
    }

    private void enableAction(short actionId, boolean en) {
        if (GV.appMenu != null) {
            GV.appMenu.setEnable(new short[]{actionId}, en);
        }
        if (GVData.appTool != null && GVData.appTool instanceof ToolBarManager) {
            ToolBarManager tbm = (ToolBarManager)GVData.appTool;
            tbm.setEnable(actionId, en);
        }
    }

    public void enableCopyAction(boolean en) {
        this.enableAction((short)5235, en);
    }

    public void enablePasteAction(boolean en) {
        this.enableAction((short)5245, en);
    }

    private void execDataPipe() {
        DialogExecDataPipe dedp = new DialogExecDataPipe();
        dedp.setDataPipe((DataPipe)this.oldNode.getUserObject());
        if (!dedp.isValidateDataSource()) {
            return;
        }
        dedp.start();
        dedp.show();
    }

    public Object executeCmd(short cmd) {
        Object o;
        if (cmd > 10000) {
            cmd = (short)(cmd - 10000);
            this.executePopCmd(cmd);
            return null;
        }
        if (this.oldNode != null) {
            o = this.oldNode.getUserObject();
            if (o instanceof View) {
                if (cmd != 5230 && cmd != 5225 && !this.viewEditor.saveView()) {
                    return null;
                }
                if (this.viewEditor.executeCmd(cmd)) {
                    return null;
                }
            } else if (o instanceof DataPipe) {
                if (!this.saveDataPipe()) {
                    return null;
                }
                this.saveDataPipeList();
            }
        }
        switch (cmd) {
            case 5225: {
                if (this.addSemanticObject()) break;
                return null;
            }
            case 5231: {
                if (this.delSemanticObject(true)) break;
                return null;
            }
            case 5230: {
                if (this.delSemanticObject(false)) break;
                return null;
            }
            case 5220: {
                this.listView.setSelectionInterval(0, this.listView.getTableModel().getRowCount() - 1);
                return null;
            }
            case 5260: {
                View view = (View)this.listView.getSelectedValue();
                if (view == null) {
                    return null;
                }
                ViewList vl = this.vManager.getViewList();
                int index = vl.indexOf(view.getViewName());
                if (index == 0) {
                    return null;
                }
                View topView = vl.getView(index - 1);
                vl.setView(index - 1, view);
                vl.setView(index, topView);
                SemanticsTreeNode node = this.getSelectedNode();
                this.refreshView(node.getName());
                this.listView.setSelectedIndex(index - 1);
                break;
            }
            case 5265: {
                View view = (View)this.listView.getSelectedValue();
                if (view == null) {
                    return null;
                }
                ViewList vl = this.vManager.getViewList();
                int index = vl.indexOf(view.getViewName());
                if (index == vl.getViewCount() - 1) {
                    return null;
                }
                View bottomView = vl.getView(index + 1);
                vl.setView(index + 1, view);
                vl.setView(index, bottomView);
                SemanticsTreeNode node = this.getSelectedNode();
                this.refreshView(node.getName());
                this.listView.setSelectedIndex(index + 1);
                break;
            }
            case 5235: {
                this.copy(false);
                return null;
            }
            case 5245: {
                if (this.paste()) break;
                return null;
            }
            case 5283: {
                if (this.createViewStructure()) break;
                return null;
            }
            case 5287: {
                this.executePopCmd(cmd);
                return null;
            }
            case 5270: {
                if (this.oldNode != null) {
                    o = this.oldNode.getUserObject();
                    if (o instanceof View) {
                        Object val = this.listView.getSelectedValue();
                        if (val == null) {
                            return null;
                        }
                        this.viewEditor.saveView();
                        GVData.getFrameManager().openSheetData((View)val);
                    } else if (o instanceof DataPipe) {
                        this.execDataPipe();
                    }
                }
                return null;
            }
            case 5210: {
                break;
            }
            case 5215: {
                break;
            }
            case 5075: {
                this.reload();
                return null;
            }
            default: {
                return null;
            }
        }
        this.dataModified(true);
        return null;
    }

    private void executePopCmd(short cmd) {
        switch (cmd) {
            case 5225: {
                if (this.addSemanticObject()) break;
                return;
            }
            case 5231: {
                this.delSemanticObject(true);
                break;
            }
            case 5220: {
                this.listView.setSelectionInterval(0, this.listView.getTableModel().getRowCount() - 1);
                return;
            }
            case 5260: {
                break;
            }
            case 5265: {
                break;
            }
            case 5235: {
                this.copy(true);
                return;
            }
            case 5245: {
                this.paste();
                break;
            }
            case 5283: {
                if (this.createViewStructure()) break;
                return;
            }
            case 5270: {
                if (this.oldNode == null) {
                    return;
                }
                Object val = this.oldNode.getUserObject();
                if (val instanceof View) {
                    this.viewEditor.saveView();
                    GVData.getFrameManager().openSheetData((View)val);
                } else if (val instanceof DataPipe) {
                    this.execDataPipe();
                }
                return;
            }
            case 5210: {
                break;
            }
            case 5215: {
                return;
            }
            case 5285: {
                this.viewEditor.executeCmd((short)5285);
                break;
            }
            case 5287: {
                Object node = this.oldNode.getUserObject();
                if (!(node instanceof View)) {
                    return;
                }
                View view = (View)this.oldNode.getUserObject();
                if (view instanceof BuiltinView) {
                    return;
                }
                DataSet ds = SheetViewData.getViewDataSet(view, true, true);
                if (ds == null) {
                    return;
                }
                int c = ds.getColCount();
                byte[] colTypes = new byte[c];
                int i = 0;
                while (i < c) {
                    colTypes[i] = ds.getColInfo(i).getDataType();
                    ++i;
                }
                BuiltinView bv = new BuiltinView();
                int cc = ds.getColCount();
                int rr = ds.getRowCount();
                String[][] values = new String[rr][cc];
                int row = 1;
                while (row <= rr) {
                    Object[] rowData = ds.getRowData(row);
                    String[] rowdata = new String[cc];
                    int col = 0;
                    while (col < cc) {
                        String val;
                        rowdata[col] = val = Types.toString(rowData[col]);
                        ++col;
                    }
                    values[row - 1] = rowdata;
                    ++row;
                }
                int i2 = 0;
                while (i2 < ds.getColCount()) {
                    ColInfo ci = new ColInfo();
                    ColInfoBase cib = ds.getColInfo(i2);
                    ci.setColName(cib.getColName());
                    ci.setColTitle(cib.getColTitle());
                    ci.setDataDescription(cib.getDataDescription());
                    ci.setDataPrecision(cib.getDataPrecision());
                    ci.setDataType(cib.getDataType());
                    ci.setDataWidth(cib.getDataWidth());
                    ci.setDefValue(cib.getDefValue());
                    ci.setNullable(cib.isNullable());
                    ci.setPrimaryKey(cib.isPrimaryKey());
                    bv.addColInfo(ci);
                    ++i2;
                }
                bv.setValues(values);
                bv.setViewName(this.getNewBuiltinViewName(view.getViewName()));
                ViewList vl = this.vManager.getViewList();
                if (vl == null) {
                    vl = new ViewList();
                    this.vManager.setViewList(vl);
                }
                vl.addView(bv);
                this.refreshView(bv.getViewName());
                break;
            }
            case 5075: {
                this.reload();
                return;
            }
        }
        this.dataModified(true);
    }

    private boolean existViewName(String viewName) {
        String[] viewNames = this.vManager.listViewNames();
        int i = 0;
        while (i < viewNames.length) {
            if (viewName.equalsIgnoreCase(viewNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Vector getClipBoard() {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clip.getContents(null);
        if (contents == null) {
            return null;
        }
        try {
            Vector views = (Vector)contents.getTransferData(TransferableSemantics.semanticFlavor);
            return views;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getNewBuiltinViewName(String viewName) {
        if (!this.existViewName(viewName = viewName + "_BV")) {
            return viewName;
        }
        int i = 1;
        while (this.existViewName(viewName + String.valueOf(i))) {
            ++i;
        }
        return viewName + String.valueOf(i);
    }

    private String getNewName(Object objList, String prefix) {
        String newName;
        if (objList instanceof ViewList) {
            ViewList vl = (ViewList)objList;
            int i = 0;
            while (i < vl.getViewCount()) {
                newName = i == 0 ? prefix : prefix + i;
                if (!vl.hasView(newName)) {
                    return newName;
                }
                ++i;
            }
            newName = prefix + vl.getViewCount();
        } else if (objList instanceof EditStyleList) {
            EditStyleList esl = (EditStyleList)objList;
            int i = 0;
            while (i < esl.size()) {
                newName = i == 0 ? prefix : prefix + i;
                if (!esl.isEditStyleName(newName)) {
                    return newName;
                }
                ++i;
            }
            newName = prefix + esl.size();
        } else if (objList instanceof DataPipeList) {
            DataPipeList dpl = (DataPipeList)objList;
            int i = 0;
            while (i < dpl.size()) {
                newName = i == 0 ? prefix : prefix + i;
                if (!dpl.isExistName(newName)) {
                    return newName;
                }
                ++i;
            }
            newName = prefix + dpl.size();
        } else {
            ParamList pl = (ParamList)objList;
            int i = 0;
            while (i < pl.getParamCount()) {
                newName = i == 0 ? prefix : prefix + i;
                if (!pl.isParamName(newName)) {
                    return newName;
                }
                ++i;
            }
            newName = prefix + pl.getParamCount();
        }
        return newName;
    }

    private String getNewName(Object objList) {
        if (objList instanceof ViewList) {
            return this.getNewName(objList, "view");
        }
        if (objList instanceof EditStyleList) {
            return this.getNewName(objList, "style");
        }
        if (objList instanceof DataPipeList) {
            return this.getNewName(objList, "pipe");
        }
        return this.getNewName(objList, "arg");
    }

    private View getNextView(byte vType) {
        ViewList vl = this.vManager.getViewList();
        int i = vl.getViewCount() - 1;
        while (i >= 0) {
            View v = vl.getView(i);
            switch (vType) {
                case 1: {
                    if (!(v instanceof TableView)) break;
                    return v;
                }
                case 3: {
                    if (!(v instanceof SQLView)) break;
                    return v;
                }
                case 2: {
                    if (!(v instanceof ProcView)) break;
                    return v;
                }
                case 4: {
                    if (!(v instanceof BuiltinView)) break;
                    return v;
                }
                case 5: {
                    if (!(v instanceof CustomView)) break;
                    return v;
                }
            }
            --i;
        }
        return null;
    }

    private MyListViewModel getNodeModel(SemanticsTreeNode node) {
        ViewList vList;
        int i;
        Object[][] data = new Object[][]{};
        MyListViewModel emptyModel = new MyListViewModel(data);
        if (node == null) {
            return emptyModel;
        }
        String cat = (String)node.getUserObject();
        int subNodesCount = this.countSubNodes(node);
        int c = 0;
        data = new Object[subNodesCount][4];
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (cat.equals(this.TYPE_EDITSTYLE)) {
            EditStyleList esl = this.vManager.getEditStyleList();
            if (esl == null || !node.isRoot()) {
                return emptyModel;
            }
            i = 0;
            while (i < esl.size()) {
                EditStyle es = esl.get(i);
                data[c][0] = es;
                data[c][1] = es.getDispFormat();
                data[c][2] = this.getObjectType(es);
                data[c][3] = sdf.format(new Date(es.getEditTime()));
                ++c;
                ++i;
            }
        }
        if (cat.equals(this.TYPE_OUTERPARAM)) {
            ParamList pl = this.vManager.getParamList();
            if (pl == null || !node.isRoot()) {
                return emptyModel;
            }
            i = 0;
            while (i < pl.getParamCount()) {
                OuterParam op = pl.getParam(i);
                data[c][0] = op;
                data[c][1] = op.getDescription();
                data[c][2] = this.getObjectType(op);
                data[c][3] = sdf.format(new Date(op.getEditTime()));
                ++c;
                ++i;
            }
        }
        if ((vList = this.vManager.getViewList()) == null) {
            return emptyModel;
        }
        i = 0;
        while (i < vList.getViewCount()) {
            View v = vList.getView(i);
            if (cat == this.TYPE_TABLE && v instanceof TableView || cat == this.TYPE_BUILTIN && v instanceof BuiltinView || cat == this.TYPE_CUSTOM && v instanceof CustomView || cat == this.TYPE_SQL && v instanceof SQLView || cat == this.TYPE_PROC && v instanceof ProcView || cat == this.TYPE_VIEW || node.isRoot()) {
                String sql;
                data[c][0] = v;
                if (v instanceof TableView) {
                    data[c][1] = ((TableView)v).getTableName();
                } else if (v instanceof SQLView) {
                    sql = ((SQLView)v).getSQL();
                    if (sql != null) {
                        data[c][1] = sql.length() > 20 ? sql.substring(0, 20) + "..." : sql;
                    }
                } else if (v instanceof ProcView) {
                    sql = ((ProcView)v).getSQL();
                    if (sql != null) {
                        data[c][1] = sql.length() > 20 ? sql.substring(0, 20) + "..." : sql;
                    }
                } else {
                    data[c][1] = null;
                }
                data[c][2] = this.getObjectType(v);
                data[c][3] = sdf.format(new Date(v.getEditTime()));
                ++c;
            }
            ++i;
        }
        return new MyListViewModel(data);
    }

    private String getObjectType(Object v) {
        if (v instanceof TableView) {
            return this.TYPE_TABLE;
        }
        if (v instanceof SQLView) {
            return this.TYPE_SQL;
        }
        if (v instanceof ProcView) {
            return this.TYPE_PROC;
        }
        if (v instanceof BuiltinView) {
            return this.TYPE_BUILTIN;
        }
        if (v instanceof CustomView) {
            return this.TYPE_CUSTOM;
        }
        if (v instanceof EditStyle) {
            return this.TYPE_EDITSTYLE;
        }
        if (v instanceof OuterParam) {
            return this.TYPE_OUTERPARAM;
        }
        return null;
    }

    public IDataSheet getRootSheet() {
        return this;
    }

    private SemanticsTreeNode getSelectedNode() {
        TreePath path = this.mTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (SemanticsTreeNode)path.getLastPathComponent();
    }

    public String getSheetTitle() {
        return this.fileName;
    }

    public SemanticsManager getViewManager() {
        return this.vManager;
    }

    private void init() {
        this.mTree.addMouseListener(new mTree_mouseAdapter());
        this.listView.setListData((TableModel)new MyListViewModel(new String[0][]));
        this.listView.setCellPreferredSize(4, new Dimension(200, 20));
        this.listView.setViewMode(4);
        this.listView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object o = SheetViewManager.this.listView.getSelectedValue();
                if (o == null) {
                    return;
                }
                String objName = ((View)o).getViewName();
                SheetViewManager.this.refreshView(objName);
            }
        });
        this.listView.addMouseListener((MouseListener)new listView_mouseAdapter());
        this.listDataPipe.setListData(this.vManager.getDataPipeList());
    }

    private boolean isSaved() {
        boolean saved = true;
        if (this.isDataChanged) {
            String t1 = Lang.getText("sheeteditor.asksave", Lang.getText("sheetviewmanager.file"), this.fileName);
            String t2 = Lang.getText("sheeteditor.asksavetitle");
            int option = JOptionPane.showConfirmDialog(GV.appFrame, t1, t2, 1);
            switch (option) {
                case 0: {
                    saved = this.save();
                    break;
                }
                case 1: {
                    saved = true;
                    break;
                }
                default: {
                    saved = false;
                }
            }
        }
        return saved;
    }

    void loadSubCat(SemanticsTreeNode parent) {
        String cat = (String)parent.getUserObject();
        if (cat.equals(this.TYPE_TABLE) || cat.equals(this.TYPE_SQL) || cat.equals(this.TYPE_PROC) || cat.equals(this.TYPE_BUILTIN) || cat.equals(this.TYPE_CUSTOM)) {
            ViewList vList = this.vManager.getViewList();
            if (vList == null) {
                return;
            }
            int i = 0;
            while (i < vList.getViewCount()) {
                View v = vList.getView(i);
                if (cat.equals(this.TYPE_TABLE) && v instanceof TableView || cat.equals(this.TYPE_BUILTIN) && v instanceof BuiltinView || cat.equals(this.TYPE_CUSTOM) && v instanceof CustomView || cat.equals(this.TYPE_SQL) && v instanceof SQLView || cat.equals(this.TYPE_PROC) && v instanceof ProcView) {
                    SemanticsTreeNode subNode = new SemanticsTreeNode(v);
                    parent.add(subNode);
                }
                ++i;
            }
        }
    }

    void loadSubPipe(SemanticsTreeNode parent) {
        DataPipeList list = this.vManager.getDataPipeList();
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                DataPipe dp = list.get(i);
                SemanticsTreeNode subNode = new SemanticsTreeNode(dp);
                parent.add(subNode);
                ++i;
            }
        }
    }

    public boolean paste() {
        ParamList pl;
        EditStyleList esl;
        Vector o;
        if (this.oldNode != null) {
            if (this.oldNode.getType() == 0) {
                if (this.oldNode.getUserObject() == this.TYPE_EDITSTYLE) {
                    this.editStyle.paste();
                    return true;
                }
                if (this.oldNode.getUserObject() == this.TYPE_OUTERPARAM) {
                    this.outerParam.paste();
                    return true;
                }
            }
        }
        if ((o = this.getClipBoard()) == null) {
            return false;
        }
        Vector objs = o;
        ViewList vl = this.vManager.getViewList();
        if (vl == null) {
            vl = new ViewList();
            this.vManager.setViewList(vl);
        }
        if ((esl = this.vManager.getEditStyleList()) == null) {
            esl = new EditStyleList();
            this.vManager.setEditStyleList(esl);
        }
        if ((pl = this.vManager.getParamList()) == null) {
            pl = new ParamList();
            this.vManager.setParamList(pl);
        }
        int i = 0;
        while (i < objs.size()) {
            String copiedName;
            Object obj = objs.get(i);
            if (obj instanceof View) {
                View v = (View)obj;
                View copiedView = (View)v.deepClone();
                copiedName = this.getNewName(vl, v.getViewName());
                copiedView.setViewName(copiedName);
                vl.addView(copiedView);
            } else if (obj instanceof EditStyle) {
                EditStyle es = (EditStyle)obj;
                EditStyle copiedStyle = (EditStyle)es.deepClone();
                copiedName = this.getNewName(esl, es.getName());
                copiedStyle.setName(copiedName);
                esl.add(copiedStyle);
            } else {
                OuterParam op = (OuterParam)obj;
                OuterParam copiedParam = (OuterParam)op.deepClone();
                copiedName = this.getNewName(pl, op.getParamName());
                copiedParam.setParamName(copiedName);
                pl.addParam(copiedParam);
            }
            ++i;
        }
        this.refreshView(null);
        return true;
    }

    private void refreshView(String nodeName) {
        SemanticsTreeNode node;
        this.enableCopyAction(false);
        this.enablePasteAction(false);
        SemanticsTreeNode root = new SemanticsTreeNode(this.fileName);
        if (nodeName == null && (node = this.getSelectedNode()) != null) {
            nodeName = node.getName();
        }
        node = new SemanticsTreeNode(this.TYPE_VIEW);
        SemanticsTreeNode vNode = new SemanticsTreeNode(this.TYPE_TABLE);
        this.loadSubCat(vNode);
        node.add(vNode);
        vNode = new SemanticsTreeNode(this.TYPE_SQL);
        this.loadSubCat(vNode);
        node.add(vNode);
        vNode = new SemanticsTreeNode(this.TYPE_PROC);
        this.loadSubCat(vNode);
        node.add(vNode);
        vNode = new SemanticsTreeNode(this.TYPE_BUILTIN);
        this.loadSubCat(vNode);
        node.add(vNode);
        vNode = new SemanticsTreeNode(this.TYPE_CUSTOM);
        this.loadSubCat(vNode);
        node.add(vNode);
        root.add(node);
        node = new SemanticsTreeNode(this.TYPE_EDITSTYLE);
        root.add(node);
        node = new SemanticsTreeNode(this.TYPE_OUTERPARAM);
        root.add(node);
        node = new SemanticsTreeNode(this.TYPE_DATAPIPE);
        this.loadSubPipe(node);
        root.add(node);
        this.mTreeModel = new DefaultTreeModel(root);
        this.mTree.setModel(this.mTreeModel);
        this.mTree.setCellRenderer(new SemanticsTreeRender());
        this.listView.setListData((TableModel)this.getNodeModel(null));
        this.listView.setCellRenderer((DefaultCellRenderer)new MyListViewRender());
        this.listView.setCellEditor((DefaultCellEditor)new MyListViewEditor());
        this.splitPane.add((Component)this.listView, "right");
        int splitPos = new Double(0.25 * Toolkit.getDefaultToolkit().getScreenSize().getWidth()).intValue();
        this.splitPane.setDividerLocation(splitPos);
        this.setSelectionTreeNode(nodeName);
        EditStyleList esl = this.vManager.getEditStyleList();
        this.editStyle.setEditStyles(esl, this.vManager);
        ParamList pl = this.vManager.getParamList();
        this.outerParam.setOuterParams(pl, this.vManager.listEditStyleNames());
    }

    private void reload() {
        this.refreshView(null);
    }

    public boolean remoteSaveAs() {
        DialogRemoteOpen dro = new DialogRemoteOpen(DialogRemoteOpen.T_SAVEAS);
        dro.setPath(this.fileName);
        dro.show();
        if (dro.getOption() != 0) {
            return false;
        }
        String newName = dro.getPath();
        this.adjustNewFileEnv(this.fileName, newName);
        this.isRemote = true;
        return this.save();
    }

    public boolean save() {
        if (!this.viewEditor.saveView()) {
            return false;
        }
        if (this.oldNode != null && this.oldNode.getUserObject() instanceof DataPipe && !this.saveDataPipe()) {
            return false;
        }
        this.vManager.setEditStyleList(this.editStyle.getEditStyles());
        this.vManager.setParamList(this.outerParam.getOuterParams());
        this.saveDataPipeList();
        if (!this.isRemote || this.isRemote && LogInfo.canSaveLocalSemantic() && this.saveLocal) {
            File f = new File(this.fileName);
            if (f == null || !this.fileName.toLowerCase().endsWith(".xml")) {
                return this.saveAs();
            }
            GV.appMenu.refreshRecentSemantic(this.fileName);
            this.vManager.writeXML(this.fileName);
        } else {
            if (!(LogInfo.canSaveSemantic() || LogInfo.canSaveAsSemantic() && !this.oldFileName.equals(this.fileName) || LogInfo.canSaveLocalSemantic() && this.saveLocal)) {
                JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("sheetviewmanager.cantsave") + this.fileName + Lang.getText("sheetviewmanager.toserver"));
                return false;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.vManager.writeXMLStream(new StreamResult(baos));
            Response res = LogInfo.putRemoteFileStream(this.fileName, Const.FILE_SEMANTICS, baos.toByteArray());
            if (res.state != Const.OK) {
                JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("sheetviewmanager.savefile") + this.fileName + Lang.getText("sheetviewmanager.faild") + "\r\n" + res.clause);
                return false;
            }
        }
        this.dataModified(false);
        return true;
    }

    public boolean saveAs() {
        if (this.isRemote && !LogInfo.canSaveLocalSemantic()) {
            JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("sheetviewmanager.cantsaveas") + "[ " + this.fileName + " ]" + Lang.getText("sheetviewmanager.tolocal"), Lang.getText("public.note"), -1);
            return false;
        }
        StringTokenizer st = new StringTokenizer(this.fileName);
        String defaultName = this.fileName;
        if (st.hasMoreTokens()) {
            defaultName = st.nextToken();
        }
        int slash = defaultName.lastIndexOf(System.getProperty("file.separator"));
        int dot = defaultName.lastIndexOf(".");
        defaultName = slash > -1 && dot > -1 ? defaultName.substring(slash + 1, dot) : "";
        String tmpExt = "xml";
        File saveFile = GM.dialogSelectFile(tmpExt, GV.lastDirectory, Lang.getText("sheetviewmanager.save"), defaultName);
        if (saveFile == null) {
            return false;
        }
        String sfile = saveFile.getAbsolutePath();
        GV.lastDirectory = saveFile.getParent();
        if (!sfile.toLowerCase().endsWith("xml")) {
            saveFile = new File(saveFile.getParent(), saveFile.getName() + ".xml");
            sfile = saveFile.getAbsolutePath();
        }
        if (!GM.canSaveAsFile(sfile)) {
            return false;
        }
        this.adjustNewFileEnv(this.fileName, sfile);
        this.saveLocal = true;
        boolean saved = this.save();
        this.saveLocal = false;
        return saved;
    }

    private boolean saveDataPipe() {
        DataPipe dp = this.dataPipe.getDataPipe();
        if (dp != null) {
            this.oldNode.setUserObject(dp);
        }
        return dp != null;
    }

    private void saveDataPipeList() {
        DataPipeList dataPipeList = new DataPipeList();
        SemanticsTreeNode root = (SemanticsTreeNode)this.mTreeModel.getRoot();
        int i = 0;
        while (i < root.getChildCount()) {
            SemanticsTreeNode child = (SemanticsTreeNode)root.getChildAt(i);
            if (child.getName().equals(this.TYPE_DATAPIPE)) {
                int j = 0;
                while (j < child.getChildCount()) {
                    SemanticsTreeNode node = (SemanticsTreeNode)child.getChildAt(j);
                    DataPipe dp = (DataPipe)node.getUserObject();
                    dataPipeList.add(dp);
                    ++j;
                }
            }
            ++i;
        }
        this.vManager.setDataPipeList(dataPipeList);
    }

    private void setSelectionTreeNode(String nodeName) {
        if (nodeName == null) {
            return;
        }
        SemanticsTreeNode root = (SemanticsTreeNode)this.mTreeModel.getRoot();
        Enumeration<TreeNode> nodes = root.breadthFirstEnumeration();
        DefaultMutableTreeNode node = null;
        while (nodes.hasMoreElements()) {
            node = (SemanticsTreeNode)nodes.nextElement();
            if (((SemanticsTreeNode)node).getName().equals(nodeName)) break;
        }
        if (node == null) {
            return;
        }
        Object[] path = node.getPath();
        this.mTree.setSelectionPath(new TreePath(path));
        this.oldNode = node;
        this.treeNodeSelected((SemanticsTreeNode)node);
    }

    private boolean sureDelete() {
        if (ConfigOptions.bDeletePrompt.booleanValue()) {
            int option = JOptionPane.showOptionDialog(this, Lang.getText("sheetviewmanager.querydelete"), Lang.getText("public.delete"), 0, 3, null, new String[]{Lang.getText("public.yes"), Lang.getText("public.no")}, Lang.getText("public.no"));
            return option == 0;
        }
        return true;
    }

    private void treeNodeSelected(SemanticsTreeNode node) {
        switch (node.getType()) {
            case 0: {
                String typeName = (String)node.getUserObject();
                if (typeName == this.TYPE_EDITSTYLE) {
                    this.enableCopyAction(false);
                    this.enablePasteAction(false);
                    EditStyleList esl = this.vManager.getEditStyleList();
                    this.editStyle.setEditStyles(esl, this.vManager);
                    this.splitPane.add((Component)this.editStyle, "right");
                    break;
                }
                if (typeName == this.TYPE_OUTERPARAM) {
                    this.enableCopyAction(false);
                    this.enablePasteAction(false);
                    ParamList pl = this.vManager.getParamList();
                    this.outerParam.setOuterParams(pl, this.vManager.listEditStyleNames());
                    this.splitPane.add((Component)this.outerParam, "right");
                    break;
                }
                if (typeName == this.TYPE_DATAPIPE) {
                    this.enableCopyAction(false);
                    this.enablePasteAction(false);
                    this.listDataPipe.setListData(this.vManager.getDataPipeList());
                    this.splitPane.add((Component)this.listDataPipe, "right");
                    break;
                }
                this.enableCopyAction(false);
                this.enablePasteAction(true);
                this.listView.setListData((TableModel)this.getNodeModel(node));
                this.listView.setCellRenderer((DefaultCellRenderer)new MyListViewRender());
                this.listView.setCellEditor((DefaultCellEditor)new MyListViewEditor());
                this.splitPane.add((Component)this.listView, "right");
                break;
            }
            case 71: {
                DataPipe dp = (DataPipe)node.getUserObject();
                this.dataPipe.setDataPipe(dp);
                this.splitPane.add((Component)this.dataPipe, "right");
                break;
            }
            default: {
                this.enableCopyAction(true);
                this.enablePasteAction(false);
                View view = (View)node.getUserObject();
                this.viewEditor.showView(view, this.vManager, this.vManager.listEditStyleNames());
                this.splitPane.add((Component)this.viewEditor, "right");
            }
        }
        int splitPos = new Double(0.25 * Toolkit.getDefaultToolkit().getScreenSize().getWidth()).intValue();
        this.splitPane.setDividerLocation(splitPos);
    }

    class listView_mouseAdapter
    extends MouseAdapter {
        listView_mouseAdapter() {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getButton() != 3) {
                return;
            }
            Object item = SheetViewManager.this.listView.getSelectedValue();
            if (item == null) {
                return;
            }
            MenuManagerPop mpop = new MenuManagerPop();
            JPopupMenu pop = mpop.getPopupMenu(2);
            pop.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class mTree_mouseAdapter
    extends MouseAdapter {
        mTree_mouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 2) {
                return;
            }
            TreePath path = SheetViewManager.this.mTree.getClosestPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            SheetViewManager.this.mTree.setSelectionPath(path);
            SemanticsTreeNode node = (SemanticsTreeNode)path.getLastPathComponent();
            if (node.getLevel() == 3) {
                SheetViewManager.this.viewEditor.executeCmd((short)5285);
            }
        }

        public void mousePressed(MouseEvent e) {
            SemanticsTreeNode node;
            int selRow = SheetViewManager.this.mTree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = SheetViewManager.this.mTree.getPathForLocation(e.getX(), e.getY());
            if (selRow == -1) {
                return;
            }
            boolean saved = false;
            if (SheetViewManager.this.oldNode != null) {
                SemanticsTreeNode cfr_ignored_0 = SheetViewManager.this.oldNode;
                if (SheetViewManager.this.oldNode.getType() == 0) {
                    String strType = (String)SheetViewManager.this.oldNode.getUserObject();
                    if (strType == SheetViewManager.this.TYPE_EDITSTYLE) {
                        saved = SheetViewManager.this.editStyle.checkData();
                        if (!saved) {
                            this.rollBackNode();
                            return;
                        }
                        SheetViewManager.this.vManager.setEditStyleList(SheetViewManager.this.editStyle.getEditStyles());
                    } else if (strType == SheetViewManager.this.TYPE_OUTERPARAM) {
                        saved = SheetViewManager.this.outerParam.checkData();
                        if (!saved) {
                            this.rollBackNode();
                            return;
                        }
                        SheetViewManager.this.vManager.setParamList(SheetViewManager.this.outerParam.getOuterParams());
                    }
                } else {
                    Object o = SheetViewManager.this.oldNode.getUserObject();
                    if (o instanceof View) {
                        saved = SheetViewManager.this.viewEditor.saveView();
                    } else if (o instanceof DataPipe && (saved = SheetViewManager.this.saveDataPipe())) {
                        SheetViewManager.this.saveDataPipeList();
                    }
                    if (!saved) {
                        this.rollBackNode();
                        return;
                    }
                    SheetViewManager.this.mTreeModel.nodeChanged(SheetViewManager.this.oldNode);
                }
            }
            SheetViewManager.this.oldNode = node = (SemanticsTreeNode)selPath.getLastPathComponent();
            SheetViewManager.this.treeNodeSelected(node);
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getButton() != 3) {
                return;
            }
            TreePath path = SheetViewManager.this.mTree.getClosestPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            SheetViewManager.this.mTree.setSelectionPath(path);
            SemanticsTreeNode node = (SemanticsTreeNode)path.getLastPathComponent();
            MenuManagerPop mpop = new MenuManagerPop();
            JPopupMenu pop = mpop.getPopupMenu(node.getLevel());
            if (node.getLevel() == 1 && node.getName().equals(SheetViewManager.this.TYPE_DATAPIPE)) {
                pop = new JPopupMenu();
                pop.add(((MenuManager)GV.appMenu).cloneMenuItem((short)5225));
                pop.add(((MenuManager)GV.appMenu).cloneMenuItem((short)5075));
            } else if (node.getLevel() == 2 && node.getUserObject() instanceof DataPipe) {
                pop = new JPopupMenu();
                JMenuItem mItem = ((MenuManager)GV.appMenu).cloneMenuItem((short)5231);
                mItem.setText(Lang.getText("sheetviewmanager.delpipe"));
                pop.add(mItem);
                mItem = ((MenuManager)GV.appMenu).cloneMenuItem((short)5270);
                mItem.setText(Lang.getText("sheetviewmanager.transdata"));
                pop.add(mItem);
                pop.addSeparator();
                pop.add(((MenuManager)GV.appMenu).cloneMenuItem((short)5075));
            }
            pop.show(e.getComponent(), e.getX(), e.getY());
        }

        private void rollBackNode() {
            TreePath path = new TreePath(SheetViewManager.this.oldNode.getPath());
            SheetViewManager.this.mTree.setSelectionPath(path);
        }
    }

    class MyListViewRender
    extends DefaultCellRenderer {
        MyListViewRender() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String val = "";
            if (value != null) {
                val = value instanceof View ? ((View)value).getViewName() : (value instanceof EditStyle ? ((EditStyle)value).getName() : (value instanceof OuterParam ? ((OuterParam)value).getParamName() : value.toString()));
            }
            JLabel label = new JLabel(val);
            if (isSelected) {
                label.setForeground(table.getSelectionForeground());
                label.setBackground(table.getSelectionBackground());
            } else {
                label.setForeground(table.getForeground());
                label.setBackground(table.getBackground());
            }
            if (column == 0) {
                Icon icon = new SemanticsTreeNode(value).getDispIcon();
                label.setIcon(icon);
            }
            return label;
        }
    }

    class MyListViewEditor
    extends DefaultCellEditor {
        JTextField tfEditor = new JTextField();

        public MyListViewEditor() {
            this.tfEditor.setEditable(false);
            this.setEditingStopBehavior(1);
        }

        protected void commitEdit() throws ParseException {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String val = "";
            if (value != null) {
                val = value instanceof View ? ((View)value).getViewName() : (value instanceof EditStyle ? ((EditStyle)value).getName() : (value instanceof OuterParam ? ((OuterParam)value).getParamName() : value.toString()));
            }
            if (column == 0) {
                this.tfEditor.setText(val);
            }
            return this.tfEditor;
        }

        protected Object getValue() {
            return this.tfEditor.getText();
        }

        protected void setValue(Object object) {
            if (object != null && object instanceof View) {
                this.tfEditor.setText(((View)object).getViewName());
            }
        }
    }

    class MyListViewModel
    extends DefaultTableModel
    implements ColumnSorter {
        public MyListViewModel(Object[][] data, Object[] colNames) {
            super(data, colNames);
        }

        public MyListViewModel(Object[][] data) {
            this(data, colNames);
        }

        private int shiftRowUp(int row, int step) {
            if (row < 0) {
                return row;
            }
            int cr = row;
            if (cr <= 0) {
                return -1;
            }
            this.moveRow(cr, cr, cr - step);
            return cr - 1;
        }

        public void sortColumn(int column, boolean ascending) {
            if (this.getRowCount() < 2) {
                return;
            }
            int i = 0;
            while (i < this.getRowCount()) {
                Object o = this.getValueAt(i, column);
                if (!(o == null || o instanceof Comparable || o instanceof View || o instanceof EditStyle || o instanceof OuterParam)) {
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < this.getRowCount() - 1) {
                int j = i + 1;
                while (j < this.getRowCount()) {
                    Object tmp = this.getValueAt(i, column);
                    Object ci = tmp instanceof View ? ((View)tmp).getViewName() : (tmp instanceof EditStyle ? ((EditStyle)tmp).getName() : (tmp instanceof OuterParam ? ((OuterParam)tmp).getParamName() : (Comparable)tmp));
                    tmp = this.getValueAt(j, column);
                    Object cj = tmp instanceof View ? ((View)tmp).getViewName() : (tmp instanceof EditStyle ? ((EditStyle)tmp).getName() : (tmp instanceof OuterParam ? ((OuterParam)tmp).getParamName() : (Comparable)tmp));
                    boolean lb_exchange = ascending ? (ci == null || cj == null ? cj == null : ci.compareTo(cj) > 0) : (ci == null || cj == null ? ci == null : ci.compareTo(cj) < 0);
                    if (lb_exchange) {
                        this.shiftRowUp(j, j - i);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    class Listener
    extends InternalFrameAdapter {
        IDataSheet sheet;

        public Listener(SheetViewManager parent) {
            this.sheet = parent;
        }

        static /* synthetic */ SheetViewManager access$500(Listener x0) {
            return x0.SheetViewManager.this;
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    GVData.activeSheet = this.this$1.sheet;
                    GVData.getFrameManager().changeBar(GVData.getManagerMenu(), GVData.getManagerTool());
                    GV.appMenu.addLiveMenu(this.this$1.sheet.getSheetTitle());
                    GV.appMenu.resetPrivilegeMenu();
                    Listener.access$500(this.this$1).dataModified(SheetViewManager.access$600(Listener.access$500(this.this$1)));
                    SheetViewManager.access$100(Listener.access$500(this.this$1), null);
                }
            });
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            GVData.getFrameManager().closeSheet(this.sheet);
        }
    }
}

