/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.cache;

import com.runqian.base4.util.Logger;
import com.runqian.base4.util.ReportError;
import com.runqian.report4.cache.CacheManager;
import com.runqian.report4.cache.PagerCache;
import com.runqian.report4.cache.ReportCache;
import com.runqian.report4.cache.Utils;
import com.runqian.report4.cache.WriterThread;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.PageBuilder;
import com.runqian.report4.usermodel.PagerInfo;
import java.io.File;
import java.lang.ref.SoftReference;

class LocalPagerCache
extends PagerCache {
    public LocalPagerCache(ReportCache rc, PagerInfo pi) {
        super(rc, Utils.getId(), pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PageBuilder getPageBuilder() throws Throwable {
        if (this.pbRef == null) {
            PageBuilder pb;
            if (this.isInterrupted) {
                throw new ReportError("Calculation is interrupted!");
            }
            IReport report = this.rc.getReport();
            if (report == null) {
                return null;
            }
            this.tempPb = pb = new PageBuilder(report, this.pi, true);
            try {
                pb.createPages();
                this.pbRef = new SoftReference<PageBuilder>(pb);
                Object var4_5 = null;
                this.tempPb = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.tempPb = null;
                throw throwable;
            }
            new WriterThread(2, this.id, pb, this.getLogInfo()).start();
            return pb;
        }
        PageBuilder pb = (PageBuilder)this.pbRef.get();
        if (pb == null) {
            try {
                CacheManager.debug((String)("\u5f00\u59cb\u8bfb\u53d6\u5206\u9875\u7f13\u5b58\uff0c" + this.getLogInfo()));
                pb = PageBuilder.cacheRead(this.rc.getReport(), this.pi, CacheManager.getInstance().getCachePath().getPath(), this.id, CacheManager.getInstance().getCompressMode());
                this.pbRef = new SoftReference<PageBuilder>(pb);
                CacheManager.debug((String)("\u8bfb\u53d6\u5206\u9875\u7f13\u5b58\u7ed3\u675f\uff0c" + this.getLogInfo()));
            }
            catch (Throwable e) {
                Logger.error(e.getMessage(), e);
            }
        }
        return pb;
    }

    public int getPageCount() throws Throwable {
        return this.getPageBuilder().getPageCount();
    }

    boolean isEqualsPagerInfo(PagerInfo pi) {
        return pi.equals(this.pi);
    }

    synchronized void release() {
        File file = new File(CacheManager.getInstance().getCachePath(), this.id);
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForWriteThread() {
        if (this.pbRef == null) {
            try {
                this.getPageBuilder();
                Thread.sleep(100L);
            }
            catch (Throwable e) {
            }
        }
        String string = this.id;
        synchronized (string) {
            if (this.pbRef != null) {
                this.pbRef.get();
            }
        }
    }
}

