/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.dataset;

import java.util.ArrayList;
import java.util.List;

class BlockList {
    private int blockSize;
    private int colCount = 0;
    private List dataList = new ArrayList(16);
    private int rowCount = 0;

    public BlockList(int colCount, int blockSize) {
        this.colCount = colCount;
        this.blockSize = blockSize;
    }

    public BlockList(int colCount) {
        this(colCount, 1024);
    }

    public void addRow(Object[] data) {
        Object[] block = null;
        int r = this.rowCount;
        if (r % this.blockSize == 0) {
            block = new Object[this.blockSize];
            this.dataList.add(block);
        } else {
            block = (Object[])this.dataList.get(r / this.blockSize);
        }
        this.rowCount = r + 1;
        block[r % this.blockSize] = data;
    }

    public Object[] addRow() {
        Object[] row = new Object[this.colCount];
        this.addRow(row);
        return row;
    }

    public Object[] getRow(int r) {
        if (r >= this.rowCount) {
            return null;
        }
        int blockIndex = r / this.blockSize;
        Object[] block = (Object[])this.dataList.get(blockIndex);
        return (Object[])block[r % this.blockSize];
    }
}

