/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide;

import com.runqian.base4.util.StringUtils;
import com.runqian.report4.model.ReportDefine2;
import com.runqian.report4.usermodel.Area;
import com.runqian.report4.usermodel.IByteMap;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.PrintSetup;
import com.runqian.report4.util.ReportParser;
import com.runqian.report4.view.excel.ExcelColor;
import java.awt.Color;
import java.awt.Font;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.poi2.hssf.usermodel.HSSFCell;
import org.apache.poi2.hssf.usermodel.HSSFCellStyle;
import org.apache.poi2.hssf.usermodel.HSSFDataFormat;
import org.apache.poi2.hssf.usermodel.HSSFDateUtil;
import org.apache.poi2.hssf.usermodel.HSSFFont;
import org.apache.poi2.hssf.usermodel.HSSFHyperlink;
import org.apache.poi2.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi2.hssf.usermodel.HSSFRichTextString;
import org.apache.poi2.hssf.usermodel.HSSFRow;
import org.apache.poi2.hssf.usermodel.HSSFSheet;
import org.apache.poi2.hssf.usermodel.HSSFWorkbook;
import org.apache.poi2.hssf.util.Region;

public class SheetTransfer {
    private Region[] _$1;
    private IReport _$2;
    private ReportParser _$3;
    private HSSFWorkbook _$4;
    private HSSFSheet _$5;
    private HSSFFont[] _$6;
    private boolean _$7;
    private boolean _$8 = false;
    private boolean _$9 = false;

    public SheetTransfer(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, HSSFFont[] hSSFFontArray) {
        float f;
        this._$4 = hSSFWorkbook;
        this._$5 = hSSFSheet;
        this._$6 = hSSFFontArray;
        int n = hSSFSheet.getLastRowNum() + 1;
        int n2 = SheetTransfer._$1(hSSFSheet);
        if (n == 1 && n2 == 0) {
            this._$7 = true;
            return;
        }
        this._$2 = new ReportDefine2(n, n2);
        this._$2.setUnit((byte)0);
        this._$3 = new ReportParser(this._$2);
        int n3 = 1;
        while (n3 <= n) {
            HSSFRow hSSFRow = hSSFSheet.getRow(n3 - 1);
            if (hSSFRow != null) {
                f = hSSFRow.getHeight();
                f /= 19.62f;
                if (hSSFRow.getZeroHeight()) {
                    this._$2.getRowCell(n3).setRowVisible(false);
                }
                this._$2.getRowCell(n3).setRowHeight(f);
            }
            ++n3;
        }
        int n4 = 1;
        while (n4 <= n2) {
            f = hSSFSheet.getColumnWidth((short)(n4 - 1));
            if (f == 8.0f) {
                f = 2304.0f;
            }
            f /= 42.74f;
            if (hSSFSheet.isColumnHidden((short)(n4 - 1))) {
                this._$2.getColCell((short)n4).setColVisible(false);
            }
            this._$2.getColCell((short)n4).setColWidth(f);
            ++n4;
        }
        this._$1 = new Region[hSSFSheet.getNumMergedRegions()];
        int n5 = 0;
        while (n5 < this._$1.length) {
            this._$1[n5] = hSSFSheet.getMergedRegionAt(n5);
            ++n5;
        }
    }

    private void _$1() {
        int n = 0;
        while (n < this._$1.length) {
            int n2 = this._$1[n].getRowFrom() + 1;
            int n3 = this._$1[n].getRowTo() + 1;
            short s = (short)(this._$1[n].getColumnFrom() + 1);
            short s2 = (short)(this._$1[n].getColumnTo() + 1);
            INormalCell iNormalCell = this._$3.getCell(n2, s);
            iNormalCell.setMergedArea(new Area(n2, s, n3, s2));
            int n4 = n2;
            while (n4 <= n3) {
                short s3 = s;
                while (s3 <= s2) {
                    this._$2.setCell(n4, s3, iNormalCell);
                    s3 = (short)(s3 + 1);
                }
                ++n4;
            }
            ++n;
        }
    }

    private static void _$1(StringBuffer stringBuffer, int n) {
        if ((n >> 24 & 0xFF) == 0) {
            stringBuffer.append("transparent");
            return;
        }
        stringBuffer.append('#');
        StringUtils.appendHexString(stringBuffer, n, 3);
    }

    private String _$1(HSSFCell hSSFCell) {
        HSSFDataFormat hSSFDataFormat = this._$4.createDataFormat();
        return hSSFDataFormat.getFormat(hSSFCell.getCellStyle().getDataFormat());
    }

    private static void _$1(HSSFFont hSSFFont, StringBuffer stringBuffer, HSSFFont hSSFFont2, String string) {
        if (string == null || string.length() < 1) {
            return;
        }
        String string2 = hSSFFont.getFontName();
        short s = hSSFFont.getBoldweight();
        short s2 = hSSFFont.getColor();
        short s3 = hSSFFont.getFontHeightInPoints();
        boolean bl = hSSFFont.getItalic();
        short s4 = hSSFFont.getTypeOffset();
        byte by = hSSFFont.getUnderline();
        if (s4 == 2) {
            stringBuffer.append("<sub>");
        } else if (s4 == 1) {
            stringBuffer.append("<sup>");
        }
        stringBuffer.append("<font ").append(" style=\"");
        if (string2 != null && !string2.equals(hSSFFont2)) {
            stringBuffer.append("font-family:").append(string2).append(";");
        }
        if (s3 != hSSFFont2.getFontHeightInPoints()) {
            stringBuffer.append("font-size:").append(s3).append(";");
        }
        if (s != hSSFFont2.getBoldweight()) {
            if (s == 700) {
                stringBuffer.append("font-weight:bold;");
            } else if (s == 400) {
                stringBuffer.append("font-weight:normal;");
            }
        }
        if (bl != hSSFFont2.getItalic()) {
            if (bl) {
                stringBuffer.append("font-style:italic;");
            } else {
                stringBuffer.append("font-style:normal;");
            }
        }
        if (by != hSSFFont2.getUnderline()) {
            if (by != 0) {
                stringBuffer.append("text-decoration:underline;");
            } else {
                stringBuffer.append("text-decoration:none;");
            }
        }
        if (s2 != hSSFFont2.getColor()) {
            stringBuffer.append("color:");
            SheetTransfer._$1(stringBuffer, ExcelColor.getColorInReport(hSSFFont.getColor(), Color.black));
        }
        stringBuffer.append("\">");
        stringBuffer.append(string);
        stringBuffer.append("</font>");
        if (s4 == 2) {
            stringBuffer.append("</sub>");
            return;
        }
        if (s4 == 1) {
            stringBuffer.append("</sup>");
        }
    }

    static int _$1(HSSFSheet hSSFSheet) {
        short s = 0;
        int n = hSSFSheet.getLastRowNum();
        int n2 = 0;
        while (n2 <= n) {
            short s2;
            HSSFRow hSSFRow = hSSFSheet.getRow(n2);
            if (hSSFRow != null && (s2 = hSSFRow.getLastCellNum()) > s) {
                s = s2;
            }
            ++n2;
        }
        return s;
    }

    private int _$1(short s) {
        switch (s) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 32: 
            case 33: 
            case 55: 
            case 56: {
                return 1;
            }
            case 22: {
                return 2;
            }
        }
        if (s >= 201 && s <= 211) {
            return 1;
        }
        return 0;
    }

    private void _$1(short s, short s2, int n, short s3, int n2) {
        byte by = 80;
        float f = 0.75f;
        switch (s) {
            case 7: 
            case 9: 
            case 11: {
                by = 81;
                break;
            }
            case 3: {
                by = 82;
                break;
            }
            case 6: {
                by = 84;
                break;
            }
            case 4: {
                by = 83;
                break;
            }
            case 2: {
                by = 83;
                f = 1.5f;
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                by = 81;
                f = 1.5f;
                break;
            }
            case 8: {
                by = 82;
                f = 1.5f;
                break;
            }
            case 0: {
                by = 80;
                return;
            }
            case 5: {
                by = 83;
                f = 2.0f;
                break;
            }
            case 1: {
                by = 83;
                f = 1.0f;
                break;
            }
        }
        switch (n2) {
            case 1: {
                this._$2.setTBStyle(n, s3, by);
                this._$2.setTBWidth(n, s3, f);
                this._$2.setTBColor(n, s3, ExcelColor.getColorInReport(s2, Color.black));
                return;
            }
            case 2: {
                this._$2.setBBStyle(n, s3, by);
                this._$2.setBBWidth(n, s3, f);
                this._$2.setBBColor(n, s3, ExcelColor.getColorInReport(s2, Color.black));
                return;
            }
            case 3: {
                this._$2.setLBStyle(n, s3, by);
                this._$2.setLBWidth(n, s3, f);
                this._$2.setLBColor(n, s3, ExcelColor.getColorInReport(s2, Color.black));
                return;
            }
            case 4: {
                this._$2.setRBStyle(n, s3, by);
                this._$2.setRBWidth(n, s3, f);
                this._$2.setRBColor(n, s3, ExcelColor.getColorInReport(s2, Color.black));
                return;
            }
        }
    }

    public void save(String string) throws Exception {
        if (this._$7) {
            return;
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
        objectOutputStream.writeObject(this._$2);
        objectOutputStream.close();
    }

    public void setExportRichText(boolean bl) {
        this._$9 = bl;
    }

    public void setFormulaAsExp(boolean bl) {
        this._$8 = bl;
    }

    public IReport toReport() {
        int n;
        PrintSetup printSetup;
        if (this._$7) {
            return null;
        }
        HSSFDataFormat hSSFDataFormat = this._$4.createDataFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DecimalFormat decimalFormat = new DecimalFormat("#.##################");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = 1;
        while (n2 <= this._$2.getRowCount()) {
            printSetup = this._$5.getRow(n2 - 1);
            if (printSetup != null) {
                short s = 1;
                while (s <= this._$2.getColCount()) {
                    HSSFCell hSSFCell = printSetup.getCell((short)(s - 1));
                    if (hSSFCell != null) {
                        String string;
                        HSSFFont hSSFFont;
                        String string2;
                        String string3;
                        int n3;
                        int n4;
                        HSSFRichTextString hSSFRichTextString;
                        n = hSSFCell.getCellType();
                        INormalCell iNormalCell = this._$3.getCell(n2, s);
                        String string4 = "";
                        boolean bl = false;
                        switch (n) {
                            case 1: {
                                hSSFRichTextString = hSSFCell.getRichStringCellValue();
                                if (this._$9 && hSSFRichTextString != null && hSSFRichTextString.numFormattingRuns() > 0) {
                                    bl = true;
                                }
                                string4 = SheetTransfer.transferString(hSSFCell, this._$9, this._$6);
                                break;
                            }
                            case 0: {
                                String string5;
                                double d = hSSFCell.getNumericCellValue();
                                if (HSSFDateUtil.isCellDateFormatted((HSSFCell)hSSFCell, (HSSFDataFormat)hSSFDataFormat)) {
                                    Date date = HSSFDateUtil.getJavaDate((double)d);
                                    n4 = this._$1(hSSFCell.getCellStyle().getDataFormat());
                                    if (n4 == 0) {
                                        string4 = simpleDateFormat.format(date);
                                        break;
                                    }
                                    if (n4 == 1) {
                                        string4 = new SimpleDateFormat("HH:mm:ss").format(date);
                                        break;
                                    }
                                    if (n4 != 2) break;
                                    string4 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
                                    break;
                                }
                                string4 = decimalFormat.format(d);
                                n3 = string4.indexOf(".");
                                if (n3 >= 0) {
                                    n4 = 1;
                                    ++n3;
                                    while (n3 < string4.length()) {
                                        if (string4.charAt(n3) != '0') {
                                            n4 = 0;
                                            break;
                                        }
                                        ++n3;
                                    }
                                    if (n4 != 0) {
                                        string4 = string4.substring(0, string4.indexOf("."));
                                    }
                                }
                                if ((string5 = this._$1(hSSFCell)) == null || string5.trim().length() <= 0 || string5.equalsIgnoreCase("General") || string5.equalsIgnoreCase("text") || string5.equalsIgnoreCase("@")) break;
                                int n5 = (string5 = string5.trim()).indexOf("_");
                                if (n5 > 0) {
                                    string5 = string5.substring(0, n5);
                                }
                                iNormalCell.setFormat(string5);
                                break;
                            }
                            case 2: {
                                if (this._$8) {
                                    string4 = "";
                                    IByteMap iByteMap = iNormalCell.getExpMap(true);
                                    iByteMap.put((byte)40, hSSFCell.getCellFormula());
                                    break;
                                }
                                string4 = null;
                                try {
                                    string4 = decimalFormat.format(hSSFCell.getNumericCellValue());
                                }
                                catch (Exception exception) {}
                                String string6 = this._$1(hSSFCell);
                                if (string6 == null || string6.trim().length() <= 0 || string6.equalsIgnoreCase("General") || string6.equalsIgnoreCase("text") || string6.equalsIgnoreCase("@")) break;
                                n4 = (string6 = string6.trim()).indexOf("_");
                                if (n4 > 0) {
                                    string6 = string6.substring(0, n4);
                                }
                                iNormalCell.setFormat(string6);
                                break;
                            }
                        }
                        if (string4 != null && string4.trim().length() > 0) {
                            iNormalCell.setValue(string4);
                        }
                        if (bl) {
                            iNormalCell.setCellType((byte)-56);
                        }
                        hSSFRichTextString = hSSFCell.getCellStyle();
                        int n6 = -48;
                        short s2 = hSSFRichTextString.getAlignment();
                        if (s2 == 2) {
                            n6 = -47;
                        } else if (s2 == 3) {
                            n6 = -46;
                        } else if (s2 == 0) {
                            try {
                                Double.parseDouble(string4);
                                n6 = -46;
                            }
                            catch (Exception exception) {
                                try {
                                    if (HSSFDateUtil.isCellDateFormatted((HSSFCell)hSSFCell)) {
                                        n6 = -46;
                                    }
                                }
                                catch (Exception exception2) {}
                            }
                        }
                        iNormalCell.setHAlign((byte)n6);
                        n3 = -31;
                        short s3 = hSSFRichTextString.getVerticalAlignment();
                        n4 = s3;
                        if (s3 == 0) {
                            n3 = -32;
                        } else if (n4 == 2) {
                            n3 = -30;
                        }
                        iNormalCell.setVAlign((byte)n3);
                        if (hSSFRichTextString.getWrapText()) {
                            iNormalCell.setTextWrap(true);
                        }
                        if ((string3 = (String)hashMap.get(string2 = (hSSFFont = this._$6[hSSFRichTextString.getFontIndex()]).getFontName())) == null) {
                            if (new Font(string2, 0, 12).canDisplay('\u6c49')) {
                                hashMap.put(string2, "1");
                            } else {
                                hashMap.put(string2, "0");
                                string2 = "Dialog";
                            }
                        } else if ("0".equals(string3)) {
                            string2 = "Dialog";
                        }
                        iNormalCell.setFontName(string2);
                        short s4 = hSSFFont.getFontHeightInPoints();
                        iNormalCell.setFontSize(s4);
                        iNormalCell.setForeColor(ExcelColor.getColorInReport(hSSFFont.getColor(), Color.black));
                        if (hSSFFont.getBoldweight() == 700) {
                            iNormalCell.setBold(true);
                        }
                        iNormalCell.setItalic(hSSFFont.getItalic());
                        if (hSSFFont.getUnderline() != 0) {
                            iNormalCell.setUnderline(true);
                        }
                        this._$1(hSSFRichTextString.getBorderTop(), hSSFRichTextString.getTopBorderColor(), n2, s, 1);
                        this._$1(hSSFRichTextString.getBorderBottom(), hSSFRichTextString.getBottomBorderColor(), n2, s, 2);
                        this._$1(hSSFRichTextString.getBorderLeft(), hSSFRichTextString.getLeftBorderColor(), n2, s, 3);
                        this._$1(hSSFRichTextString.getBorderRight(), hSSFRichTextString.getRightBorderColor(), n2, s, 4);
                        iNormalCell.setBackColor(ExcelColor.getBackColor(this._$4, (HSSFCellStyle)hSSFRichTextString, Color.WHITE));
                        HSSFHyperlink hSSFHyperlink = hSSFCell.getHyperlink();
                        if (hSSFHyperlink != null && (string = hSSFHyperlink.getAddress()) != null && string.trim().length() > 0) {
                            iNormalCell.setHyperlink(string);
                        }
                    }
                    s = (short)(s + 1);
                }
            }
            ++n2;
        }
        this._$1();
        printSetup = this._$2.getPrintSetup();
        HSSFPrintSetup hSSFPrintSetup = this._$5.getPrintSetup();
        try {
            short s = hSSFPrintSetup.getPaperSize();
            printSetup.setPaper(s);
            n = hSSFPrintSetup.getLandscape();
            if (n != 0) {
                printSetup.setOrientation((byte)0);
            } else {
                printSetup.setOrientation((byte)1);
            }
        }
        catch (Exception exception) {}
        printSetup.setLeftMargin((float)(this._$5.getMargin((short)0) * 25.4));
        printSetup.setRightMargin((float)(this._$5.getMargin((short)1) * 25.4));
        printSetup.setTopMargin((float)(this._$5.getMargin((short)2) * 25.4));
        printSetup.setBottomMargin((float)(this._$5.getMargin((short)3) * 25.4));
        return this._$2;
    }

    public static String transferString(HSSFCell hSSFCell, boolean bl, HSSFFont[] hSSFFontArray) {
        String string;
        if (hSSFCell == null) {
            return null;
        }
        HSSFRichTextString hSSFRichTextString = hSSFCell.getRichStringCellValue();
        String string2 = hSSFCell.getStringCellValue();
        if (!bl || hSSFRichTextString == null || hSSFRichTextString.numFormattingRuns() < 1) {
            return string2;
        }
        HSSFFont hSSFFont = hSSFFontArray[hSSFCell.getCellStyle().getFontIndex()];
        int n = hSSFRichTextString.numFormattingRuns();
        short s = hSSFRichTextString.getFontOfFormattingRun(0);
        int n2 = hSSFRichTextString.getIndexOfFormattingRun(0);
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 > 0) {
            stringBuffer.append(string2.substring(0, n2));
        }
        int n3 = 1;
        while (n3 < n) {
            int n4 = hSSFRichTextString.getIndexOfFormattingRun(n3);
            string = hSSFFontArray[s];
            String string3 = string2.substring(n2, n4);
            SheetTransfer._$1((HSSFFont)string, stringBuffer, hSSFFont, string3);
            s = hSSFRichTextString.getFontOfFormattingRun(n3);
            n2 = n4;
            ++n3;
        }
        HSSFFont hSSFFont2 = hSSFFontArray[s];
        string = string2.substring(n2);
        SheetTransfer._$1(hSSFFont2, stringBuffer, hSSFFont, string);
        return stringBuffer.toString();
    }
}

