/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.base;

import com.runqian.report4.control.ScanControl;
import com.runqian.report4.ide.base.CSSItem;
import com.runqian.report4.model.ReportDefine2;
import com.runqian.report4.usermodel.INormalCell;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class CSSRender
extends ScanControl
implements ListCellRenderer {
    INormalCell nc;

    public CSSRender() {
        this.setPreferredSize(new Dimension(100, 35));
        this.nc = CSSRender.initControl(this, 25, 10);
    }

    public static void drawItem(CSSItem item, INormalCell nc, ScanControl sc) {
        if (item == null) {
            return;
        }
        nc.setValue(item.name);
        item.style.applyToCell(nc);
        sc.repaint();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            CSSItem item = (CSSItem)value;
            int fore = item.style.getForeColor();
            int back = item.style.getBackColor();
            item.style.setForeColor(list.getSelectionForeground().getRGB());
            item.style.setBackColor(list.getSelectionBackground().getRGB());
            CSSRender.drawItem(item, this.nc, this);
            item.style.setForeColor(fore);
            item.style.setBackColor(back);
        } else {
            CSSRender.drawItem((CSSItem)value, this.nc, this);
        }
        return this;
    }

    public static INormalCell initControl(ScanControl sc, int w, int h) {
        ReportDefine2 report = new ReportDefine2(1, 1);
        sc.setReport(report);
        report.getRowCell(1).setRowHeight(h);
        report.getColCell((short)1).setColWidth(w);
        sc.setEditable(false);
        return report.getCell(1, (short)1);
    }
}

