/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.base;

import com.runqian.base4.tool.ConfigFile;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.XMLFile;
import com.runqian.report4.ide.base.DataSource;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;

public class DataSourceListModel
extends DefaultListModel {
    public void addRemoteDataSource(DataSource dataSource) {
        if (this.existDSName(dataSource.getName())) {
            System.out.println("Notice: Remote datasource[ " + dataSource.getName() + " ] replaced the same name local or system one.");
            this.removeElement(this.getDataSource(dataSource.getName()));
        }
        dataSource.setFromType((byte)2);
        this.addElement(dataSource);
    }

    public boolean existDSName(String string) {
        return this.getDataSource(string) != null;
    }

    public DataSource getDataSource(String string) {
        if (!GM.isValidString(string)) {
            return null;
        }
        Enumeration enumeration = this.elements();
        DataSource dataSource = null;
        while (enumeration.hasMoreElements()) {
            dataSource = (DataSource)enumeration.nextElement();
            String string2 = dataSource.getName();
            if (!string.equalsIgnoreCase(string2)) continue;
            return dataSource;
        }
        return null;
    }

    public Vector listNames() {
        Enumeration enumeration = this.elements();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            DataSource dataSource = (DataSource)enumeration.nextElement();
            vector.add(dataSource.getName());
        }
        return vector;
    }

    public void save() throws Throwable {
        Enumeration enumeration = this.elements();
        XMLFile xMLFile = ConfigFile.getConfigFile().xmlFile();
        xMLFile.deleteElement("REPORT/DATASOURCE");
        xMLFile.newElement("REPORT", "DATASOURCE");
        int n = 0;
        while (enumeration.hasMoreElements()) {
            DataSource dataSource = (DataSource)enumeration.nextElement();
            if (dataSource.isSystem() || dataSource.isRemote()) continue;
            String string = "DS" + ++n;
            xMLFile.newElement("REPORT/DATASOURCE", string);
            xMLFile.setAttribute("REPORT/DATASOURCE/" + string + "/name", dataSource.getName());
            xMLFile.setAttribute("REPORT/DATASOURCE/" + string + "/config", dataSource.toString());
        }
        xMLFile.save();
    }
}

