/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.dialog;

import com.runqian.base4.swing.JComboBoxEx;
import com.runqian.base4.tool.ConfigFile;
import com.runqian.base4.tool.GCWindow;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.tool.Section;
import com.runqian.report4.ide.GVIde;
import com.runqian.report4.ide.base.CustomConfig;
import com.runqian.report4.ide.base.Maps;
import com.runqian.report4.ide.dialog.DialogBarCode_btEdit_actionAdapter;
import com.runqian.report4.ide.dialog.DialogBarCode_comboCustomClass_actionAdapter;
import com.runqian.report4.ide.dialog.DialogBarCode_jBCancel_actionAdapter;
import com.runqian.report4.ide.dialog.DialogBarCode_jBOK_actionAdapter;
import com.runqian.report4.ide.dialog.DialogBarCode_jCBImageFormat_actionAdapter;
import com.runqian.report4.ide.dialog.DialogBarCode_jCBType_actionAdapter;
import com.runqian.report4.ide.dialog.DialogBarCode_jSPAngle_changeAdapter;
import com.runqian.report4.ide.dialog.DialogBarCode_this_windowAdapter;
import com.runqian.report4.ide.dialog.IDialogCustom;
import com.runqian.report4.usermodel.BarcodeProperty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;

public class DialogBarCode
extends JDialog {
    int ALLOW_PRINTING = 2048;
    private BorderLayout borderLayout1;
    private JButton btEdit;
    private JComboBoxEx comboCustomClass;
    private JPanel customBarcodePanel;
    FlowLayout flowLayout1;
    GridBagLayout gridBagLayout1;
    private JButton jBCancel;
    private JButton jBOK;
    private JComboBoxEx jCBBaselinePosition;
    private JComboBoxEx jCBChecksumMode;
    private JComboBoxEx jCBCode128CodeSet;
    private JCheckBox jCBDisplayChecksum;
    private JCheckBox jCBDisplayStartStop;
    private JComboBoxEx jCBFontName;
    private JComboBoxEx jCBFontSize;
    private JComboBoxEx jCBImageFormat;
    private JComboBoxEx jCBMsgPosition;
    private JComboBoxEx jCBType;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLayeredPane jP1;
    private JPanel jPanel1;
    JPanel jPanel2;
    JPanel jPanel3;
    private JSpinner jSPAngle;
    private JSpinner jSPHeight;
    private JSpinner jSPIntercharGapWidth;
    private JSpinner jSPModuleWidth;
    private JSpinner jSPQuietZone;
    private JSpinner jSPShortbarHeight;
    private JSpinner jSPWideFactor;
    private JTextField jTFValue;
    private JLabel labelCustom1;
    private JLabel labelCustom2;
    int m_option = 2;
    private JPanel panel1 = new JPanel();
    private JTextField tfCustomParam;

    public DialogBarCode() {
        super(GV.appFrame, "\u6761\u5f62\u7801\u5c5e\u6027 [\u6570\u503c\u5355\u4f4d\uff1a\u6beb\u7c73(MM)]", true);
        this.borderLayout1 = new BorderLayout();
        this.jPanel1 = new JPanel();
        this.jBOK = new JButton();
        this.jBCancel = new JButton();
        this.jP1 = new JLayeredPane();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jCBDisplayChecksum = new JCheckBox();
        this.jCBDisplayStartStop = new JCheckBox();
        this.jCBType = new JComboBoxEx();
        this.jSPHeight = new JSpinner(new SpinnerNumberModel(1.0, 0.0, Double.MAX_VALUE, 1.0));
        this.jLabel4 = new JLabel();
        this.jSPModuleWidth = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 1000.0, 0.2f));
        this.jLabel5 = new JLabel();
        this.jSPAngle = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 45));
        this.jLabel6 = new JLabel();
        this.jCBFontName = new JComboBoxEx();
        this.jLabel7 = new JLabel();
        this.jCBFontSize = GM.getFontSizes();
        this.jLabel8 = new JLabel();
        this.jCBMsgPosition = new JComboBoxEx();
        this.jLabel9 = new JLabel();
        this.jSPQuietZone = new JSpinner(new SpinnerNumberModel(1.0, 0.0, Double.MAX_VALUE, 1.0));
        this.jLabel10 = new JLabel();
        this.jCBChecksumMode = new JComboBoxEx();
        this.jLabel11 = new JLabel();
        this.jSPIntercharGapWidth = new JSpinner(new SpinnerNumberModel(1.0, 0.0, Double.MAX_VALUE, 0.1));
        this.jLabel12 = new JLabel();
        this.jSPWideFactor = new JSpinner(new SpinnerNumberModel(1.0, 1.0, Double.MAX_VALUE, 0.25));
        this.jLabel13 = new JLabel();
        this.jSPShortbarHeight = new JSpinner(new SpinnerNumberModel(1.0, 0.0, Double.MAX_VALUE, 1.0));
        this.jLabel14 = new JLabel();
        this.jCBBaselinePosition = new JComboBoxEx();
        this.jCBCode128CodeSet = new JComboBoxEx();
        this.jLabel3 = new JLabel();
        this.jTFValue = new JTextField();
        this.jLabel15 = new JLabel();
        this.jCBImageFormat = new JComboBoxEx();
        this.jPanel2 = new JPanel();
        this.gridBagLayout1 = new GridBagLayout();
        this.jPanel3 = new JPanel();
        this.flowLayout1 = new FlowLayout();
        this.labelCustom1 = new JLabel(Lang.getText("grapheditdialog.type"));
        this.labelCustom2 = new JLabel(Lang.getText("grapheditdialog.param"));
        Lang.setCurrentType((byte)8);
        try {
            this.setDefaultCloseOperation(2);
            this.jbInit();
            this.init();
            this.resetLangText();
            this.setSize(550, 450);
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Exception e) {
            GM.showException(e);
        }
    }

    void btEdit_actionPerformed(ActionEvent e) {
        if (!GM.isValidString(this.comboCustomClass.getSelectedItem())) {
            return;
        }
        String name = (String)this.comboCustomClass.getSelectedItem();
        String param = this.tfCustomParam.getText();
        try {
            String dialogName = this.getCustomBarcodeDialog(name);
            if (dialogName == null) {
                return;
            }
            if (Class.forName(dialogName).newInstance() instanceof JDialog) {
                IDialogCustom dialog = (IDialogCustom)Class.forName(dialogName).newInstance();
                dialog.setParam(param);
                ((JDialog)((Object)dialog)).show();
                if (dialog.getOption() == 0) {
                    this.tfCustomParam.setText(dialog.getParam());
                }
            }
        }
        catch (Throwable ex) {
            GM.showException(ex);
        }
    }

    void comboCustomClass_actionPerformed(ActionEvent e) {
        if (GM.isValidString(this.comboCustomClass.getSelectedItem())) {
            String desc = (String)this.comboCustomClass.getSelectedItem();
            try {
                ArrayList configList = this.totalCustomBarcodeConfigList();
                int i = 0;
                while (i < configList.size()) {
                    CustomConfig cc = (CustomConfig)configList.get(i);
                    if (cc.getName().equals(desc)) {
                        String dialogName = cc.getDialogName();
                        this.btEdit.setEnabled(GM.isValidString(dialogName));
                    }
                    ++i;
                }
            }
            catch (Throwable ex) {
            }
        }
    }

    private boolean existCBConfigInLocal(ArrayList local, String name) {
        int i = 0;
        while (i < local.size()) {
            CustomConfig cc = (CustomConfig)local.get(i);
            if (cc.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public BarcodeProperty get() {
        BarcodeProperty bp = new BarcodeProperty();
        bp.setType(((Number)this.jCBType.x_getSelectedItem()).byteValue());
        bp.setValue(this.jTFValue.getText());
        bp.setHeight(((Number)this.jSPHeight.getValue()).floatValue());
        bp.setModuleWidth(((Number)this.jSPModuleWidth.getValue()).doubleValue());
        bp.setAngle(((Number)this.jSPAngle.getValue()).intValue());
        bp.setFontName(this.jCBFontName.x_getSelectedItem().toString());
        bp.setFontSize(((Number)this.jCBFontSize.x_getSelectedItem()).intValue());
        bp.setTextPosition(((Number)this.jCBMsgPosition.x_getSelectedItem()).byteValue());
        bp.setQuietZone(((Number)this.jSPQuietZone.getValue()).floatValue());
        bp.setImageFormat(((Number)this.jCBImageFormat.x_getSelectedItem()).byteValue());
        if (this.jCBChecksumMode.isEnabled()) {
            bp.setCheckSumMode(((Number)this.jCBChecksumMode.x_getSelectedItem()).byteValue());
        }
        if (this.jSPIntercharGapWidth.isEnabled()) {
            bp.setCharGapWidth(((Number)this.jSPIntercharGapWidth.getValue()).floatValue());
        }
        if (this.jSPWideFactor.isEnabled()) {
            bp.setWideFactor(((Number)this.jSPWideFactor.getValue()).floatValue());
        }
        if (this.jCBDisplayStartStop.isEnabled()) {
            bp.setDisplayStartStop(this.jCBDisplayStartStop.isSelected());
        }
        if (this.jCBDisplayChecksum.isEnabled()) {
            bp.setDisplayCheckSum(this.jCBDisplayChecksum.isSelected());
        }
        if (this.jSPShortbarHeight.isEnabled()) {
            bp.setShortBarHeight(((Number)this.jSPShortbarHeight.getValue()).floatValue());
        }
        if (this.jCBBaselinePosition.isEnabled()) {
            bp.setBaseLinePosition(((Number)this.jCBBaselinePosition.x_getSelectedItem()).byteValue());
        }
        if (this.jCBCode128CodeSet.isEnabled()) {
            bp.setCode128CodeSet(((Number)this.jCBCode128CodeSet.x_getSelectedItem()).byteValue());
        }
        if (this.comboCustomClass.isEnabled()) {
            bp.setCustomClassName((String)this.comboCustomClass.x_getSelectedItem());
        }
        if (this.tfCustomParam.isEnabled()) {
            bp.setCustomParam(this.tfCustomParam.getText());
        }
        return bp;
    }

    private Vector[] getCustomBarcodeConfigVectors() throws Exception, Throwable {
        Vector[] v = new Vector[2];
        Vector<String> code = new Vector<String>();
        Vector<String> disp = new Vector<String>();
        ArrayList total = this.totalCustomBarcodeConfigList();
        if (total != null) {
            int i = 0;
            while (i < total.size()) {
                CustomConfig cc = (CustomConfig)total.get(i);
                code.add(cc.getClassName());
                disp.add(cc.getName());
                ++i;
            }
        }
        v[0] = code;
        v[1] = disp;
        return v;
    }

    private String getCustomBarcodeDialog(String name) throws Throwable {
        ArrayList total = this.totalCustomBarcodeConfigList();
        int i = 0;
        while (i < total.size()) {
            CustomConfig cc = (CustomConfig)total.get(i);
            if (cc.getName().equals(name)) {
                return cc.getDialogName();
            }
            ++i;
        }
        return null;
    }

    public int getOption() {
        return this.m_option;
    }

    public void init() {
        this.jCBType.x_setData(Maps.barTypeCode(), Maps.barTypeDisp());
        String cstr = "Helvetica,OCR-B,Helvetica,Arial";
        Section code = new Section(cstr);
        Section disp = new Section(cstr);
        this.jCBFontName.x_setData(code.toVector(), disp.toVector());
        this.jCBMsgPosition.x_setData(Maps.barTextPosCode(), Maps.barTextPosDisp());
        this.jCBChecksumMode.x_setData(Maps.barCheckSumCode(), Maps.barCheckSumDisp());
        this.jCBBaselinePosition.x_setData(Maps.barBaselineCode(), Maps.barBaselineDisp());
        this.jCBCode128CodeSet.x_setData(Maps.bar128CodeSetCode(), Maps.bar128CodeSetDisp());
        this.jCBImageFormat.x_setData(Maps.imageFormatCode(), Maps.imageFormatDisp());
        this.jCBType.x_setSelectedCodeItem(new Byte(2));
        this.jCBType_actionPerformed(null);
        this.jSPHeight.setValue(new Float(15.0));
        this.jSPModuleWidth.setValue(new Integer(1));
        this.jCBFontName.x_setSelectedCodeItem("Helvetica");
        this.jCBFontSize.x_setSelectedCodeItem(new Short(12));
        this.jCBMsgPosition.x_setSelectedCodeItem(new Byte(1));
        this.jSPQuietZone.setValue(new Float(2.0f));
        this.jCBChecksumMode.x_setSelectedCodeItem(new Byte(1));
        this.jSPIntercharGapWidth.setValue(new Float(0.19));
        this.jSPWideFactor.setValue(new Float(1.0f));
        this.jCBDisplayStartStop.setSelected(false);
        this.jCBDisplayChecksum.setSelected(false);
        this.jSPShortbarHeight.setValue(new Float(1.25f));
        this.jCBBaselinePosition.x_setSelectedCodeItem(new Byte(1));
        this.jCBCode128CodeSet.x_setSelectedCodeItem(new Byte(0));
    }

    public void jBCancel_actionPerformed(ActionEvent actionEvent) {
        GM.setWindowDimension(this);
        this.m_option = 2;
        this.dispose();
    }

    public void jBOK_actionPerformed(ActionEvent actionEvent) {
        String s = this.jTFValue.getText();
        if (!GM.isValidString(s)) {
            JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("DialogBarCode.inputexp"));
            return;
        }
        GM.setWindowDimension(this);
        this.m_option = 0;
        this.dispose();
    }

    void jCBImageFormat_actionPerformed(ActionEvent e) {
        byte format = (Byte)this.jCBImageFormat.x_getSelectedItem();
        if (format == 1) {
            this.jSPAngle.setValue(new Integer(0));
        }
    }

    public void jCBType_actionPerformed(ActionEvent actionEvent) {
        Byte curType = (Byte)this.jCBType.x_getSelectedItem();
        if (curType == null) {
            return;
        }
        this.setAll(false);
        switch (curType) {
            case 1: {
                this.jCBChecksumMode.setEnabled(true);
                this.jSPWideFactor.setEnabled(true);
                break;
            }
            case 2: {
                this.jSPWideFactor.setEnabled(true);
                this.jCBDisplayChecksum.setEnabled(true);
                break;
            }
            case 3: {
                this.jLabel14.setText(Lang.getText("DialogBarCode.codes"));
                this.jCBCode128CodeSet.setEnabled(true);
                this.jCBCode128CodeSet.setVisible(true);
                this.jCBBaselinePosition.setVisible(false);
                this.jSPWideFactor.setEnabled(true);
                break;
            }
            case 4: {
                this.jCBDisplayChecksum.setEnabled(true);
                this.jCBChecksumMode.setEnabled(true);
                this.jSPWideFactor.setEnabled(true);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.jCBChecksumMode.setEnabled(true);
                break;
            }
            case 11: {
                this.jCBChecksumMode.setEnabled(true);
                this.jSPIntercharGapWidth.setEnabled(true);
                this.jCBDisplayChecksum.setEnabled(true);
                this.jSPShortbarHeight.setEnabled(true);
                this.jLabel14.setText(Lang.getText("DialogBarCode.basicpoint"));
                this.jCBBaselinePosition.setEnabled(true);
                this.jCBBaselinePosition.setVisible(true);
                this.jCBCode128CodeSet.setVisible(false);
                break;
            }
            case -1: {
                this.setAll(true);
            }
        }
    }

    void jSPAngle_stateChanged(ChangeEvent e) {
        byte format;
        Object v = this.jSPAngle.getValue();
        if (Double.parseDouble(v.toString()) > 0.0 && (format = ((Byte)this.jCBImageFormat.x_getSelectedItem()).byteValue()) == 1) {
            this.jCBImageFormat.x_setSelectedCodeItem(new Byte(3));
        }
    }

    private void jbInit() throws Exception {
        this.customBarcodePanel = new JPanel(new GridBagLayout());
        this.comboCustomClass = new JComboBoxEx();
        this.tfCustomParam = new JTextField();
        this.btEdit = new JButton(Lang.getText("grapheditdialog.edit"));
        this.panel1.setLayout(this.borderLayout1);
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.setText(Lang.get(GCWindow.B_OK));
        this.jBOK.addActionListener(new DialogBarCode_jBOK_actionAdapter(this));
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.setText(Lang.get(GCWindow.B_CANCEL));
        this.jBCancel.addActionListener(new DialogBarCode_jBCancel_actionAdapter(this));
        this.jP1.setLayout(this.gridBagLayout1);
        this.jLabel1.setText("\u7c7b\u578b");
        this.jLabel1.setText(Lang.get(GCWindow.L_Type));
        this.jLabel2.setText("\u9ad8\u5ea6");
        this.jLabel2.setText(Lang.get(GCWindow.L_Height));
        this.jCBDisplayChecksum.setText("\u663e\u793a\u68c0\u67e5\u7801");
        this.jCBDisplayChecksum.setText(Lang.get(GCWindow.CB_DisplayChecksum));
        this.jCBDisplayStartStop.setText("\u663e\u793a\u8d77\u505c\u533a");
        this.jCBDisplayStartStop.setText(Lang.get(GCWindow.CB_DisplayStartStop));
        this.jLabel4.setText("\u6a21\u5757\u5bbd\u5ea6");
        this.jLabel4.setText(Lang.get(GCWindow.L_ModuleWidth));
        this.jLabel5.setText("\u65cb\u8f6c\u89d2\u5ea6");
        this.jLabel5.setText(Lang.get(GCWindow.L_RotateAngle));
        this.jLabel6.setText("\u5b57\u4f53");
        this.jLabel6.setText(Lang.get(GCWindow.L_FontName));
        this.jLabel7.setText("\u5b57\u5927\u5c0f");
        this.jLabel7.setText(Lang.get(GCWindow.L_FontSize));
        this.jLabel8.setText("\u5b57\u7b26");
        this.jLabel8.setText(Lang.get(GCWindow.L_Charset));
        this.jLabel9.setText("\u9759\u533a");
        this.jLabel9.setText(Lang.get(GCWindow.L_QuietZone));
        this.jLabel10.setText("\u68c0\u5bdf\u7801\u6a21\u5f0f");
        this.jLabel10.setText(Lang.get(GCWindow.L_CheckSumMode));
        this.jLabel11.setText("\u5b57\u7b26\u95f4\u9699");
        this.jLabel11.setText(Lang.get(GCWindow.L_InterCharGap));
        this.jLabel12.setText("\u5bbd\u5ea6\u7cfb\u6570");
        this.jLabel12.setText(Lang.get(GCWindow.L_WideFactor));
        this.jLabel13.setText("\u77ed\u6761\u9ad8\u5ea6");
        this.jLabel13.setText(Lang.get(GCWindow.L_ShortBarHeight));
        this.jLabel14.setText("\u57fa\u7ebf\u4f4d\u7f6e");
        this.jLabel14.setText(Lang.get(GCWindow.L_BaseLinePosition));
        this.jCBFontName.setEditable(true);
        this.jCBType.addActionListener(new DialogBarCode_jCBType_actionAdapter(this));
        this.jLabel3.setText("\u6570\u503c");
        this.jLabel3.setText(Lang.get(GCWindow.L_Value));
        this.jCBFontSize.setEditable(true);
        this.jLabel15.setText("\u56fe\u7247\u683c\u5f0f");
        this.jLabel15.setText(Lang.get(GCWindow.L_ImageFormat));
        this.jCBImageFormat.addActionListener(new DialogBarCode_jCBImageFormat_actionAdapter(this));
        this.jSPAngle.addChangeListener(new DialogBarCode_jSPAngle_changeAdapter(this));
        this.jCBImageFormat.setToolTipText(Lang.get(GCWindow.TP_JPGCantRotate));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new DialogBarCode_this_windowAdapter(this));
        this.jPanel2.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanel1, "South");
        this.jPanel1.add(this.jBOK);
        this.jPanel1.add(this.jBCancel);
        this.panel1.add((Component)this.jP1, "Center");
        this.jP1.add((Component)this.jLabel1, GM.getGBC(1, 1));
        this.jP1.add((Component)this.jCBType, GM.getGBC(1, 2, true));
        this.jP1.add((Component)this.jLabel6, GM.getGBC(1, 3));
        this.jP1.add((Component)this.jCBFontName, GM.getGBC(1, 4, true));
        this.jP1.add((Component)this.jLabel2, GM.getGBC(2, 1));
        this.jP1.add((Component)this.jSPHeight, GM.getGBC(2, 2, true));
        this.jP1.add((Component)this.jLabel7, GM.getGBC(2, 3));
        this.jP1.add((Component)this.jCBFontSize, GM.getGBC(2, 4, true));
        this.jP1.add((Component)this.jLabel5, GM.getGBC(3, 1));
        this.jP1.add((Component)this.jSPAngle, GM.getGBC(3, 2, true));
        this.jP1.add((Component)this.jLabel4, GM.getGBC(3, 3));
        this.jP1.add((Component)this.jSPModuleWidth, GM.getGBC(3, 4, true));
        this.jP1.add((Component)this.jLabel8, GM.getGBC(4, 1));
        this.jP1.add((Component)this.jCBMsgPosition, GM.getGBC(4, 2, true));
        this.jP1.add((Component)this.jLabel9, GM.getGBC(4, 3));
        this.jP1.add((Component)this.jSPQuietZone, GM.getGBC(4, 4, true));
        this.jP1.add((Component)this.jLabel10, GM.getGBC(5, 1));
        this.jP1.add((Component)this.jCBChecksumMode, GM.getGBC(5, 2, true));
        GridBagConstraints gbc1 = GM.getGBC(5, 3, true);
        gbc1.gridwidth = 2;
        this.jP1.add((Component)this.jPanel2, gbc1);
        this.jPanel2.add((Component)this.jCBDisplayChecksum, null);
        this.jPanel2.add((Component)this.jCBDisplayStartStop, null);
        this.jP1.add((Component)this.jLabel12, GM.getGBC(6, 1));
        this.jP1.add((Component)this.jSPWideFactor, GM.getGBC(6, 2, true));
        this.jP1.add((Component)this.jLabel11, GM.getGBC(6, 3));
        this.jP1.add((Component)this.jSPIntercharGapWidth, GM.getGBC(6, 4, true));
        this.jP1.add((Component)this.jLabel13, GM.getGBC(7, 1));
        this.jP1.add((Component)this.jSPShortbarHeight, GM.getGBC(7, 2, true));
        this.jP1.add((Component)this.jLabel14, GM.getGBC(7, 3));
        this.jP1.add((Component)this.jCBBaselinePosition, GM.getGBC(7, 4, true));
        this.jP1.add((Component)this.jCBCode128CodeSet, GM.getGBC(7, 4, true));
        this.jP1.add((Component)this.jLabel3, GM.getGBC(8, 1));
        this.jP1.add((Component)this.jTFValue, GM.getGBC(8, 2, true));
        this.jP1.add((Component)this.jLabel15, GM.getGBC(8, 3));
        this.jP1.add((Component)this.jCBImageFormat, GM.getGBC(8, 4, true));
        this.customBarcodePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Lang.getText("dialogbarcode.custombarcode"), 0, 0));
        this.customBarcodePanel.add((Component)this.labelCustom1, GM.getGBC(1, 1));
        this.customBarcodePanel.add((Component)this.comboCustomClass, GM.getGBC(1, 2, true));
        this.customBarcodePanel.add((Component)this.labelCustom2, GM.getGBC(2, 1));
        this.customBarcodePanel.add((Component)this.tfCustomParam, GM.getGBC(2, 2, true));
        this.customBarcodePanel.add((Component)this.btEdit, GM.getGBC(2, 3));
        GridBagConstraints gbc2 = GM.getGBC(9, 1, true);
        gbc2.gridwidth = 4;
        this.jP1.add((Component)this.customBarcodePanel, gbc2);
        this.jP1.add((Component)this.jPanel3, GM.getGBC(10, 1, false, true));
        this.comboCustomClass.addActionListener(new DialogBarCode_comboCustomClass_actionAdapter(this));
        this.btEdit.addActionListener(new DialogBarCode_btEdit_actionAdapter(this));
        this.refreshComboCustomClass();
    }

    public static void main(String[] args) {
        new DialogBarCode().show();
    }

    private void refreshComboCustomClass() {
        try {
            Vector[] v = this.getCustomBarcodeConfigVectors();
            this.comboCustomClass.x_setData(v[0], v[1]);
            if (this.comboCustomClass.data.getSize() > 0) {
                this.comboCustomClass.setSelectedIndex(0);
            }
        }
        catch (Throwable e) {
            GM.showException(e);
        }
    }

    private void resetLangText() {
        this.setTitle(Lang.getText("DialogBarCode.Title"));
        this.jBOK.setText(Lang.getText("button.ok"));
        this.jBCancel.setText(Lang.getText("button.cancel"));
        this.jLabel1.setText(Lang.getText("DialogBarCode.type"));
        this.jLabel2.setText(Lang.getText("DialogBarCode.height"));
        this.jCBDisplayChecksum.setText(Lang.getText("DialogBarCode.checksum"));
        this.jCBDisplayStartStop.setText(Lang.getText("DialogBarCode.startstop"));
        this.jLabel4.setText(Lang.getText("DialogBarCode.width"));
        this.jLabel5.setText(Lang.getText("DialogBarCode.roundangle"));
        this.jLabel6.setText(Lang.getText("DialogBarCode.font"));
        this.jLabel7.setText(Lang.getText("DialogBarCode.size"));
        this.jLabel8.setText(Lang.getText("DialogBarCode.code"));
        this.jLabel9.setText(Lang.getText("DialogBarCode.static"));
        this.jLabel10.setText(Lang.getText("DialogBarCode.model"));
        this.jLabel11.setText(Lang.getText("DialogBarCode.codespace"));
        this.jLabel12.setText(Lang.getText("DialogBarCode.widthpara"));
        this.jLabel13.setText(Lang.getText("DialogBarCode.shortheight"));
        this.jLabel14.setText(Lang.getText("DialogBarCode.basicpoint"));
        this.jLabel3.setText(Lang.getText("DialogBarCode.value"));
        this.jLabel15.setText(Lang.getText("DialogBarCode.pictype"));
    }

    public void set(BarcodeProperty bar) {
        if (bar == null) {
            return;
        }
        this.jCBType.x_setSelectedCodeItem(new Byte(bar.getType()));
        this.jCBType_actionPerformed(null);
        this.jTFValue.setText(bar.getValue().toString());
        this.jSPHeight.setValue(new Float(bar.getHeight()));
        this.jSPModuleWidth.setValue(new Double(bar.getModuleWidth()));
        this.jSPAngle.setValue(new Integer(bar.getAngle()));
        this.jCBFontName.x_setSelectedCodeItem(bar.getFontName());
        this.jCBFontSize.x_setSelectedCodeItem(new Short((short)bar.getFontSize()));
        this.jCBMsgPosition.x_setSelectedCodeItem(new Byte(bar.getTextPosition()));
        this.jSPQuietZone.setValue(new Float(bar.getQuietZone()));
        this.jCBChecksumMode.x_setSelectedCodeItem(new Byte(bar.getCheckSumMode()));
        this.jSPIntercharGapWidth.setValue(new Float(bar.getCharGapWidth()));
        this.jSPWideFactor.setValue(new Float(bar.getWideFactor()));
        this.jCBDisplayStartStop.setSelected(bar.isDisplayStartStop());
        this.jCBDisplayChecksum.setSelected(bar.isDisplayCheckSum());
        this.jSPShortbarHeight.setValue(new Float(bar.getShortBarHeight()));
        this.jCBBaselinePosition.x_setSelectedCodeItem(new Byte(bar.getBaseLinePosition()));
        this.jCBCode128CodeSet.x_setSelectedCodeItem(new Byte(bar.getCode128CodeSet()));
        this.jCBImageFormat.x_setSelectedCodeItem(new Byte(bar.getImageFormat()));
        this.comboCustomClass.setSelectedItem(bar.getCustomClassName());
        this.tfCustomParam.setText(bar.getCustomParam());
    }

    private void setAll(boolean b) {
        this.jCBChecksumMode.setEnabled(b);
        this.jSPIntercharGapWidth.setEnabled(b);
        this.jSPWideFactor.setEnabled(b);
        this.jCBDisplayStartStop.setEnabled(b);
        this.jCBDisplayChecksum.setEnabled(b);
        this.jSPShortbarHeight.setEnabled(b);
        this.jCBBaselinePosition.setEnabled(b);
        this.jCBCode128CodeSet.setEnabled(b);
        this.jSPQuietZone.setEnabled(b);
        this.customBarcodePanel.setEnabled(b);
        this.comboCustomClass.setEnabled(b);
        this.tfCustomParam.setEnabled(b);
        this.btEdit.setEnabled(b);
        this.labelCustom1.setEnabled(b);
        this.labelCustom2.setEnabled(b);
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    private ArrayList totalCustomBarcodeConfigList() throws Exception, Throwable {
        ArrayList system;
        ArrayList<CustomConfig> local = GVIde.listCustomBarcode(ConfigFile.getConfigFile());
        if (local == null) {
            local = new ArrayList<CustomConfig>();
        }
        if ((system = GVIde.listCustomBarcode(ConfigFile.getSystemConfigFile())) != null) {
            int i = 0;
            while (i < system.size()) {
                CustomConfig cc = (CustomConfig)system.get(i);
                if (!this.existCBConfigInLocal(local, cc.getName())) {
                    local.add(cc);
                }
                ++i;
            }
        }
        return local;
    }
}

