/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.dialog;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.runqian.base4.swing.JTableEx;
import com.runqian.base4.tool.DialogInputText;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.report4.ide.dialog.DialogMatrixDataSet_jBCancel_actionAdapter;
import com.runqian.report4.ide.dialog.DialogMatrixDataSet_jBFile_actionAdapter;
import com.runqian.report4.ide.dialog.DialogMatrixDataSet_jBOK_actionAdapter;
import com.runqian.report4.ide.dialog.DialogMatrixDataSet_textWhere_keyAdapter;
import com.runqian.report4.ide.dialog.DialogMatrixDataSet_textWhere_mouseAdapter;
import com.runqian.report4.ide.dialog.DialogMatrixDataSet_this_windowAdapter;
import com.runqian.report4.ide.usermodel.IDataSetEditor;
import com.runqian.report4.usermodel.DataSetConfig;
import com.runqian.report4.usermodel.MatrixDataSetConfig;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class DialogMatrixDataSet
extends JDialog
implements IDataSetEditor {
    private final byte COL_EXP = 1;
    private final byte COL_INDEX = 0;
    GridBagLayout gridBagLayout1;
    JButton jBCancel;
    JButton jBFile;
    JButton jBOK;
    JLabel jLabel1;
    JLabel jLabel2;
    JLabel jLabel3;
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JScrollPane jScrollPane1;
    private int m_option = 2;
    private JTableEx tableParam;
    JTextField textFile;
    JTextField textWhere;
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();

    public DialogMatrixDataSet() {
        super(GV.appFrame, "\u77e9\u9635\u6570\u636e\u96c6", true);
        this.jBOK = new JButton();
        this.jBCancel = new JButton();
        this.gridBagLayout1 = new GridBagLayout();
        this.jLabel1 = new JLabel();
        this.textFile = new JTextField();
        this.jBFile = new JButton();
        this.jLabel2 = new JLabel();
        this.textWhere = new JTextField();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableParam = new JTableEx(Lang.getText("dialogmatrixdataset.tableparam"));
        try {
            this.jbInit();
            this.init();
            this.setSize(400, 250);
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
            this.resetLangText();
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    private void close() {
        GM.setWindowDimension(this);
        this.dispose();
    }

    public DataSetConfig getDataSetConfig() {
        MatrixDataSetConfig dsc = new MatrixDataSetConfig();
        dsc.setMatrixFile(this.textFile.getText());
        dsc.setQueryStatement(this.textWhere.getText());
        dsc.setParams(this.getParams());
        return dsc;
    }

    public int getOption() {
        return this.m_option;
    }

    private String[] getParams() {
        this.tableParam.acceptText();
        int count = this.tableParam.getRowCount();
        String[] params = null;
        if (count > 0) {
            params = new String[count];
            int i = 0;
            while (i < count) {
                if (GM.isValidString(this.tableParam.data.getValueAt(i, 1))) {
                    params[i] = (String)this.tableParam.data.getValueAt(i, 1);
                }
                ++i;
            }
        }
        return params;
    }

    private void init() {
        this.tableParam.setIndexCol(0);
        this.tableParam.setRowHeight(22);
        this.tableParam.getTableHeader().setReorderingAllowed(false);
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        this.close();
    }

    void jBFile_actionPerformed(ActionEvent e) {
        File file = GM.dialogSelectFile("mtxg");
        if (file == null) {
            return;
        }
        this.textFile.setText(file.getAbsolutePath());
    }

    void jBOK_actionPerformed(ActionEvent e) {
        this.m_option = 0;
        this.close();
    }

    private void jbInit() throws Exception {
        this.jPanel2.setLayout((LayoutManager)this.verticalFlowLayout1);
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogMatrixDataSet_jBOK_actionAdapter(this));
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new DialogMatrixDataSet_jBCancel_actionAdapter(this));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new DialogMatrixDataSet_this_windowAdapter(this));
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jLabel1.setText("\u77e9\u9635\u6587\u4ef6\u540d");
        this.jBFile.setText("...");
        this.jBFile.addActionListener(new DialogMatrixDataSet_jBFile_actionAdapter(this));
        this.jLabel2.setText("\u67e5\u8be2\u8bed\u53e5\u4e32");
        this.jLabel3.setText("\u53c2\u6570");
        this.textWhere.addKeyListener(new DialogMatrixDataSet_textWhere_keyAdapter(this));
        this.textWhere.addMouseListener(new DialogMatrixDataSet_textWhere_mouseAdapter(this));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jLabel1, GM.getGBC(1, 1));
        this.jPanel1.add((Component)this.textFile, GM.getGBC(1, 2, true));
        this.jPanel1.add((Component)this.jBFile, GM.getGBC(1, 3));
        this.jPanel1.add((Component)this.jLabel2, GM.getGBC(2, 1));
        GridBagConstraints gbc = GM.getGBC(2, 2, true);
        gbc.gridwidth = 2;
        this.jPanel1.add((Component)this.textWhere, gbc);
        this.jPanel1.add((Component)this.jLabel3, GM.getGBC(3, 1));
        gbc = GM.getGBC(4, 1, true, true);
        gbc.gridwidth = 3;
        this.jPanel1.add((Component)this.jScrollPane1, gbc);
        this.jScrollPane1.getViewport().add((Component)this.tableParam, null);
        this.getContentPane().add((Component)this.jPanel2, "East");
        this.jPanel2.add((Component)this.jBOK, null);
        this.jPanel2.add((Component)this.jBCancel, null);
    }

    private void resetLangText() {
        this.setTitle(Lang.getText("dialogmatrixdataset.title"));
        this.jBOK.setText(Lang.getText("button.ok"));
        this.jBCancel.setText(Lang.getText("button.cancel"));
        this.jLabel1.setText(Lang.getText("dialogmatrixdataset.label1"));
        this.jLabel2.setText(Lang.getText("dialogmatrixdataset.label2"));
        this.jLabel3.setText(Lang.getText("dialogmatrixdataset.label3"));
    }

    private void resetTableParam(String[] params) {
        this.tableParam.acceptText();
        this.tableParam.removeAllRows();
        if (params == null) {
            return;
        }
        int i = 0;
        while (i < params.length) {
            this.tableParam.addRow();
            this.tableParam.data.setValueAt(params[i], i, 1);
            ++i;
        }
    }

    public void setDataSetConfig(DataSetConfig dataSetConfig) {
        if (dataSetConfig == null) {
            return;
        }
        MatrixDataSetConfig dsc = (MatrixDataSetConfig)dataSetConfig;
        this.textFile.setText(dsc.getMatrixFile());
        this.textWhere.setText(dsc.getQueryStatement());
        this.resetTableParam(dsc.getParams());
    }

    void textWhere_keyReleased(KeyEvent e) {
        this.whereChanged();
    }

    void textWhere_mouseClicked(MouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        DialogInputText dit = new DialogInputText();
        dit.setText(this.textWhere.getText());
        dit.show();
        if (dit.getOption() == 0) {
            this.textWhere.setText(dit.getText());
            this.whereChanged();
        }
    }

    void this_windowClosing(WindowEvent e) {
        this.close();
    }

    private void whereChanged() {
        int size;
        String where = this.textWhere.getText();
        if (!GM.isValidString(where)) {
            this.resetTableParam(null);
            return;
        }
        String[] params = null;
        where = " " + where + " ";
        String[] split = where.split("\\?");
        if (split != null && (size = split.length - 1) > 0) {
            params = new String[size];
            String[] src = this.getParams();
            if (src != null && src.length > 0) {
                int length = Math.min(src.length, size);
                System.arraycopy(src, 0, params, 0, length);
            }
        }
        this.resetTableParam(params);
    }
}

