/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.dialog;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.runqian.base4.swing.JComboBoxEx;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.util.PwdUtils;
import com.runqian.report4.ide.base.DBTypeEx;
import com.runqian.report4.ide.base.DataSource;
import com.runqian.report4.ide.dialog.DialogDataSource;
import com.runqian.report4.ide.dialog.DialogODBCDataSource_jBCancel_actionAdapter;
import com.runqian.report4.ide.dialog.DialogODBCDataSource_jBOK_actionAdapter;
import com.runqian.report4.ide.dialog.DialogODBCDataSource_this_windowAdapter;
import com.runqian.report4.util.ODBCUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DialogODBCDataSource
extends JDialog {
    final String ODBC_CHARSET = "GBK";
    final String ODBC_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
    final String ODBC_URL = "jdbc:odbc:";
    GridBagLayout gridBagLayout1;
    GridBagLayout gridBagLayout2;
    JButton jBCancel;
    JButton jBOK;
    JCheckBox jCBIsAddTilde;
    JCheckBox jCaseSentence;
    JComboBoxEx jDBType;
    JTextField jDSName;
    JLabel jLabel1;
    JLabel jLabel2;
    JLabel jLabel3;
    JLabel jLabel4;
    JLabel jLabel5;
    JComboBoxEx jODBCName;
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3;
    JPanel jPanel5;
    JPasswordField jPassword;
    JCheckBox jUseSchema;
    JTextField jUser;
    private int m_option = 2;
    private String oldDSName;
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();

    public DialogODBCDataSource() {
        super(GV.appFrame, "ODBC\u6570\u636e\u6e90", true);
        this.jBCancel = new JButton();
        this.jBOK = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jDSName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jDBType = new JComboBoxEx();
        this.jLabel3 = new JLabel();
        this.jODBCName = new JComboBoxEx();
        this.jLabel4 = new JLabel();
        this.jUser = new JTextField();
        this.jLabel5 = new JLabel();
        this.jPassword = new JPasswordField();
        this.jUseSchema = new JCheckBox();
        this.jCaseSentence = new JCheckBox();
        this.jCBIsAddTilde = new JCheckBox();
        this.gridBagLayout1 = new GridBagLayout();
        this.gridBagLayout2 = new GridBagLayout();
        this.jPanel5 = new JPanel();
        try {
            this.setSize(400, 300);
            this.jbInit();
            this.init();
            this.resetLangText();
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    public DataSource get() {
        DataSource ds = new DataSource();
        ds.setDSType((byte)1);
        ds.setName(this.jDSName.getText());
        ds.setDBType(this.jDBType.getSelectedIndex());
        ds.setDBCharset("GBK");
        ds.setClientCharset("GBK");
        ds.setDriver("sun.jdbc.odbc.JdbcOdbcDriver");
        ds.setUrl("jdbc:odbc:" + (String)this.jODBCName.getSelectedItem());
        ds.setUser(this.jUser.getText());
        String pwd = new String(this.jPassword.getPassword());
        ds.setPassword(PwdUtils.encrypt(pwd));
        ds.setUseSchema(this.jUseSchema.isSelected());
        ds.setCaseSentence(this.jCaseSentence.isSelected());
        ds.setIsAddTilde(this.jCBIsAddTilde.isSelected());
        return ds;
    }

    public int getOption() {
        return this.m_option;
    }

    private void init() {
        int height = 28;
        this.jDSName.setPreferredSize(new Dimension(0, height));
        this.jDBType.setPreferredSize(new Dimension(0, height));
        this.jODBCName.setPreferredSize(new Dimension(0, height));
        this.jUser.setPreferredSize(new Dimension(0, height));
        this.jPassword.setPreferredSize(new Dimension(0, height));
        this.jUseSchema.setPreferredSize(new Dimension(0, height));
        this.jCaseSentence.setPreferredSize(new Dimension(0, height));
        this.jODBCName.setEditable(true);
        int i = 0;
        while (i < DBTypeEx.getTotalType()) {
            this.jDBType.addItem(DBTypeEx.getDBName(i));
            ++i;
        }
        ArrayList dsList = ODBCUtil.getDataSourcesName(3);
        this.jODBCName.setListData(dsList.toArray());
    }

    public boolean isNameChanged() {
        return !this.jDSName.getText().equalsIgnoreCase(this.oldDSName);
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBOK_actionPerformed(ActionEvent e) {
        try {
            if (!GM.isValidString(this.jDSName.getText())) {
                throw new Exception(Lang.getText("dialogdatasourcepara.emptydsname"));
            }
            if (!GM.isValidString(this.jODBCName.getSelectedItem())) {
                throw new Exception(Lang.getText("dialogdatasourcepara.emptyodbc"));
            }
            if (this.isNameChanged() && DialogDataSource.isExistDataSource(this.get())) {
                return;
            }
            GM.setWindowDimension(this);
            this.m_option = 0;
            this.dispose();
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new DialogODBCDataSource_this_windowAdapter(this));
        this.jPanel2.setLayout((LayoutManager)this.verticalFlowLayout1);
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new DialogODBCDataSource_jBCancel_actionAdapter(this));
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogODBCDataSource_jBOK_actionAdapter(this));
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jLabel1.setText("\u6570\u636e\u6e90\u540d\u79f0");
        this.jLabel2.setText("\u6570\u636e\u5e93\u7c7b\u578b");
        this.jLabel3.setText("ODBC\u540d\u79f0");
        this.jLabel4.setText("\u7528\u6237\u540d");
        this.jLabel5.setText("\u5bc6\u7801");
        this.jUseSchema.setText("\u4f7f\u7528\u5e26\u6a21\u5f0f\u7684\u8868\u540d\u79f0");
        this.jCaseSentence.setText("\u5927\u5c0f\u5199\u654f\u611f");
        this.jCBIsAddTilde.setText("\u4f7f\u7528\u5e26\u5f15\u53f7\u7684SQL");
        this.jPanel3.setLayout(this.gridBagLayout2);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.getContentPane().add((Component)this.jPanel2, "East");
        this.jPanel2.add((Component)this.jBOK, null);
        this.jPanel2.add((Component)this.jBCancel, null);
        this.jPanel1.add((Component)this.jPanel3, GM.getGBC(1, 1, true));
        this.jPanel1.add((Component)this.jPanel5, GM.getGBC(3, 1, true, true));
        this.jPanel3.add((Component)this.jLabel1, GM.getGBC(1, 1));
        this.jPanel3.add((Component)this.jDSName, GM.getGBC(1, 2, true));
        this.jPanel3.add((Component)this.jLabel2, GM.getGBC(2, 1));
        this.jPanel3.add((Component)this.jDBType, GM.getGBC(2, 2, true));
        this.jPanel3.add((Component)this.jLabel3, GM.getGBC(3, 1));
        this.jPanel3.add((Component)this.jODBCName, GM.getGBC(3, 2, true));
        this.jPanel3.add((Component)this.jLabel4, GM.getGBC(4, 1));
        this.jPanel3.add((Component)this.jUser, GM.getGBC(4, 2, true));
        this.jPanel3.add((Component)this.jLabel5, GM.getGBC(5, 1));
        this.jPanel3.add((Component)this.jPassword, GM.getGBC(5, 2, true));
        GridBagConstraints gbc = GM.getGBC(6, 1, true);
        gbc.gridwidth = 2;
        this.jPanel3.add((Component)this.jUseSchema, gbc);
        gbc = GM.getGBC(7, 1, true);
        gbc.gridwidth = 2;
        this.jPanel3.add((Component)this.jCaseSentence, gbc);
        gbc = GM.getGBC(8, 1, true);
        gbc.gridwidth = 2;
        this.jPanel3.add((Component)this.jCBIsAddTilde, gbc);
    }

    private void resetLangText() {
        this.setTitle(Lang.getText("dialogodbcdatasource.title"));
        this.jBCancel.setText(Lang.getText("button.cancel"));
        this.jBOK.setText(Lang.getText("button.ok"));
        this.jLabel1.setText(Lang.getText("dialogodbcdatasource.dsname"));
        this.jLabel2.setText(Lang.getText("dialogodbcdatasource.dstype"));
        this.jLabel3.setText(Lang.getText("dialogodbcdatasource.odbcname"));
        this.jLabel4.setText(Lang.getText("dialogodbcdatasource.user"));
        this.jLabel5.setText(Lang.getText("dialogodbcdatasource.password"));
        this.jUseSchema.setText(Lang.getText("dialogodbcdatasource.useschema"));
        this.jCaseSentence.setText(Lang.getText("dialogodbcdatasource.casesentence"));
        this.jCBIsAddTilde.setText(Lang.getText("dialogdatasourcepara.isaddtilde"));
    }

    public void set(DataSource ds) {
        this.oldDSName = ds.getName();
        this.jDSName.setText(ds.getName());
        String dbType = DBTypeEx.getDBName(ds.getDBType());
        this.jDBType.setSelectedItem(dbType);
        String url = ds.getUrl();
        if (url.startsWith("jdbc:odbc:")) {
            url = url.substring("jdbc:odbc:".length());
        }
        this.jODBCName.setSelectedItem(url);
        this.jUser.setText(ds.getUser());
        String pwd = ds.getPassword();
        try {
            this.jPassword.setText(PwdUtils.decrypt(pwd));
        }
        catch (Exception x) {
            // empty catch block
        }
        this.jUseSchema.setSelected(ds.isUseSchema());
        this.jCaseSentence.setSelected(ds.isCaseSentence());
        this.jCBIsAddTilde.setSelected(ds.isAddTilde());
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }
}

