/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.dialog;

import com.runqian.base4.tool.GC;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.tool.Section;
import com.runqian.base4.tool.XMLFile;
import com.runqian.base4.util.Logger;
import com.runqian.report4.ide.base.ConfigOptions;
import com.runqian.report4.ide.dialog.DialogTipsOfDay_jBClose_actionAdapter;
import com.runqian.report4.ide.dialog.DialogTipsOfDay_jBNext_actionAdapter;
import com.runqian.report4.ide.dialog.DialogTipsOfDay_jBPrevious_actionAdapter;
import com.runqian.report4.ide.dialog.DialogTipsOfDay_jTextPane1_mouseAdapter;
import com.runqian.report4.ide.dialog.DialogTipsOfDay_this_windowAdapter;
import com.runqian.report4.ide.dialog.TipOfDay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogTipsOfDay
extends JDialog {
    BorderLayout borderLayout1;
    TipOfDay currentTip = null;
    int currentTipIndex = 0;
    FlowLayout flowLayout1;
    public JButton jBClose;
    public JButton jBNext;
    public JButton jBPrevious;
    JCheckBox jCBAutoShowTip;
    JLabel jLabel1;
    JPanel jPanel1;
    JPanel jPanel2;
    JScrollPane jScrollPane1;
    public JEditorPane jTextPane1;
    protected int m_option = -1;
    JPanel panel1 = new JPanel();
    Vector tipsOfDay;

    public DialogTipsOfDay() {
        this(GV.appFrame);
    }

    public DialogTipsOfDay(Frame frame, String title) {
        super(frame, title, false);
        this.borderLayout1 = new BorderLayout();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jBClose = new JButton();
        this.jBPrevious = new JButton();
        this.jBNext = new JButton();
        this.jTextPane1 = new JEditorPane();
        this.flowLayout1 = new FlowLayout();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jCBAutoShowTip = new JCheckBox();
        this.tipsOfDay = new Vector();
        try {
            this.jbInit();
            this.setSize(400, 300);
            this.resetLangText();
            this.load();
            ++this.currentTipIndex;
            this.showTip();
            GM.setDialogDefaultButton(this, this.jBClose, this.jBPrevious);
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    public DialogTipsOfDay(Frame frame) {
        this(frame, "Tip of day");
    }

    private void close() {
        ConfigOptions.bAutoShowTip = new Boolean(this.jCBAutoShowTip.isSelected());
        ConfigOptions.iAutoShowTip = new Integer(this.currentTipIndex);
        try {
            ConfigOptions.save();
        }
        catch (Throwable ex) {
            // empty catch block
        }
        this.dispose();
    }

    public int getOption() {
        return this.m_option;
    }

    private static String getRelativeFile() {
        String relativeFile;
        switch (GC.LANGUAGE) {
            case 0: {
                relativeFile = GC.PATH_CONFIG + "/tipsofday.xml";
                break;
            }
            case 1: {
                relativeFile = GC.PATH_CONFIG + "/tipsofday_tw.xml";
                break;
            }
            default: {
                relativeFile = GC.PATH_CONFIG + "/tipsofday_en.xml";
            }
        }
        return relativeFile;
    }

    private static XMLFile getXmlFile(boolean showException) {
        String file = DialogTipsOfDay.getRelativeFile();
        String filePath = GV.getAbsolutePath(file);
        try {
            File f = new File(filePath);
            if (f.exists()) {
                return new XMLFile(filePath);
            }
            throw new Exception();
        }
        catch (Throwable x) {
            if (showException) {
                x.printStackTrace();
            }
            return null;
        }
    }

    public static boolean isTipFileExists() {
        return DialogTipsOfDay.getXmlFile(false) != null;
    }

    void jBClose_actionPerformed(ActionEvent e) {
        this.close();
    }

    void jBNext_actionPerformed(ActionEvent e) {
        this.currentTipIndex = this.currentTipIndex == this.tipsOfDay.size() - 1 ? 0 : ++this.currentTipIndex;
        this.showTip();
    }

    void jBPrevious_actionPerformed(ActionEvent e) {
        this.currentTipIndex = this.currentTipIndex == 0 ? this.tipsOfDay.size() - 1 : --this.currentTipIndex;
        this.showTip();
    }

    void jTextPane1_mouseClicked(MouseEvent e) {
        int b = e.getButton();
        if (b != 1) {
            return;
        }
        if (GM.getOperationSytem() == 0 && this.currentTip != null && GM.isValidString(this.currentTip.url)) {
            try {
                if (this.currentTip.url.toLowerCase().startsWith("http:")) {
                    Runtime.getRuntime().exec("cmd /C start " + this.currentTip.url);
                } else {
                    String path = GV.getAbsolutePath(this.currentTip.url);
                    Runtime.getRuntime().exec("cmd /C \"" + path + "\"");
                    Logger.info("Tip URL: " + path);
                }
            }
            catch (Exception x) {
                GM.showException(x);
            }
        }
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.jBClose.setMnemonic('C');
        this.jBClose.setText("\u5173\u95ed(C)");
        this.jBClose.addActionListener(new DialogTipsOfDay_jBClose_actionAdapter(this));
        this.jPanel1.setLayout(this.flowLayout1);
        this.jBPrevious.setMnemonic('P');
        this.jBPrevious.setText("\u4e0a\u4e00\u6761(P)");
        this.jBPrevious.addActionListener(new DialogTipsOfDay_jBPrevious_actionAdapter(this));
        this.jBNext.setMnemonic('N');
        this.jBNext.setText("\u4e0b\u4e00\u6761(N)");
        this.jBNext.addActionListener(new DialogTipsOfDay_jBNext_actionAdapter(this));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("\u4f60\u77e5\u9053\u5417?");
        this.jCBAutoShowTip.setText("\u542f\u52a8\u65f6\u81ea\u52a8\u6253\u5f00\u8be5\u7a97\u53e3");
        this.flowLayout1.setAlignment(2);
        this.jTextPane1.setForeground(Color.blue);
        this.jTextPane1.setEditable(false);
        this.jTextPane1.addMouseListener(new DialogTipsOfDay_jTextPane1_mouseAdapter(this));
        this.addWindowListener(new DialogTipsOfDay_this_windowAdapter(this));
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.jBPrevious, null);
        this.jPanel1.add((Component)this.jBNext, null);
        this.jPanel1.add((Component)this.jBClose, null);
        this.panel1.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jLabel1, GM.getGBC(1, 1, true));
        this.jPanel2.add((Component)this.jScrollPane1, GM.getGBC(2, 1, true, true));
        this.jPanel2.add((Component)this.jCBAutoShowTip, GM.getGBC(3, 1, true));
        this.jScrollPane1.getViewport().add((Component)this.jTextPane1, null);
    }

    private void load() {
        this.tipsOfDay.removeAllElements();
        XMLFile tipFile = DialogTipsOfDay.getXmlFile(true);
        if (tipFile == null) {
            this.jBPrevious.setEnabled(false);
            this.jBNext.setEnabled(false);
        } else {
            try {
                String path = "TIPS";
                Section tips = tipFile.listElement(path);
                int i = 0;
                while (i < tips.size()) {
                    String desc = tipFile.getAttribute(path + "/" + tips.get(i) + "/desc");
                    String url = tipFile.getAttribute(path + "/" + tips.get(i) + "/url");
                    this.tipsOfDay.add(new TipOfDay(desc, url));
                    ++i;
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        this.jCBAutoShowTip.setSelected(ConfigOptions.bAutoShowTip);
        this.currentTipIndex = ConfigOptions.iAutoShowTip;
    }

    private void resetLangText() {
        this.setTitle(Lang.getText("DialogTipsOfDay.title"));
        this.jBClose.setText(Lang.getText("button.close"));
        this.jBPrevious.setText(Lang.getText("DialogTipsOfDay.previous"));
        this.jBNext.setText(Lang.getText("DialogTipsOfDay.next"));
        this.jLabel1.setText(Lang.getText("DialogTipsOfDay.doyouknow"));
        this.jCBAutoShowTip.setText(Lang.getText("DialogTipsOfDay.autostart"));
    }

    private void showTip() {
        this.jTextPane1.setCursor(Cursor.getDefaultCursor());
        if (this.tipsOfDay.size() == 0) {
            return;
        }
        if (this.currentTipIndex >= this.tipsOfDay.size()) {
            this.currentTipIndex = 0;
        }
        this.currentTip = (TipOfDay)this.tipsOfDay.get(this.currentTipIndex);
        this.jTextPane1.setText(this.currentTip.desc);
        if (GM.isValidString(this.currentTip.url)) {
            this.jTextPane1.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    void this_windowClosing(WindowEvent e) {
        this.close();
    }
}

