/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.dialog;

import com.runqian.report4.usermodel.input.RadioBox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;

class RadioBoxEditor
extends DefaultCellEditor {
    JPanel basePanel = new JPanel(new FlowLayout(0));
    HashMap map = new HashMap();

    public RadioBoxEditor(RadioBox rb) {
        super(new JTextField());
        RadioBoxEditor.fillPanel(rb, this.basePanel, this.map);
        this.setClickCountToStart(1);
    }

    public static void fillPanel(RadioBox rb, JPanel panel, HashMap map) {
        ArrayList codes = rb.getCodeList();
        ArrayList disps = rb.getDispList();
        ButtonGroup bg = new ButtonGroup();
        int i = 0;
        while (i < codes.size()) {
            String code = (String)codes.get(i);
            String disp = (String)disps.get(i);
            JRadioButton rbutton = new JRadioButton(disp);
            panel.add(rbutton);
            bg.add(rbutton);
            map.put(code, rbutton);
            ++i;
        }
    }

    public Object getCellEditorValue() {
        Iterator codes = this.map.keySet().iterator();
        while (codes.hasNext()) {
            String code = (String)codes.next();
            JRadioButton rb = (JRadioButton)this.map.get(code);
            if (!rb.isSelected()) continue;
            return code;
        }
        return null;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Iterator codes = this.map.keySet().iterator();
        while (codes.hasNext()) {
            String code = (String)codes.next();
            if (!code.equals(value)) continue;
            JRadioButton rb = (JRadioButton)this.map.get(code);
            rb.setSelected(true);
            break;
        }
        return this.basePanel;
    }
}

