/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.wizard;

import com.runqian.base4.swing.JListEx;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.Lang;
import com.runqian.report4.dataset.ColInfoBase;
import com.runqian.report4.dataset.DataSet;
import com.runqian.report4.ide.wizard.WizardColInfo;
import com.runqian.report4.ide.wizard.WizardConfig;
import com.runqian.report4.usermodel.DataSetConfig;
import com.runqian.report4.usermodel.DataSetMetaData;
import com.runqian.report4.usermodel.IReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PanelSelectDataSet
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2;
    JLabel jLabel1;
    JPanel jPanel3;
    JScrollPane jScrollPane1;
    JListEx listDataSet = new JListEx();
    private IReport report;
    private WizardConfig wc;

    public PanelSelectDataSet(WizardConfig wc, IReport report) {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.borderLayout2 = new BorderLayout();
        this.jLabel1 = new JLabel();
        try {
            this.wc = wc;
            this.report = report;
            this.jbInit();
            this.init();
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    private String getDataSetNames() {
        String dataSetNames = "";
        DataSetMetaData dsmd = this.report.getDataSetMetaData();
        if (dsmd == null) {
            return null;
        }
        int count = dsmd.getDataSetConfigCount();
        int i = 0;
        while (i < count) {
            DataSetConfig dsc = this.report.getDataSetMetaData().getDataSetConfig(i);
            String dataSetName = dsc.getName();
            dataSetNames = i == count - 1 ? dataSetNames + dataSetName : dataSetNames + dataSetName + ",";
            ++i;
        }
        return dataSetNames;
    }

    private void init() {
        this.listDataSet.setSelectionMode(0);
        String dataSetNames = this.getDataSetNames();
        if (GM.isValidString(dataSetNames)) {
            this.listDataSet.setListData(dataSetNames);
            this.listDataSet.setSelectedIndex(0);
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel3.setLayout(this.borderLayout2);
        this.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.add((Component)this.jLabel1, "North");
        this.jScrollPane1.getViewport().add((Component)this.listDataSet, null);
    }

    public boolean selectDataSetNext(Map dataSetMap) {
        String select = this.listDataSet.getSelectedItems();
        if (!GM.isValidString(select)) {
            JOptionPane.showMessageDialog(this, Lang.getText("dialogselectdataset.selectdsmsg"), Lang.getText("public.error"), 2);
            return false;
        }
        DataSetConfig dsc = null;
        String dsName = (String)this.listDataSet.getSelectedValues()[0];
        DataSetMetaData dsmd = this.report.getDataSetMetaData();
        int i = 0;
        while (i < dsmd.getDataSetConfigCount()) {
            DataSetConfig temp = dsmd.getDataSetConfig(i);
            if ((',' + temp.getName() + ',').indexOf(',' + dsName + ',') >= 0) {
                dsc = temp;
                break;
            }
            ++i;
        }
        DataSetConfig dscNew = (DataSetConfig)dsc.deepClone();
        dscNew.setName(dsName);
        this.wc.setDataSetConfig(dscNew);
        DataSet ds = (DataSet)dataSetMap.get(dsName);
        if (ds == null || ds.getColCount() == 0) {
            JOptionPane.showMessageDialog(null, Lang.getText("wizard.dsnull"));
            return false;
        }
        Vector<WizardColInfo> colInfoList = new Vector<WizardColInfo>();
        int i2 = 0;
        while (i2 < ds.getColCount()) {
            WizardColInfo wci = new WizardColInfo();
            ColInfoBase ci = ds.getColInfo(i2);
            if (GM.isValidString(ci.getColTitle())) {
                wci.setName(ci.getColTitle());
            } else {
                wci.setName(ci.getColName());
            }
            wci.setType(ci.getDataType());
            colInfoList.add(wci);
            ++i2;
        }
        if (colInfoList == null || colInfoList.size() == 0) {
            JOptionPane.showMessageDialog(null, Lang.getText("wizard.dsnull"));
            return false;
        }
        this.wc.setColInfoList(colInfoList);
        return true;
    }

    public void setDefaultSelectName(String defDsName) {
        if (GM.isValidString(defDsName)) {
            this.listDataSet.setSelectedValue(defDsName, true);
        }
    }
}

