/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.model.engine;

import com.runqian.base4.util.ReportError;
import com.runqian.report4.model.engine.ExtCell;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.model.engine.InputExpression;
import com.runqian.report4.model.expression.Expression;
import com.runqian.report4.usermodel.ByteMap;
import com.runqian.report4.usermodel.IByteMap;
import com.runqian.report4.usermodel.INormalCell;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class NormalCellEngine
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 7415358161299951956L;
    protected ExtCellSet cs;
    protected INormalCell srcPrepare;
    protected ExtCell srcCurrent;
    protected IByteMap propEngMap;
    protected Object expression;
    protected Object[] addExpression;
    protected InputExpression propInput;
    protected int sourceRow;
    protected short sourceCol;
    protected boolean isDSFunction;
    protected boolean isAddDsFun;
    protected byte extensible;
    protected byte state;
    protected IByteMap customPropEngMap;
    protected Object cellGraphExpression;

    protected void clearEngineInfo() {
        this.cs = null;
    }

    public Object clone() {
        try {
            NormalCellEngine normalCellEngine = (NormalCellEngine)super.clone();
            if (this.propEngMap != null) {
                normalCellEngine.propEngMap = new ByteMap();
                normalCellEngine.propEngMap.addAll(this.propEngMap);
            }
            if (this.customPropEngMap != null) {
                normalCellEngine.customPropEngMap = new ByteMap();
                normalCellEngine.customPropEngMap.addAll(this.customPropEngMap);
            }
            return normalCellEngine;
        }
        catch (Exception exception) {
            throw new ReportError(exception.getMessage(), exception);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        short s;
        byte by = objectInput.readByte();
        this.cs = (ExtCellSet)objectInput.readObject();
        this.srcPrepare = (INormalCell)objectInput.readObject();
        this.srcCurrent = (ExtCell)objectInput.readObject();
        short s2 = objectInput.readShort();
        if (s2 > 0) {
            this.propEngMap = new ByteMap(s2);
            s = 0;
            while (s < s2) {
                this.propEngMap.add(objectInput.readByte(), objectInput.readObject());
                s = (short)(s + 1);
            }
        }
        this.expression = objectInput.readObject();
        this.sourceRow = objectInput.readInt();
        this.sourceCol = objectInput.readShort();
        this.extensible = objectInput.readByte();
        this.state = objectInput.readByte();
        if (by > 1 && (s2 = objectInput.readShort()) > 0) {
            this.customPropEngMap = new ByteMap(s2);
            s = 0;
            while (s < s2) {
                this.customPropEngMap.add(objectInput.readByte(), objectInput.readObject());
                s = (short)(s + 1);
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Object object;
        short s;
        short s2;
        objectOutput.writeByte(3);
        objectOutput.writeObject(this.cs);
        objectOutput.writeObject(this.srcPrepare);
        objectOutput.writeObject(this.srcCurrent);
        if (this.propEngMap != null) {
            s2 = this.propEngMap.size();
            objectOutput.writeShort(s2);
            s = 0;
            while (s < s2) {
                objectOutput.writeByte(this.propEngMap.getKey(s));
                object = this.propEngMap.getValue(s);
                if (object instanceof Expression) {
                    objectOutput.writeObject(((Expression)object).toString());
                } else {
                    objectOutput.writeObject(object);
                }
                s = (short)(s + 1);
            }
        } else {
            objectOutput.writeShort(0);
        }
        if (this.expression instanceof Expression) {
            if (this.state == 8) {
                objectOutput.writeObject(((Expression)this.expression).toString());
            } else {
                objectOutput.writeObject(null);
            }
        } else {
            objectOutput.writeObject(this.expression);
        }
        objectOutput.writeInt(this.sourceRow);
        objectOutput.writeShort(this.sourceCol);
        objectOutput.writeByte(this.extensible);
        objectOutput.writeByte(this.state);
        if (this.customPropEngMap != null) {
            s2 = this.customPropEngMap.size();
            objectOutput.writeShort(s2);
            s = 0;
            while (s < s2) {
                objectOutput.writeByte(this.customPropEngMap.getKey(s));
                object = this.customPropEngMap.getValue(s);
                if (object instanceof Expression) {
                    objectOutput.writeObject(((Expression)object).toString());
                } else {
                    objectOutput.writeObject(object);
                }
                s = (short)(s + 1);
            }
            return;
        }
        objectOutput.writeShort(0);
    }
}

