/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.model.engine;

import com.runqian.base4.tool.GC;
import com.runqian.base4.util.Logger;
import com.runqian.base4.util.Sentence;
import com.runqian.base4.util.StringUtils;
import com.runqian.report4.control.ControlUtils;
import com.runqian.report4.model.ReportDefine;
import com.runqian.report4.model.engine.ExtCell;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.model.engine.ExtNormalCell;
import com.runqian.report4.model.engine.SVGConvert;
import com.runqian.report4.usermodel.Area;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.IColCell;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.IRowCell;
import com.runqian.report4.usermodel.graph.ImageValue;
import com.runqian.report4.util.ReportParser;
import com.runqian.report4.util.RichTextElement;
import com.runqian.report4.util.RichTextUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;

class Perfected {
    Perfected() {
    }

    private static void adjustCellSize(IReport r, INormalCell cell, float toWidth, float toHeight, byte unit) {
        int i;
        int i2;
        float w = Perfected.getMergedWidth(r, cell, false, 1.0f, unit);
        float h = Perfected.getMergedHeight(r, cell, false, 1.0f, unit);
        Area ar = cell.getMergedArea();
        int startCol = ar.getBeginCol();
        short endCol = ar.getEndCol();
        int startRow = ar.getBeginRow();
        int endRow = ar.getEndRow();
        if (toWidth > w) {
            if (cell.isMerged()) {
                int colspan = endCol - startCol + 1;
                i2 = startCol;
                while (i2 <= endCol) {
                    IColCell cc = r.getColCell((short)i2);
                    if (!cc.getColVisible()) {
                        --colspan;
                    }
                    ++i2;
                }
                int dw = (int)Math.ceil((double)(toWidth - w) * 1.0 / (double)colspan);
                i = startCol;
                while (i <= endCol) {
                    IColCell cc = r.getColCell((short)i);
                    if (cc.getColVisible()) {
                        cc.setColWidth(Perfected.unUnitTransfer(dw + (int)Math.ceil(Perfected.unitTransfer(cc.getColWidth(), unit) * 1.0f), unit));
                    }
                    ++i;
                }
            } else {
                IColCell cc = r.getColCell((short)startCol);
                cc.setColWidth(Perfected.unUnitTransfer(toWidth, unit));
            }
        }
        if (toHeight > h) {
            if (cell.isMerged()) {
                int rowspan = endRow - startRow + 1;
                i2 = startRow;
                while (i2 <= endRow) {
                    IRowCell rc = r.getRowCell(i2);
                    if (!rc.getRowVisible()) {
                        --rowspan;
                    }
                    ++i2;
                }
                int dh = (int)Math.ceil((double)(toHeight - h) * 1.0 / (double)rowspan);
                i = startRow;
                while (i <= endRow) {
                    IRowCell rc = r.getRowCell(i);
                    if (rc.getRowVisible()) {
                        rc.setRowHeight(Perfected.unUnitTransfer(dh + (int)Math.ceil(Perfected.unitTransfer(rc.getRowHeight(), unit) * 1.0f), unit));
                    }
                    ++i;
                }
            } else {
                IRowCell rc = r.getRowCell(startRow);
                rc.setRowHeight(Perfected.unUnitTransfer(toHeight, unit));
            }
        }
    }

    private static void adjustHtmlRowHeight(IReport r, INormalCell cell, String html, byte unit) {
        Area ar = cell.getMergedArea();
        int startRow = ar.getBeginRow();
        int endRow = ar.getEndRow();
        int oldH = (int)Math.floor(Perfected.getMergedHeight(r, cell, false, 1.0f, unit));
        int indent = (int)Perfected.unitTransfer(cell.getIndent() * 1.0f, unit);
        float w = Perfected.getMergedWidth(r, cell, false, 1.0f, unit);
        int totalH = ReportParser.getHTMLCellHeight(html, cell, 1.0f, (int)w, oldH, indent);
        if (totalH == 0) {
            return;
        }
        if (oldH < totalH) {
            if (cell.isMerged()) {
                int rowspan = endRow - startRow + 1;
                int i = startRow;
                while (i <= endRow) {
                    IRowCell rc = r.getRowCell(i);
                    if (!rc.getRowVisible()) {
                        --rowspan;
                    } else {
                        short j = 1;
                        short jCount = r.getColCount();
                        while (j <= jCount) {
                            INormalCell c = r.getCell(i, j);
                            if (c != null && c.getRowHidden()) {
                                --rowspan;
                                break;
                            }
                            j = (short)(j + 1);
                        }
                    }
                    ++i;
                }
                int dh = (int)Math.ceil((double)(totalH - oldH) * 1.0 / (double)rowspan);
                int i2 = startRow;
                while (i2 <= endRow) {
                    IRowCell rc = r.getRowCell(i2);
                    if (rc.getRowVisible()) {
                        boolean visible = true;
                        short j = 1;
                        short jCount = r.getColCount();
                        while (j <= jCount) {
                            INormalCell c = r.getCell(i2, j);
                            if (c != null && c.getRowHidden()) {
                                visible = false;
                                break;
                            }
                            j = (short)(j + 1);
                        }
                        if (visible) {
                            rc.setRowHeight(Perfected.unUnitTransfer(dh + (int)Math.ceil(Perfected.unitTransfer(rc.getRowHeight(), unit) * 1.0f), unit));
                        }
                    }
                    ++i2;
                }
            } else {
                IRowCell rc = r.getRowCell(startRow);
                rc.setRowHeight(Perfected.unUnitTransfer(totalH, unit));
            }
        }
    }

    private static void adjustRichTextRowHeight(IReport r, INormalCell cell, String text, byte unit) {
        int totalH = RichTextUtil.getTotalHeight(r, cell, text);
        if (totalH == 0) {
            return;
        }
        Area ar = cell.getMergedArea();
        int startRow = ar.getBeginRow();
        int endRow = ar.getEndRow();
        int oldH = (int)Math.floor(Perfected.getMergedHeight(r, cell, false, 1.0f, unit));
        if (oldH < totalH) {
            if (cell.isMerged()) {
                int rowspan = endRow - startRow + 1;
                int i = startRow;
                while (i <= endRow) {
                    IRowCell rc = r.getRowCell(i);
                    if (!rc.getRowVisible()) {
                        --rowspan;
                    } else {
                        short j = 1;
                        short jCount = r.getColCount();
                        while (j <= jCount) {
                            INormalCell c = r.getCell(i, j);
                            if (c != null && c.getRowHidden()) {
                                --rowspan;
                                break;
                            }
                            j = (short)(j + 1);
                        }
                    }
                    ++i;
                }
                int dh = (int)Math.ceil((double)(totalH - oldH) * 1.0 / (double)rowspan);
                int i2 = startRow;
                while (i2 <= endRow) {
                    IRowCell rc = r.getRowCell(i2);
                    if (rc.getRowVisible()) {
                        boolean visible = true;
                        short j = 1;
                        short jCount = r.getColCount();
                        while (j <= jCount) {
                            INormalCell c = r.getCell(i2, j);
                            if (c != null && c.getRowHidden()) {
                                visible = false;
                                break;
                            }
                            j = (short)(j + 1);
                        }
                        if (visible) {
                            rc.setRowHeight(Perfected.unUnitTransfer(dh + (int)Math.ceil(Perfected.unitTransfer(rc.getRowHeight(), unit) * 1.0f), unit));
                        }
                    }
                    ++i2;
                }
            } else {
                IRowCell rc = r.getRowCell(startRow);
                rc.setRowHeight(Perfected.unUnitTransfer(totalH, unit));
            }
        }
    }

    private static void adjustRowHeight(IReport r, INormalCell cell, String text, byte unit) {
        int totalH = Perfected.getTotalHeight(r, cell, text, unit);
        if (totalH == 0) {
            return;
        }
        Area ar = cell.getMergedArea();
        int startRow = ar.getBeginRow();
        int endRow = ar.getEndRow();
        int oldH = (int)Math.floor(Perfected.getMergedHeight(r, cell, false, 1.0f, unit));
        if (oldH < totalH) {
            if (cell.isMerged()) {
                int rowspan = endRow - startRow + 1;
                int i = startRow;
                while (i <= endRow) {
                    IRowCell rc = r.getRowCell(i);
                    if (!rc.getRowVisible()) {
                        --rowspan;
                    } else {
                        short j = 1;
                        short jCount = r.getColCount();
                        while (j <= jCount) {
                            INormalCell c = r.getCell(i, j);
                            if (c != null && c.getRowHidden()) {
                                --rowspan;
                                break;
                            }
                            j = (short)(j + 1);
                        }
                    }
                    ++i;
                }
                int dh = (int)Math.ceil((double)(totalH - oldH) * 1.0 / (double)rowspan);
                int i2 = startRow;
                while (i2 <= endRow) {
                    IRowCell rc = r.getRowCell(i2);
                    if (rc.getRowVisible()) {
                        boolean visible = true;
                        short j = 1;
                        short jCount = r.getColCount();
                        while (j <= jCount) {
                            INormalCell c = r.getCell(i2, j);
                            if (c != null && c.getRowHidden()) {
                                visible = false;
                                break;
                            }
                            j = (short)(j + 1);
                        }
                        if (visible) {
                            rc.setRowHeight(Perfected.unUnitTransfer(dh + (int)Math.ceil(Perfected.unitTransfer(rc.getRowHeight(), unit) * 1.0f), unit));
                        }
                    }
                    ++i2;
                }
            } else {
                IRowCell rc = r.getRowCell(startRow);
                rc.setRowHeight(Perfected.unUnitTransfer(totalH, unit));
            }
        }
    }

    private static void flexCell(IReport r, int row, int colTotal, int dataStartCol, int dataEndCol) {
        int align;
        INormalCell cell;
        int j = 0;
        int right = dataStartCol;
        j = colTotal;
        while (j >= dataStartCol) {
            cell = r.getCell(row, (short)j);
            if (cell != null) {
                right = j;
                break;
            }
            --j;
        }
        j = align = right - (colTotal - dataEndCol);
        while (j >= dataStartCol) {
            cell = r.getCell(row, (short)j);
            if (cell != null && cell.isStretchWhenPaged()) {
                align = j;
                break;
            }
            --j;
        }
        if (align > 0) {
            INormalCell cell2;
            int k = 0;
            j = right;
            while (j > align) {
                cell2 = r.getCell(row, (short)j);
                if (cell2 != null && ((ExtCell)((Object)cell2)).getRow() == row && ((ExtCell)((Object)cell2)).getCol() == j) {
                    ((ExtCell)((Object)cell2)).setCol((short)(colTotal - k));
                    r.setCell(row, (short)(colTotal - k), cell2);
                }
                --j;
                ++k;
            }
            cell2 = r.getCell(row, (short)align);
            if (((ExtCell)((Object)cell2)).getRow() == row) {
                ((ExtNormalCell)cell2).addColMerge((short)(colTotal - right));
            }
        }
    }

    public static void flexTilteHeaderFooter(IReport r, int rowTotal, short colTotal) {
        IColCell cc;
        int end = 1;
        int dataStartCol = 1;
        while (dataStartCol <= colTotal) {
            cc = r.getColCell((short)dataStartCol);
            if (cc.getColType() == -79) break;
            dataStartCol = (short)(dataStartCol + 1);
        }
        int dataEndCol = colTotal;
        while (dataEndCol >= dataStartCol) {
            cc = r.getColCell((short)dataEndCol);
            if (cc.getColType() == -79) break;
            dataEndCol = (short)(dataEndCol - 1);
        }
        int i = 1;
        while (i <= rowTotal) {
            IRowCell rc = r.getRowCell(i);
            byte type = rc.getRowType();
            if (type != -93 && type != -96) break;
            Perfected.flexCell(r, i, colTotal, dataStartCol, dataEndCol);
            end = i++;
        }
        int i2 = 1;
        while (i2 <= end) {
            int j = 1;
            while (j <= colTotal) {
                INormalCell cell = r.getCell(i2, (short)j);
                if (cell != null && cell.isMerged() && ((ExtCell)((Object)cell)).getRow() == i2 && ((ExtCell)((Object)cell)).getCol() == j) {
                    Area ar = cell.getMergedArea();
                    int endRow = ar.getEndRow();
                    short endCol = ar.getEndCol();
                    int m = ar.getBeginRow();
                    while (m <= endRow) {
                        short n = ar.getBeginCol();
                        while (n <= endCol) {
                            r.setCell(m, n, cell);
                            n = (short)(n + 1);
                        }
                        ++m;
                    }
                }
                ++j;
            }
            ++i2;
        }
        int i3 = rowTotal;
        while (i3 >= 1) {
            IRowCell rc = r.getRowCell(i3);
            byte type = rc.getRowType();
            if (type != -92 && type != -89) break;
            Perfected.flexCell(r, i3, colTotal, dataStartCol, dataEndCol);
            end = i3--;
        }
        int i4 = end;
        while (i4 <= rowTotal) {
            int j = 1;
            while (j <= colTotal) {
                INormalCell cell = r.getCell(i4, (short)j);
                if (cell != null && cell.isMerged() && ((ExtCell)((Object)cell)).getRow() == i4 && ((ExtCell)((Object)cell)).getCol() == j) {
                    Area ar = cell.getMergedArea();
                    int endRow = ar.getEndRow();
                    short endCol = ar.getEndCol();
                    int m = ar.getBeginRow();
                    while (m <= endRow) {
                        short n = ar.getBeginCol();
                        while (n <= endCol) {
                            r.setCell(m, n, cell);
                            n = (short)(n + 1);
                        }
                        ++m;
                    }
                }
                ++j;
            }
            ++i4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static byte[] getFileBytes(Object picFile, Context ctx, INormalCell cell) {
        if (picFile == null) {
            return null;
        }
        InputStream fis = null;
        if (picFile instanceof String) {
            byte[] tojpg;
            block43: {
                String picPath = (String)picFile;
                if (picPath.trim().length() == 0) {
                    return null;
                }
                if (new File(picPath).exists()) {
                    fis = new FileInputStream(picPath);
                } else if (ctx != null && ctx.getApplication() != null) {
                    if (!(picPath = StringUtils.replace(picPath, "\\", "/")).startsWith("/")) {
                        picPath = "/" + picPath;
                    }
                    fis = ctx.getApplication().getResourceAsStream(picPath);
                }
                if (fis == null) {
                    String mainDir = ctx.getMainDir();
                    if (!picPath.startsWith("/")) {
                        picPath = "/" + picPath;
                    }
                    if (new File(picPath = mainDir + picPath).exists()) {
                        fis = new FileInputStream(picPath);
                    } else if (ctx.getApplication() != null) {
                        if (!(picPath = StringUtils.replace(picPath, "\\", "/")).startsWith("/")) {
                            picPath = "/" + picPath;
                        }
                        fis = ctx.getApplication().getResourceAsStream(picPath);
                    }
                }
                if (fis == null && picPath != null && picPath.toLowerCase().indexOf("svg") > 0) {
                    tojpg = SVGConvert.transSvg((String)picFile);
                    cell.setValue(tojpg);
                }
                if (fis != null) break block43;
                tojpg = null;
                Object var8_11 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception e2) {
                }
                return tojpg;
            }
            tojpg = ControlUtils.getStreamBytes(fis);
            Object var8_12 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e2) {
            }
            return tojpg;
            catch (Exception e) {
                byte[] byArray;
                try {
                    byArray = null;
                    Object var8_13 = null;
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception e2) {
                    }
                    throw throwable;
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception e2) {
                }
                return byArray;
            }
        }
        if (picFile instanceof InputStream) {
            block47: {
                fis = (InputStream)picFile;
                if (fis != null) break block47;
                byte[] picPath = null;
                Object var11_21 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception e3) {
                }
                return picPath;
            }
            byte[] picPath = ControlUtils.getStreamBytes(fis);
            Object var11_22 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e3) {
            }
            return picPath;
            catch (Exception e) {
                byte[] byArray;
                try {
                    byArray = null;
                    Object var11_23 = null;
                }
                catch (Throwable throwable) {
                    Object var11_24 = null;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception e3) {
                    }
                    throw throwable;
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception e3) {
                }
                return byArray;
            }
        }
        return null;
    }

    protected static Font getFont(INormalCell cell) {
        int fontStyle = 0;
        if (cell.isBold()) {
            ++fontStyle;
        }
        if (cell.isItalic()) {
            fontStyle += 2;
        }
        return new Font(cell.getFontName(), fontStyle, cell.getFontSize());
    }

    protected static float getMergedHeight(IReport r, INormalCell cell, boolean includeHideRow, float scale, byte unit) {
        int height = 0;
        Area ar = cell.getMergedArea();
        int startRow = ar.getBeginRow();
        int endRow = ar.getEndRow();
        if (!cell.isMerged()) {
            IRowCell rc = r.getRowCell(startRow);
            height = (int)Math.ceil(Perfected.unitTransfer(rc.getRowHeight(), unit) * scale);
            if (rc.getRowVisible()) {
                return height;
            }
            return 0.0f;
        }
        int i = startRow;
        while (i <= endRow) {
            IRowCell rc = r.getRowCell(i);
            int h = (int)Math.ceil(Perfected.unitTransfer(rc.getRowHeight(), unit) * scale);
            if (includeHideRow) {
                height += h;
            } else if (rc.getRowVisible()) {
                boolean visible = true;
                short j = 1;
                short jCount = r.getColCount();
                while (j <= jCount) {
                    INormalCell c = r.getCell(i, j);
                    if (c != null && c.getRowHidden()) {
                        visible = false;
                        break;
                    }
                    j = (short)(j + 1);
                }
                if (visible) {
                    height += h;
                }
            }
            ++i;
        }
        return height;
    }

    protected static float getMergedWidth(IReport r, INormalCell cell, boolean includeHideCol, float scale, byte unit) {
        int width = 0;
        Area ar = cell.getMergedArea();
        int startCol = ar.getBeginCol();
        short endCol = ar.getEndCol();
        if (!cell.isMerged()) {
            IColCell cc = r.getColCell((short)startCol);
            width = (int)Math.ceil(Perfected.unitTransfer(cc.getColWidth(), unit) * scale);
            if (cc.getColVisible()) {
                return width;
            }
            return 0.0f;
        }
        int i = startCol;
        while (i <= endCol) {
            IColCell cc = r.getColCell((short)i);
            float w = cc.getColWidth();
            if (includeHideCol) {
                width = (int)((double)width + Math.ceil(Perfected.unitTransfer(w, unit) * scale));
            } else if (cc.getColVisible()) {
                width = (int)((double)width + Math.ceil(Perfected.unitTransfer(w, unit) * scale));
            }
            ++i;
        }
        return width;
    }

    private static Object getOutsizeImage(Context ctx) {
        String p;
        String filePath;
        String logoPath;
        File f;
        String relativeFile = GC.PATH_LOGO + "/outsize.gif";
        String home = System.getProperty("report.home");
        if (!relativeFile.startsWith("/")) {
            relativeFile = "/" + relativeFile;
        }
        if ((f = new File(logoPath = Sentence.replace(filePath = home + relativeFile, "/", p = System.getProperty("file.separator"), 1))).exists()) {
            return logoPath;
        }
        if (ctx.getApplication() != null) {
            logoPath = ctx.getApplication().getRealPath("/images/outsize.gif");
            if (logoPath == null) {
                InputStream is = ctx.getApplication().getResourceAsStream("/images/outsize.gif");
                if (is != null) {
                    return is;
                }
            } else {
                f = new File(logoPath);
            }
        }
        if (f.exists()) {
            return logoPath;
        }
        Logger.warn("Get image file: " + logoPath + " failure!");
        return null;
    }

    protected static int getReportHeight(IReport r, float scale) {
        int height = 0;
        int totalRow = r.getRowCount();
        byte unit = r.getUnit();
        int row = 1;
        while (row <= totalRow) {
            IRowCell rc = r.getRowCell(row);
            if (rc.getRowVisible()) {
                height += (int)Math.ceil(Perfected.unitTransfer(rc.getRowHeight(), unit) * scale);
            }
            ++row;
        }
        return height;
    }

    protected static int getReportWidth(IReport r, float scale) {
        int width = 0;
        int totalCol = r.getColCount();
        byte unit = r.getUnit();
        int col = 1;
        while (col <= totalCol) {
            IColCell cc = r.getColCell((short)col);
            if (cc.getColVisible()) {
                width += (int)Math.ceil(Perfected.unitTransfer(cc.getColWidth(), unit) * scale);
            }
            ++col;
        }
        return width;
    }

    public static int getTotalHeight(IReport r, INormalCell cell, String text, byte unit) {
        if (text.trim().length() == 0) {
            return 0;
        }
        float w = Perfected.getMergedWidth(r, cell, false, 1.0f, unit);
        int indent = (int)Perfected.unitTransfer(cell.getIndent() * 1.0f, unit);
        if (cell.getHAlign() == -47) {
            indent *= 2;
        }
        if ((w = w - (float)indent - 4.0f) <= 0.0f) {
            return 0;
        }
        FontMetrics fm = new BufferedImage(10, 10, 2).getGraphics().getFontMetrics(Perfected.getFont(cell));
        ArrayList al = StringUtils.wrapString(text, fm, w);
        if (al.size() < 2) {
            return 0;
        }
        int lineH = (int)Math.ceil((double)fm.getFont().getSize() * 1.28);
        int totalH = lineH * al.size() + 2;
        return totalH;
    }

    public static void perfect(ExtCellSet report, Context ctx) {
        byte align;
        byte unit = report.getUnit();
        boolean shrinkFont = false;
        int rows = report.getRowCount();
        int cols = report.getColCount();
        Perfected.flexTilteHeaderFooter(report, rows, (short)cols);
        int row = 1;
        while (row <= rows) {
            int col = 1;
            while (col <= cols) {
                ExtNormalCell cell = (ExtNormalCell)report.getCell(row, (short)col);
                if (cell != null && cell.getRow() == row && cell.getCol() == col) {
                    if (cell.getRowHidden()) {
                        IRowCell rc = report.getRowCell(row);
                        rc.setRowVisible(false);
                    }
                    if (cell.getColHidden()) {
                        IColCell cc = report.getColCell((short)col);
                        cc.setColVisible(false);
                    }
                }
                ++col;
            }
            ++row;
        }
        int row2 = 1;
        while (row2 <= rows) {
            int col = 1;
            while (col <= cols) {
                ExtNormalCell cell = (ExtNormalCell)report.getCell(row2, (short)col);
                if (cell != null && cell.getRow() == row2 && cell.getCol() == col) {
                    Area ar;
                    String text;
                    byte dataType = cell.getCellType();
                    Object subValue = cell.getValue();
                    if (dataType == -60 && subValue instanceof ExtCellSet) {
                        Perfected.perfect((ExtCellSet)subValue, ctx);
                        cell.setValue(subValue);
                    }
                    int adjust = cell.getAdjustSizeMode();
                    if (cell.getTextWrap() && adjust != 51) {
                        if (dataType == -64 && adjust != 52) {
                            if (adjust == 48) {
                                cell.setAdjustSizeMode((byte)49);
                                adjust = 49;
                            }
                            text = "";
                            String data = cell.getDispValue();
                            if (data != null) {
                                text = data;
                            }
                            if (text.length() == 0 && subValue != null) {
                                text = subValue.toString();
                            }
                            if (text.length() > 0) {
                                Perfected.adjustRowHeight(report, cell, text, unit);
                            }
                        } else if (dataType == -56 && adjust != 52) {
                            if (adjust == 48) {
                                cell.setAdjustSizeMode((byte)49);
                                adjust = 49;
                            }
                            text = "";
                            String data = cell.getDispValue();
                            if (data != null) {
                                text = data;
                            }
                            if (text.length() == 0 && subValue != null) {
                                text = subValue.toString();
                            }
                            if (text.length() > 0) {
                                Perfected.adjustRichTextRowHeight(report, cell, text, unit);
                            }
                        } else if (dataType == -58 && adjust != 52) {
                            if (adjust == 48) {
                                cell.setAdjustSizeMode((byte)49);
                                adjust = 49;
                            }
                            text = "";
                            String data = cell.getDispValue();
                            if (data != null) {
                                text = data;
                            }
                            if (text.length() == 0 && subValue != null) {
                                text = subValue.toString();
                            }
                            if (text.length() > 0) {
                                Perfected.adjustHtmlRowHeight(report, cell, text, unit);
                            }
                        }
                    }
                    if (cell.getBreakPageAfterRow()) {
                        ar = cell.getMergedArea();
                        IRowCell rc = report.getRowCell(ar.getEndRow());
                        rc.setBreakPage(true);
                    }
                    if (cell.getBreakPageAfterCol()) {
                        ar = cell.getMergedArea();
                        IColCell cc = report.getColCell(ar.getEndCol());
                        cc.setBreakPage(true);
                    }
                    if (dataType == -63 || dataType == -62 || dataType == -57) {
                        Object vl = subValue;
                        if (vl instanceof ImageValue) {
                            vl = ((ImageValue)vl).getValue();
                        }
                        byte[] bytes = null;
                        float w = Perfected.getMergedWidth(report, cell, false, 1.0f, unit);
                        float h = Perfected.getMergedHeight(report, cell, false, 1.0f, unit);
                        if (vl instanceof byte[]) {
                            bytes = (byte[])vl;
                        } else if (vl instanceof String) {
                            bytes = Perfected.getFileBytes((String)vl, ctx, cell);
                        }
                        if (bytes != null) {
                            int iw = 0;
                            int ih = 0;
                            Class<?> imageReader = null;
                            try {
                                imageReader = Class.forName("javax.imageio.ImageReader");
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (imageReader != null) {
                                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                                ImageInputStream iis = null;
                                try {
                                    iis = ImageIO.createImageInputStream(bais);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                if (iis != null) {
                                    try {
                                        Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
                                        ImageReader reader = readers.next();
                                        reader.setInput(iis);
                                        iw = reader.getWidth(0);
                                        ih = reader.getHeight(0);
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    ReportDefine rd = report.getReportDefine();
                                    if (rd != null) {
                                        int maxW = rd.getImageMaxWidth();
                                        int maxH = rd.getImageMaxHeight();
                                        if (maxW > 0 && iw > maxW || maxH > 0 && ih > maxH) {
                                            Object outsizeGif = Perfected.getOutsizeImage(ctx);
                                            if (outsizeGif != null) {
                                                bytes = Perfected.getFileBytes(outsizeGif, ctx, cell);
                                                bais = new ByteArrayInputStream(bytes);
                                                iis = null;
                                                try {
                                                    iis = ImageIO.createImageInputStream(bais);
                                                }
                                                catch (Exception e) {
                                                    // empty catch block
                                                }
                                                if (vl instanceof String) {
                                                    if (outsizeGif instanceof String) {
                                                        cell.setValue(outsizeGif);
                                                    } else if (outsizeGif instanceof InputStream) {
                                                        cell.setValue(bytes);
                                                    }
                                                } else if (vl instanceof ImageValue) {
                                                    ((ImageValue)vl).setValue(bytes);
                                                } else if (vl instanceof byte[]) {
                                                    cell.setValue(bytes);
                                                }
                                                try {
                                                    Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
                                                    ImageReader reader = readers.next();
                                                    reader.setInput(iis);
                                                    iw = reader.getWidth(0);
                                                    ih = reader.getHeight(0);
                                                }
                                                catch (Exception e) {
                                                }
                                            } else {
                                                Logger.error("Can't find outsize Image: outsize.gif");
                                            }
                                        }
                                    }
                                }
                            } else {
                                Image image = new ImageIcon(bytes).getImage();
                                iw = image.getWidth(null);
                                ih = image.getHeight(null);
                            }
                            if (((float)iw > w || (float)ih > h) && (adjust == 48 || dataType == -57)) {
                                Perfected.adjustCellSize(report, cell, iw, ih + 1, unit);
                            }
                        }
                    } else if (dataType == -60) {
                        if (subValue instanceof IReport) {
                            IReport sub = (IReport)subValue;
                            float w = Perfected.getMergedWidth(report, cell, false, 1.0f, unit);
                            float h = Perfected.getMergedHeight(report, cell, false, 1.0f, unit);
                            int subw = Perfected.getReportWidth(sub, 1.0f);
                            int subh = Perfected.getReportHeight(sub, 1.0f);
                            if ((float)subw >= w || (float)subh >= h || adjust == 50) {
                                int newW;
                                IColCell cc;
                                int newH;
                                IRowCell rc;
                                byte subunit = sub.getUnit();
                                if (adjust == 48) {
                                    Perfected.adjustCellSize(report, cell, subw + 2, subh + 2, unit);
                                } else if (adjust == 49 || adjust == 52) {
                                    if ((float)subh > (h = (float)((int)h / 2 * 2 - 1))) {
                                        int subRows = sub.getRowCount();
                                        int setH = 0;
                                        int i = 1;
                                        while (i <= subRows) {
                                            rc = sub.getRowCell(i);
                                            if (rc.getRowVisible()) {
                                                float hh = Perfected.unitTransfer(rc.getRowHeight(), subunit) * 1.0f;
                                                newH = Math.round(hh * h / (float)subh);
                                                if (i == subRows) {
                                                    newH = (int)h - setH;
                                                } else {
                                                    setH += newH;
                                                }
                                                rc.setRowHeight(Perfected.unUnitTransfer(newH, subunit));
                                            }
                                            ++i;
                                        }
                                    }
                                    if ((float)subw > (w = (float)((int)w / 2 * 2 - 1))) {
                                        int subCols = sub.getColCount();
                                        int setW = 0;
                                        int i = 1;
                                        while (i <= subCols) {
                                            cc = sub.getColCell((short)i);
                                            if (cc.getColVisible()) {
                                                float ww = Perfected.unitTransfer(cc.getColWidth(), subunit) * 1.0f;
                                                newW = (int)Math.ceil(ww * w / (float)subw);
                                                if (i == subCols) {
                                                    newW = (int)w - setW;
                                                } else {
                                                    setW += newW;
                                                }
                                                cc.setColWidth(Perfected.unUnitTransfer(newW, subunit));
                                            }
                                            ++i;
                                        }
                                    }
                                } else if (adjust == 50) {
                                    if ((float)subh != (h = (float)((int)h / 2 * 2 - 1))) {
                                        int subRows = sub.getRowCount();
                                        int setH = 0;
                                        int i = 1;
                                        while (i <= subRows) {
                                            rc = sub.getRowCell(i);
                                            if (rc.getRowVisible()) {
                                                float hh = Perfected.unitTransfer(rc.getRowHeight(), subunit) * 1.0f;
                                                newH = Math.round(hh * h / (float)subh);
                                                if (i == subRows) {
                                                    newH = (int)h - setH;
                                                } else {
                                                    setH += newH;
                                                }
                                                rc.setRowHeight(Perfected.unUnitTransfer(newH, subunit));
                                            }
                                            ++i;
                                        }
                                    }
                                    if ((float)subw != (w = (float)((int)w / 2 * 2 - 1))) {
                                        int subCols = sub.getColCount();
                                        int setW = 0;
                                        int i = 1;
                                        while (i <= subCols) {
                                            cc = sub.getColCell((short)i);
                                            if (cc.getColVisible()) {
                                                float ww = Perfected.unitTransfer(cc.getColWidth(), subunit) * 1.0f;
                                                newW = (int)Math.ceil(ww * w / (float)subw);
                                                if (i == subCols) {
                                                    newW = (int)w - setW;
                                                } else {
                                                    setW += newW;
                                                }
                                                cc.setColWidth(Perfected.unUnitTransfer(newW, subunit));
                                            }
                                            ++i;
                                        }
                                    }
                                }
                            }
                        }
                    } else if (dataType == -64) {
                        boolean bl = shrinkFont = adjust == 51 || shrinkFont;
                        if (adjust == 48) {
                            FontMetrics fm = new BufferedImage(10, 10, 2).getGraphics().getFontMetrics(Perfected.getFont(cell));
                            String text2 = "";
                            String obj = cell.getDispValue();
                            if (obj != null) {
                                text2 = obj;
                            }
                            if (text2.length() == 0 && subValue != null) {
                                text2 = subValue.toString();
                            }
                            int w = fm.stringWidth(text2);
                            int indent = (int)Math.floor(Perfected.unitTransfer(cell.getIndent() * 1.0f, unit));
                            align = cell.getHAlign();
                            if (align == -47) {
                                indent *= 2;
                            }
                            float h = Perfected.getMergedHeight(report, cell, false, 1.0f, unit);
                            Perfected.adjustCellSize(report, cell, w + indent + 4, h, unit);
                        }
                    } else if (dataType == -56 && adjust == 48 && !cell.getTextWrap()) {
                        text = "";
                        String obj = cell.getDispValue();
                        if (obj != null) {
                            text = obj;
                        }
                        if (text.length() == 0 && subValue != null) {
                            text = subValue.toString();
                        }
                        ArrayList elements = null;
                        try {
                            elements = RichTextUtil.getRichTextElements(text, cell.getFontName(), cell.getFontSize(), cell.getForeColor(), cell.isBold(), cell.isItalic(), cell.isUnderline());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        int eiSize = 0;
                        if (elements != null) {
                            eiSize = elements.size();
                        }
                        int w = 0;
                        int ei = 0;
                        while (ei < eiSize) {
                            Object eObj = elements.get(ei);
                            if (eObj instanceof RichTextElement) {
                                RichTextElement rte = (RichTextElement)eObj;
                                FontMetrics fm = new BufferedImage(10, 10, 2).getGraphics().getFontMetrics(RichTextUtil.getFont(rte));
                                w += fm.stringWidth(rte.text);
                            }
                            ++ei;
                        }
                        int indent = (int)Math.floor(Perfected.unitTransfer(cell.getIndent() * 1.0f, unit));
                        byte align2 = cell.getHAlign();
                        if (align2 == -47) {
                            indent *= 2;
                        }
                        float h = Perfected.getMergedHeight(report, cell, false, 1.0f, unit);
                        Perfected.adjustCellSize(report, cell, w + indent + 4, h, unit);
                    }
                }
                ++col;
            }
            ++row2;
        }
        if (shrinkFont) {
            int row3 = 1;
            while (row3 <= rows) {
                int col = 1;
                while (col <= cols) {
                    INormalCell cell = report.getCell(row3, (short)col);
                    if (cell != null && ((ExtCell)((Object)cell)).getRow() == row3 && ((ExtCell)((Object)cell)).getCol() == col) {
                        byte adjust;
                        byte dataType = cell.getCellType();
                        Object value = cell.getValue();
                        if (dataType == -64 && (adjust = cell.getAdjustSizeMode()) == 51) {
                            String text = "";
                            Object obj = cell.getDispValue();
                            if (obj != null) {
                                text = obj.toString();
                            }
                            if (text.length() == 0 && (obj = cell.getValue()) != null) {
                                text = obj.toString();
                            }
                            float w = Perfected.getMergedWidth(report, cell, false, 1.0f, unit);
                            float indent = Perfected.unitTransfer(cell.getIndent() * 1.0f, unit);
                            align = cell.getHAlign();
                            if (align == -47) {
                                indent *= 2.0f;
                            }
                            float h = Perfected.getMergedHeight(report, cell, false, 1.0f, unit);
                            boolean wrap = cell.getTextWrap();
                            Graphics g = new BufferedImage(10, 10, 2).getGraphics();
                            float fontSize = Perfected.shrinkFontSize(text, w -= indent, h, wrap, Perfected.getFont(cell), g, unit);
                            cell.setFontSize((short)fontSize);
                        }
                    }
                    ++col;
                }
                ++row3;
            }
        }
    }

    private static int shrinkFontSize(String text, float w, float h, boolean wrap, Font font, Graphics g, byte unit) {
        if (text == null || text.trim().length() == 0) {
            return font.getSize();
        }
        int fontSize = font.getSize();
        if (fontSize < 2) {
            return 1;
        }
        if (wrap) {
            while (true) {
                FontMetrics fm = g.getFontMetrics(font);
                ArrayList al = StringUtils.wrapString(text, fm, w);
                int lineH = (int)Math.ceil((double)fontSize * 1.28);
                int totalH = lineH * al.size() + 5;
                if ((float)totalH <= h) {
                    return fontSize;
                }
                font = new Font(font.getFontName(), font.getStyle(), --fontSize);
            }
        }
        FontMetrics fm = g.getFontMetrics(font);
        int sw = fm.stringWidth(text);
        if ((float)sw > w) {
            if ((fontSize = (int)((double)fontSize * 1.0 * (double)w / (double)sw)) < 2) {
                return 1;
            }
            while (true) {
                if ((float)(sw = (fm = g.getFontMetrics(font = new Font(font.getFontName(), font.getStyle(), fontSize))).stringWidth(text)) > w) {
                    return fontSize - 1;
                }
                ++fontSize;
            }
        }
        return fontSize;
    }

    public static float unUnitTransfer(float f, byte unit) {
        if (unit == 2) {
            f /= 72.0f;
        } else if (unit == 1) {
            f = f * 25.4f / 72.0f;
        }
        return f;
    }

    public static float unitTransfer(float f, byte unit) {
        if (unit == 2) {
            f *= 72.0f;
        } else if (unit == 1) {
            f = f * 72.0f / 25.4f;
        }
        return f;
    }
}

