/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.model.engine2;

import com.runqian.report4.dataset.DsValue;
import com.runqian.report4.dataset.Group;
import com.runqian.report4.dataset.Row;
import com.runqian.report4.model.ExtList;
import com.runqian.report4.model.engine2.ExtNCell;
import com.runqian.report4.model.engine2.ExtRow;
import com.runqian.report4.model.engine2.RowReport;
import com.runqian.report4.model.engine2.SrcCell;
import com.runqian.report4.model.expression.Expression;
import com.runqian.report4.model.expression.Variant2;
import com.runqian.report4.usermodel.Context;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class ExtPRow
extends ExtRow {
    private static final long serialVersionUID = 1L;
    protected ExtRow[] extRows;
    protected ExtList subRows;
    protected DsValue currentDs;
    protected DsValue[] addDs;

    public ExtPRow() {
    }

    public ExtPRow(int n, int n2, RowReport rowReport, SrcCell[] srcCellArray) {
        super(n, n2, rowReport, srcCellArray);
    }

    protected void addSub(ExtRow extRow) {
        if (this.subRows == null) {
            this.subRows = new ExtList();
        }
        this.subRows.add(extRow);
        if (extRow.isExtend()) {
            this.engine.isLeafExtRow = false;
        }
    }

    protected void calcAddDataSet(Context context, SrcCell srcCell) {
        int n;
        if (srcCell.addExpression != null && (n = srcCell.addExpression.length) > 0) {
            this.addDs = new DsValue[n];
            int n2 = 0;
            while (n2 < n) {
                if (srcCell.addExpression[n2] != null) {
                    Object object = ((Expression)srcCell.addExpression[n2]).calculate(context, false);
                    if (object instanceof List && ((List)object).size() > 0) {
                        object = ((List)object).get(0);
                    }
                    if (object instanceof Row || object instanceof Group) {
                        this.addDs[n2] = (DsValue)object;
                    }
                }
                ++n2;
            }
        }
    }

    public void calculate(Context context, short s) {
        SrcCell srcCell = this.engine.sCell[s - 1];
        if (srcCell != null) {
            if (this.engine.report.getState() >= 7 && srcCell.state != 8) {
                return;
            }
            Expression expression = (Expression)srcCell.getValueExp();
            if (expression != null) {
                Object object;
                if (srcCell.isDsFunction()) {
                    this.setDSCurrent(context);
                }
                if ((object = expression.calculate(context, false)) instanceof List && srcCell.isExtend()) {
                    int n = ((List)object).size();
                    if (n == 0) {
                        this.values[s - 1] = null;
                        return;
                    }
                    this.engine.report.extendRow(this, n);
                    ExtNCell extNCell = this.engine.report.getCurrent();
                    int n2 = 0;
                    while (n2 < n) {
                        Object e = ((List)object).get(n2);
                        ExtPRow extPRow = (ExtPRow)this.extRows[n2];
                        extPRow.values[s - 1] = Variant2.getValue(e, false, false);
                        if (e instanceof Row || e instanceof Group) {
                            extPRow.currentDs = (DsValue)e;
                            ((DsValue)e).getDataSet().setCurrent((DsValue)e, true);
                        }
                        if (srcCell.getCellType() == -64) {
                            extNCell.setRow(extPRow);
                            srcCell.calcDispValue(extPRow, e, context, extPRow.displayValues, s - 1);
                        }
                        extPRow.calcAddDataSet(context, srcCell);
                        ++n2;
                    }
                    extNCell.setRow(this);
                    return;
                }
                this.values[s - 1] = Variant2.getValue(object, false, false);
                if (object instanceof Row || object instanceof Group) {
                    this.currentDs = (DsValue)object;
                    ((DsValue)object).getDataSet().setCurrent((DsValue)object, true);
                }
                if (srcCell.getCellType() == -64 || srcCell.getCellType() == -58 || srcCell.getCellType() == -56) {
                    srcCell.calcDispValue(this, object, context, this.displayValues, s - 1);
                }
                this.calcAddDataSet(context, srcCell);
            }
        }
    }

    public Object clone() {
        ExtPRow extPRow = (ExtPRow)super.clone();
        ((ExtPRow)super.clone()).subRows = null;
        extPRow.currentDs = null;
        return extPRow;
    }

    public ExtRow getExtRow(int n) {
        if (this.extRows == null) {
            if (n == 0) {
                return this;
            }
            return null;
        }
        if (n < 0 || n >= this.extRows.length) {
            return null;
        }
        return this.extRows[n];
    }

    public int getExtSize() {
        if (this.extRows != null) {
            return this.extRows.length;
        }
        return 1;
    }

    public ExtRow getParent() {
        return this.parent;
    }

    public int getPosition() {
        if (this.extRows == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.extRows.length;
        while (n < n2) {
            if (this == this.extRows[n]) {
                return n;
            }
            ++n;
        }
        throw new RuntimeException();
    }

    public ExtRow getSubRow(int n) {
        if (this.subRows == null) {
            return null;
        }
        if (n < 0 || n >= this.subRows.size()) {
            return null;
        }
        return (ExtRow)this.subRows.get(n);
    }

    public ExtRow getSubRow(ExtRow extRow) {
        if (this.subRows == null) {
            return null;
        }
        int n = 0;
        int n2 = this.subRows.size();
        while (n < n2) {
            ExtRow extRow2 = (ExtRow)this.subRows.get(n);
            if (extRow2.getSource() == extRow) {
                return extRow2;
            }
            ++n;
        }
        return null;
    }

    public ExtRow getSubRowByOrg(int n) {
        if (this.subRows == null) {
            return null;
        }
        int n2 = 0;
        int n3 = this.subRows.size();
        while (n2 < n3) {
            ExtRow extRow = (ExtRow)this.subRows.get(n2);
            if (extRow.getSourceRow() == n) {
                return extRow;
            }
            ++n2;
        }
        return null;
    }

    public int getSubSize() {
        if (this.subRows != null) {
            return this.subRows.size();
        }
        return 0;
    }

    public boolean isDirectParent(ExtRow extRow) {
        return extRow.getParent() == this;
    }

    public boolean isExtend() {
        return true;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        super.readExternal(objectInput);
        this.subRows = (ExtList)objectInput.readObject();
        if (by < 2) {
            int n = objectInput.readInt();
            if (n > 0) {
                this.extRows = new ExtRow[n];
                int n2 = 0;
                while (n2 < n) {
                    this.extRows[n2] = (ExtRow)objectInput.readObject();
                    ++n2;
                }
                return;
            }
        } else {
            this.extRows = (ExtRow[])objectInput.readObject();
        }
    }

    protected void romoveSub(ExtRow extRow) {
        int n = this.subRows.indexOf(extRow);
        if (n != -1) {
            this.subRows.remove(n);
        }
    }

    public void setDSCurrent(Context context) {
        this.engine.report.resetDSCurrent(context);
        if (this.currentDs != null) {
            this.currentDs.getDataSet().setCurrent(this.currentDs, true);
        }
        if (this.addDs != null) {
            int n = this.addDs.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.addDs[n2] != null) {
                    this.addDs[n2].getDataSet().setCurrent(this.addDs[n2], true);
                }
                ++n2;
            }
        }
        ExtRow extRow = this.parent;
        while (extRow != null) {
            extRow.setParentDSCurrent();
            extRow = extRow.getParent();
        }
        this.engine.report.setDSCurrent(context);
    }

    public void setExtRows(ExtRow[] extRowArray) {
        this.extRows = extRowArray;
    }

    protected void setParentDSCurrent() {
        if (this.currentDs != null && this.currentDs.getDataSet().getCurrent() == null) {
            this.currentDs.getDataSet().setCurrent(this.currentDs, true);
        }
        if (this.addDs != null) {
            int n = this.addDs.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.addDs[n2] != null && this.addDs[n2].getDataSet().getCurrent() == null) {
                    this.addDs[n2].getDataSet().setCurrent(this.addDs[n2], true);
                }
                ++n2;
            }
        }
    }

    public void updateRow(RowReport rowReport, ExtRow extRow) {
        ExtList extList;
        int n;
        int n2;
        if (extRow.parent != null) {
            this.parent = rowReport.getExtRow(extRow.parent.getRow());
        }
        this.engine = rowReport.getExtRow((int)extRow.getSource().getRow()).engine;
        ExtRow[] extRowArray = ((ExtPRow)extRow).extRows;
        if (((ExtPRow)extRow).extRows != null && (n2 = extRowArray.length) > 0) {
            if (extRowArray[0] == extRow) {
                this.extRows = new ExtRow[n2];
                n = 0;
                while (n < n2) {
                    this.extRows[n] = rowReport.getExtRow(extRowArray[n].getRow());
                    ++n;
                }
            } else {
                this.extRows = ((ExtPRow)rowReport.getExtRow((int)extRowArray[0].getRow())).extRows;
            }
        }
        if ((extList = ((ExtPRow)extRow).subRows) != null) {
            n = extList.size();
            this.subRows = new ExtList(n);
            int n3 = 0;
            while (n3 < n) {
                this.subRows.add(rowReport.getExtRow(((ExtRow)extList.get(n3)).getRow()));
                ++n3;
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(2);
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.subRows);
        objectOutput.writeObject(this.extRows);
    }
}

