/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.model.engine2;

import com.runqian.base4.util.ReportError;
import com.runqian.report4.model.CellLocation;
import com.runqian.report4.model.engine2.ExtRow;
import com.runqian.report4.model.engine2.RCellEngine;
import com.runqian.report4.model.engine2.RowReport;
import com.runqian.report4.model.expression.Expression;
import com.runqian.report4.model.expression.Variant2;
import com.runqian.report4.usermodel.ByteMap;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.IByteMap;
import com.runqian.report4.usermodel.IRowCell;
import com.runqian.report4.util.ByteArrayInputRecord;
import com.runqian.report4.util.ByteArrayOutputRecord;
import com.runqian.report4.util.MacroResolver2;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;

public class ExtRCell
implements IRowCell,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected int row;
    protected RCellEngine engine = new RCellEngine();

    public ExtRCell() {
    }

    public ExtRCell(RowReport rowReport, int n, IRowCell iRowCell) {
        this.row = n;
        this.engine.report = rowReport;
        this.engine.srcCell = iRowCell;
        this.engine.rowHeightExp = iRowCell.getRowHeightExp();
        this.engine.rowVisibleExp = iRowCell.getRowVisibleExp();
        this.engine.rowBreakPageExp = iRowCell.getBreakPageExp();
        IByteMap iByteMap = iRowCell.getCustomPropertiesExpMap();
        if (iByteMap != null && iByteMap.size() > 0) {
            short s = iByteMap.size();
            this.engine.customPropEngMap = new ByteMap(s);
            short s2 = 0;
            while (s2 < s) {
                byte by = iByteMap.getKey(s2);
                Object object = iByteMap.getValue(s2);
                this.engine.customPropEngMap.put(by, object);
                s2 = (short)(s2 + 1);
            }
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ReportError(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
        }
    }

    public void cloneEngine(RowReport rowReport, ExtRCell extRCell) {
        this.engine = new RCellEngine();
        this.engine.rowHeightExp = extRCell.engine.rowHeightExp;
        this.engine.rowVisibleExp = extRCell.engine.rowVisibleExp;
        this.engine.rowBreakPageExp = extRCell.engine.rowBreakPageExp;
        this.engine.report = rowReport;
        this.engine.srcCell = extRCell.engine.srcCell;
        if (extRCell.engine.customPropEngMap != null && extRCell.engine.customPropEngMap.size() > 0) {
            short s = extRCell.engine.customPropEngMap.size();
            this.engine.customPropEngMap = new ByteMap(s);
            short s2 = 0;
            while (s2 < s) {
                byte by = extRCell.engine.customPropEngMap.getKey(s2);
                Object object = extRCell.engine.customPropEngMap.getValue(s2);
                this.engine.customPropEngMap.put(by, object);
                s2 = (short)(s2 + 1);
            }
        }
    }

    public Object deepClone() {
        return this.clone();
    }

    public void fillRecord(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord byteArrayInputRecord = new ByteArrayInputRecord(byArray);
    }

    public boolean getBreakPage() {
        if (this.engine.rowBreakPageExp != null && ((Expression)this.engine.rowBreakPageExp).getState() <= this.engine.report.getState()) {
            ExtRow extRow = this.engine.report.getExtRow(this.row);
            this.engine.report.setCurrent(extRow, null);
            Object object = Variant2.getValue(((Expression)this.engine.rowBreakPageExp).calculate(this.engine.report.getContext(), false), false, false);
            return (Boolean)object;
        }
        return this.engine.srcCell.getBreakPage();
    }

    public String getBreakPageExp() {
        return this.engine.srcCell.getBreakPageExp();
    }

    public IByteMap getCustomPropertiesExpMap() {
        return this.engine.srcCell.getCustomPropertiesExpMap();
    }

    public IByteMap getCustomPropertiesMap() {
        IByteMap iByteMap = this.engine.srcCell.getCustomPropertiesMap();
        if (this.engine.customPropEngMap != null && this.engine.customPropEngMap.size() > 0) {
            int n = this.engine.customPropEngMap.size();
            byte by = 0;
            Object var4_4 = null;
            ByteMap byteMap = new ByteMap((short)n);
            int n2 = 0;
            while (n2 < n) {
                by = this.engine.customPropEngMap.getKey(n2);
                Expression expression = (Expression)this.engine.customPropEngMap.get(by);
                if (expression != null) {
                    if (expression.getState() > this.engine.report.getState()) {
                        byteMap.add(by, iByteMap.get(by));
                    } else {
                        ExtRow extRow = this.engine.report.getExtRow(this.row);
                        this.engine.report.setCurrent(extRow, null);
                        byteMap.add(by, Variant2.getValue(expression.calculate(this.engine.report.getContext(), false), false, false));
                    }
                }
                ++n2;
            }
            return byteMap;
        }
        return iByteMap;
    }

    public IByteMap getExpMap() {
        return this.engine.srcCell.getExpMap();
    }

    public IByteMap getExpMap(boolean bl) {
        return this.engine.srcCell.getExpMap(bl);
    }

    public byte getGroupHeaderLevel() {
        return this.engine.srcCell.getGroupHeaderLevel();
    }

    public String getNotes() {
        return this.engine.srcCell.getNotes();
    }

    public IByteMap getPropertyMap() {
        ByteMap byteMap = new ByteMap(4);
        byteMap.put((byte)10, new Byte(this.getRowType()));
        byteMap.put((byte)11, new Float(this.getRowHeight()));
        byteMap.put((byte)12, new Boolean(this.getRowVisible()));
        byteMap.put((byte)13, new Boolean(this.getBreakPage()));
        return byteMap;
    }

    public float getRowHeight() {
        if (this.engine.rowHeightExp != null && ((Expression)this.engine.rowHeightExp).getState() <= this.engine.report.getState()) {
            ExtRow extRow = this.engine.report.getExtRow(this.row);
            this.engine.report.setCurrent(extRow, null);
            Object object = Variant2.getValue(((Expression)this.engine.rowHeightExp).calculate(this.engine.report.getContext(), false), false, false);
            return ((Number)object).floatValue();
        }
        return this.engine.srcCell.getRowHeight();
    }

    public String getRowHeightExp() {
        return this.engine.srcCell.getRowHeightExp();
    }

    public byte getRowType() {
        return this.engine.srcCell.getRowType();
    }

    public boolean getRowVisible() {
        if (this.engine.rowVisibleExp != null && ((Expression)this.engine.rowVisibleExp).getState() <= this.engine.report.getState()) {
            ExtRow extRow = this.engine.report.getExtRow(this.row);
            this.engine.report.setCurrent(extRow, null);
            Object object = Variant2.getValue(((Expression)this.engine.rowVisibleExp).calculate(this.engine.report.getContext(), false), false, false);
            return (Boolean)object;
        }
        return this.engine.srcCell.getRowVisible();
    }

    public String getRowVisibleExp() {
        return this.engine.srcCell.getRowVisibleExp();
    }

    public String getSourceId() {
        return CellLocation.getCellId(this.row, 0);
    }

    public void prepProperties(Map map, Context context) {
        try {
            if (this.engine.rowHeightExp != null) {
                if (map != null) {
                    this.engine.rowHeightExp = MacroResolver2.replaceMacros((String)this.engine.rowHeightExp, context);
                }
                this.engine.rowHeightExp = new Expression(this.engine.report, context, (String)this.engine.rowHeightExp);
            }
            if (this.engine.rowVisibleExp != null) {
                if (map != null) {
                    this.engine.rowVisibleExp = MacroResolver2.replaceMacros((String)this.engine.rowVisibleExp, context);
                }
                this.engine.rowVisibleExp = new Expression(this.engine.report, context, (String)this.engine.rowVisibleExp);
            }
            if (this.engine.rowBreakPageExp != null) {
                if (map != null) {
                    this.engine.rowBreakPageExp = MacroResolver2.replaceMacros((String)this.engine.rowBreakPageExp, context);
                }
                this.engine.rowBreakPageExp = new Expression(this.engine.report, context, (String)this.engine.rowBreakPageExp);
            }
            if (this.engine.customPropEngMap != null) {
                int n = this.engine.customPropEngMap.size();
                int n2 = 0;
                while (n2 < n) {
                    byte by = this.engine.customPropEngMap.getKey(n2);
                    String string = (String)this.engine.customPropEngMap.getValue(n2);
                    if (map != null) {
                        string = MacroResolver2.replaceMacros(string, context);
                    }
                    this.engine.customPropEngMap.put(by, new Expression(this.engine.report, context, string));
                    ++n2;
                }
                return;
            }
        }
        catch (ReportError reportError) {
            ReportError reportError2 = reportError;
            reportError.setCellId(this.getSourceId());
            throw reportError2;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readByte();
        this.row = objectInput.readInt();
        this.engine = (RCellEngine)objectInput.readObject();
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord byteArrayOutputRecord = new ByteArrayOutputRecord();
        return byteArrayOutputRecord.toByteArray();
    }

    public void setBreakPage(boolean bl) {
    }

    public void setBreakPageExp(String string) {
    }

    public void setCustomPropertiesExpMap(IByteMap iByteMap) {
    }

    public void setCustomPropertiesMap(IByteMap iByteMap) {
    }

    public void setExpMap(IByteMap iByteMap) {
    }

    public void setGroupHeaderLevel(byte by) {
    }

    public void setNotes(String string) {
    }

    public void setPropertyMap(IByteMap iByteMap) {
    }

    public void setRow(int n) {
        this.row = n;
    }

    public void setRowHeight(float f) {
    }

    public void setRowHeightExp(String string) {
    }

    public void setRowType(byte by) {
    }

    public void setRowVisible(boolean bl) {
    }

    public void setRowVisibleExp(String string) {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        objectOutput.writeInt(this.row);
        objectOutput.writeObject(this.engine);
    }
}

