/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.model.expression;

import com.runqian.base4.resources.EngineMessage;
import com.runqian.base4.resources.MessageManager;
import com.runqian.base4.util.CustomReportError;
import com.runqian.base4.util.Escape;
import com.runqian.base4.util.Queue;
import com.runqian.base4.util.ReportError;
import com.runqian.base4.util.Sentence;
import com.runqian.base4.util.Stack;
import com.runqian.report4.dataset.DataSet;
import com.runqian.report4.model.engine.CSVariable;
import com.runqian.report4.model.engine.ExtCell;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.model.engine2.CSVariable2;
import com.runqian.report4.model.engine2.RowReport;
import com.runqian.report4.model.engine2.SrcCell;
import com.runqian.report4.model.expression.Constant;
import com.runqian.report4.model.expression.DSVariable;
import com.runqian.report4.model.expression.Function;
import com.runqian.report4.model.expression.FunctionLib;
import com.runqian.report4.model.expression.Node;
import com.runqian.report4.model.expression.ParamNode;
import com.runqian.report4.model.expression.UnknownSymbol;
import com.runqian.report4.model.expression.Variant2;
import com.runqian.report4.model.expression.lIlIIIlllIlIIlII;
import com.runqian.report4.model.expression.operator.Add;
import com.runqian.report4.model.expression.operator.Address;
import com.runqian.report4.model.expression.operator.And;
import com.runqian.report4.model.expression.operator.Comma;
import com.runqian.report4.model.expression.operator.DSMember;
import com.runqian.report4.model.expression.operator.Divide;
import com.runqian.report4.model.expression.operator.Equals;
import com.runqian.report4.model.expression.operator.Evaluate;
import com.runqian.report4.model.expression.operator.Greater;
import com.runqian.report4.model.expression.operator.In;
import com.runqian.report4.model.expression.operator.Link;
import com.runqian.report4.model.expression.operator.Mod;
import com.runqian.report4.model.expression.operator.Multiply;
import com.runqian.report4.model.expression.operator.Negative;
import com.runqian.report4.model.expression.operator.Not;
import com.runqian.report4.model.expression.operator.NotEquals;
import com.runqian.report4.model.expression.operator.NotGreater;
import com.runqian.report4.model.expression.operator.NotSmaller;
import com.runqian.report4.model.expression.operator.Or;
import com.runqian.report4.model.expression.operator.Plus;
import com.runqian.report4.model.expression.operator.Smaller;
import com.runqian.report4.model.expression.operator.Subtract;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.IReport;
import java.util.Map;

public class Expression {
    protected String expStr;
    protected int location;
    protected Node home;
    protected Node preNode;

    public Expression(DataSet dataSet, Context context, String string) {
        this(null, dataSet, context, string);
    }

    public Expression(Node node) {
        this.home = node;
    }

    public Expression(Context context, String string) {
        this(null, null, context, string);
    }

    public Expression(IReport iReport, DataSet dataSet, Context context, String string) {
        this.expStr = string;
        this.location = 0;
        try {
            if (string != null) {
                this.create(iReport, dataSet, context);
                if (this.home != null) {
                    this.home = this.home.optimize(context);
                    return;
                }
            }
        }
        catch (ReportError reportError) {
            MessageManager messageManager = EngineMessage.get();
            reportError.setErrorMsg(String.valueOf(messageManager.getMessage("Expression.exp")) + string + messageManager.getMessage("Expression.middle") + reportError.getErrorMsg());
            throw reportError;
        }
    }

    public Expression(IReport iReport, DataSet dataSet, Context context, String string, boolean bl) {
        this.expStr = string;
        this.location = 0;
        try {
            if (string != null) {
                this.create(iReport, dataSet, context);
                if (bl && this.home != null) {
                    this.home = this.home.optimize(context);
                    return;
                }
            }
        }
        catch (ReportError reportError) {
            MessageManager messageManager = EngineMessage.get();
            reportError.setErrorMsg(String.valueOf(messageManager.getMessage("Expression.exp")) + string + messageManager.getMessage("Expression.middle") + reportError.getErrorMsg());
            throw reportError;
        }
    }

    public Expression(IReport iReport, Context context, String string) {
        this(iReport, null, context, string);
    }

    public Expression(String string) {
        this(null, null, null, string);
    }

    private boolean _$1() {
        int n = this.location;
        int n2 = this.expStr.length();
        while (n < n2 && Character.isWhitespace(this.expStr.charAt(n))) {
            ++n;
        }
        if (n >= n2) {
            return false;
        }
        return this.expStr.charAt(n) == '(';
    }

    private boolean _$1(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < '0' || c > '9') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Object calcExcelExp(Context context, boolean bl) {
        try {
            if (this.home == null) {
                return null;
            }
            return this.home.calcExcelExp(context, bl);
        }
        catch (ReportError reportError) {
            MessageManager messageManager = EngineMessage.get();
            reportError.setErrorMsg(String.valueOf(messageManager.getMessage("Expression.exp")) + this.expStr + messageManager.getMessage("Expression.middle") + reportError.getErrorMsg());
            throw reportError;
        }
    }

    public Object calculate(Context context, boolean bl) {
        try {
            if (this.home == null) {
                return null;
            }
            return this.home.calculate(context, bl);
        }
        catch (ReportError reportError) {
            ReportError reportError2 = reportError;
            if (!(reportError instanceof CustomReportError)) {
                MessageManager messageManager = EngineMessage.get();
                reportError2.setErrorMsg(String.valueOf(messageManager.getMessage("Expression.exp")) + this.expStr + messageManager.getMessage("Expression.middle") + reportError2.getErrorMsg());
            }
            throw reportError2;
        }
    }

    protected void create(IReport iReport, DataSet dataSet, Context context) {
        int n = this.expStr.length();
        Node node = null;
        int n2 = 0;
        block18: while (this.location < n) {
            Object object;
            char c = this.expStr.charAt(this.location);
            if (Character.isWhitespace(c)) {
                ++this.location;
                continue;
            }
            node = null;
            switch (c) {
                case '(': {
                    ++n2;
                    ++this.location;
                    continue block18;
                }
                case ')': {
                    if (--n2 < 0) {
                        object = EngineMessage.get();
                        throw new ReportError("(,)" + ((MessageManager)object).getMessage("Expression.illmacthed"));
                    }
                    ++this.location;
                    continue block18;
                }
                case '+': {
                    node = this.preNode != null && !this.preNode.isOperator() ? new Add() : new Plus();
                    ++this.location;
                    break;
                }
                case '-': {
                    node = this.preNode != null && !this.preNode.isOperator() ? new Subtract() : new Negative();
                    ++this.location;
                    break;
                }
                case '*': {
                    node = new Multiply();
                    ++this.location;
                    break;
                }
                case '/': {
                    node = new Divide();
                    ++this.location;
                    break;
                }
                case '=': {
                    ++this.location;
                    if (this.preNode == null) {
                        node = lIlIIIlllIlIIlII._$1(iReport, context, this.expStr.substring(this.location), this);
                        this.location = n;
                        break;
                    }
                    if (this.location < n && this.expStr.charAt(this.location) == '=') {
                        node = new Equals();
                        ++this.location;
                        break;
                    }
                    node = new Evaluate();
                    break;
                }
                case '!': {
                    ++this.location;
                    if (this.location < n && this.expStr.charAt(this.location) == '=') {
                        node = new NotEquals();
                        ++this.location;
                        break;
                    }
                    node = new Not();
                    break;
                }
                case '>': {
                    ++this.location;
                    if (this.location < n && this.expStr.charAt(this.location) == '=') {
                        node = new NotSmaller();
                        ++this.location;
                        break;
                    }
                    node = new Greater();
                    break;
                }
                case '<': {
                    ++this.location;
                    if (this.location < n && this.expStr.charAt(this.location) == '=') {
                        node = new NotGreater();
                        ++this.location;
                        break;
                    }
                    node = new Smaller();
                    break;
                }
                case '&': {
                    ++this.location;
                    if (this.location < n && this.expStr.charAt(this.location) == '&') {
                        node = new And();
                        ++this.location;
                        break;
                    }
                    node = new Address(iReport);
                    break;
                }
                case '|': {
                    ++this.location;
                    if (this.location < n && this.expStr.charAt(this.location) == '|') {
                        node = new Or();
                        ++this.location;
                        break;
                    }
                    object = EngineMessage.get();
                    throw new ReportError(String.valueOf(((MessageManager)object).getMessage("Expression.unknownSymbol")) + "|");
                }
                case ',': {
                    node = new Comma();
                    ++this.location;
                    break;
                }
                case ':': {
                    node = new Link(iReport);
                    ++this.location;
                    break;
                }
                case '%': {
                    node = new Mod();
                    ++this.location;
                    break;
                }
                case '.': {
                    if (this.preNode == null || this.preNode.isOperator()) {
                        node = this.createNode(iReport, dataSet, context);
                        break;
                    }
                    node = new DSMember();
                    ++this.location;
                    break;
                }
                default: {
                    node = this.createNode(iReport, dataSet, context);
                }
            }
            node.setInBrackets(n2);
            this.preNode = node;
            if (this.home == null) {
                this.home = node;
                continue;
            }
            object = this.home;
            Object object2 = null;
            while (object != null && ((Node)object).getPriority() < node.getPriority()) {
                object2 = object;
                object = ((Node)object).getRight();
            }
            node.setLeft((Node)object);
            if (object2 != null) {
                ((Node)object2).setRight(node);
                continue;
            }
            this.home = node;
        }
        if (n2 > 0) {
            MessageManager messageManager = EngineMessage.get();
            throw new ReportError("(,)" + messageManager.getMessage("Expression.illmacthed"));
        }
    }

    protected Node createDSNode(IReport iReport, DataSet dataSet, String string, Context context, boolean bl) {
        if (this._$1()) {
            if (bl && FunctionLib.isDSFunName(string)) {
                Function function = FunctionLib.newDSFunction(string, dataSet);
                function.setParameter(iReport, dataSet, context, this.scanParameter(context));
                return function;
            }
            if (this.preNode instanceof DSMember) {
                MessageManager messageManager = EngineMessage.get();
                throw new ReportError(String.valueOf(messageManager.getMessage("Expression.unknownDataSet")) + string);
            }
        } else if (dataSet != null) {
            int n = Expression.getDSColNo(dataSet, string, context);
            if (n >= 0) {
                return new DSVariable(dataSet, n);
            }
            return lIlIIIlllIlIIlII._$1(iReport, context, dataSet, string);
        }
        return null;
    }

    protected Node createNode(IReport iReport, DataSet dataSet, Context context) {
        Object object;
        char c = this.expStr.charAt(this.location);
        int n = -1;
        if (c == '\"' || c == '\'') {
            n = Sentence.scanQuotation(this.expStr, this.location);
            if (n == -1) {
                MessageManager messageManager = EngineMessage.get();
                throw new ReportError("\",'" + messageManager.getMessage("Expression.illmacthed"));
            }
            String string = this.expStr.substring(this.location + 1, n);
            this.location = n + 1;
            return new Constant(Escape.remove(string));
        }
        if (iReport != null && c == '{') {
            n = Sentence.scanBrace(this.expStr, this.location);
            if (n == -1) {
                MessageManager messageManager = EngineMessage.get();
                throw new ReportError("{,}" + messageManager.getMessage("Expression.illmacthed"));
            }
            Function function = FunctionLib.newFunction("select");
            function.setParameter(iReport, dataSet, context, this.expStr.substring(this.location + 1, n));
            this.location = n + 1;
            return function;
        }
        if (c == '[') {
            Function function;
            n = Sentence.scanBracket(this.expStr, this.location);
            if (n == -1) {
                MessageManager messageManager = EngineMessage.get();
                throw new ReportError("[,]" + messageManager.getMessage("Expression.illmacthed"));
            }
            if (this.preNode instanceof CSVariable) {
                if (iReport == null) {
                    MessageManager messageManager = EngineMessage.get();
                    throw new ReportError(String.valueOf(messageManager.getMessage("Expression.unknownExpression")) + "[,]");
                }
                function = FunctionLib.newFunction("move");
            } else if (this.preNode instanceof CSVariable2) {
                if (iReport == null) {
                    MessageManager messageManager = EngineMessage.get();
                    throw new ReportError(String.valueOf(messageManager.getMessage("Expression.unknownExpression")) + "[,]");
                }
                function = FunctionLib.newFunction("move2");
            } else {
                function = this.preNode != null ? FunctionLib.newFunction("offset") : FunctionLib.newFunction("list");
            }
            function.setParameter(iReport, dataSet, context, this.expStr.substring(this.location + 1, n));
            this.location = n + 1;
            return function;
        }
        String string = this.scanId();
        if (string.equalsIgnoreCase("and")) {
            return new And();
        }
        if (string.equalsIgnoreCase("or")) {
            return new Or();
        }
        if (string.equalsIgnoreCase("not")) {
            return new Not();
        }
        if (string.equalsIgnoreCase("in")) {
            return new In();
        }
        DataSet dataSet2 = dataSet;
        int n2 = string.indexOf(46);
        if (n2 > 0) {
            object = string.substring(0, n2);
            if (!Sentence.checkIdentifier((String)object) && !this._$1((String)object)) {
                MessageManager messageManager = EngineMessage.get();
                throw new ReportError(messageManager.getMessage("Identifier.DSName", object));
            }
            dataSet2 = context.getDataSet((String)object);
            if (dataSet2 != null) {
                Node node = this.createDSNode(iReport, dataSet2, string = string.substring(n2 + 1), context, true);
                if (node != null) {
                    return node;
                }
                MessageManager messageManager = EngineMessage.get();
                throw new ReportError(String.valueOf(messageManager.getMessage("Expression.unknownDataSet")) + string);
            }
        }
        if ((c = string.charAt(0)) == '@') {
            if (string.length() >= 2 && string.charAt(1) == '@') {
                string = string.substring(2);
                return new Constant(context.getParamValue(string));
            }
            if (context.isParamName(string = string.substring(1))) {
                return new Constant(context.getParamValue(string));
            }
            object = EngineMessage.get();
            throw new ReportError(String.valueOf(((MessageManager)object).getMessage("Expression.unknownParam")) + "@" + string);
        }
        if (c == '$') {
            string = string.substring(1);
            if (iReport instanceof ExtCellSet) {
                object = ((ExtCellSet)iReport).getSource(string);
                if (object != null) {
                    return new CSVariable((ExtCell)object, true);
                }
            } else if (iReport instanceof RowReport && (object = ((RowReport)iReport).getSource(string)) != null) {
                return new CSVariable2((SrcCell)object, true);
            }
            object = EngineMessage.get();
            throw new ReportError(String.valueOf(((MessageManager)object).getMessage("Expression.unknownCell")) + "$" + string);
        }
        if (iReport instanceof ExtCellSet) {
            object = ((ExtCellSet)iReport).getSource(string);
            if (object != null) {
                return new CSVariable((ExtCell)object, false);
            }
        } else if (iReport instanceof RowReport && (object = ((RowReport)iReport).getSource(string)) != null) {
            return new CSVariable2((SrcCell)object, false);
        }
        if (dataSet != null && (object = this.createDSNode(iReport, dataSet, string, context, false)) != null) {
            return object;
        }
        if (this.preNode instanceof DSMember && (object = this.createDSNode(iReport, null, string, context, true)) != null) {
            return object;
        }
        if (this._$1()) {
            if (FunctionLib.isFunName(string)) {
                object = FunctionLib.newFunction(string);
                ((Function)object).setParameter(iReport, dataSet, context, this.scanParameter(context));
                return object;
            }
            if (dataSet != null && (object = this.createDSNode(iReport, null, string, context, true)) != null) {
                return object;
            }
            object = EngineMessage.get();
            throw new ReportError(String.valueOf(((MessageManager)object).getMessage("Expression.unknownFunction")) + string);
        }
        if (context.isParamName(string)) {
            return new ParamNode(string, context.getParamValue(string));
        }
        object = Variant2.parse(string);
        if (object instanceof String) {
            return new UnknownSymbol((String)object);
        }
        return new Constant(object);
    }

    public static int getDSColNo(DataSet dataSet, String string, Context context) {
        String string2;
        Object object;
        int n = -1;
        if (string != null && string.charAt(0) == '#' && (object = Variant2.parse(string2 = string.substring(1))) instanceof Number && (n = ((Number)object).intValue()) >= 0 && n <= dataSet.getColCount()) {
            return n;
        }
        n = dataSet.getColNo(string);
        if (n >= 0) {
            return n;
        }
        return dataSet.getColNoFromTitle(string);
    }

    public String getExp(Context context) {
        try {
            if (this.home == null) {
                return null;
            }
            return this.home.getExp(context);
        }
        catch (ReportError reportError) {
            MessageManager messageManager = EngineMessage.get();
            reportError.setErrorMsg(String.valueOf(messageManager.getMessage("Expression.exp")) + this.expStr + messageManager.getMessage("Expression.middle") + reportError.getErrorMsg());
            throw reportError;
        }
    }

    public Node getHome() {
        return this.home;
    }

    public byte getState() {
        if (this.home != null) {
            return this.home.getState();
        }
        return 4;
    }

    public boolean isDSFunction() {
        if (this.home != null) {
            return this.home.isDSFunction();
        }
        return false;
    }

    public boolean isDelayFun() {
        return this.home != null && this.home.isDelayFun();
    }

    public boolean isExtend() {
        if (this.home != null) {
            return this.home.isExtended();
        }
        return false;
    }

    public boolean isLayerCo() {
        return this.home != null && this.home.isLayerCo();
    }

    public boolean isLineCo() {
        return this.home != null && this.home.isLineCo();
    }

    public boolean isPlaneCo() {
        return this.home != null && this.home.isPlaneCo();
    }

    public boolean isSpecial() {
        return this.home != null && this.home.isSpecial();
    }

    public boolean isSpecialGroup() {
        return this.home != null && this.home.isSpecialGroup();
    }

    public void optimize(Context context) {
        if (this.home != null) {
            this.home = this.home.optimize(context);
        }
    }

    public void putDataSet(Map map) {
        if (this.home != null) {
            this.home.putDataSet(map);
        }
    }

    protected String scanId() {
        int n = this.expStr.length();
        int n2 = this.location;
        while (this.location < n) {
            char c = this.expStr.charAt(this.location);
            if (Character.isWhitespace(c) || c == '+' || c == '-' || c == '*' || c == '/' || c == '%' || c == '=' || c == '&' || c == '|' || c == '!' || c == ':' || c == ',' || c == '>' || c == '<' || c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}') break;
            ++this.location;
        }
        return this.expStr.substring(n2, this.location);
    }

    protected String scanParameter(Context context) {
        char c;
        int n = this.expStr.length();
        while (this.location < n) {
            c = this.expStr.charAt(this.location);
            if (!Character.isWhitespace(c)) break;
            ++this.location;
        }
        if (this.location == n) {
            MessageManager messageManager = EngineMessage.get();
            throw new ReportError(messageManager.getMessage("Expression.missingParam"));
        }
        c = this.expStr.charAt(this.location);
        if (c != '(') {
            MessageManager messageManager = EngineMessage.get();
            throw new ReportError(messageManager.getMessage("Expression.missingParam"));
        }
        int n2 = Sentence.scanParenthesis(this.expStr, this.location);
        if (n2 == -1) {
            MessageManager messageManager = EngineMessage.get();
            throw new ReportError("(,)" + messageManager.getMessage("Expression.illmacthed"));
        }
        String string = this.expStr.substring(this.location + 1, n2);
        this.location = n2 + 1;
        return string;
    }

    public void testValue(Queue queue, Stack stack) {
        if (this.home != null) {
            this.home.testValue(queue, stack);
        }
    }

    public String toString() {
        return this.expStr;
    }
}

