/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.model.expression;

import com.runqian.base4.resources.EngineMessage;
import com.runqian.base4.resources.MessageManager;
import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.ReportError;
import com.runqian.report4.dataset.DataSet;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.model.engine2.RowReport;
import com.runqian.report4.model.expression.ComputeColumn;
import com.runqian.report4.model.expression.Display;
import com.runqian.report4.model.expression.Expression;
import com.runqian.report4.model.expression.Function;
import com.runqian.report4.model.expression.FunctionLib;
import com.runqian.report4.model.expression.Node;
import com.runqian.report4.semantics.ComputedColInfo;
import com.runqian.report4.semantics.EditStyle;
import com.runqian.report4.semantics.EditStyleList;
import com.runqian.report4.semantics.SemanticsManager;
import com.runqian.report4.semantics.View;
import com.runqian.report4.semantics.ViewList;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.IReport;

class SemanticsExp {
    private static final int MASK_DESC = 3;
    private static final int MASK_FIELD = 895;
    private static final int MASK_HAVEVIEW = Short.MAX_VALUE;
    private static final int MASK_NULLGROUP = 24576;
    private static final int MASK_TERM = 32763;
    private static final int OPT_AVG = 16;
    private static final int OPT_COUNT = 128;
    private static final int OPT_DISPLAY = 32768;
    private static final int OPT_DISTINCT = 256;
    private static final int OPT_ENUMGROUP = 8192;
    private static final int OPT_FILTER = 2048;
    private static final int OPT_FILTERCROSS = 4096;
    private static final int OPT_FILTERONE = 1024;
    private static final int OPT_GROUP = 1;
    private static final int OPT_MAX = 32;
    private static final int OPT_MIN = 64;
    private static final int OPT_OVERLAPGROUP = 16384;
    private static final int OPT_SELECT = 2;
    private static final int OPT_SELECTONE = 512;
    private static final int OPT_SUM = 8;
    private static final int OPT_VALUE = 4;

    SemanticsExp() {
    }

    static Node createComputed(IReport cs, Context ctx, DataSet ds, String id) {
        ComputedColInfo info = SemanticsExp.getComputedColInfo(ctx, ds, id);
        if (info != null) {
            if (cs instanceof ExtCellSet) {
                ((ExtCellSet)cs).setSemanticsExpFlag(true);
            } else if (cs instanceof RowReport) {
                ((RowReport)cs).setSemanticsExpFlag(true);
            }
            return new ComputeColumn(cs, ds, ctx, info.getColExp());
        }
        return null;
    }

    static Node createSemantic(IReport cs, Context ctx, String exp, Expression ept) {
        Node node = null;
        if (cs instanceof ExtCellSet) {
            ((ExtCellSet)cs).setSemanticsExpFlag(true);
        } else if (cs instanceof RowReport) {
            ((RowReport)cs).setSemanticsExpFlag(true);
        }
        ArgumentTokenizer at = new ArgumentTokenizer(exp, ';');
        if (!at.hasNext()) {
            MessageManager mm = EngineMessage.get();
            throw new ReportError(mm.getMessage("Expression.missingOption"));
        }
        int opt = SemanticsExp.getType(at.next().trim(), ctx);
        if ((opt & Short.MAX_VALUE) != 0) {
            DataSet ds = null;
            if (at.hasNext()) {
                ds = ctx.getDataSet(at.next().trim());
            }
            if (ds == null) {
                MessageManager mm = EngineMessage.get();
                throw new ReportError(mm.getMessage("Expression.missingDataSet"));
            }
            String param = "";
            boolean flag = false;
            if ((opt & 0x37F) != 0) {
                if (!at.hasNext()) {
                    MessageManager mm = EngineMessage.get();
                    throw new ReportError(mm.getMessage("Expression.missingField"));
                }
                param = at.next().trim();
                if (opt == 4) {
                    return ept.createDSNode(cs, ds, param, ctx, true);
                }
                if ((opt & 3) != 0 && at.hasNext()) {
                    param = param + "," + at.next().trim();
                }
                flag = true;
            } else if ((opt & 0x6000) != 0) {
                if (!at.hasNext()) {
                    MessageManager mm = EngineMessage.get();
                    throw new ReportError(mm.getMessage("Expression.missingNullGroup"));
                }
                param = at.next().trim();
                flag = true;
            }
            if ((opt & 0x7FFB) != 0) {
                if (at.hasNext()) {
                    if (flag) {
                        param = param + ",";
                    }
                    param = param + at.next().trim();
                }
                String funName = SemanticsExp.getFunction(opt, ctx);
                node = FunctionLib.newDSFunction(funName, ds);
                ((Function)node).setParameter(cs, ds, ctx, param);
            }
        } else if (opt == 32768) {
            SemanticsManager sm = ctx.getSemanticsManager();
            if (at.hasNext() && sm != null) {
                String styleName = at.next();
                EditStyle style = null;
                EditStyleList styleList = sm.getEditStyleList();
                if (styleName != null && styleName.length() > 0) {
                    style = styleList.get(styleName);
                }
                if (style != null) {
                    node = new Display(cs, style.getEditConfig());
                }
            }
        }
        return node;
    }

    private static ComputedColInfo getComputedColInfo(Context ctx, DataSet ds, String id) {
        View v;
        ViewList list;
        SemanticsManager sm = ctx.getSemanticsManager();
        if (sm != null && (list = sm.getViewList()) != null && (v = list.getView(ds.getDataSetName())) != null) {
            return v.getComputedColInfo(id);
        }
        return null;
    }

    private static String getFunction(int opt, Context ctx) {
        if (1 == opt) {
            return "group";
        }
        if (2 == opt) {
            return "select";
        }
        if (128 == opt) {
            return "count";
        }
        if (8 == opt) {
            return "sum";
        }
        if (16 == opt) {
            return "avg";
        }
        if (32 == opt) {
            return "max";
        }
        if (64 == opt) {
            return "min";
        }
        if (512 == opt) {
            return "select1";
        }
        if (1024 == opt) {
            return "filter1";
        }
        if (2048 == opt) {
            return "filter";
        }
        if (4096 == opt) {
            return "filterCross";
        }
        if (8192 == opt) {
            return "enumGroup";
        }
        if (256 == opt) {
            return "dcount";
        }
        if (16384 == opt) {
            return "overlap";
        }
        MessageManager mm = EngineMessage.get();
        throw new ReportError(mm.getMessage("Expression.unknownOption") + opt);
    }

    private static int getType(String str, Context ctx) {
        if ("\u5206\u7ec4".equals(str) || "Group".equals(str)) {
            return 1;
        }
        if ("\u5217\u8868".equals(str) || "Select".equals(str)) {
            return 2;
        }
        if ("\u53d6\u503c".equals(str) || "Value".equals(str)) {
            return 4;
        }
        if ("\u8ba1\u6570".equals(str) || "Count".equals(str)) {
            return 128;
        }
        if ("\u6c42\u548c".equals(str) || "Sum".equals(str)) {
            return 8;
        }
        if ("\u5e73\u5747".equals(str) || "Avg".equals(str)) {
            return 16;
        }
        if ("\u6700\u5927".equals(str) || "Max".equals(str)) {
            return 32;
        }
        if ("\u6700\u5c0f".equals(str) || "Min".equals(str)) {
            return 64;
        }
        if ("\u5355\u9009".equals(str) || "SelectOne".equals(str)) {
            return 512;
        }
        if ("\u4e00\u5bf9\u4e00".equals(str) || "FilterOne".equals(str)) {
            return 1024;
        }
        if ("\u4e00\u5bf9\u591a".equals(str) || "Filter".equals(str)) {
            return 2048;
        }
        if ("\u591a\u5bf9\u591a".equals(str) || "FilterCross".equals(str)) {
            return 4096;
        }
        if ("\u679a\u4e3e".equals(str) || "EnumGroup".equals(str)) {
            return 8192;
        }
        if ("\u663e\u793a".equals(str) || "Display".equals(str)) {
            return 32768;
        }
        if ("\u5355\u8ba1".equals(str) || "CountDistinct".equals(str)) {
            return 256;
        }
        if ("\u53e0\u4e3e".equals(str) || "EnumGroupOverlap".equals(str)) {
            return 16384;
        }
        MessageManager mm = EngineMessage.get();
        throw new ReportError(mm.getMessage("Expression.unknownOption") + str);
    }
}

