/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.print;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.servlet.ServletContext;

public class Directory {
    public static boolean createFileByFile(File parent, String fileName, byte[] b) throws Exception {
        if (!parent.exists() && !parent.mkdirs()) {
            throw new Exception("\u521b\u5efa\u6587\u4ef6\u76ee\u5f55\u5931\u8d25\uff01");
        }
        fileName = parent.getAbsolutePath() + File.separator + fileName;
        File file = new File(fileName);
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(b);
        fos.flush();
        fos.close();
        return true;
    }

    public static boolean createFileByRelative(ServletContext application, String path, String fileName, byte[] b) throws Exception {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String realPath = application.getRealPath(path);
        File file = new File(realPath);
        return Directory.createFileByFile(file, fileName, b);
    }

    public static boolean createFileByRelative(ServletContext application, String path, String fileName, String content) throws Exception {
        return Directory.createFileByRelative(application, path, fileName, content.getBytes());
    }

    public static String createTempFile(File dir, String prefix, String suffix, String content) {
        try {
            File file = File.createTempFile(prefix, suffix, dir);
            PrintWriter pw = new PrintWriter(new FileOutputStream(file), true);
            pw.print(content);
            pw.close();
            file.deleteOnExit();
            return file.getName();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return "";
        }
    }

    public static boolean deleteDirByFile(File file) throws Exception {
        if (!file.exists()) {
            return false;
        }
        if (file == null || !file.isDirectory()) {
            throw new Exception("\u6587\u4ef6\u5bf9\u8c61\u4e3a\u7a7a\u6216\u4e0d\u662f\u6587\u4ef6\u5939! ");
        }
        File[] child = file.listFiles();
        int i = 0;
        while (i < child.length) {
            if (child[i].isFile() && !child[i].delete()) {
                return false;
            }
            if (child[i].isDirectory()) {
                return Directory.deleteDirByFile(child[i]);
            }
            ++i;
        }
        return file.delete();
    }

    public static boolean deleteDirByRelative(ServletContext application, String path) throws Exception {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String realPath = application.getRealPath(path);
        File file = new File(realPath);
        return Directory.deleteDirByFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileContent(File file) {
        String string;
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String content = "";
                String tmp = null;
                while (true) {
                    if ((tmp = br.readLine()) == null) {
                        string = content;
                        Object var6_7 = null;
                        break;
                    }
                    content = content + tmp + "\n";
                }
            }
            catch (Exception e) {
                String string2 = "";
                Object var6_8 = null;
                try {
                    if (br == null) return string2;
                    br.close();
                    return string2;
                }
                catch (Exception e2) {
                }
                return string2;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {}
            catch (Exception e2) {
                throw throwable;
            }
            if (br == null) throw throwable;
            br.close();
            throw throwable;
        }
        try {}
        catch (Exception e2) {
            return string;
        }
        if (br == null) return string;
        br.close();
        return string;
    }

    public static boolean mergeDirByFile(File merged, File mergeTo) throws Exception {
        if (!merged.exists() || !mergeTo.exists()) {
            return false;
        }
        if (merged == null || !merged.isDirectory()) {
            throw new Exception("\u60f3\u79fb\u52a8\u7684\u6587\u4ef6\u5bf9\u8c61\u4e3a\u7a7a\u6216\u4e0d\u662f\u6587\u4ef6\u5939! ");
        }
        if (mergeTo == null || !mergeTo.isDirectory()) {
            throw new Exception("\u76ee\u7684\u6587\u4ef6\u5bf9\u8c61\u4e3a\u7a7a\u6216\u4e0d\u662f\u6587\u4ef6\u5939! ");
        }
        File[] child = merged.listFiles();
        int i = 0;
        while (i < child.length) {
            File destDir = new File(mergeTo.getAbsolutePath() + File.separator + child[i].getName());
            if (destDir.exists() && destDir.isFile()) {
                destDir = new File(destDir.getAbsolutePath() + "-moved");
            }
            if (child[i].isFile() && !child[i].renameTo(destDir)) {
                return false;
            }
            if (child[i].isDirectory()) {
                if (!destDir.exists() && !destDir.mkdir()) {
                    return false;
                }
                if (!Directory.mergeDirByFile(child[i], destDir)) {
                    return false;
                }
            }
            ++i;
        }
        return Directory.deleteDirByFile(merged);
    }

    public static boolean mergeDirByRelative(ServletContext application, String mergedPath, String mergeToPath) throws Exception {
        if (!mergedPath.startsWith("/")) {
            mergedPath = "/" + mergedPath;
        }
        if (!mergeToPath.startsWith("/")) {
            mergeToPath = "/" + mergeToPath;
        }
        String realPath = application.getRealPath(mergedPath);
        File merged = new File(realPath);
        realPath = application.getRealPath(mergeToPath);
        File mergeTo = new File(realPath);
        return Directory.mergeDirByFile(merged, mergeTo);
    }

    public static boolean moveDirByFile(File moved, File moveTo) throws Exception {
        if (!moved.exists() || !moveTo.exists()) {
            return false;
        }
        if (moved == null || !moved.isDirectory()) {
            throw new Exception("\u60f3\u79fb\u52a8\u7684\u6587\u4ef6\u5bf9\u8c61\u4e3a\u7a7a\u6216\u4e0d\u662f\u6587\u4ef6\u5939! ");
        }
        if (moveTo == null || !moveTo.isDirectory()) {
            throw new Exception("\u76ee\u7684\u6587\u4ef6\u5bf9\u8c61\u4e3a\u7a7a\u6216\u4e0d\u662f\u6587\u4ef6\u5939! ");
        }
        File destDir = new File(moveTo.getAbsolutePath() + File.separator + moved.getName());
        if (destDir.exists() && destDir.isFile()) {
            destDir = new File(destDir.getAbsolutePath() + "-moved");
        }
        if (!destDir.exists() && !destDir.mkdir()) {
            return false;
        }
        return Directory.mergeDirByFile(moved, destDir);
    }

    public static boolean moveDirByRelative(ServletContext application, String movedPath, String moveToPath) throws Exception {
        if (!movedPath.startsWith("/")) {
            movedPath = "/" + movedPath;
        }
        if (!moveToPath.startsWith("/")) {
            moveToPath = "/" + moveToPath;
        }
        String realPath = application.getRealPath(movedPath);
        File moved = new File(realPath);
        realPath = application.getRealPath(moveToPath);
        File moveTo = new File(realPath);
        return Directory.moveDirByFile(moved, moveTo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateFileContent(File file, String content, boolean append) throws Exception {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileOutputStream(file.getAbsolutePath(), append), true);
            pw.print(content);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Exception e) {
            }
            throw throwable;
        }
        try {
            if (pw != null) {
                pw.close();
            }
        }
        catch (Exception e) {
        }
    }
}

