/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.print;

import com.runqian.report4.control.PrintFrame;
import com.runqian.report4.print.Directory;
import com.runqian.report4.print.Main;
import com.runqian.report4.print.OptionDialog;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.util.ReportUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class HistoryRat
extends JPanel
implements ActionListener,
MouseListener {
    private String currDay;
    private JButton delDirs;
    private JButton delRats;
    private JList dirList;
    private JFrame frame;
    private JButton optionsBtn;
    private String path;
    private JButton quitBtn;
    private JList ratList;
    private JButton scanBtn;
    private JButton updateBtn;

    public HistoryRat(JFrame frame) throws Exception {
        File[] fs;
        this.frame = frame;
        this.path = Main.config.getProperty("cacheDir");
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u62a5\u8868\u7f13\u5b58\u65e5\u671f"), this.createBaseGBC(1, 1, 1, 1));
        panel.add((Component)new JLabel("\u67d0\u65e5\u7f13\u5b58\u62a5\u8868"), this.createBaseGBC(1, 2, 1, 1));
        DefaultListModel<String> model = new DefaultListModel<String>();
        File dir = new File(this.path);
        if (dir.exists() && (fs = dir.listFiles()) != null) {
            int i = 0;
            while (i < fs.length) {
                if (fs[i].isDirectory()) {
                    model.addElement(fs[i].getName());
                }
                ++i;
            }
        }
        this.dirList = new JList(model);
        this.dirList.addMouseListener(this);
        JScrollPane jsp = new JScrollPane(this.dirList, 20, 30);
        jsp.setPreferredSize(new Dimension(140, 100));
        GridBagConstraints gbc = this.createBaseGBC(2, 1, 1, 1);
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel.add((Component)jsp, gbc);
        this.ratList = new JList();
        this.ratList.addMouseListener(this);
        JScrollPane jsp1 = new JScrollPane(this.ratList, 20, 30);
        GridBagConstraints gbc1 = this.createBaseGBC(2, 2, 1, 1);
        gbc1.weighty = 1.0;
        gbc1.weightx = 1.0;
        gbc1.fill = 1;
        panel.add((Component)jsp1, gbc1);
        this.add((Component)panel, "Center");
        JPanel panel1 = new JPanel(new FlowLayout(3, 5, 12));
        panel1.add(new JLabel("\u3000"));
        this.scanBtn = this.createButton("\u9884\u89c8\u62a5\u8868");
        panel1.add(this.scanBtn);
        this.delDirs = this.createButton("\u5220\u9664\u6240\u9009\u65e5\u671f");
        panel1.add(this.delDirs);
        this.delRats = this.createButton("\u5220\u9664\u6240\u9009\u62a5\u8868");
        panel1.add(this.delRats);
        JPanel emptyPanel = new JPanel();
        emptyPanel.setPreferredSize(new Dimension(90, 50));
        panel1.add(emptyPanel);
        this.updateBtn = this.createButton("\u68c0\u67e5\u66f4\u65b0");
        panel1.add(this.updateBtn);
        this.optionsBtn = this.createButton("\u7cfb\u7edf\u9009\u9879");
        panel1.add(this.optionsBtn);
        this.quitBtn = this.createButton("\u9000\u3000\u3000\u51fa");
        panel1.add(this.quitBtn);
        panel1.setPreferredSize(new Dimension(100, 100));
        this.add((Component)panel1, "East");
    }

    public void actionPerformed(ActionEvent e) {
        try {
            Object o = e.getSource();
            if (o.equals(this.scanBtn)) {
                Object value = this.ratList.getSelectedValue();
                if (value != null) {
                    this.scanReport(value.toString());
                }
            } else if (o.equals(this.delDirs)) {
                int[] ids = this.dirList.getSelectedIndices();
                int i = ids.length - 1;
                while (i >= 0) {
                    String day = this.dirList.getModel().getElementAt(ids[i]).toString();
                    File file = new File(this.path, day);
                    if (Directory.deleteDirByFile(file)) {
                        ((DefaultListModel)this.dirList.getModel()).removeElementAt(ids[i]);
                    }
                    --i;
                }
            } else if (o.equals(this.delRats)) {
                int[] ids = this.ratList.getSelectedIndices();
                int i = ids.length - 1;
                while (i >= 0) {
                    String name = this.ratList.getModel().getElementAt(ids[i]).toString();
                    File file = new File(this.path + "\\" + this.currDay + "\\" + name);
                    if (file.delete()) {
                        ((DefaultListModel)this.ratList.getModel()).removeElementAt(ids[i]);
                    }
                    --i;
                }
            } else if (o.equals(this.quitBtn)) {
                System.exit(0);
            } else if (o.equals(this.updateBtn)) {
                int result = Main.update();
                if (result == 1) {
                    JOptionPane.showMessageDialog(this.frame, "\u7a0b\u5e8f\u5df2\u66f4\u65b0\uff0c\u91cd\u542f\u7a0b\u5e8f\u540e\u751f\u6548");
                } else if (result == 2) {
                    JOptionPane.showMessageDialog(this.frame, "\u6ca1\u6709\u68c0\u6d4b\u5230\u65b0\u7248\u672c");
                }
            } else if (o.equals(this.optionsBtn)) {
                OptionDialog f = new OptionDialog(this.frame);
                Dimension size = f.getSize();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                int newX = (screenSize.width - size.width) / 2;
                int newY = (screenSize.height - size.height) / 2;
                f.setLocation(newX, newY);
                f.show();
            }
        }
        catch (Exception ex) {
            Main.dispError(ex);
        }
    }

    private GridBagConstraints createBaseGBC(int rowIndex, int colIndex, int rowSpan, int colSpan) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = colIndex;
        gbc.gridy = rowIndex;
        gbc.gridwidth = colSpan;
        gbc.gridheight = rowSpan;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 3, 5);
        gbc.fill = 2;
        return gbc;
    }

    private JButton createButton(String label) {
        JButton b = new JButton(label);
        b.setPreferredSize(new Dimension(90, 25));
        b.setMargin(new Insets(2, 3, 2, 3));
        b.addActionListener(this);
        return b;
    }

    public void mouseClicked(MouseEvent e) {
        Object o = e.getSource();
        if (o.equals(this.dirList)) {
            int index = this.dirList.locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            String d = this.dirList.getModel().getElementAt(index).toString();
            File f = new File(this.path, d);
            File[] fs = f.listFiles();
            DefaultListModel<String> model = new DefaultListModel<String>();
            int i = 0;
            while (i < fs.length) {
                model.addElement(fs[i].getName());
                ++i;
            }
            this.ratList.setModel(model);
            this.currDay = d;
        } else if (o.equals(this.ratList) && e.getClickCount() > 1) {
            int index = this.ratList.locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            String rat = this.ratList.getModel().getElementAt(index).toString();
            this.scanReport(rat);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private void scanReport(String name) {
        try {
            IReport report = ReportUtils.read(this.path + "\\" + this.currDay + "\\" + name);
            PrintFrame pf = new PrintFrame(report, "", null, null, false, this.frame);
            pf.show();
        }
        catch (Throwable t) {
            Main.dispError(t);
        }
    }
}

