/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.print;

import com.runqian.base4.resources.MessageManager;
import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.Native2Ascii;
import com.runqian.report4.control.ControlUtils;
import com.runqian.report4.control.PrintFrame;
import com.runqian.report4.print.ManageFrame;
import com.runqian.report4.print.Registery;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.util.ReportUtils;
import com.runqian.report4.view.applet.GroupPrintDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class Main {
    private String appRoot;
    private String cachedId;
    public static Properties config;
    private String dataServlet;
    private String directPrint;
    private String fileName;
    private String isGroup;
    private static JFrame mainFrame;
    private String mirror;
    private MessageManager mm;
    private String needSave;
    private String needSelectPrinter;
    private HashMap params = new HashMap();
    private String reportParamsId;
    private String reportTitles;
    private String saveAsName;
    private String savePrintSetup;
    private String serverPagedPrint;
    private String sessionId;
    private String srcType;
    private String updateServer;
    private String updateServerMsg;
    private String userUnitName;

    public Main() {
        this.mm = MessageManager.getManager("com.runqian.base4.resources.print");
        try {
            System.setProperty("java.awt.im.style", "on-the-spot");
            String installPath = Registery.getKeyValue("HKEY_LOCAL_MACHINE\\\\SOFTWARE\\Classes\\RQLocalPrint", "installpath");
            FileInputStream fis = new FileInputStream(installPath + "\\config.ini");
            config = new Properties();
            config.load(fis);
            config.put("installPath", installPath);
            String cacheDir = config.getProperty("cacheDir");
            if (cacheDir == null || cacheDir.trim().length() == 0) {
                config.put("cacheDir", installPath + "\\history");
            }
        }
        catch (Exception e) {
            Main.dispError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void dispError(Throwable t) {
        block8: {
            FileOutputStream fos = null;
            fos = new FileOutputStream(config.getProperty("installPath") + "\\log.txt", true);
            PrintWriter pw = new PrintWriter(fos, true);
            pw.println();
            pw.println("\u9519\u8bef\u53d1\u751f\u65f6\u95f4\uff1a" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            t.printStackTrace(pw);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintWriter(baos, true));
            String msg = "\u51fa\u73b0\u9519\u8bef\uff0c\u8be6\u60c5\u8bf7\u770b\u65e5\u5fd7\u6587\u4ef6log.txt\n" + t.getMessage();
            JOptionPane.showMessageDialog(mainFrame, msg);
            Object var6_6 = null;
            try {
                fos.close();
            }
            catch (Exception e2) {
            }
            break block8;
            {
                catch (Exception e) {
                    Object var6_7 = null;
                    try {
                        fos.close();
                    }
                    catch (Exception e2) {
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    fos.close();
                }
                catch (Exception e2) {
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String server, String fileName) throws Exception {
        String installPath = config.getProperty("installPath");
        FileOutputStream fos = null;
        try {
            URL url = new URL(server + "/RQLocalPrint/" + fileName);
            byte[] b = ControlUtils.getStreamBytes(url.openStream());
            fos = new FileOutputStream(installPath + "\\" + fileName);
            fos.write(b);
            fos.flush();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                fos.close();
            }
            catch (Exception e) {
            }
            throw throwable;
        }
        try {
            fos.close();
        }
        catch (Exception e) {
        }
    }

    private String getParameter(String key, String def) {
        String value = (String)this.params.get(key);
        return value != null ? value : def;
    }

    private void initParameters() {
        this.appRoot = this.getParameter("appRoot", null);
        this.dataServlet = this.getParameter("dataServlet", "");
        this.fileName = this.getParameter("fileName", "");
        if (this.fileName != null) {
            this.fileName = Native2Ascii.decode(this.fileName);
        }
        this.srcType = this.getParameter("srcType", "file");
        this.reportParamsId = this.getParameter("reportParamsId", null);
        this.cachedId = this.getParameter("cachedId", null);
        this.userUnitName = this.getParameter("unitName", "");
        if (this.userUnitName != null) {
            this.userUnitName = Native2Ascii.decode(this.userUnitName);
        }
        this.savePrintSetup = this.getParameter("savePrintSetup", "no");
        this.isGroup = this.getParameter("isGroup", "0");
        this.reportTitles = this.getParameter("reportTitles", null);
        this.needSelectPrinter = this.getParameter("needSelectPrinter", "yes");
        this.serverPagedPrint = this.getParameter("serverPagedPrint", "no");
        this.mirror = this.getParameter("mirror", "no");
        this.sessionId = this.getParameter("sessionId", null);
        this.directPrint = this.getParameter("directPrint", null);
        this.needSave = this.getParameter("needSave", "no");
        this.saveAsName = this.getParameter("saveAsName", null);
        this.updateServer = this.getParameter("updateServer", null);
        this.updateServerMsg = this.getParameter("updateServerMsg", "yes");
    }

    public static void main(String[] args) {
        Main m = new Main();
        if (args.length > 0) {
            m.setParams(args[0]);
        }
        try {
            Main.setLNFFonts();
            m.start();
        }
        catch (Throwable e) {
            Main.dispError(e);
        }
    }

    private void save(IReport report) {
        String needSaveCfg = config.getProperty("needSave", "1");
        if (!"1".equals(needSaveCfg)) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date d = new Date();
        String dir = sdf.format(d);
        sdf = new SimpleDateFormat("HH\u65f6mm\u5206ss\u79d2");
        this.saveAsName = this.saveAsName == null ? this.fileName : Native2Ascii.decode(this.saveAsName);
        String name = this.saveAsName + "__" + sdf.format(d) + ".rat";
        File f = new File(config.getProperty("cacheDir") + "\\" + dir);
        f.mkdirs();
        try {
            ReportUtils.write(f.getAbsolutePath() + "\\" + name, report);
        }
        catch (Throwable t) {
            Main.dispError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void saveConfig() {
        block8: {
            String path = config.getProperty("installPath");
            FileOutputStream fos = null;
            fos = new FileOutputStream(path + "\\config.ini");
            config.store(fos, "");
            Object var4_2 = null;
            try {
                fos.close();
            }
            catch (Exception e2) {
            }
            break block8;
            {
                catch (Exception e) {
                    Main.dispError(e);
                    Object var4_3 = null;
                    try {
                        fos.close();
                    }
                    catch (Exception e2) {
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    fos.close();
                }
                catch (Exception e2) {
                }
                throw throwable;
            }
        }
    }

    public static void setLNFFonts() {
        Font font = new Font("Dialog", 0, 12);
        Enumeration keys = UIManager.getLookAndFeelDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!(UIManager.get(key) instanceof Font)) continue;
            UIManager.put(key, font);
        }
    }

    public void setParams(String s) {
        int pos = s.indexOf("/");
        if ((s = s.substring(pos + 2)).endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        ArgumentTokenizer at = new ArgumentTokenizer(s, '&');
        while (at.hasMoreTokens()) {
            String tmp = at.nextToken();
            pos = tmp.indexOf("=");
            String key = tmp.substring(0, pos);
            String value = tmp.substring(pos + 1);
            this.params.put(key, value);
        }
        this.initParameters();
    }

    public void start() throws Throwable {
        if (this.updateServer != null) {
            config.setProperty("server", this.updateServer);
            Main.saveConfig();
            if (!"no".equals(this.updateServerMsg)) {
                JOptionPane.showMessageDialog(null, "\u66f4\u65b0\u670d\u52a1\u5668\u5730\u5740\u5df2\u4fdd\u5b58\u5230\u672c\u673a\u6253\u5370\u7ba1\u7406\u7cfb\u7edf\u4e2d");
                System.exit(0);
            }
        }
        if (this.appRoot != null) {
            mainFrame = new JFrame("\u6253\u5370\u62a5\u8868");
            mainFrame.setDefaultCloseOperation(3);
            if (this.directPrint == null) {
                mainFrame.setSize(300, 100);
                mainFrame.setLocation(250, 250);
                mainFrame.setVisible(true);
                mainFrame.getContentPane().setLayout(new BorderLayout());
                JLabel label = new JLabel(this.mm.getMessage("applet.flashText"));
                label.setForeground(Color.red);
                label.setHorizontalAlignment(0);
                label.setFont(new Font("Dialog", 0, 12));
                mainFrame.getContentPane().add(label);
                mainFrame.show();
            }
            if ("1".equals(this.isGroup)) {
                GroupPrintDialog gpd = new GroupPrintDialog((Frame)mainFrame, this.userUnitName);
                gpd.setFileName(this.fileName);
                gpd.setAppRoot(this.appRoot);
                gpd.setDataServlet(this.dataServlet);
                gpd.setReportParamsId(this.reportParamsId);
                ArgumentTokenizer at = new ArgumentTokenizer(this.reportTitles, ',');
                String[] tmp = new String[at.countTokens()];
                int i = 0;
                while (i < tmp.length) {
                    tmp[i] = at.nextToken();
                    ++i;
                }
                gpd.setReportTitles(tmp);
                gpd.setNeedSelectPrinter("yes".equalsIgnoreCase(this.needSelectPrinter));
                gpd.setNeedExit(true);
                gpd.showDialog();
                mainFrame.setLocation(-350, 250);
            } else if (!"no".equalsIgnoreCase(this.serverPagedPrint)) {
                PrintFrame f = new PrintFrame(this.cachedId, this.userUnitName, this.appRoot, this.fileName, this.srcType, this.reportParamsId, mainFrame, null, this.sessionId);
                try {
                    f.setPagesPerTime(Integer.parseInt(this.serverPagedPrint));
                }
                catch (Exception e) {
                    // empty catch block
                }
                f.show();
                mainFrame.setLocation(-350, 250);
            } else {
                String dataServer = this.appRoot + this.dataServlet + "&fileName=" + Native2Ascii.encode(this.fileName) + "&srcType=" + this.srcType;
                if (this.reportParamsId != null) {
                    dataServer = dataServer + "&reportParamsId=" + this.reportParamsId;
                }
                if (this.cachedId != null) {
                    dataServer = dataServer + "&cachedId=" + this.cachedId;
                }
                dataServer = dataServer + "&time=" + new Date().getTime();
                URL url = new URL(dataServer);
                InputStream is = url.openStream();
                IReport report = ReportUtils.read(is);
                is.close();
                PrintFrame f = new PrintFrame(report, this.userUnitName, this.appRoot, this.fileName, this.savePrintSetup.equalsIgnoreCase("yes"), mainFrame, null);
                mainFrame.setLocation(-350, 250);
                if ("yes".equalsIgnoreCase(this.mirror)) {
                    f.setMirrorPrint(true);
                }
                f.setNeedExit(true);
                if ("yes".equalsIgnoreCase(this.needSave)) {
                    this.save(report);
                }
                if (this.directPrint != null) {
                    f.setModal(false);
                    f.setLocation(-1000, -1000);
                    f.show();
                    f.directPrint("yes".equalsIgnoreCase(this.needSelectPrinter));
                } else {
                    f.show();
                }
            }
        } else {
            try {
                mainFrame = new ManageFrame();
            }
            catch (Exception e) {
                Main.dispError(e);
                System.exit(0);
            }
            mainFrame.setSize(700, 560);
            Dimension size = mainFrame.getSize();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int newX = (screenSize.width - size.width) / 2;
            int newY = (screenSize.height - size.height) / 2;
            mainFrame.setLocation(newX, newY);
            mainFrame.show();
            String updateCfg = config.getProperty("update", "1");
            if ("1".equals(updateCfg) && Main.update() == 1) {
                String path = config.getProperty("installPath");
                Runtime.getRuntime().exec(path + "\\startPrint.exe");
                System.exit(0);
            }
        }
    }

    public static int update() {
        String server = config.getProperty("server");
        String version = config.getProperty("version");
        Properties p = new Properties();
        try {
            URL url = new URL(server + "/RQLocalPrint/version.txt");
            p.load(url.openStream());
        }
        catch (Exception e) {
            Main.dispError(new Exception("\u65e0\u6cd5\u8fde\u63a5\u7a0b\u5e8f\u66f4\u65b0\u670d\u52a1\u5668\uff0c\u7f51\u7edc\u4e0d\u901a\u3001\u670d\u52a1\u5668\u6ca1\u6709\u8fd0\u884c\u6216\u670d\u52a1\u5668\u5730\u5740\u8bbe\u7f6e\u9519\u8bef", e));
            return 2;
        }
        try {
            String ver = p.getProperty("version");
            if (ver.compareTo(version) > 0) {
                String msg = "\u670d\u52a1\u5668\u7248\u672c\u662f" + ver + ", \u672c\u673a\u7248\u672c\u662f" + version + ", \u662f\u5426\u66f4\u65b0\uff1f";
                if (JOptionPane.showConfirmDialog(null, msg, "\u662f\u5426\u66f4\u65b0\u7a0b\u5e8f", 0) == 0) {
                    Main.download(server, "runqianReport4Applet.jar");
                    Main.download(server, "localPrint.jar");
                    config.setProperty("version", ver);
                    Main.saveConfig();
                    return 1;
                }
                return 3;
            }
        }
        catch (Exception e) {
            Main.dispError(new Exception("\u81ea\u52a8\u66f4\u65b0\u7a0b\u5e8f\u65f6\u4ea7\u751f\u9519\u8bef\uff1a" + e.getMessage(), e));
        }
        return 2;
    }
}

