/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.print;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class Registery {
    private static final int ERROR_CODE = 1;
    private static final int ERROR_SUCCESS = 0;
    private static final int KEY_QUERY_VALUE = 1;
    private static final int NATIVE_HANDLE = 0;
    static /* synthetic */ Class array$B;

    public static int WindowsRegCloseKey(int nativeHandle) throws Exception {
        Class<?> theClass = Class.forName("java.util.prefs.WindowsPreferences");
        Method m = theClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
        m.setAccessible(true);
        Object ret = m.invoke(null, new Integer(nativeHandle));
        return (Integer)ret;
    }

    private static String absolutePath() {
        return "/";
    }

    private static String byteArrayToString(byte[] array) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < array.length - 1) {
            result.append((char)array[i]);
            ++i;
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static int getHKEY(String path) throws Exception {
        if (path.startsWith("HKEY_CURRENT_USER")) {
            return -2147483647;
        }
        if (path.startsWith("HKEY_LOCAL_MACHINE")) {
            return -2147483646;
        }
        throw new Exception("Path   should   start   with   HKEY_CURRENT_USER   or   HKEY_LOCAL_MACHINE");
    }

    public static String getKeyValue(String path, String key) throws Exception {
        int hkey = Registery.getHKEY(path);
        byte[] WINDOWS_ROOT_PATH = Registery.stripHKEY(path);
        return Registery.getValue(hkey, WINDOWS_ROOT_PATH, key);
    }

    public static String getValue(int hkey, byte[] WINDOWS_ROOT_PATH, String key) throws Exception {
        Class<?> theClass = Class.forName("java.util.prefs.WindowsPreferences");
        int[] result = Registery.openKey1(hkey, Registery.windowsAbsolutePath(WINDOWS_ROOT_PATH), 1);
        if (result[1] != 0) {
            throw new Exception("Path   not   found!");
        }
        int nativeHandle = result[0];
        Method m = theClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, array$B == null ? (array$B = Registery.class$("[B")) : array$B);
        m.setAccessible(true);
        byte[] windowsName = Registery.toWindowsName(key);
        Object value = m.invoke(null, new Integer(nativeHandle), windowsName);
        Registery.WindowsRegCloseKey(nativeHandle);
        if (value == null) {
            throw new Exception("Path   found.     Key   not   found.");
        }
        byte[] origBuffer = (byte[])value;
        byte[] destBuffer = new byte[origBuffer.length - 1];
        System.arraycopy(origBuffer, 0, destBuffer, 0, origBuffer.length - 1);
        return new String(destBuffer);
    }

    public static void main(String[] args) {
        args = new String[]{"HKEY_LOCAL_MACHINE\\\\SOFTWARE\\JavaSoft\\Prefs\\RQLocalPrint", "installpath"};
        if (args.length != 2) {
            System.out.println("Usage:   java   Main   path   key");
            System.out.print("     eg.:   java   Main   \"HKEY_CURRENT_USER\\");
            System.out.print("\\Software\\\\Microsoft\\\\Internet   Explorer\\\\Main\"");
            System.out.println("   \"start   page\"");
            System.exit(1);
        }
        try {
            int hkey = Registery.getHKEY(args[0]);
            byte[] WINDOWS_ROOT_PATH = Registery.stripHKEY(args[0]);
            String key = args[1];
            System.out.println(Registery.getValue(hkey, WINDOWS_ROOT_PATH, key));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public static int openKey(byte[] windowsAbsolutePath, int securityMask) throws Exception {
        Class<?> theClass = Class.forName("java.util.prefs.WindowsPreferences");
        Method m = theClass.getDeclaredMethod("openKey", array$B == null ? (array$B = Registery.class$("[B")) : array$B, Integer.TYPE);
        m.setAccessible(true);
        Object ret = m.invoke(null, windowsAbsolutePath, new Integer(securityMask));
        return (Integer)ret;
    }

    public static int[] openKey1(int hkey, byte[] windowsAbsolutePath, int securityMask) throws Exception {
        Class<?> theClass = Class.forName("java.util.prefs.WindowsPreferences");
        Method m = theClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, array$B == null ? (array$B = Registery.class$("[B")) : array$B, Integer.TYPE);
        m.setAccessible(true);
        Object ret = m.invoke(null, new Integer(hkey), windowsAbsolutePath, new Integer(securityMask));
        return (int[])ret;
    }

    private static byte[] stringToByteArray(String str) {
        byte[] result = new byte[str.length() + 1];
        int i = 0;
        while (i < str.length()) {
            result[i] = (byte)str.charAt(i);
            ++i;
        }
        result[str.length()] = 0;
        return result;
    }

    public static byte[] stripHKEY(String path) {
        int beginIndex = path.indexOf("\\\\");
        String subtmp = path.substring(beginIndex + 2);
        return Registery.stringToByteArray(subtmp);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String toJavaValueString(byte[] windowsNameArray) {
        String windowsName = Registery.byteArrayToString(windowsNameArray);
        StringBuffer javaName = new StringBuffer();
        int i = 0;
        while (i < windowsName.length()) {
            int ch;
            block8: {
                block6: {
                    int next;
                    block7: {
                        ch = windowsName.charAt(i);
                        if (ch != 47) break block6;
                        next = 32;
                        if (windowsName.length() <= i + 1) break block7;
                        char c = windowsName.charAt(i + 1);
                        next = c;
                        if (c != 'u') break block7;
                        if (windowsName.length() < i + 6) {
                            return javaName.toString();
                        }
                        ch = (char)Integer.parseInt(windowsName.substring(i + 2, i + 6), 16);
                        i += 5;
                        break block8;
                    }
                    if (windowsName.length() > i + 1 && windowsName.charAt(i + 1) >= 'A' && next <= 90) {
                        ch = next;
                        ++i;
                        break block8;
                    } else if (windowsName.length() > i + 1 && next == 47) {
                        ch = 92;
                        ++i;
                    }
                    break block8;
                }
                if (ch == 92) {
                    ch = 47;
                }
            }
            javaName.append((char)ch);
            ++i;
        }
        return javaName.toString();
    }

    private static byte[] toWindowsName(String javaName) {
        StringBuffer windowsName = new StringBuffer();
        int i = 0;
        while (i < javaName.length()) {
            char ch = javaName.charAt(i);
            if (ch < ' ' || ch > '\u007f') {
                throw new RuntimeException("Unable   to   convert   to   Windows   name");
            }
            if (ch == '\\') {
                windowsName.append("//");
            } else if (ch == '/') {
                windowsName.append('\\');
            } else if (ch >= 'A' && ch <= 'Z') {
                windowsName.append("/" + ch);
            } else {
                windowsName.append(ch);
            }
            ++i;
        }
        return Registery.stringToByteArray(windowsName.toString());
    }

    private static byte[] windowsAbsolutePath(byte[] WINDOWS_ROOT_PATH) {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        bstream.write(WINDOWS_ROOT_PATH, 0, WINDOWS_ROOT_PATH.length - 1);
        StringTokenizer tokenizer = new StringTokenizer(Registery.absolutePath(), "/");
        while (tokenizer.hasMoreTokens()) {
            bstream.write(92);
            String nextName = tokenizer.nextToken();
            byte[] windowsNextName = Registery.toWindowsName(nextName);
            bstream.write(windowsNextName, 0, windowsNextName.length - 1);
        }
        bstream.write(0);
        return bstream.toByteArray();
    }
}

