/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.remote;

import com.runqian.report4.remote.Const;
import com.runqian.report4.remote.LogInfo;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.IReportDefineLoader;
import com.runqian.report4.util.ReportUtils;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;

public class RemoteReportDefineLoader
implements IReportDefineLoader {
    private static HashSet loaders = new HashSet();

    public static void addLoader(IReportDefineLoader loader) {
        loaders.add(loader);
    }

    public static void clearLoaders() {
        loaders.clear();
    }

    public long lastModified(String reportName) {
        return 0L;
    }

    public IReport load(String reportName) {
        InputStream is = LogInfo.getRemoteFileStream(reportName, Const.FILE_RAQ);
        if (is != null) {
            try {
                IReport r = ReportUtils.read(is);
                is.close();
                return r;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        return null;
    }

    public static IReport readReportDefine(String name) {
        Iterator it = loaders.iterator();
        while (it.hasNext()) {
            IReportDefineLoader ipdl = (IReportDefineLoader)it.next();
            try {
                IReport r = ipdl.load(name);
                return r;
            }
            catch (Exception x) {
            }
        }
        return null;
    }
}

