/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.transfer;

import com.runqian.base.tool.Segment;
import com.runqian.base4.util.Escape;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.graph.BarcodeProperty;
import com.runqian.report4.transfer.ExpressionTransfer;
import com.runqian.report4.transfer.GraphTransfer;
import com.runqian.report4.usermodel.Context;

class BarcodeTransfer {
    BarcodeTransfer() {
    }

    private static byte getBarcodeType(String type) {
        if (type != null && type.trim().length() > 0) {
            if (BarcodeProperty.BAR_CODE_TYPE_CODABAR.equals(type)) {
                return 1;
            }
            if (BarcodeProperty.BAR_CODE_TYPE_CODE39.equals(type)) {
                return 2;
            }
            if (BarcodeProperty.BAR_CODE_TYPE_CODE128.equals(type)) {
                return 3;
            }
            if (BarcodeProperty.BAR_CODE_TYPE_2OF5.equals(type)) {
                return 4;
            }
            if (BarcodeProperty.BAR_CODE_TYPE_INTL2OF5.equals(type)) {
                return 5;
            }
            if (BarcodeProperty.BAR_CODE_TYPE_INTERLEAVE2OF5.equals(type)) {
                return 6;
            }
            if (BarcodeProperty.BAR_CODE_TYPE_EAN13.equals(type)) {
                return 7;
            }
            if (BarcodeProperty.BAR_CODE_TYPE_EAN8.equals(type)) {
                return 8;
            }
            if (BarcodeProperty.BAR_CODE_TYPE_UPCA.equals(type)) {
                return 9;
            }
            if (BarcodeProperty.BAR_CODE_TYPE_UPCE.equals(type)) {
                return 10;
            }
            if (BarcodeProperty.BAR_CODE_TYPE_POSTNET.equals(type)) {
                return 11;
            }
        }
        return 1;
    }

    private static byte getBaseLinePosition(String pos) {
        return 1;
    }

    private static byte getCheckSumMode(String mode) {
        return 1;
    }

    private static byte getTextPosition(String pos) {
        return 1;
    }

    static com.runqian.report4.usermodel.BarcodeProperty transfer(String param, CellSet cs, Context ctx) {
        com.runqian.report4.usermodel.BarcodeProperty bp = new com.runqian.report4.usermodel.BarcodeProperty();
        BarcodeProperty obh = new BarcodeProperty(param);
        Segment set = obh.getProperties();
        bp.setType(BarcodeTransfer.getBarcodeType(Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_TYPE))));
        String value = Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_VALUE));
        if (value != null) {
            bp.setValue("=" + ExpressionTransfer.transfer(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_HEIGHT))) != null && value.trim().length() > 0) {
            bp.setHeight(Double.parseDouble(value));
        }
        if ((value = Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_MODULEWIDTH))) != null && value.trim().length() > 0) {
            bp.setModuleWidth(1.0);
        }
        if ((value = Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_BARHEIGHT))) != null && value.trim().length() > 0) {
            bp.setAngle(Double.valueOf(value).intValue());
        }
        bp.setFontName(Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_FONTNAME)));
        value = Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_FONTSIZE));
        if (value != null && value.trim().length() > 0) {
            bp.setFontSize(Double.parseDouble(value));
        }
        bp.setTextPosition(BarcodeTransfer.getTextPosition(Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_MSGPOSITION))));
        value = Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_QUIETZONE));
        if (value != null && value.trim().length() > 0) {
            bp.setQuietZone(Double.parseDouble(value));
        }
        bp.setCheckSumMode(BarcodeTransfer.getCheckSumMode(Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_CHECKSUMMODE))));
        value = Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_INTERCHARGAPWIDTH));
        if (value != null && value.trim().length() > 0) {
            bp.setCharGapWidth(Double.parseDouble(value));
        }
        if ((value = Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_WIDEFACTOR))) != null && value.trim().length() > 0) {
            bp.setWideFactor(Double.parseDouble(value));
        }
        if ((value = Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_DISPLAYSTARTSTOP))) != null && value.trim().length() > 0) {
            bp.setDisplayStartStop(Boolean.getBoolean(value));
        }
        if ((value = Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_DISPLAYCHECKSUM))) != null && value.trim().length() > 0) {
            bp.setDisplayCheckSum(Boolean.getBoolean(value));
        }
        if ((value = Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_SHORTBARHEIGHT))) != null && value.trim().length() > 0) {
            bp.setShortBarHeight(Double.parseDouble(value));
        }
        bp.setBaseLinePosition(BarcodeTransfer.getBaseLinePosition(Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_BASELINEPOSITION))));
        bp.setImageFormat(GraphTransfer.getImageFormat(Escape.removeEscAndQuote(set.get(BarcodeProperty.BAR_CODE_IMAGEFORMAT))));
        return bp;
    }
}

