/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.transfer;

import com.runqian.base.util.ShortMap;
import com.runqian.report.cellset.Cell;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report4.model.Pager;
import com.runqian.report4.transfer.ExpressionTransfer;
import com.runqian.report4.usermodel.ByteMap;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.IColCell;

class ColCellTransfer {
    ColCellTransfer() {
    }

    private static byte getColType(Integer type) {
        if (CellPropertyDefine.CCT_TABLE_HEADER.equals(type)) {
            return -80;
        }
        if (CellPropertyDefine.CCT_NORMAL.equals(type)) {
            return -79;
        }
        return -79;
    }

    private static void setExpressions(IColCell cell, ShortMap exps, CellSet cs, Context ctx) {
        int count = exps.size();
        ByteMap expMap = new ByteMap(4);
        int i = 0;
        while (i < count) {
            short key = exps.getKey(i);
            Object value = exps.getValue(i);
            byte newKey = -1;
            switch (key) {
                case 2102: {
                    newKey = 10;
                    break;
                }
                case 2101: {
                    newKey = 11;
                    break;
                }
                case 4106: {
                    newKey = 12;
                    break;
                }
                case 3102: {
                    newKey = 13;
                    break;
                }
                case 4706: {
                    newKey = 14;
                }
            }
            if (newKey != -1) {
                String newValue = ExpressionTransfer.transfer((String)value, cs, ctx);
                expMap.put(newKey, newValue);
            }
            if (count > 0) {
                cell.setExpMap(expMap);
            }
            ++i;
        }
    }

    private static void setValues(IColCell cell, ShortMap values, byte unit) {
        int count = values.size();
        int i = 0;
        while (i < count) {
            short key = values.getKey(i);
            Object value = values.getValue(i);
            switch (key) {
                case 2102: {
                    cell.setColType(ColCellTransfer.getColType((Integer)value));
                    break;
                }
                case 2101: {
                    cell.setColWidth(Pager.unUnitTransfer(((Number)value).floatValue(), unit));
                    break;
                }
                case 4106: {
                    cell.setColVisible((Boolean)value);
                    break;
                }
                case 3102: {
                    cell.setBreakPage((Boolean)value);
                    break;
                }
                case 4706: {
                    cell.setNotes((String)value);
                }
            }
            ++i;
        }
    }

    static void transfer(IColCell cell, Cell cl, CellSet cs, Context ctx, byte unit) {
        ShortMap exps;
        ShortMap values = cl.getValuesMap();
        if (values != null) {
            ColCellTransfer.setValues(cell, values, unit);
        }
        if ((exps = cl.getExpressionsMap()) != null) {
            ColCellTransfer.setExpressions(cell, exps, cs, ctx);
        }
    }
}

