/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.transfer;

import com.runqian.base.util.SegmentSet;
import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.Escape;
import com.runqian.report.cellset.CellSet;
import com.runqian.report4.transfer.ExpressionTransfer;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.graph.AlarmLine;
import com.runqian.report4.usermodel.graph.GraphCategory;
import com.runqian.report4.usermodel.graph.GraphFont;
import com.runqian.report4.usermodel.graph.GraphFonts;
import com.runqian.report4.usermodel.graph.GraphProperty;
import com.runqian.report4.usermodel.graph.GraphSery;
import com.runqian.report4.usermodel.graph.TimeTrendXValue;
import java.util.ArrayList;
import java.util.Iterator;

class GraphTransfer {
    GraphTransfer() {
    }

    private static AlarmLine[] getAlarmLines(String alarms, CellSet cs, Context ctx) {
        ArrayList<AlarmLine> list = new ArrayList<AlarmLine>();
        SegmentSet segs = new SegmentSet(alarms, '&');
        Iterator it = segs.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            ArgumentTokenizer st = new ArgumentTokenizer(segs.get(name), ',');
            AlarmLine alarm = new AlarmLine();
            alarm.setName("=" + ExpressionTransfer.transfer(name, cs, ctx));
            alarm.setAlarmValue("=" + ExpressionTransfer.transfer(st.next(), cs, ctx));
            alarm.setLineType(GraphTransfer.getGraphLineType(Integer.parseInt(st.next())));
            alarm.setColor(Integer.parseInt(st.next()));
            list.add(alarm);
        }
        int count = list.size();
        AlarmLine[] lines = new AlarmLine[count];
        int i = 0;
        while (i < count) {
            lines[i] = (AlarmLine)list.get(i);
            ++i;
        }
        return lines;
    }

    private static GraphCategory[] getCategories(String cates, String serial, CellSet cs, Context ctx) {
        if (serial != null && serial.trim().length() > 0) {
            ArrayList<GraphCategory> list = new ArrayList<GraphCategory>();
            ArrayList<GraphSery> lt = new ArrayList<GraphSery>();
            ArgumentTokenizer at = new ArgumentTokenizer(cates, '|');
            ArgumentTokenizer atm = new ArgumentTokenizer(serial, '|');
            while (at.hasNext()) {
                GraphCategory category = new GraphCategory();
                category.setCategory("=" + ExpressionTransfer.transfer(at.next(), cs, ctx));
                lt.clear();
                ArgumentTokenizer at1 = new ArgumentTokenizer(atm.next(), '&');
                while (at1.hasNext()) {
                    GraphSery sery = new GraphSery();
                    ArgumentTokenizer at2 = new ArgumentTokenizer(at1.next(), '=');
                    if (at2.hasNext()) {
                        sery.setName("=" + ExpressionTransfer.transfer(at2.next(), cs, ctx));
                    }
                    if (at2.hasNext()) {
                        sery.setExp("=" + ExpressionTransfer.transfer(at2.next(), cs, ctx));
                    }
                    lt.add(sery);
                }
                int count = lt.size();
                GraphSery[] serys = new GraphSery[count];
                int i = 0;
                while (i < count) {
                    serys[i] = (GraphSery)lt.get(i);
                    ++i;
                }
                category.setSeries(serys);
                list.add(category);
            }
            int count = list.size();
            GraphCategory[] categories = new GraphCategory[count];
            int i = 0;
            while (i < count) {
                categories[i] = (GraphCategory)list.get(i);
                ++i;
            }
            return categories;
        }
        return null;
    }

    private static double getDataUnit(String unit) {
        if ("1".equals(unit)) {
            return 1.0;
        }
        if ("2".equals(unit)) {
            return 2.0;
        }
        if ("1000".equals(unit)) {
            return 1000.0;
        }
        if ("10000".equals(unit)) {
            return 10000.0;
        }
        if ("1000000".equals(unit)) {
            return 1000000.0;
        }
        if ("10000000".equals(unit)) {
            return 1.0E7;
        }
        if ("100000000".equals(unit)) {
            return 1.0E8;
        }
        if ("1000000000".equals(unit)) {
            return 1.0E9;
        }
        if ("0.01".equals(unit)) {
            return 0.01;
        }
        if ("0.001".equals(unit)) {
            return 0.001;
        }
        if ("0.0001".equals(unit)) {
            return 1.0E-4;
        }
        if ("0.000001".equals(unit)) {
            return 1.0E-6;
        }
        return 1.0;
    }

    private static byte getDispData(String disp) {
        if ("1".equals(disp)) {
            return 1;
        }
        if ("2".equals(disp)) {
            return 2;
        }
        if ("3".equals(disp)) {
            return 3;
        }
        return 1;
    }

    private static GraphFonts getFonts(String fonts) {
        SegmentSet segs = new SegmentSet(fonts, '&');
        GraphFonts gFonts = new GraphFonts();
        GraphFont gf = gFonts.getTitleFont();
        String tmp = segs.get(Integer.toString(0));
        if (tmp != null && tmp.trim().length() > 0) {
            GraphTransfer.setFonts(gf, tmp);
        }
        gf = gFonts.getXTitleFont();
        tmp = segs.get(Integer.toString(1));
        if (tmp != null && tmp.trim().length() > 0) {
            GraphTransfer.setFonts(gf, tmp);
        }
        gf = gFonts.getYTitleFont();
        tmp = segs.get(Integer.toString(2));
        if (tmp != null && tmp.trim().length() > 0) {
            GraphTransfer.setFonts(gf, tmp);
        }
        gf = gFonts.getXLabelFont();
        tmp = segs.get(Integer.toString(3));
        if (tmp != null && tmp.trim().length() > 0) {
            GraphTransfer.setFonts(gf, tmp);
        }
        gf = gFonts.getYLabelFont();
        tmp = segs.get(Integer.toString(4));
        if (tmp != null && tmp.trim().length() > 0) {
            GraphTransfer.setFonts(gf, tmp);
        }
        gf = gFonts.getLegendFont();
        tmp = segs.get(Integer.toString(5));
        if (tmp != null && tmp.trim().length() > 0) {
            GraphTransfer.setFonts(gf, tmp);
        }
        gf = gFonts.getDataFont();
        tmp = segs.get(Integer.toString(6));
        if (tmp != null && tmp.trim().length() > 0) {
            GraphTransfer.setFonts(gf, tmp);
        }
        return gFonts;
    }

    private static byte getGraphLineType(int type) {
        switch (type) {
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        return 1;
    }

    private static byte getGraphType(int type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 14;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 16;
            }
            case 17: {
                return 17;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 19;
            }
            case 21: {
                return 21;
            }
            case 20: {
                return 20;
            }
            case 22: {
                return 22;
            }
            case 23: {
                return 23;
            }
            case 24: {
                return 24;
            }
            case 25: {
                return 25;
            }
        }
        return 1;
    }

    static byte getImageFormat(String format) {
        if (format != null && format.trim().length() > 0) {
            if ("jpg".equalsIgnoreCase(format)) {
                return 1;
            }
            if ("gif".equalsIgnoreCase(format)) {
                return 2;
            }
            if ("png".equalsIgnoreCase(format)) {
                return 3;
            }
        }
        return 1;
    }

    private static byte getLegendLocation(int leg) {
        switch (leg) {
            case 0: {
                return 5;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return 2;
    }

    private static String getSemicolonValue(String value, CellSet cs, Context ctx) {
        if (value != null && value.trim().length() > 0) {
            String result = "=";
            ArgumentTokenizer st = new ArgumentTokenizer(value, ';');
            if (st.hasMoreTokens()) {
                result = result + ExpressionTransfer.transfer(st.next(), cs, ctx);
            }
            if (st.hasMoreTokens()) {
                result = result + ";" + ExpressionTransfer.transfer(st.next(), cs, ctx);
            }
            return result;
        }
        return null;
    }

    private static TimeTrendXValue[] getTimeTrendXValues(String values, CellSet cs, Context ctx) {
        ArrayList<TimeTrendXValue> list = new ArrayList<TimeTrendXValue>();
        ArgumentTokenizer at = new ArgumentTokenizer(values, '/');
        while (at.hasMoreTokens()) {
            String tmp = at.nextToken();
            ArgumentTokenizer token = new ArgumentTokenizer(tmp, '\t');
            TimeTrendXValue xav = new TimeTrendXValue();
            xav.setStartValue("=" + ExpressionTransfer.transfer(token.next(), cs, ctx));
            xav.setEndValue("=" + ExpressionTransfer.transfer(token.next(), cs, ctx));
            xav.setSampleValue("=" + ExpressionTransfer.transfer(token.next(), cs, ctx));
            xav.setSampleUnit(GraphTransfer.getTimeUnit(Integer.parseInt(token.next())));
            xav.setMarkValue("=" + ExpressionTransfer.transfer(token.next(), cs, ctx));
            xav.setMarkUnit(GraphTransfer.getTimeUnit(Integer.parseInt(token.next())));
            list.add(xav);
        }
        int count = list.size();
        TimeTrendXValue[] times = new TimeTrendXValue[count];
        int i = 0;
        while (i < count) {
            times[i] = (TimeTrendXValue)list.get(i);
            ++i;
        }
        return times;
    }

    private static byte getTimeUnit(int unit) {
        switch (unit) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        return 4;
    }

    private static void setFonts(GraphFont gf, String font) {
        ArgumentTokenizer at = new ArgumentTokenizer(font, ',');
        gf.setFamily(at.nextToken());
        gf.setAutoResize("1".equals(at.nextToken()));
        gf.setSize(Integer.parseInt(at.nextToken()));
        gf.setBold("1".equals(at.nextToken()));
        gf.setColor(Integer.parseInt(at.nextToken()));
        gf.setVerticalText("1".equals(at.nextToken()));
        gf.setAngle(Integer.parseInt(at.nextToken()));
    }

    static GraphProperty transfer(String param, CellSet cs, Context ctx) {
        GraphProperty gp = new GraphProperty();
        com.runqian.report.graph.GraphProperty ogp = new com.runqian.report.graph.GraphProperty(param);
        SegmentSet ss = ogp.getProperties();
        byte imageType = 1;
        gp.setType(GraphTransfer.getGraphType(Integer.parseInt(Escape.removeEscAndQuote(ss.get("type")))));
        String value = Escape.removeEscAndQuote(ss.get("axisColor"));
        if (value != null && value.trim().length() > 0) {
            gp.setAxisColor(Integer.parseInt(value));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("canvasColor"))) != null && value.trim().length() > 0) {
            gp.setCanvasColor(Integer.parseInt(value));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("backColor"))) != null && value.trim().length() > 0) {
            gp.setGraphBackColor(Integer.parseInt(value));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("xTitle"))) != null && value.trim().length() > 0) {
            gp.setXTitle("=" + ExpressionTransfer.transfer(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("yTitle"))) != null && value.trim().length() > 0) {
            gp.setYTitle("=" + ExpressionTransfer.transfer(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("graphTitle"))) != null && value.trim().length() > 0) {
            gp.setGraphTitle("=" + ExpressionTransfer.transfer(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("gridLineType"))) != null && value.trim().length() > 0) {
            gp.setGridLineType(GraphTransfer.getGraphLineType(Integer.parseInt(value)));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("gridLineColor"))) != null && value.trim().length() > 0) {
            gp.setGridLineColor(Integer.parseInt(value));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("barDistance"))) != null && value.trim().length() > 0) {
            gp.setBarDistance("=" + ExpressionTransfer.transfer(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("graphFormat"))) != null && value.trim().length() > 0) {
            imageType = GraphTransfer.getImageFormat(value);
            gp.setImageFormat(imageType);
        }
        if ((value = Escape.removeEscAndQuote(ss.get("graphTransparent"))) != null && value.trim().length() > 0) {
            gp.setGraphTransparent("1".equals(value));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("barGradient"))) != null && value.trim().length() > 0) {
            gp.setGradientColor("1".equals(value) && imageType != 2);
        }
        if ((value = Escape.removeEscAndQuote(ss.get("useTopN"))) != null && value.trim().length() > 0) {
            gp.setTopData("=" + ExpressionTransfer.transfer(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("displayValue"))) != null && value.trim().length() > 0) {
            gp.setDisplayData(GraphTransfer.getDispData(value));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("displayValueFormat"))) != null && value.trim().length() > 0) {
            gp.setDisplayDataFormat(GraphTransfer.getSemicolonValue(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("link"))) != null && value.trim().length() > 0) {
            gp.setLink("=" + ExpressionTransfer.transfer(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("linkTarget"))) != null && value.trim().length() > 0) {
            gp.setLinkTarget("=" + ExpressionTransfer.transfer(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("legendLocation"))) != null && value.trim().length() > 0) {
            gp.setLegendLocation(GraphTransfer.getLegendLocation(Integer.parseInt(value)));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("colorConfig"))) != null && value.trim().length() > 0) {
            gp.setColorConfig(value);
        }
        if ((value = Escape.removeEscAndQuote(ss.get("yStartValue"))) != null && value.trim().length() > 0) {
            gp.setYStartValue(GraphTransfer.getSemicolonValue(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("yEndValue"))) != null && value.trim().length() > 0) {
            gp.setYEndValue(GraphTransfer.getSemicolonValue(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("yInterval"))) != null && value.trim().length() > 0) {
            gp.setYInterval(GraphTransfer.getSemicolonValue(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("yUnit"))) != null && value.trim().length() > 0) {
            gp.setDataUnit(GraphTransfer.getDataUnit(value));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("yMinMarks"))) != null && value.trim().length() > 0) {
            gp.setYMinMarks("=" + ExpressionTransfer.transfer(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("margin"))) != null && value.trim().length() > 0) {
            gp.setTitleMargin("=" + ExpressionTransfer.transfer(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("drawDot"))) != null && value.trim().length() > 0) {
            gp.setDrawLineDot("1".equals(value));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("displayIntersection"))) != null && value.trim().length() > 0) {
            gp.setShowOverlapText("1".equals(value));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("legendBySery"))) != null && value.trim().length() > 0) {
            gp.setDrawLegendBySery("1".equals(value));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("xInterval"))) != null && value.trim().length() > 0) {
            gp.setXInterval("=" + ExpressionTransfer.transfer(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("fonts"))) != null && value.trim().length() > 0) {
            gp.setFonts(GraphTransfer.getFonts(value));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("statusStartTime"))) != null && value.trim().length() > 0) {
            gp.setStatusStartTimeExp("=" + ExpressionTransfer.transfer(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("statusEndTime"))) != null && value.trim().length() > 0) {
            gp.setStatusEndTimeExp("=" + ExpressionTransfer.transfer(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("statusCategery"))) != null && value.trim().length() > 0) {
            gp.setStatusCategoryExp("=" + ExpressionTransfer.transfer(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("statusState"))) != null && value.trim().length() > 0) {
            gp.setStatusStateExp("=" + ExpressionTransfer.transfer(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("statusBarHeight"))) != null && value.trim().length() > 0) {
            gp.setStatusBarWidth("=" + ExpressionTransfer.transfer(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("statusTimeType"))) != null && value.trim().length() > 0) {
            gp.setStatusTimeType(GraphTransfer.getTimeUnit(Integer.parseInt(value)));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("xValues"))) != null && value.trim().length() > 0) {
            gp.setTimeTrendXValues(GraphTransfer.getTimeTrendXValues(value, cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("categoryExp"))) != null && value.trim().length() > 0) {
            gp.setCategories(GraphTransfer.getCategories(value, Escape.removeEscAndQuote(ss.get("seriesValuesExp")), cs, ctx));
        }
        if ((value = Escape.removeEscAndQuote(ss.get("alarmLines"))) != null && value.trim().length() > 0) {
            gp.setAlarmLines(GraphTransfer.getAlarmLines(value, cs, ctx));
        }
        return gp;
    }
}

