/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.transfer;

import com.runqian.base.module.DataSetConfig;
import com.runqian.base.module.DataSetConfigs;
import com.runqian.base.module.OLAPSessionFactory;
import com.runqian.base.tool.Constants;
import com.runqian.base.tool.Segment;
import com.runqian.base.util.Argument;
import com.runqian.base.util.Arguments;
import com.runqian.base.util.Macros;
import com.runqian.base.util.ShortMap;
import com.runqian.base4.tool.GV;
import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.Escape;
import com.runqian.base4.util.SegmentSet;
import com.runqian.report.cellset.Cell;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.engine.SubRptList;
import com.runqian.report4.model.CalcReport;
import com.runqian.report4.transfer.ExpressionTransfer;
import com.runqian.report4.usermodel.BackGraphConfig;
import com.runqian.report4.usermodel.BuiltinDataSetConfig;
import com.runqian.report4.usermodel.CSQLDataSetConfig;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.CustomDataSetConfig;
import com.runqian.report4.usermodel.DataSetMetaData;
import com.runqian.report4.usermodel.EssDataSetConfig;
import com.runqian.report4.usermodel.ExportConfig;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.MacroMetaData;
import com.runqian.report4.usermodel.ParamMetaData;
import com.runqian.report4.usermodel.PrintSetup;
import com.runqian.report4.usermodel.ProcDataSetConfig;
import com.runqian.report4.usermodel.SQLDataSetConfig;
import com.runqian.report4.usermodel.SubReportConfig;
import com.runqian.report4.usermodel.SubReportMetaData;
import com.runqian.report4.usermodel.TxtDataSetConfig;
import com.runqian.report4.usermodel.XMLDataSetConfig;
import java.util.ArrayList;
import java.util.Map;

class ReportInfoTransfer {
    ReportInfoTransfer() {
    }

    private static com.runqian.report4.usermodel.DataSetConfig getBuildinDataSetConfig(DataSetConfig dsc) {
        BuiltinDataSetConfig bdsc = new BuiltinDataSetConfig();
        bdsc.setName(dsc.getName());
        String sql = dsc.getSQL();
        Segment set = new Segment(sql);
        String colName = set.get("names");
        String colType = set.get("types");
        String data = set.get("data");
        ArgumentTokenizer at = new ArgumentTokenizer(data, '\n');
        ArgumentTokenizer at1 = new ArgumentTokenizer(colName, '\t');
        ArgumentTokenizer at2 = new ArgumentTokenizer(colType, '\t');
        int colCount = at1.countTokens();
        int rowCount = at.countTokens();
        String[] colNames = new String[colCount];
        byte[] colTypes = new byte[colCount];
        String[][] values = new String[rowCount][colCount];
        int i = 0;
        while (i < colCount) {
            colNames[i] = at1.nextToken();
            int columnType = 6;
            try {
                columnType = Integer.parseInt(at2.nextToken());
            }
            catch (Exception e) {
                columnType = 6;
            }
            colTypes[i] = ReportInfoTransfer.getParamType(columnType);
            ++i;
        }
        int j = 0;
        while (j < rowCount) {
            String rowData = at.nextToken();
            ArgumentTokenizer rowAt = new ArgumentTokenizer(rowData, '\t');
            int i2 = 0;
            while (i2 < colCount) {
                values[j][i2] = Escape.removeEscAndQuote(rowAt.nextToken());
                ++i2;
            }
            ++j;
        }
        bdsc.setColTypes(colTypes);
        bdsc.setValues(values);
        bdsc.setColNames(colNames);
        return bdsc;
    }

    private static DataSetMetaData getDataSetMetaData(String dataset, CellSet cs, Context ctx, IReport rd) {
        DataSetConfig dsc = null;
        DataSetConfigs dscs = new DataSetConfigs(dataset);
        String[] dsns = dscs.getDataSetNames();
        if (dsns != null) {
            int count = dsns.length;
            DataSetMetaData dsmm = new DataSetMetaData(count);
            rd.setDataSetMetaData(dsmm);
            int i = 0;
            while (i < count) {
                dsc = dscs.get(dsns[i]);
                int type = dsc.getSQLType();
                switch (type) {
                    case 8: {
                        dsmm.addDataSetConfig(ReportInfoTransfer.getBuildinDataSetConfig(dsc));
                        CalcReport.calcDataSet(rd, ctx, false);
                        break;
                    }
                    case 1: 
                    case 2: {
                        dsmm.addDataSetConfig(ReportInfoTransfer.getNormalDataSetConfig(dsc, cs, ctx));
                        CalcReport.calcDataSet(rd, ctx, false);
                        break;
                    }
                    case 9: {
                        dsmm.addDataSetConfig(ReportInfoTransfer.getOlapDataSetConfig(dsc));
                        CalcReport.calcDataSet(rd, ctx, false);
                        break;
                    }
                    case 7: {
                        dsmm.addDataSetConfig(ReportInfoTransfer.getSelfDataSetConfig(dsc));
                        CalcReport.calcDataSet(rd, ctx, false);
                        break;
                    }
                    case 5: {
                        dsmm.addDataSetConfig(ReportInfoTransfer.getTextDataSetConfig(dsc));
                        CalcReport.calcDataSet(rd, ctx, false);
                        break;
                    }
                    case 6: {
                        dsmm.addDataSetConfig(ReportInfoTransfer.getXmlDataSetConfig(dsc));
                        CalcReport.calcDataSet(rd, ctx, false);
                        break;
                    }
                    case 3: {
                        dsmm.addDataSetConfig(ReportInfoTransfer.getProcDataSetConfig(dsc, cs, ctx));
                        CalcReport.calcDataSet(rd, ctx, false);
                        break;
                    }
                }
                ++i;
            }
            return dsmm;
        }
        return null;
    }

    private static ExportConfig getExportConfig(String config) {
        ExportConfig ec = new ExportConfig();
        boolean exportHideRow = false;
        boolean exportHideCol = false;
        String password = null;
        String userPwd = null;
        String ownerPwd = null;
        String permission = null;
        if (config != null && config.trim().length() > 0) {
            Segment segs = new Segment(config);
            String tmp = segs.get(Constants.EXCEL_NOTEXPORTHIDEROWS);
            exportHideRow = "false".equalsIgnoreCase(tmp);
            tmp = segs.get(Constants.EXCEL_NOTEXPORTHIDECOLS);
            exportHideCol = "false".equalsIgnoreCase(tmp);
            password = segs.get(Constants.EXCEL_PASSWORD);
            userPwd = segs.get(Constants.PDF_PASSWORD_USER);
            ownerPwd = segs.get(Constants.PDF_PASSWORD_OWNER);
            permission = segs.get(Constants.PDF_PERMISSION);
        }
        ec.setExcelHiddenColExported(!exportHideCol);
        ec.setExcelHiddenRowExported(!exportHideRow);
        ec.setExcelFilePassword(password);
        ec.setPDFUserPassword(userPwd);
        ec.setPDFOwnerPassword(ownerPwd);
        int privilege = 0;
        if (permission != null) {
            privilege = Integer.parseInt(permission);
        }
        ec.setPDFPrivilege(privilege);
        return ec;
    }

    private static byte getHAlign(Integer align) {
        if (CellPropertyDefine.PL_CENTER.equals(align)) {
            return 1;
        }
        if (CellPropertyDefine.PL_LEFT.equals(align)) {
            return 0;
        }
        if (CellPropertyDefine.PL_RIGHT.equals(align)) {
            return 2;
        }
        return 1;
    }

    private static byte getInputType(Integer type) {
        if (CellPropertyDefine.CRT_CROSS.equals(type) || CellPropertyDefine.CRT_GRID.equals(type) || CellPropertyDefine.CRT_COMPLEX.equals(type)) {
            return 0;
        }
        if (CellPropertyDefine.CRT_INPUT.equals(type)) {
            return 1;
        }
        return 0;
    }

    private static byte getLayout(Integer layout) {
        if (CellPropertyDefine.CPLI_ROW.equals(layout)) {
            return 0;
        }
        if (CellPropertyDefine.CPLI_COL.equals(layout)) {
            return 1;
        }
        return 0;
    }

    private static MacroMetaData getMacroMetaData(String macro, CellSet cs, Context ctx) {
        Macros macros = new Macros(macro);
        int count = macros.size();
        MacroMetaData mmd = new MacroMetaData(count);
        int i = 0;
        while (i < count) {
            String value = macros.getValue(i);
            if (value != null) {
                if ((value = value.trim()).length() > 1 && value.charAt(0) == '=') {
                    value = ExpressionTransfer.transfer(value.substring(1), cs, ctx);
                    mmd.addMacro(macros.getName(i).toLowerCase(), macros.getTitle(i), (byte)1, value);
                } else {
                    mmd.addMacro(macros.getName(i).toLowerCase(), macros.getTitle(i), (byte)0, value);
                }
            } else {
                mmd.addMacro(macros.getName(i).toLowerCase(), macros.getTitle(i), (byte)0, value);
            }
            ++i;
        }
        return mmd;
    }

    private static com.runqian.report4.usermodel.DataSetConfig getNormalDataSetConfig(DataSetConfig dsc, CellSet cs, Context ctx) {
        String sql;
        SQLDataSetConfig sdsc = null;
        sdsc = dsc.getSQLType() == 2 ? new CSQLDataSetConfig() : new SQLDataSetConfig();
        sdsc.setName(dsc.getName());
        sdsc.setDataSourceName(dsc.getDataSourceName());
        String sql2 = sql = dsc.getSQL();
        if (sql != null) {
            sql2 = sql.replaceAll("\n", " ");
        }
        sdsc.setSQL(sql2);
        sdsc.setBeginRow(dsc.getBeginRow());
        sdsc.setEndRow(dsc.getEndRow());
        int[] argTypes = dsc.getArgumentTypes();
        String[] argNames = dsc.getSqlArguments();
        int count = argNames.length;
        int i = 0;
        while (i < count) {
            sdsc.addParam(ExpressionTransfer.transfer(argNames[i], cs, ctx), ReportInfoTransfer.getParamType(argTypes[i]));
            ++i;
        }
        return sdsc;
    }

    private static com.runqian.report4.usermodel.DataSetConfig getOlapDataSetConfig(DataSetConfig dsc) {
        EssDataSetConfig edsc = new EssDataSetConfig();
        edsc.setName(dsc.getName());
        edsc.setDataSourceName(dsc.getDataSourceName());
        Segment olap = new Segment(dsc.getSQL());
        byte tp = 1;
        String type = olap.get("dstype");
        if (OLAPSessionFactory.ESSBASE_TYPE_DIM_VIEW.equals(type)) {
            tp = 2;
        }
        edsc.setAppName(olap.get("appname"));
        edsc.setCubeName(olap.get("cubename"));
        edsc.setDimensions(new String[]{olap.get("dims")});
        edsc.setType(tp);
        return edsc;
    }

    private static byte getOrientation(Integer ot) {
        if (CellPropertyDefine.CPO_LANDSCAPE.equals(ot)) {
            return 0;
        }
        if (CellPropertyDefine.CPO_PORTRAIT.equals(ot)) {
            return 1;
        }
        return 1;
    }

    private static byte getPagerHeaderFooder(Integer mode) {
        if (CellPropertyDefine.CHS_ALL.equals(mode)) {
            return 0;
        }
        if (CellPropertyDefine.CHS_ONE.equals(mode)) {
            return 1;
        }
        return 0;
    }

    private static byte getPagerStyle(Integer style) {
        if (CellPropertyDefine.CPS_PAPER.equals(style)) {
            return 2;
        }
        if (CellPropertyDefine.CPS_ROWS.equals(style)) {
            return 1;
        }
        return 2;
    }

    private static short getPaper(Integer size) {
        if (CellPropertyDefine.CPS_A2.equals(size)) {
            return 66;
        }
        if (CellPropertyDefine.CPS_A3.equals(size)) {
            return 8;
        }
        if (CellPropertyDefine.CPS_A4.equals(size)) {
            return 9;
        }
        if (CellPropertyDefine.CPS_A5.equals(size)) {
            return 11;
        }
        if (CellPropertyDefine.CPS_B3.equals(size)) {
            return 9999;
        }
        if (CellPropertyDefine.CPS_B4.equals(size)) {
            return 33;
        }
        if (CellPropertyDefine.CPS_B5.equals(size)) {
            return 34;
        }
        if (CellPropertyDefine.CPS_USERDEFINED.equals(size)) {
            return 256;
        }
        if (CellPropertyDefine.CPS_B4_JIS.equals(size)) {
            return 12;
        }
        if (CellPropertyDefine.CPS_B5_JIS.equals(size)) {
            return 13;
        }
        return 9;
    }

    private static ParamMetaData getParamMetaData(String param, Context ctx) {
        Argument arg = null;
        Arguments args = new Arguments(param);
        int count = args.size();
        Map paramMap = ctx.getParamMap(true);
        ParamMetaData pmd = new ParamMetaData(count);
        int i = 0;
        while (i < count) {
            arg = args.get(i);
            pmd.addParam(arg.enName, arg.chName, (byte)0, ReportInfoTransfer.getParamType(Integer.parseInt(arg.type)), (short)0, (short)0, true, arg.fmt, arg.value);
            paramMap.put(arg.enName, null);
            ++i;
        }
        return pmd;
    }

    static byte getParamType(int tp) {
        if (17 == tp) {
            return 1;
        }
        if (19 == tp) {
            return 6;
        }
        if (6 == tp) {
            return 11;
        }
        if (2 == tp) {
            return 8;
        }
        if (3 == tp) {
            return 9;
        }
        if (4 == tp) {
            return 10;
        }
        if (5 == tp) {
            return 12;
        }
        if (9 == tp) {
            return 0;
        }
        if (273 == tp) {
            return 51;
        }
        if (275 == tp) {
            return 56;
        }
        if (262 == tp) {
            return 61;
        }
        return 0;
    }

    private static com.runqian.report4.usermodel.DataSetConfig getProcDataSetConfig(DataSetConfig dsc, CellSet cs, Context ctx) {
        ProcDataSetConfig pdsc = new ProcDataSetConfig();
        pdsc.setName(dsc.getName());
        pdsc.setDataSourceName(dsc.getDataSourceName());
        pdsc.setSQL(dsc.getSQL());
        pdsc.setBeginRow(dsc.getBeginRow());
        pdsc.setEndRow(dsc.getEndRow());
        int[] argTypes = dsc.getArgumentTypes();
        String[] argNames = dsc.getSqlArguments();
        int count = argNames.length;
        int i = 0;
        while (i < count) {
            if ("@@result".equalsIgnoreCase(argNames[i])) {
                pdsc.addParam(ExpressionTransfer.transfer(argNames[i], cs, ctx), (byte)101, (byte)1, null);
            } else {
                pdsc.addParam(ExpressionTransfer.transfer(argNames[i], cs, ctx), ReportInfoTransfer.getParamType(argTypes[i]), (byte)0, null);
            }
            ++i;
        }
        return pdsc;
    }

    private static com.runqian.report4.usermodel.DataSetConfig getSelfDataSetConfig(DataSetConfig dsc) {
        CustomDataSetConfig cdsc = new CustomDataSetConfig();
        cdsc.setName(dsc.getName());
        String define = dsc.getSQL();
        SegmentSet set = new SegmentSet(define, ';');
        String arg = set.get("args");
        arg = Escape.removeEscAndQuote(arg);
        String classes = set.get("class");
        classes = Escape.removeEscAndQuote(classes);
        cdsc.setFactoryClass(classes);
        ArgumentTokenizer at = new ArgumentTokenizer(arg, ';');
        ArrayList<String[]> list = new ArrayList<String[]>();
        while (at.hasMoreTokens()) {
            String s = at.nextToken();
            int pos = s.indexOf(",");
            if (pos <= 0) continue;
            String[] st = new String[]{s.substring(0, pos), s.substring(pos + 1, s.length())};
            list.add(st);
        }
        int count = list.size();
        if (count > 0) {
            String[] names = new String[count];
            String[] values = new String[count];
            int i = 0;
            while (i < count) {
                String[] st = (String[])list.get(i);
                names[i] = st[0];
                values[i] = st[1];
                ++i;
            }
            cdsc.setArgNames(names);
            cdsc.setArgValues(values);
        }
        return cdsc;
    }

    private static SubReportMetaData getSubReportMetaData(String subRpt) {
        SubRptList list = new SubRptList(subRpt);
        String[] names = list.getRptNames();
        if (names != null) {
            int count = names.length;
            SubReportConfig src = null;
            SubReportMetaData spmd = new SubReportMetaData(count);
            int i = 0;
            while (i < names.length) {
                src = new SubReportConfig();
                src.setName(names[i]);
                src.setURL(list.getAddress(i));
                src.setURLType(ReportInfoTransfer.getSubRptUrlType(list.getType(i)));
                spmd.addSubReportConfig(src);
                ++i;
            }
            return spmd;
        }
        return null;
    }

    private static byte getSubRptUrlType(String type) {
        if ("url".equals(type)) {
            return 2;
        }
        if ("\u7edd\u5bf9\u8def\u5f84".equals(type)) {
            return 1;
        }
        if ("\u76f8\u5bf9\u8def\u5f84".equals(type)) {
            return 0;
        }
        return 1;
    }

    private static byte getSubmitType(Integer type) {
        if (CellPropertyDefine.SUBMIT_UPDATABLE.equals(type)) {
            return 0;
        }
        if (CellPropertyDefine.SUBMIT_UPDATABLE_WRITABLE.equals(type)) {
            return 1;
        }
        if (CellPropertyDefine.SUBMIT_ALL.equals(type)) {
            return 2;
        }
        return 0;
    }

    private static com.runqian.report4.usermodel.DataSetConfig getTextDataSetConfig(DataSetConfig dsc) {
        TxtDataSetConfig tdsc = new TxtDataSetConfig();
        tdsc.setName(dsc.getName());
        tdsc.setFileName(dsc.getSQL());
        return tdsc;
    }

    private static byte getUnit(Integer unit) {
        if (CellPropertyDefine.CSU_PIXEL.equals(unit)) {
            return 0;
        }
        if (CellPropertyDefine.CSU_MM.equals(unit)) {
            return 1;
        }
        if (CellPropertyDefine.CSU_INCH.equals(unit)) {
            return 2;
        }
        return 0;
    }

    private static com.runqian.report4.usermodel.DataSetConfig getXmlDataSetConfig(DataSetConfig dsc) {
        XMLDataSetConfig xdsc = new XMLDataSetConfig();
        xdsc.setName(dsc.getName());
        xdsc.setFileName(dsc.getSQL());
        return xdsc;
    }

    private static byte getZoomMode(Integer mode) {
        if (CellPropertyDefine.SP_NONE.equals(mode)) {
            return 1;
        }
        if (CellPropertyDefine.SP_WIDTH.equals(mode)) {
            return 2;
        }
        if (CellPropertyDefine.SP_HEIGHT.equals(mode)) {
            return 3;
        }
        return 1;
    }

    static void transfer(Cell cell, IReport rd, CellSet cs) {
        ShortMap values;
        short columns = 1;
        if (cell != null && (values = cell.getValuesMap()) != null) {
            Object value;
            BackGraphConfig bgc = null;
            Context ctx = new Context(GV.prepareContext(null));
            byte input = 0;
            int count = values.size();
            PrintSetup ps = rd.getPrintSetup();
            if (ps == null) {
                ps = new PrintSetup();
                rd.setPrintSetup(ps);
            }
            if ((value = values.get((short)1105)) != null) {
                rd.setParamMetaData(ReportInfoTransfer.getParamMetaData((String)value, ctx));
            }
            if ((value = values.get((short)1107)) != null) {
                rd.setMacroMetaData(ReportInfoTransfer.getMacroMetaData((String)value, cs, ctx));
            }
            if ((value = values.get((short)1102)) != null) {
                ReportInfoTransfer.getDataSetMetaData((String)value, cs, ctx, rd);
            }
            if ((value = values.get((short)1101)) != null) {
                input = ReportInfoTransfer.getInputType((Integer)value);
                rd.setInput(input);
            }
            if (input == 1 && (value = values.get((short)1224)) != null) {
                rd.setSubmit(ReportInfoTransfer.getSubmitType((Integer)value));
            }
            int i = 0;
            while (i < count) {
                short key = values.getKey(i);
                value = values.getValue(i);
                switch (key) {
                    case 1108: {
                        rd.setSubReportMetaData(ReportInfoTransfer.getSubReportMetaData((String)value));
                        break;
                    }
                    case 1110: {
                        rd.setExportConfig(ReportInfoTransfer.getExportConfig((String)value));
                        break;
                    }
                    case 1209: {
                        rd.setUnit(ReportInfoTransfer.getUnit((Integer)value));
                        break;
                    }
                    case 1220: {
                        rd.setDispRatio(((Number)value).intValue());
                        break;
                    }
                    case 4706: {
                        rd.setNotes((String)value);
                        break;
                    }
                    case 4705: {
                        rd.setTip((String)value);
                        break;
                    }
                    case 1221: {
                        bgc = rd.getBackGraphConfig();
                        if (bgc == null) {
                            bgc = new BackGraphConfig();
                            rd.setBackGraphConfig(bgc);
                        }
                        bgc.setType((byte)0);
                        bgc.setURLOrClassName((String)value);
                        break;
                    }
                    case 1223: {
                        bgc = rd.getBackGraphConfig();
                        if (bgc == null) {
                            bgc = new BackGraphConfig();
                            rd.setBackGraphConfig(bgc);
                        }
                        bgc.setDispMode((Boolean)value != false ? (byte)11 : 10);
                        break;
                    }
                    case 1106: {
                        columns = ((Number)value).shortValue();
                        if (columns <= 0) break;
                        ps.setTableColumnNum(columns);
                        break;
                    }
                    case 1201: {
                        ps.setPaper(ReportInfoTransfer.getPaper((Integer)value));
                        break;
                    }
                    case 1202: {
                        ps.setOrientation(ReportInfoTransfer.getOrientation((Integer)value));
                        break;
                    }
                    case 1203: {
                        ps.setPaperWidth(((Number)value).floatValue());
                        break;
                    }
                    case 1204: {
                        ps.setPaperHeight(((Number)value).floatValue());
                        break;
                    }
                    case 1205: {
                        ps.setLeftMargin(((Number)value).floatValue());
                        break;
                    }
                    case 1206: {
                        ps.setRightMargin(((Number)value).floatValue());
                        break;
                    }
                    case 1207: {
                        ps.setTopMargin(((Number)value).floatValue());
                        break;
                    }
                    case 1208: {
                        ps.setBottomMargin(((Number)value).floatValue());
                        break;
                    }
                    case 1210: {
                        ps.setPagerStyle(ReportInfoTransfer.getPagerStyle((Integer)value));
                        break;
                    }
                    case 1211: {
                        ps.setRowNumPerPage(((Number)value).shortValue());
                        break;
                    }
                    case 1212: {
                        ps.setLayoutRowNum(((Number)value).shortValue());
                        break;
                    }
                    case 1213: {
                        ps.setLayoutColNum(((Number)value).shortValue());
                        break;
                    }
                    case 1214: {
                        ps.setLayout(ReportInfoTransfer.getLayout((Integer)value));
                        break;
                    }
                    case 1215: {
                        ps.setPageHeaderAndFooterYMode(ReportInfoTransfer.getPagerHeaderFooder((Integer)value));
                        break;
                    }
                    case 1217: {
                        ps.setZoomMode(ReportInfoTransfer.getZoomMode((Integer)value));
                        break;
                    }
                    case 1219: {
                        ps.setHAlign(ReportInfoTransfer.getHAlign((Integer)value));
                        break;
                    }
                    case 1222: {
                        ps.setBackGraphPrinted((Boolean)value);
                    }
                }
                ++i;
            }
        }
    }
}

