/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.usermodel;

import com.runqian.base4.resources.EngineMessage;
import com.runqian.base4.resources.MessageManager;
import com.runqian.base4.util.Logger;
import com.runqian.base4.util.ReportError;
import com.runqian.report4.model.Pager;
import com.runqian.report4.model.ReportDefine;
import com.runqian.report4.model.SrcRptPager;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.model.engine.SimplePager;
import com.runqian.report4.model.engine2.RowReport;
import com.runqian.report4.model.engine2.SimplePager2;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.IlIlIlllIlIIlIlI;
import com.runqian.report4.usermodel.PagerInfo;
import com.runqian.report4.usermodel.PerfMonitor;
import com.runqian.report4.usermodel.PrintSetup;
import java.awt.print.PageFormat;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PageBuilder {
    private Pager _$1;
    PagerInfo _$2;
    private boolean _$3 = false;
    private IReport _$4;
    private static boolean _$5 = false;

    public PageBuilder(IReport iReport) throws Throwable {
        this._$2 = new PagerInfo(iReport.getPrintSetup());
        this._$1(iReport);
    }

    public PageBuilder(IReport iReport, float f, float f2) throws Throwable {
        this(iReport, f, f2, 0);
    }

    public PageBuilder(IReport iReport, float f, float f2, int n) throws Throwable {
        this._$2 = new PagerInfo(iReport.getPrintSetup());
        this._$2.setPaperSize(f, f2);
        this._$2.setTableColumnNum((short)n);
        this._$1(iReport);
    }

    public PageBuilder(IReport iReport, PagerInfo pagerInfo) throws Throwable {
        this._$2 = pagerInfo;
        this._$1(iReport);
    }

    public PageBuilder(IReport iReport, PagerInfo pagerInfo, boolean bl) throws Throwable {
        this._$2 = pagerInfo;
        if (bl) {
            this._$4 = iReport;
            return;
        }
        this._$1(iReport);
    }

    public PageBuilder(IReport iReport, PageFormat pageFormat, int n) throws Throwable {
        this._$2 = new PagerInfo(iReport.getPrintSetup());
        this._$2.setPageFormat(pageFormat);
        this._$2.setTableColumnNum((short)n);
        this._$1(iReport);
    }

    public PageBuilder(IReport iReport, PageFormat pageFormat, int n, String string) throws Throwable {
        this._$2 = new PagerInfo(iReport.getPrintSetup());
        this._$2.setPageFormat(pageFormat);
        this._$2.setTableColumnNum((short)n);
        if (string != null && string.equals("RQAppletQR")) {
            _$5 = true;
        }
        this._$1(iReport);
    }

    public PageBuilder(IReport iReport, short s) throws Throwable {
        this._$2 = new PagerInfo(iReport.getPrintSetup());
        this._$2.setPaper(s);
        this._$1(iReport);
    }

    private PageBuilder(PagerInfo pagerInfo) {
        this._$2 = pagerInfo;
    }

    private boolean _$1(SimplePager2 simplePager2, String string, boolean bl) throws IOException {
        int n = simplePager2.getYPageCount();
        int n2 = simplePager2.getXPageCount();
        if (n < 1 || n2 < 1) {
            return false;
        }
        int[] nArray = new int[n * n2];
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(n2);
        int n3 = dataOutputStream.size();
        SimplePager2.writeIntArray(dataOutputStream, nArray);
        simplePager2.write(dataOutputStream);
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n2) {
                nArray[n4] = dataOutputStream.size();
                ++n4;
                SimplePager2.PageIdleCache pageIdleCache = (SimplePager2.PageIdleCache)simplePager2.getPagesSheet().get(n5, n6);
                pageIdleCache.write(dataOutputStream);
                ++n6;
            }
            ++n5;
        }
        dataOutputStream.flush();
        dataOutputStream.close();
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        randomAccessFile.seek(n3);
        SimplePager2.writeIntArray(randomAccessFile, nArray);
        randomAccessFile.close();
        return true;
    }

    private void _$1(IReport iReport) throws Throwable {
        ExtCellSet extCellSet;
        int n = 0;
        int n2 = (iReport.getRowCount() + 1) * (iReport.getColCount() + 1);
        n2 = iReport instanceof RowReport ? (int)((double)n2 * 1.1) : (int)((double)n2 * 2.1);
        PrintSetup printSetup = iReport.getPrintSetup();
        if (printSetup != null) {
            this._$3 = printSetup.isGroupHeaderColumnRepeated();
        }
        boolean bl = (extCellSet = ExtCellSet.get()).getType() == 0 || extCellSet.getVersion() == 20;
        PerfMonitor.enterTask(bl);
        try {
            try {
                PerfMonitor.increaseCellNum(n2);
                n = n2;
                this._$2(iReport);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Logger.error("Out of Memory");
                PerfMonitor.fireOutOfMemory();
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            PerfMonitor.leaveTask();
            PerfMonitor.reduceCellNum(n);
            throw throwable;
        }
        PerfMonitor.leaveTask();
        PerfMonitor.reduceCellNum(n);
    }

    private void _$2(IReport iReport) throws Throwable {
        if (iReport instanceof ExtCellSet) {
            this._$1 = new SimplePager(iReport, this._$2);
        } else if (iReport instanceof RowReport) {
            this._$1 = new SimplePager2(iReport, this._$2);
        } else if (iReport instanceof ReportDefine) {
            this._$1 = new SrcRptPager(iReport, this._$2);
        } else {
            throw new RuntimeException();
        }
        this._$1.setColumns(this._$2.getTableColumnNum());
        this._$1.setColumnRepeatedGroupHeader(this._$3);
        try {
            this._$1.createPages();
            return;
        }
        catch (Throwable throwable) {
            this._$1.clear();
            throw throwable;
        }
    }

    public static PageBuilder cacheRead(IReport iReport, PagerInfo pagerInfo, String string, String string2, boolean bl) throws IOException, ClassNotFoundException {
        String string3 = new File(string, string2).getPath();
        PageBuilder pageBuilder = new PageBuilder(pagerInfo);
        new PageBuilder(pagerInfo)._$1 = new IlIlIlllIlIIlIlI(iReport, string3, bl);
        return pageBuilder;
    }

    public boolean cacheSave(String string, String string2, boolean bl) throws IOException {
        String string3 = new File(string, string2).getPath();
        if (this._$1 instanceof SimplePager2) {
            return this._$1((SimplePager2)this._$1, string3, bl);
        }
        if (this._$1 instanceof SimplePager) {
            ((SimplePager)this._$1).saveTo(string3, bl);
        } else if (this._$1 instanceof SrcRptPager) {
            ((SrcRptPager)this._$1).saveTo(string3, bl);
        } else {
            throw new RuntimeException();
        }
        return true;
    }

    public void createPages() throws Throwable {
        if (this._$4 != null) {
            this._$1(this._$4);
            this._$4 = null;
        }
    }

    public IReport[] getAllPages() throws Exception {
        int n = this._$1.getYPageCount();
        int n2 = this._$1.getXPageCount();
        IReport[] iReportArray = new IReport[n * n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                iReportArray[n3 * n2 + n4] = this._$1.getPage(n3, n4, n, n2);
                ++n4;
            }
            ++n3;
        }
        return iReportArray;
    }

    public IReport getPage(int n) throws Exception {
        int n2 = n - 1;
        IReport iReport = null;
        if (n2 >= 0) {
            int n3 = this._$1.getXPageCount();
            int n4 = this._$1.getYPageCount();
            int n5 = n2 / n3;
            int n6 = n2 % n3;
            if (n5 >= 0 && n5 < n4 && n6 >= 0 && n6 < n3) {
                iReport = this._$1.getPage(n5, n6, n4, n3);
            }
        }
        if (iReport == null) {
            MessageManager messageManager = EngineMessage.get();
            throw new ReportError(String.valueOf(messageManager.getMessage("PageBuilder.invalidPage")) + n);
        }
        return iReport;
    }

    public int getPageCount() {
        return this._$1.getXPageCount() * this._$1.getYPageCount();
    }

    public PagerInfo getPagerInfo() {
        return this._$2;
    }

    public int getPapersCount() {
        return (int)Math.ceil((double)(this._$1.getYPageCount() * this._$1.getXPageCount()) / (double)(this._$2.getLayoutColNum() * this._$2.getLayoutRowNum()));
    }

    public int getXPageCount() {
        return this._$1.getXPageCount();
    }

    public int getYPageCount() {
        return this._$1.getYPageCount();
    }

    public void interrupt() {
        if (this._$1 != null) {
            this._$1.interrupt();
        }
    }

    public static boolean isApplet() {
        return _$5;
    }
}

