/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.usermodel;

import com.runqian.base4.resources.EngineMessage;
import com.runqian.base4.resources.MessageManager;
import com.runqian.base4.tool.GC;
import com.runqian.base4.tool.GV;
import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.report4.model.engine.ExtCellSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class Palette {
    public static final byte PATTERN_DEFAULT = 0;
    public static final byte PATTERN_H_THIN_LINE = 1;
    public static final byte PATTERN_H_THICK_LINE = 2;
    public static final byte PATTERN_V_THIN_LINE = 3;
    public static final byte PATTERN_V_THICK_LINE = 4;
    public static final byte PATTERN_THIN_SLASH = 5;
    public static final byte PATTERN_THICK_SLASH = 6;
    public static final byte PATTERN_THIN_BACKSLASH = 7;
    public static final byte PATTERN_THICK_BACKSLASH = 8;
    public static final byte PATTERN_THIN_GRID = 9;
    public static final byte PATTERN_THICK_GRID = 10;
    public static final byte PATTERN_THIN_BEVEL_GRID = 11;
    public static final byte PATTERN_THICK_BEVEL_GRID = 12;
    public static final byte PATTERN_DOT_1 = 13;
    public static final byte PATTERN_DOT_2 = 14;
    public static final byte PATTERN_DOT_3 = 15;
    public static final byte PATTERN_DOT_4 = 16;
    public static final byte PATTERN_SQUARE_FLOOR = 17;
    public static final byte PATTERN_DIAMOND_FLOOR = 18;
    public static final byte PATTERN_BRICK_WALL = 19;
    private int[] _$1 = null;
    private byte[] _$2 = null;
    private int _$3 = 0;
    private static Palette _$4 = Palette._$2();
    private static Map _$5 = Palette._$1();
    static /* synthetic */ Class class$com$runqian$report4$usermodel$Palette;

    public Palette() {
        this(20);
    }

    public Palette(int n) {
        this._$1 = new int[n];
        this._$2 = new byte[n];
    }

    private static Map _$1() {
        HashMap hashMap = new HashMap();
        try {
            Properties properties = new Properties();
            ExtCellSet extCellSet = ExtCellSet.get();
            InputStream inputStream = null;
            if (extCellSet.getType() == 0) {
                String string = String.valueOf(GC.PATH_WEB_CONFIG) + "/color.properties";
                File file = new File(GV.getAbsolutePath(string));
                inputStream = file.exists() ? new FileInputStream(file) : (class$com$runqian$report4$usermodel$Palette != null ? class$com$runqian$report4$usermodel$Palette : (class$com$runqian$report4$usermodel$Palette = Palette.class$("com.runqian.report4.usermodel.Palette"))).getResourceAsStream(string);
            }
            if (inputStream == null) {
                inputStream = (class$com$runqian$report4$usermodel$Palette != null ? class$com$runqian$report4$usermodel$Palette : (class$com$runqian$report4$usermodel$Palette = Palette.class$("com.runqian.report4.usermodel.Palette"))).getResourceAsStream("/config/color.properties");
            }
            properties.load(inputStream);
            return Palette.loadPalettes(properties);
        }
        catch (Exception exception) {
            MessageManager messageManager = EngineMessage.get();
            System.out.println(messageManager.getMessage("GraphExpression.getColor"));
            return hashMap;
        }
    }

    private static int _$1(int n, int n2, int n3, int n4) {
        return (n4 & 0xFF) << 24 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF;
    }

    private static Palette _$2() {
        Palette palette = new Palette(26);
        palette.addColor(Palette._$1(128, 128, 0, 255));
        palette.addColor(Palette._$1(255, 128, 0, 255));
        palette.addColor(Palette._$1(192, 255, 0, 255));
        palette.addColor(Palette._$1(0, 0, 128, 255));
        palette.addColor(Palette._$1(128, 0, 128, 255));
        palette.addColor(Palette._$1(255, 0, 128, 255));
        palette.addColor(Palette._$1(0, 128, 128, 255));
        palette.addColor(Palette._$1(128, 128, 128, 255));
        palette.addColor(Palette._$1(0, 255, 255, 255));
        palette.addColor(Palette._$1(192, 192, 192, 255));
        palette.addColor(Palette._$1(255, 128, 128, 255));
        palette.addColor(Palette._$1(0, 255, 128, 255));
        palette.addColor(Palette._$1(192, 255, 128, 255));
        palette.addColor(Palette._$1(255, 255, 0, 255));
        palette.addColor(Palette._$1(255, 255, 128, 255));
        palette.addColor(Palette._$1(128, 0, 255, 255));
        palette.addColor(Palette._$1(255, 0, 255, 255));
        palette.addColor(Palette._$1(0, 128, 255, 255));
        palette.addColor(Palette._$1(128, 128, 255, 255));
        palette.addColor(Palette._$1(255, 128, 255, 255));
        palette.addColor(Palette._$1(192, 255, 255, 255));
        palette.addColor(Palette._$1(255, 0, 0, 255));
        palette.addColor(Palette._$1(0, 255, 0, 255));
        palette.addColor(Palette._$1(0, 0, 255, 255));
        palette.addColor(Palette._$1(0, 128, 0, 255));
        palette.addColor(Palette._$1(255, 255, 255, 255));
        return palette;
    }

    public void addColor(int n) {
        this.ensureCapacity(this._$3 + 1);
        this._$1[this._$3++] = n;
    }

    public void addColor(int n, int n2) {
        this.ensureCapacity(this._$3 + 1);
        int[] nArray = this._$1;
        int n3 = this._$3 - n;
        System.arraycopy(nArray, n, nArray, n + 1, n3);
        nArray[n] = n2;
        ++this._$3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void clear() {
        this._$3 = 0;
    }

    public void ensureCapacity(int n) {
        int[] nArray = this._$1;
        if (n > nArray.length) {
            int n2 = nArray.length * 3 / 2 + 1;
            this._$1 = new int[n2 < n ? n : n2];
            System.arraycopy(nArray, 0, this._$1, 0, this._$3);
            this._$2 = new byte[n2 < n ? n : n2];
            System.arraycopy(this._$2, 0, this._$2, 0, this._$3);
        }
    }

    public int getColor(int n) {
        if (this._$1.length == 0) {
            return _$4.getColor(n);
        }
        int n2 = n < this._$1.length ? n : n % this._$1.length;
        return this._$1[n2];
    }

    public static Palette getDefaultPalette() {
        return _$4;
    }

    public byte getPattern(int n) {
        if (this._$2.length == 0) {
            return 0;
        }
        int n2 = n < this._$2.length ? n : n % this._$2.length;
        return this._$2[n2];
    }

    public static Paint getPatternPaint(Color color, byte by) {
        TexturePaint texturePaint = null;
        int n = 0;
        int n2 = 0;
        Color color2 = color;
        Color color3 = Color.black;
        switch (by) {
            case 1: {
                Rectangle rectangle = new Rectangle(n + 1, n2 + 1, 6, 6);
                BufferedImage bufferedImage = new BufferedImage(6, 6, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 6, 6);
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(0.1f));
                graphics2D.drawLine(0, 1, 6, 1);
                graphics2D.drawLine(0, 3, 6, 3);
                graphics2D.drawLine(0, 5, 6, 5);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 2: {
                Rectangle rectangle = new Rectangle(n + 1, n2 + 1, 6, 6);
                BufferedImage bufferedImage = new BufferedImage(6, 6, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 6, 6);
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(1.5f));
                graphics2D.drawLine(0, 2, 6, 2);
                graphics2D.drawLine(0, 5, 6, 5);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 3: {
                Rectangle rectangle = new Rectangle(n + 1, n2 + 1, 6, 6);
                BufferedImage bufferedImage = new BufferedImage(6, 6, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 6, 6);
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(0.1f));
                graphics2D.drawLine(1, 0, 1, 6);
                graphics2D.drawLine(3, 0, 3, 6);
                graphics2D.drawLine(5, 0, 5, 6);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 4: {
                Rectangle rectangle = new Rectangle(n + 1, n2 + 1, 6, 6);
                BufferedImage bufferedImage = new BufferedImage(6, 6, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 6, 6);
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(1.5f));
                graphics2D.drawLine(2, 0, 2, 6);
                graphics2D.drawLine(5, 0, 5, 6);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 5: {
                Rectangle rectangle = new Rectangle(n + 1, n2 + 1, 3, 3);
                BufferedImage bufferedImage = new BufferedImage(3, 3, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 3, 3);
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(0.1f));
                graphics2D.drawLine(0, 0, 3, 3);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 6: {
                Rectangle rectangle = new Rectangle(n + 1, n2 + 1, 4, 4);
                BufferedImage bufferedImage = new BufferedImage(4, 4, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                Palette.setGraphAntiAliasing(graphics2D);
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 4, 4);
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(1.5f, 2, 2, 10.0f, null, 0.0f));
                graphics2D.drawLine(0, 0, 4, 4);
                graphics2D.drawLine(3, -1, 5, 1);
                graphics2D.drawLine(-1, 3, 1, 5);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 7: {
                Rectangle rectangle = new Rectangle(n + 1, n2 + 1, 3, 3);
                BufferedImage bufferedImage = new BufferedImage(3, 3, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 3, 3);
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(0.1f));
                graphics2D.drawLine(2, 0, -1, 3);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 8: {
                Rectangle rectangle = new Rectangle(n + 1, n2 + 1, 4, 4);
                BufferedImage bufferedImage = new BufferedImage(4, 4, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                Palette.setGraphAntiAliasing(graphics2D);
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 4, 4);
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(1.5f, 2, 2, 10.0f, null, 0.0f));
                graphics2D.drawLine(4, 0, 0, 4);
                graphics2D.drawLine(-1, 1, 1, -1);
                graphics2D.drawLine(3, 5, 5, 3);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 9: {
                Rectangle rectangle = new Rectangle(n + 1, n2 + 1, 3, 3);
                BufferedImage bufferedImage = new BufferedImage(3, 3, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 3, 3);
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(0.1f, 2, 0, 10.0f, null, 0.0f));
                graphics2D.drawLine(1, 0, 1, 3);
                graphics2D.drawLine(0, 1, 3, 1);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 10: {
                Rectangle rectangle = new Rectangle(n + 1, n2 + 1, 5, 5);
                BufferedImage bufferedImage = new BufferedImage(5, 5, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 5, 5);
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(1.5f, 2, 0, 10.0f, null, 0.0f));
                graphics2D.drawLine(3, 0, 3, 5);
                graphics2D.drawLine(0, 3, 5, 3);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 11: {
                Rectangle rectangle = new Rectangle(n + 1, n2 + 1, 5, 5);
                BufferedImage bufferedImage = new BufferedImage(5, 5, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 5, 5);
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(0.5f, 2, 0, 10.0f, null, 0.0f));
                graphics2D.drawLine(0, 0, 5, 5);
                graphics2D.drawLine(0, 5, 5, 0);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 12: {
                Rectangle rectangle = new Rectangle(n + 1, n2 + 1, 6, 6);
                BufferedImage bufferedImage = new BufferedImage(6, 6, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                Palette.setGraphAntiAliasing(graphics2D);
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 6, 6);
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(1.5f, 2, 2, 10.0f, null, 0.0f));
                graphics2D.drawLine(0, 0, 6, 6);
                graphics2D.drawLine(0, 6, 6, 0);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 13: {
                Rectangle rectangle = new Rectangle(n, n2, 12, 12);
                BufferedImage bufferedImage = new BufferedImage(12, 12, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                Palette.setGraphAntiAliasing(graphics2D);
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 12, 12);
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, null, 0.0f));
                graphics2D.drawLine(2, 3, 2, 3);
                graphics2D.drawLine(8, 9, 8, 9);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 14: {
                Rectangle rectangle = new Rectangle(n, n2, 12, 12);
                BufferedImage bufferedImage = new BufferedImage(12, 12, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 12, 12);
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, null, 0.0f));
                graphics2D.drawLine(2, 3, 2, 3);
                graphics2D.drawLine(6, 11, 6, 11);
                graphics2D.drawLine(10, 7, 10, 7);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 15: {
                Rectangle rectangle = new Rectangle(n, n2, 9, 9);
                BufferedImage bufferedImage = new BufferedImage(9, 9, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                Palette.setGraphAntiAliasing(graphics2D);
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 9, 9);
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, null, 0.0f));
                graphics2D.drawLine(2, 2, 2, 2);
                graphics2D.drawLine(5, 8, 5, 8);
                graphics2D.drawLine(8, 5, 8, 5);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 16: {
                Rectangle rectangle = new Rectangle(n, n2, 4, 4);
                BufferedImage bufferedImage = new BufferedImage(4, 4, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 4, 4);
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, null, 0.0f));
                graphics2D.drawLine(1, 3, 1, 3);
                graphics2D.drawLine(3, 1, 3, 1);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 17: {
                Rectangle rectangle = new Rectangle(0, 0, 8, 8);
                BufferedImage bufferedImage = new BufferedImage(8, 8, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 8, 8);
                graphics2D.setColor(color3);
                graphics2D.fillRect(0, 0, 4, 4);
                graphics2D.fillRect(4, 4, 4, 4);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 18: {
                Rectangle rectangle = new Rectangle(n + 1, n2 + 1, 8, 8);
                BufferedImage bufferedImage = new BufferedImage(8, 8, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 8, 8);
                graphics2D.setColor(color3);
                int[] nArray = new int[4];
                nArray[0] = 4;
                nArray[2] = 4;
                nArray[3] = 8;
                int[] nArray2 = nArray;
                int[] nArray3 = new int[4];
                nArray3[1] = 4;
                nArray3[2] = 8;
                nArray3[3] = 4;
                int[] nArray4 = nArray3;
                graphics2D.fillPolygon(nArray2, nArray4, 4);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 19: {
                Rectangle rectangle = new Rectangle(n + 1, n2 + 1, 12, 12);
                BufferedImage bufferedImage = new BufferedImage(12, 12, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, 12, 12);
                graphics2D.setStroke(new BasicStroke(0.1f));
                graphics2D.setColor(color3);
                graphics2D.drawLine(0, 0, 12, 0);
                graphics2D.drawLine(0, 3, 12, 3);
                graphics2D.drawLine(0, 6, 12, 6);
                graphics2D.drawLine(0, 9, 12, 9);
                graphics2D.drawLine(2, 0, 2, 3);
                graphics2D.drawLine(8, 3, 8, 6);
                graphics2D.drawLine(2, 6, 2, 9);
                graphics2D.drawLine(8, 9, 8, 12);
                texturePaint = new TexturePaint(bufferedImage, rectangle);
                break;
            }
        }
        return texturePaint;
    }

    public static int getPatternsCount() {
        return 20;
    }

    public static byte[] listPatterns() {
        byte[] byArray = new byte[20];
        int n = 0;
        while (n <= 19) {
            byArray[n] = n;
            n = (byte)(n + 1);
        }
        return byArray;
    }

    public static Map loadPalettes(Properties properties) {
        HashMap<String, Palette> hashMap = new HashMap<String, Palette>();
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArgumentTokenizer argumentTokenizer = new ArgumentTokenizer(properties.getProperty(string), ',');
            int n = argumentTokenizer.countTokens();
            Palette palette = new Palette(n);
            new Palette(n)._$3 = 0;
            while (argumentTokenizer.hasNext()) {
                StringTokenizer stringTokenizer = new StringTokenizer(argumentTokenizer.next(), "@");
                palette._$1[palette._$3] = Integer.parseInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    palette._$2[palette._$3] = Byte.parseByte(stringTokenizer.nextToken());
                }
                ++palette._$3;
            }
            hashMap.put(string, palette);
        }
        return hashMap;
    }

    public static Palette readColor(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        if (ExtCellSet.get().getType() == 0) {
            _$5 = Palette._$1();
        }
        return (Palette)_$5.get(string);
    }

    protected static void setGraphAntiAliasing(Graphics2D graphics2D) {
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1, 0.1f));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public int size() {
        return this._$3;
    }

    public void trimToSize() {
        int[] nArray = this._$1;
        if (this._$3 < nArray.length) {
            this._$1 = new int[this._$3];
            System.arraycopy(nArray, 0, this._$1, 0, this._$3);
            this._$2 = new byte[this._$3];
            System.arraycopy(this._$2, 0, this._$2, 0, this._$3);
        }
    }
}

