/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.util;

import com.runqian.report4.usermodel.IRecord;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;

public class ByteArrayInputRecord {
    private ByteArrayInputStream _$1;

    public ByteArrayInputRecord(byte[] byArray) {
        this._$1 = new ByteArrayInputStream(byArray);
    }

    public int available() {
        return this._$1.available();
    }

    public boolean readBoolean() throws IOException {
        int n = this._$1.read();
        return n == 1;
    }

    public boolean readBoolean2() throws IOException, EOFException {
        if (this._$1.available() > 0) {
            int n = this._$1.read();
            return n == 1;
        }
        throw new EOFException();
    }

    public byte readByte() throws IOException {
        int n = this._$1.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public byte readByte2() throws IOException, EOFException, EOFException {
        if (this._$1.available() > 0) {
            int n = this._$1.read();
            if (n < 0) {
                throw new EOFException();
            }
            return (byte)n;
        }
        throw new EOFException();
    }

    public ArrayList readByteArray() throws IOException {
        int n = this.readShort();
        if (n <= 0) {
            return null;
        }
        ArrayList<Byte> arrayList = new ArrayList<Byte>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(new Byte(this.readByte()));
            ++n2;
        }
        return arrayList;
    }

    public ArrayList readByteArray2() throws IOException, EOFException {
        if (this._$1.available() > 0) {
            int n = this.readShort();
            if (n <= 0) {
                return null;
            }
            ArrayList<Byte> arrayList = new ArrayList<Byte>(n);
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(new Byte(this.readByte()));
                ++n2;
            }
            return arrayList;
        }
        throw new EOFException();
    }

    public byte[] readBytes() throws IOException {
        int n = this.readInt();
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    public byte[] readBytes2() throws IOException, EOFException {
        if (this._$1.available() > 0) {
            int n = this.readInt();
            if (n <= 0) {
                return null;
            }
            byte[] byArray = new byte[n];
            this.readFully(byArray);
            return byArray;
        }
        throw new EOFException();
    }

    public final char readChar() throws IOException {
        int n;
        int n2 = this._$1.read();
        if ((n2 | (n = this._$1.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + n);
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public double readDouble2() throws IOException, EOFException {
        if (this._$1.available() > 0) {
            return Double.longBitsToDouble(this.readLong());
        }
        throw new EOFException();
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public float readFloat2() throws IOException, EOFException {
        if (this._$1.available() > 0) {
            return Float.intBitsToFloat(this.readInt());
        }
        throw new EOFException();
    }

    public int readFully(byte[] byArray) throws IOException {
        return this.readFully(byArray, 0, byArray.length);
    }

    public int readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = this._$1.read(byArray, n + n4, n2 - n4)) >= 0) continue;
            if (n4 == 0) {
                return -1;
            }
            return n4;
        } while ((n4 += n3) != n2);
        return n4;
    }

    public int readFully2(byte[] byArray) throws IOException, EOFException {
        if (this._$1.available() > 0) {
            return this.readFully(byArray, 0, byArray.length);
        }
        throw new EOFException();
    }

    public int readFully2(byte[] byArray, int n, int n2) throws IOException, EOFException {
        if (this._$1.available() > 0) {
            int n3;
            int n4 = 0;
            do {
                if ((n3 = this._$1.read(byArray, n + n4, n2 - n4)) >= 0) continue;
                if (n4 == 0) {
                    return -1;
                }
                return n4;
            } while ((n4 += n3) != n2);
            return n4;
        }
        throw new EOFException();
    }

    public int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this._$1.read();
        if ((n4 | (n3 = this._$1.read()) | (n2 = this._$1.read()) | (n = this._$1.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    public int readInt2() throws IOException, EOFException {
        if (this._$1.available() > 0) {
            int n;
            int n2;
            int n3;
            int n4 = this._$1.read();
            if ((n4 | (n3 = this._$1.read()) | (n2 = this._$1.read()) | (n = this._$1.read())) < 0) {
                throw new EOFException();
            }
            return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
        }
        throw new EOFException();
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public long readLong2() throws IOException, EOFException {
        if (this._$1.available() > 0) {
            return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
        }
        throw new EOFException();
    }

    public Object readObject(boolean bl) throws IOException, ClassNotFoundException {
        byte by = this.readByte();
        switch (by) {
            case -1: {
                return null;
            }
            case 0: {
                String string = this.readString();
                IRecord iRecord = null;
                try {
                    iRecord = (IRecord)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    exception.printStackTrace();
                }
                return this.readRecord(iRecord);
            }
            case 1: {
                return this.readUTF();
            }
            case 2: {
                int n = this.readInt();
                byte[] byArray = this.readBytes();
                return new BigDecimal(new BigInteger(byArray), n);
            }
            case 3: {
                return new java.util.Date(this.readLong());
            }
            case 4: {
                return new Integer(this.readInt());
            }
            case 5: {
                return new Long(this.readLong());
            }
            case 6: {
                if (this.readByte() == 1) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 7: {
                return new BigInteger(this.readBytes());
            }
            case 8: {
                return this.readBytes();
            }
            case 9: {
                return new Double(this.readDouble());
            }
            case 10: {
                return new Float(this.readFloat());
            }
            case 11: {
                return new Byte(this.readByte());
            }
            case 12: {
                return new Short(this.readShort());
            }
            case 31: {
                return new Timestamp(this.readLong());
            }
            case 32: {
                return new Time(this.readLong());
            }
            case 33: {
                return new Date(this.readLong());
            }
        }
        return this.readBytes();
    }

    public Object readObject2(boolean bl) throws IOException, ClassNotFoundException, EOFException {
        if (this._$1.available() > 0) {
            byte by = this.readByte();
            switch (by) {
                case -1: {
                    return null;
                }
                case 1: {
                    return this.readUTF();
                }
                case 2: {
                    int n = this.readInt();
                    byte[] byArray = this.readBytes();
                    return new BigDecimal(new BigInteger(byArray), n);
                }
                case 3: {
                    return new java.util.Date(this.readLong());
                }
                case 4: {
                    return new Integer(this.readInt());
                }
                case 5: {
                    return new Long(this.readLong());
                }
                case 6: {
                    if (this.readByte() == 1) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                case 7: {
                    return new BigInteger(this.readBytes());
                }
                case 8: {
                    return this.readBytes();
                }
                case 9: {
                    return new Double(this.readDouble());
                }
                case 10: {
                    return new Float(this.readFloat());
                }
                case 11: {
                    return new Byte(this.readByte());
                }
                case 12: {
                    return new Short(this.readShort());
                }
            }
            return this.readBytes();
        }
        throw new EOFException();
    }

    public IRecord readRecord(IRecord iRecord) throws IOException, ClassNotFoundException {
        int n = this.readInt();
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        iRecord.fillRecord(byArray);
        return iRecord;
    }

    public IRecord readRecord2(IRecord iRecord) throws IOException, ClassNotFoundException, EOFException {
        if (this._$1.available() > 0) {
            int n = this.readInt();
            if (n <= 0) {
                return null;
            }
            byte[] byArray = new byte[n];
            this._$1.read(byArray);
            iRecord.fillRecord(byArray);
            return iRecord;
        }
        throw new EOFException();
    }

    public short readShort() throws IOException {
        int n;
        int n2 = this._$1.read();
        if ((n2 | (n = this._$1.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n);
    }

    public short readShort2() throws IOException, EOFException {
        if (this._$1.available() > 0) {
            int n;
            int n2 = this._$1.read();
            if ((n2 | (n = this._$1.read())) < 0) {
                throw new EOFException();
            }
            return (short)((n2 << 8) + n);
        }
        throw new EOFException();
    }

    public String readString() throws IOException {
        int n = this.readInt();
        if (n <= -2) {
            n = -1 * n - 2;
            StringBuffer stringBuffer = new StringBuffer(n);
            byte[] byArray = new byte[n];
            int n2 = 0;
            this.readFully(byArray, 0, n);
            while (n2 < n) {
                int n3 = byArray[n2] & 0xFF;
                switch (n3 >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++n2;
                        stringBuffer.append((char)n3);
                        break;
                    }
                    case 12: 
                    case 13: {
                        if ((n2 += 2) > n) {
                            throw new UTFDataFormatException();
                        }
                        byte by = byArray[n2 - 1];
                        if ((by & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        stringBuffer.append((char)((n3 & 0x1F) << 6 | by & 0x3F));
                        break;
                    }
                    case 14: {
                        if ((n2 += 3) > n) {
                            throw new UTFDataFormatException();
                        }
                        byte by = byArray[n2 - 2];
                        byte by2 = byArray[n2 - 1];
                        if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        stringBuffer.append((char)((n3 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F));
                        break;
                    }
                    default: {
                        throw new UTFDataFormatException();
                    }
                }
            }
            return new String(stringBuffer);
        }
        if (n == -1) {
            return null;
        }
        byte[] byArray = new byte[n];
        this._$1.read(byArray);
        return new String(byArray);
    }

    public String readString2() throws IOException, EOFException {
        if (this._$1.available() > 0) {
            return this.readString();
        }
        throw new EOFException();
    }

    public ArrayList readStringArray() throws IOException {
        int n = this.readShort();
        if (n <= 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.readString());
            ++n2;
        }
        return arrayList;
    }

    public ArrayList readStringArray2() throws IOException, EOFException {
        if (this._$1.available() > 0) {
            int n = this.readShort();
            if (n <= 0) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>(n);
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(this.readString());
                ++n2;
            }
            return arrayList;
        }
        throw new EOFException();
    }

    public String[] readStrings() throws IOException {
        int n = this.readShort();
        if (n <= 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.readString();
            ++n2;
        }
        return stringArray;
    }

    public String[] readStrings2() throws IOException, EOFException {
        if (this._$1.available() > 0) {
            int n = this.readShort();
            if (n <= 0) {
                return null;
            }
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = this.readString();
                ++n2;
            }
            return stringArray;
        }
        throw new EOFException();
    }

    public String readUTF() throws IOException {
        int n = this.readUnsignedShort();
        StringBuffer stringBuffer = new StringBuffer(n);
        byte[] byArray = new byte[n];
        int n2 = 0;
        this.readFully(byArray, 0, n);
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    stringBuffer.append((char)n3);
                    break;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0x1F) << 6 | by & 0x3F));
                    break;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 2];
                    byte by2 = byArray[n2 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F));
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(stringBuffer);
    }

    public String readUTF2() throws IOException {
        if (this._$1.available() > 0) {
            int n = this.readShort();
            StringBuffer stringBuffer = new StringBuffer(n);
            byte[] byArray = new byte[n];
            int n2 = 0;
            this.readFully(byArray, 0, n);
            while (n2 < n) {
                int n3 = byArray[n2] & 0xFF;
                switch (n3 >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++n2;
                        stringBuffer.append((char)n3);
                        break;
                    }
                    case 12: 
                    case 13: {
                        if ((n2 += 2) > n) {
                            throw new UTFDataFormatException();
                        }
                        byte by = byArray[n2 - 1];
                        if ((by & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        stringBuffer.append((char)((n3 & 0x1F) << 6 | by & 0x3F));
                        break;
                    }
                    case 14: {
                        if ((n2 += 3) > n) {
                            throw new UTFDataFormatException();
                        }
                        byte by = byArray[n2 - 2];
                        byte by2 = byArray[n2 - 1];
                        if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        stringBuffer.append((char)((n3 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F));
                        break;
                    }
                    default: {
                        throw new UTFDataFormatException();
                    }
                }
            }
            return new String(stringBuffer);
        }
        throw new EOFException();
    }

    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this._$1.read();
        if ((n2 | (n = this._$1.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + n;
    }
}

