/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.util;

import com.runqian.report4.usermodel.IRecord;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;

public class ByteArrayOutputRecord {
    private ByteArrayOutputStream _$1 = new ByteArrayOutputStream();

    private void _$1(char c) throws IOException {
        this._$1.write(c >>> 8 & 0xFF);
        this._$1.write(c & 0xFF);
    }

    public int size() {
        return this._$1.size();
    }

    public byte[] toByteArray() {
        return this._$1.toByteArray();
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this._$1.write(1);
            return;
        }
        this._$1.write(0);
    }

    public void writeByte(byte by) throws IOException {
        this._$1.write(by);
    }

    public void writeByteArray(ArrayList arrayList) throws IOException {
        if (arrayList == null) {
            this.writeShort((short)0);
            return;
        }
        int n = arrayList.size();
        this.writeShort((short)n);
        int n2 = 0;
        while (n2 < n) {
            this.writeByte((Byte)arrayList.get(n2));
            ++n2;
        }
    }

    public void writeBytes(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.writeInt(0);
            return;
        }
        this.writeInt(byArray.length);
        this._$1.write(byArray);
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeInt(int n) throws IOException {
        this._$1.write(n >>> 24 & 0xFF);
        this._$1.write(n >>> 16 & 0xFF);
        this._$1.write(n >>> 8 & 0xFF);
        this._$1.write(n & 0xFF);
    }

    public void writeLong(long l) throws IOException {
        this._$1.write((int)(l >>> 56) & 0xFF);
        this._$1.write((int)(l >>> 48) & 0xFF);
        this._$1.write((int)(l >>> 40) & 0xFF);
        this._$1.write((int)(l >>> 32) & 0xFF);
        this._$1.write((int)(l >>> 24) & 0xFF);
        this._$1.write((int)(l >>> 16) & 0xFF);
        this._$1.write((int)(l >>> 8) & 0xFF);
        this._$1.write((int)l & 0xFF);
    }

    public void writeObject(Object object, boolean bl) throws IOException {
        if (object == null) {
            this._$1.write(-1);
            return;
        }
        if (object instanceof IRecord) {
            this._$1.write(0);
            this.writeString(object.getClass().getName());
            this.writeRecord((IRecord)object);
            return;
        }
        if (object instanceof String) {
            this._$1.write(1);
            this.writeUTF((String)object);
            return;
        }
        if (object instanceof BigDecimal) {
            this._$1.write(2);
            BigDecimal bigDecimal = (BigDecimal)object;
            this.writeInt(bigDecimal.scale());
            this.writeBytes(bigDecimal.unscaledValue().toByteArray());
            return;
        }
        if (object instanceof Timestamp) {
            this._$1.write(31);
            this.writeLong(((Timestamp)object).getTime());
            return;
        }
        if (object instanceof Time) {
            this._$1.write(32);
            this.writeLong(((Time)object).getTime());
            return;
        }
        if (object instanceof java.sql.Date) {
            this._$1.write(33);
            this.writeLong(((java.sql.Date)object).getTime());
            return;
        }
        if (object instanceof Date) {
            this._$1.write(3);
            this.writeLong(((Date)object).getTime());
            return;
        }
        if (object instanceof Integer) {
            this._$1.write(4);
            this.writeInt((Integer)object);
            return;
        }
        if (object instanceof Long) {
            this._$1.write(5);
            this.writeLong((Long)object);
            return;
        }
        if (object instanceof Boolean) {
            this._$1.write(6);
            this._$1.write((Boolean)object != false ? 1 : 0);
            return;
        }
        if (object instanceof BigInteger) {
            this._$1.write(7);
            this.writeBytes(((BigInteger)object).toByteArray());
            return;
        }
        if (object instanceof byte[]) {
            this._$1.write(8);
            this.writeBytes((byte[])object);
            return;
        }
        if (object instanceof Double) {
            this._$1.write(9);
            this.writeDouble((Double)object);
            return;
        }
        if (object instanceof Float) {
            this._$1.write(10);
            this.writeFloat(((Float)object).floatValue());
            return;
        }
        if (object instanceof Byte) {
            this._$1.write(11);
            this._$1.write(((Byte)object).byteValue());
            return;
        }
        if (object instanceof Short) {
            this._$1.write(12);
            this.writeShort((Short)object);
            return;
        }
        this._$1.write(-1);
    }

    public void writeRecord(IRecord iRecord) throws IOException {
        if (iRecord == null) {
            this.writeInt(-1);
            return;
        }
        byte[] byArray = iRecord.serialize();
        this.writeBytes(byArray);
    }

    public void writeShort(short s) throws IOException {
        this._$1.write(s >>> 8 & 0xFF);
        this._$1.write(s & 0xFF);
    }

    public void writeString(String string) throws IOException {
        char c;
        if (string == null) {
            this.writeInt(-1);
            return;
        }
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        int n3 = 0;
        string.getChars(0, n, cArray, 0);
        int n4 = 0;
        while (n4 < n) {
            c = cArray[n4];
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n4;
        }
        byte[] byArray = new byte[n2];
        this.writeInt(-1 * n2 - 2);
        int n5 = 0;
        while (n5 < n) {
            c = cArray[n5];
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n3++] = (byte)c;
            } else if (c > '\u07ff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
            } else {
                byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
            }
            ++n5;
        }
        this._$1.write(byArray);
    }

    public void writeStringArray(ArrayList arrayList) throws IOException {
        if (arrayList == null) {
            this.writeShort((short)0);
            return;
        }
        int n = arrayList.size();
        this.writeShort((short)n);
        int n2 = 0;
        while (n2 < n) {
            this.writeString((String)arrayList.get(n2));
            ++n2;
        }
    }

    public void writeStrings(String[] stringArray) throws IOException {
        if (stringArray == null) {
            this.writeShort((short)0);
            return;
        }
        int n = stringArray.length;
        this.writeShort((short)n);
        int n2 = 0;
        while (n2 < n) {
            this.writeString(stringArray[n2]);
            ++n2;
        }
    }

    public int writeUTF(String string) throws IOException {
        char c;
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        int n3 = 0;
        string.getChars(0, n, cArray, 0);
        int n4 = 0;
        while (n4 < n) {
            c = cArray[n4];
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n4;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] byArray = new byte[n2 + 2];
        byte[] byArray2 = byArray;
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray2[n3++] = (byte)(n2 & 0xFF);
        int n5 = 0;
        while (n5 < n) {
            c = cArray[n5];
            if (c >= '\u0001' && c <= '\u007f') {
                byArray2[n3++] = (byte)c;
            } else if (c > '\u07ff') {
                byArray2[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray2[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray2[n3++] = (byte)(0x80 | c & 0x3F);
            } else {
                byArray2[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray2[n3++] = (byte)(0x80 | c & 0x3F);
            }
            ++n5;
        }
        this._$1.write(byArray2);
        return n2 + 2;
    }
}

