/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.view.applet;

import com.runqian.base4.resources.MessageManager;
import com.runqian.report4.view.applet.AReport;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.net.URL;
import java.util.StringTokenizer;
import javax.print.PrintService;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import netscape.javascript.JSObject;

public class DirectPrintApplet
extends JApplet
implements ActionListener {
    private String appRoot;
    private String backColor;
    private String blackWhitePrint;
    private String cachedId;
    private String dataServlet;
    private String fileName;
    private String fontColor;
    private String fontFace;
    private String fontSize;
    private String icon;
    private String label;
    private MessageManager mm;
    private String needPrintPrompt;
    private String needSelectPrinter;
    private String needSetPageSize;
    private String paramCharset;
    private JButton printButton = new JButton();
    private String reportParamsId;
    private String savePrintSetup;
    private String srcType;

    public DirectPrintApplet() {
        this.mm = MessageManager.getManager("com.runqian.base4.resources.print");
    }

    public void actionPerformed(ActionEvent e) {
        JComponent source = (JComponent)e.getSource();
        if (source.equals(this.printButton)) {
            this.print();
        }
    }

    private String getParameter(String key, String def) {
        return this.getParameter(key) != null ? this.getParameter(key) : def;
    }

    public Frame getParentWindow(Component compOnApplet) {
        Container c = compOnApplet.getParent();
        while (c != null) {
            if (c instanceof Frame) {
                return (Frame)c;
            }
            c = c.getParent();
        }
        return null;
    }

    public void init() {
        this.initParameters();
        System.setProperty("java.awt.im.style", "on-the-spot");
        try {
            Container pane = this.getContentPane();
            pane.setLayout(new BorderLayout());
            if (this.icon == null) {
                this.printButton.setText(this.label);
                this.printButton.setFont(new Font(this.fontFace, 0, Integer.parseInt(this.fontSize)));
                this.printButton.setForeground(this.toColor(this.fontColor, Color.black));
                this.printButton.setBackground(this.toColor(this.backColor, Color.white));
            } else {
                ImageIcon ic = new ImageIcon(new URL(this.appRoot + this.icon));
                this.printButton.setIcon(ic);
            }
            this.printButton.setBorder(null);
            this.printButton.addActionListener(this);
            this.printButton.setCursor(Cursor.getPredefinedCursor(12));
            pane.add(this.printButton);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void initParameters() {
        this.appRoot = this.getParameter("appRoot", "");
        if (!this.appRoot.toLowerCase().startsWith("http")) {
            URL urlBase = this.getCodeBase();
            this.appRoot = urlBase.getProtocol() + "://" + urlBase.getHost() + ":" + urlBase.getPort() + this.appRoot;
        }
        this.dataServlet = this.getParameter("dataServlet", "");
        this.fileName = this.getParameter("fileName", "");
        this.srcType = this.getParameter("srcType", "file");
        this.reportParamsId = this.getParameter("reportParamsId", null);
        this.cachedId = this.getParameter("cachedId", null);
        this.fontFace = this.getParameter("fontFace", "\u5b8b\u4f53");
        this.fontSize = this.getParameter("fontSize", "12");
        int i = 0;
        while (i < this.fontSize.length()) {
            if (!Character.isDigit(this.fontSize.charAt(i))) {
                this.fontSize = this.fontSize.substring(0, i);
            }
            ++i;
        }
        this.fontColor = this.getParameter("fontColor", "#000000");
        this.backColor = this.getParameter("backColor", "#ffffff");
        this.label = this.getParameter("label", "\u6253\u5370");
        this.needPrintPrompt = this.getParameter("needPrintPrompt", "no");
        this.needSelectPrinter = this.getParameter("needSelectPrinter", "no");
        this.savePrintSetup = this.getParameter("savePrintSetup", "no");
        this.needSetPageSize = this.getParameter("needSetPageSize", "no");
        this.paramCharset = this.getParameter("paramCharset", "GBK");
        this.blackWhitePrint = this.getParameter("blackWhitePrint", "no");
        this.icon = this.getParameter("icon", null);
    }

    public void print() {
        String s = null;
        JSObject jsobject = null;
        try {
            jsobject = JSObject.getWindow((Applet)this);
            s = (String)jsobject.eval("javascript:try{ runqian_getPrintReports(); }catch(e){}");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (s != null) {
            this.fileName = s;
        }
        if (this.fileName == null || this.fileName.trim().length() == 0) {
            return;
        }
        if (this.needPrintPrompt.equalsIgnoreCase("yes") && JOptionPane.showConfirmDialog(null, "\u662f\u5426\u6253\u5370\uff1f", "\u662f\u5426\u6253\u5370", 0, 3) != 0) {
            return;
        }
        this.fileName = this.fileName.trim();
        PrinterJob job = PrinterJob.getPrinterJob();
        PrintService[] pss = job.lookupPrintServices();
        if (pss.length == 0) {
            JOptionPane.showMessageDialog(this, MessageManager.getManager("noPrinter"));
            return;
        }
        if (this.needSelectPrinter.equalsIgnoreCase("yes")) {
            try {
                if (!job.printDialog()) {
                    return;
                }
            }
            catch (Exception e) {
            }
        }
        boolean bsavePrintSetup = "yes".equalsIgnoreCase(this.savePrintSetup);
        PageFormat outerPf = null;
        int count = 1;
        if (this.fileName.startsWith("{")) {
            int index = 0;
            int len = this.fileName.length();
            while (index < len) {
                if ((index = this.fileName.indexOf("{", index)) >= 0) {
                    int end = this.fileName.indexOf("}", index);
                    s = this.fileName.substring(index + 1, end).trim();
                    index = end + 1;
                    String name = s;
                    String paramString = null;
                    int pos = s.indexOf("(");
                    if (pos > 0) {
                        paramString = s.substring(pos + 1, s.length() - 1).trim();
                        name = s.substring(0, pos).trim();
                    }
                    if (!name.toLowerCase().endsWith(".raq") && !name.toLowerCase().endsWith(".rat")) {
                        name = name + ".raq";
                    }
                    AReport report = new AReport();
                    report.appRoot = this.appRoot;
                    report.cachedId = this.cachedId;
                    report.dataServlet = this.dataServlet;
                    report.fileName = name;
                    if (paramString != null) {
                        report.paramString = paramString;
                        report.paramEncode = this.paramCharset;
                    }
                    report.srcType = this.srcType;
                    report.job = job;
                    report.savePrintSetup = bsavePrintSetup;
                    report.isBlackWhitePrint = "yes".equalsIgnoreCase(this.blackWhitePrint);
                    report.outerPf = outerPf;
                    if (count == 1 && this.needSetPageSize.equalsIgnoreCase("yes")) {
                        report.bSetPageSize = true;
                        outerPf = report.print();
                    } else {
                        report.print();
                    }
                    ++count;
                    continue;
                }
                break;
            }
        } else {
            StringTokenizer st = new StringTokenizer(this.fileName, ",");
            while (st.hasMoreTokens()) {
                String name = st.nextToken().trim();
                if (!name.toLowerCase().endsWith(".raq") && !name.toLowerCase().endsWith(".rat")) {
                    name = name + ".raq";
                }
                AReport report = new AReport();
                report.appRoot = this.appRoot;
                report.cachedId = this.cachedId;
                report.dataServlet = this.dataServlet;
                report.fileName = name;
                report.reportParamsId = this.reportParamsId;
                report.srcType = this.srcType;
                report.job = job;
                report.savePrintSetup = bsavePrintSetup;
                report.isBlackWhitePrint = "yes".equalsIgnoreCase(this.blackWhitePrint);
                report.outerPf = outerPf;
                if (count == 1 && this.needSetPageSize.equalsIgnoreCase("yes")) {
                    report.bSetPageSize = true;
                    outerPf = report.print();
                } else {
                    report.print();
                }
                ++count;
            }
        }
        try {
            jsobject.eval("javascript:try{ runqian_printOver(); }catch(e){}");
            jsobject.eval("javascript:try{ parent.runqian_printOver(); }catch(e){}");
        }
        catch (Exception e) {
        }
    }

    private Color toColor(String c, Color rc) {
        if (!(c = c.trim()).startsWith("#")) {
            return rc;
        }
        try {
            int r = Integer.parseInt(c.substring(1, 3), 16);
            int g = Integer.parseInt(c.substring(3, 5), 16);
            int b = Integer.parseInt(c.substring(5), 16);
            return new Color(r, g, b);
        }
        catch (Exception e) {
            return rc;
        }
    }
}

