/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.view.applet;

import com.runqian.base4.resources.MessageManager;
import com.runqian.base4.util.ReportError;
import com.runqian.report4.control.ContentPanel;
import com.runqian.report4.control.ControlUtils;
import com.runqian.report4.control.PrintFrame;
import com.runqian.report4.control.PrintPage;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.PageBuilder;
import com.runqian.report4.usermodel.PrintSetup;
import com.runqian.report4.util.ReportParser;
import com.runqian.report4.util.ReportUtils;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Properties;
import javax.print.PrintService;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import netscape.javascript.JSObject;

public class PrintReport
extends JApplet
implements ActionListener {
    private byte align = 1;
    private JComboBox alignBox;
    private String appRoot;
    private boolean canSetAlign = true;
    private int columns = 1;
    private JTextField columnsField;
    private int currPageNo = 1;
    public double currScale = 1.0;
    private JScrollPane dispPane;
    private JPanel dispPanel;
    private String fileName;
    private JButton firstPageButton = new JButton();
    private JComboBox gotoPageBox;
    private JPanel hidePanel;
    private PrinterJob job;
    private JButton lastPageButton;
    private MessageManager mm;
    private boolean needSelectPrinter;
    private JButton nextPageButton;
    private int pageCounts;
    private JLabel pageMarkLabel;
    private JButton pageSetupButton;
    private PageBuilder pb;
    private PageFormat pf;
    private JButton prevPageButton = new JButton();
    private Book printBook;
    private JButton printButton;
    private int printedPages = 0;
    private JComboBox printedPagesBox;
    private JComboBox ratioBox;
    private IReport report;
    private String reportParamsId;
    private boolean savePrintSetup = false;
    private String savePrintSetupKey;
    private String savePrintSetupUrl;
    private byte savedAlign;
    private String savedPrinterName;
    private byte shrink = 1;
    private JComboBox shrinkBox;
    private double shrinkScale = 1.0;
    private String srcType;
    private PageFormat truePf;
    private byte vAlign = 0;
    private JButton zoominButton;
    private JButton zoomoutButton;

    public PrintReport() {
        this.nextPageButton = new JButton();
        this.lastPageButton = new JButton();
        this.zoomoutButton = new JButton();
        this.zoominButton = new JButton();
        this.pageSetupButton = new JButton();
        this.printButton = new JButton();
        this.savedAlign = (byte)-1;
        this.mm = MessageManager.getManager("com.runqian.base4.resources.print");
    }

    public void actionPerformed(ActionEvent e) {
        JComponent source = (JComponent)e.getSource();
        if (source.equals(this.gotoPageBox)) {
            try {
                int pageNo = Integer.parseInt(this.gotoPageBox.getSelectedItem().toString());
                this.setCurrentPage(pageNo);
            }
            catch (Exception ex) {
            }
        } else if (source.equals(this.firstPageButton)) {
            this.setCurrentPage(1);
        } else if (source.equals(this.lastPageButton)) {
            this.setCurrentPage(this.pageCounts);
        } else if (source.equals(this.prevPageButton)) {
            int pageNo = this.currPageNo - 1;
            if (pageNo < 1) {
                return;
            }
            this.setCurrentPage(pageNo);
        } else if (source.equals(this.nextPageButton)) {
            int pageNo = this.currPageNo + 1;
            if (pageNo > this.pageCounts) {
                return;
            }
            this.setCurrentPage(pageNo);
        } else if (source.equals(this.zoominButton)) {
            this.hideEditor();
            this.currScale *= 1.5;
            String scale = String.valueOf((int)Math.ceil(this.currScale * 100.0)) + "%";
            this.ratioBox.setSelectedItem(scale);
        } else if (source.equals(this.zoomoutButton)) {
            this.hideEditor();
            this.currScale *= 0.667;
            String scale = String.valueOf((int)Math.ceil(this.currScale * 100.0)) + "%";
            this.ratioBox.setSelectedItem(scale);
        } else if (source.equals(this.ratioBox)) {
            this.hideEditor();
            String selectedRatio = this.ratioBox.getSelectedItem().toString();
            if (selectedRatio.equals(this.mm.getMessage("fullpage"))) {
                Rectangle r = this.dispPane.getViewport().getViewRect();
                int pfWidth = (int)this.truePf.getWidth();
                int pfHeight = (int)this.truePf.getHeight();
                double hScale = (double)(r.width - 20) * 1.0 / (double)pfWidth;
                double vScale = (double)(r.height - 10) * 1.0 / (double)pfHeight;
                this.currScale = Math.min(hScale, vScale);
                this.changeDisplayScale();
            } else {
                try {
                    this.currScale = Double.parseDouble(selectedRatio.substring(0, selectedRatio.length() - 1)) / 100.0;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.changeDisplayScale();
            }
        } else if (source.equals(this.alignBox)) {
            String selectedAlign = this.alignBox.getSelectedItem().toString();
            if (selectedAlign.equals(this.mm.getMessage("halign.c"))) {
                this.align = 1;
            } else if (selectedAlign.equals(this.mm.getMessage("halign.l"))) {
                this.align = 0;
            } else if (selectedAlign.equals(this.mm.getMessage("halign.r"))) {
                this.align = (byte)2;
            }
            int n = this.printBook.getNumberOfPages();
            int i = 0;
            while (i < n) {
                ((PrintPage)this.printBook.getPrintable(i)).setAlign(this.align);
                ++i;
            }
            this.changeDisplayScale();
            this.savePrintSetup2Server();
        } else if (source.equals(this.printedPagesBox)) {
            String s = this.printedPagesBox.getSelectedItem().toString();
            if (s.equals(this.mm.getMessage("printpage.1"))) {
                this.printedPages = 0;
            } else if (s.equals(this.mm.getMessage("printpage.2"))) {
                this.printedPages = 1;
            } else if (s.equals(this.mm.getMessage("printpage.3"))) {
                this.printedPages = 2;
            }
        } else if (source.equals(this.columnsField)) {
            int newColumns = 1;
            try {
                newColumns = Integer.parseInt(this.columnsField.getText());
            }
            catch (Exception ex) {
                this.columnsField.setText(String.valueOf(this.columns));
                return;
            }
            if (newColumns > 5) {
                newColumns = 5;
                this.columnsField.setText(String.valueOf(newColumns));
            }
            if (newColumns != this.columns) {
                this.columns = newColumns;
                try {
                    this.createPageBuilder();
                }
                catch (Throwable ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage());
                }
                this.initPrintWindow();
            }
        } else if (source.equals(this.shrinkBox)) {
            String s = this.shrinkBox.getSelectedItem().toString();
            if (s.equals(this.mm.getMessage("printzoom.1"))) {
                this.shrink = 1;
            } else if (s.equals(this.mm.getMessage("printzoom.2"))) {
                this.shrink = (byte)2;
            } else if (s.equals(this.mm.getMessage("printzoom.3"))) {
                this.shrink = (byte)3;
            }
            this.columns = Integer.parseInt(this.columnsField.getText());
            try {
                this.createPageBuilder();
            }
            catch (Throwable ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage());
            }
            this.initPrintWindow();
        } else if (source.equals(this.pageSetupButton)) {
            int imageWidth = (int)this.pf.getImageableWidth();
            int imageHeight = (int)this.pf.getImageableHeight();
            if (this.job == null) {
                this.job = PrinterJob.getPrinterJob();
            }
            if (this.savePrintSetup && this.savedPrinterName != null) {
                PrintReport printReport = this;
                PrintService[] pss = printReport.job.lookupPrintServices();
                int i = 0;
                while (i < pss.length) {
                    if (pss[i].getName().equals(this.savedPrinterName)) {
                        try {
                            this.job.setPrintService(pss[i]);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                    ++i;
                }
            }
            this.pf = this.job.pageDialog(this.pf);
            boolean needSave = false;
            if (imageWidth != (int)this.pf.getImageableWidth() || imageHeight != (int)this.pf.getImageableHeight()) {
                needSave = true;
                this.columns = Integer.parseInt(this.columnsField.getText());
                try {
                    this.createPageBuilder();
                }
                catch (Throwable ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage());
                }
                this.initPrintWindow();
            }
            if (needSave || !this.job.getPrintService().getName().equals(this.savedPrinterName)) {
                this.savePrintSetup2Server();
            }
        } else if (source.equals(this.printButton)) {
            this.print();
        }
    }

    private void addButton(JPanel panel, JButton button, String text, int row, Font font) {
        button.setText(text);
        button.setFont(font);
        button.setPreferredSize(new Dimension(85, 25));
        button.setMargin(new Insets(1, 5, 1, 5));
        button.addActionListener(this);
        panel.add((Component)button, this.createGBC(row));
    }

    private void addFunctionBar() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int row = 0;
        Font font = new Font(this.mm.getMessage("font"), 0, 12);
        this.pageMarkLabel = new JLabel();
        this.pageMarkLabel.setFont(font);
        panel.add((Component)this.pageMarkLabel, this.createGBC(row++));
        JPanel gotoPanel = new JPanel();
        JLabel label1 = new JLabel(this.mm.getMessage("topage1"));
        label1.setFont(font);
        gotoPanel.add(label1);
        this.gotoPageBox = new JComboBox();
        this.gotoPageBox.setFont(font);
        this.gotoPageBox.setPreferredSize(new Dimension(40, 20));
        this.gotoPageBox.addActionListener(this);
        gotoPanel.add(this.gotoPageBox);
        JLabel label2 = new JLabel(this.mm.getMessage("topage2"));
        label2.setFont(font);
        gotoPanel.add(label2);
        panel.add((Component)gotoPanel, this.createGBC(row++, 3));
        this.addButton(panel, this.firstPageButton, this.mm.getMessage("firstpage"), row++, font);
        this.addButton(panel, this.prevPageButton, this.mm.getMessage("prevpage"), row++, font);
        this.addButton(panel, this.nextPageButton, this.mm.getMessage("nextpage"), row++, font);
        this.addButton(panel, this.lastPageButton, this.mm.getMessage("lastpage"), row++, font);
        this.addButton(panel, this.zoominButton, this.mm.getMessage("zoomin"), row++, font);
        this.addButton(panel, this.zoomoutButton, this.mm.getMessage("zoomout"), row++, font);
        JPanel ratioPanel = new JPanel();
        JLabel label3 = new JLabel(this.mm.getMessage("scale"));
        label3.setFont(font);
        ratioPanel.add(label3);
        this.ratioBox = new JComboBox<String>(new String[]{this.mm.getMessage("fullpage"), "50%", "75%", "100%", "150%", "200%"});
        this.ratioBox.setFont(font);
        this.ratioBox.setEditable(true);
        this.ratioBox.setPreferredSize(new Dimension(55, 20));
        this.ratioBox.addActionListener(this);
        ratioPanel.add(this.ratioBox);
        panel.add((Component)ratioPanel, this.createGBC(row++, 3));
        if (this.canSetAlign) {
            JPanel alignPanel = new JPanel();
            JLabel labelAlign = new JLabel(this.mm.getMessage("halign"));
            labelAlign.setFont(font);
            alignPanel.add(labelAlign);
            this.alignBox = new JComboBox<String>(new String[]{this.mm.getMessage("halign.l"), this.mm.getMessage("halign.c"), this.mm.getMessage("halign.r")});
            this.alignBox.setSelectedIndex(this.align);
            this.alignBox.setFont(font);
            this.alignBox.setPreferredSize(new Dimension(55, 20));
            this.alignBox.addActionListener(this);
            alignPanel.add(this.alignBox);
            panel.add((Component)alignPanel, this.createGBC(row++, 0));
        }
        JPanel fenlanPanel = new JPanel();
        JLabel label4 = new JLabel(this.mm.getMessage("column"));
        label4.setFont(font);
        fenlanPanel.add(label4);
        this.columnsField = new JTextField(String.valueOf(this.columns));
        this.columnsField.setFont(font);
        this.columnsField.setPreferredSize(new Dimension(56, 20));
        this.columnsField.setHorizontalAlignment(0);
        this.columnsField.addActionListener(this);
        fenlanPanel.add(this.columnsField);
        panel.add((Component)fenlanPanel, this.createGBC(row++, 0));
        JPanel printedPagesPanel = new JPanel();
        JLabel labelPages = new JLabel(this.mm.getMessage("printpage"));
        labelPages.setFont(font);
        printedPagesPanel.add(labelPages);
        this.printedPagesBox = new JComboBox<String>(new String[]{this.mm.getMessage("printpage.1"), this.mm.getMessage("printpage.2"), this.mm.getMessage("printpage.3")});
        this.printedPagesBox.setFont(font);
        this.printedPagesBox.setPreferredSize(new Dimension(55, 20));
        this.printedPagesBox.addActionListener(this);
        printedPagesPanel.add(this.printedPagesBox);
        panel.add((Component)printedPagesPanel, this.createGBC(row++, 0));
        JPanel shrinkPanel = new JPanel();
        JLabel labelShrink = new JLabel(this.mm.getMessage("printzoom"));
        labelShrink.setFont(font);
        shrinkPanel.add(labelShrink);
        this.shrinkBox = new JComboBox<String>(new String[]{this.mm.getMessage("printzoom.1"), this.mm.getMessage("printzoom.2"), this.mm.getMessage("printzoom.3")});
        this.shrinkBox.setFont(font);
        this.shrinkBox.setPreferredSize(new Dimension(55, 20));
        if (this.shrink <= 3) {
            this.shrinkBox.setSelectedIndex(this.shrink - 1);
        }
        this.shrinkBox.addActionListener(this);
        shrinkPanel.add(this.shrinkBox);
        panel.add((Component)shrinkPanel, this.createGBC(row++, 0));
        this.addButton(panel, this.pageSetupButton, this.mm.getMessage("pagesetup"), row++, font);
        this.addButton(panel, this.printButton, this.mm.getMessage("print"), row++, font);
        GridBagConstraints gbc = this.createGBC(row);
        gbc.weighty = 1.0;
        panel.add((Component)new JPanel(), gbc);
        this.getContentPane().add((Component)panel, "East");
    }

    public void changeDisplayScale() {
        PrintFrame.setScale(this.printBook, this.currScale);
        this.dispPanel.setPreferredSize(new Dimension((int)(this.truePf.getWidth() * this.currScale), (int)(this.truePf.getHeight() * this.currScale)));
        this.dispPane.getViewport().setView(this.dispPanel);
    }

    private GridBagConstraints createGBC(int row) {
        return this.createGBC(row, 6);
    }

    private GridBagConstraints createGBC(int row, int topMargin) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = row;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(topMargin, 5, 0, 5);
        return gbc;
    }

    private void createPageBuilder() throws Throwable {
        if (this.shrink == 1) {
            this.truePf = this.pf;
            this.shrinkScale = 1.0;
        } else {
            ReportParser csp = new ReportParser(this.report);
            if (this.shrink == 2) {
                int w = csp.getReportWidth() + 2;
                this.shrinkScale = this.pf.getImageableWidth() / (double)w;
            } else if (this.shrink == 3) {
                int h = csp.getReportHeight() + 2;
                this.shrinkScale = this.pf.getImageableHeight() / (double)h;
            }
            this.truePf = this.getTruePageFormat(1.0 / this.shrinkScale);
        }
        this.pb = new PageBuilder(this.report, this.truePf, this.columns);
    }

    public void destroy() {
        ControlUtils.displayG = null;
        this.report = null;
        this.pb = null;
        int i = 0;
        while (i < this.printBook.getNumberOfPages()) {
            ((PrintPage)this.printBook.getPrintable(i)).dispose();
            ++i;
        }
    }

    private PrintPage getCurrentPage() {
        JPanel panel = (JPanel)this.dispPane.getViewport().getView();
        return (PrintPage)panel.getComponent(0);
    }

    public PageBuilder getPageBuilder() {
        return this.pb;
    }

    private String getParameter(String key, String def) {
        return this.getParameter(key) != null ? this.getParameter(key) : def;
    }

    private PageFormat getTruePageFormat(double scale) {
        PageFormat pageformat = new PageFormat();
        Paper paper = new Paper();
        Paper p = this.pf.getPaper();
        paper.setSize(p.getWidth() * scale, p.getHeight() * scale);
        double x = p.getImageableX() * scale;
        double y = p.getImageableY() * scale;
        double w = p.getImageableWidth() * scale;
        double h = p.getImageableHeight() * scale;
        paper.setImageableArea(x, y, w, h);
        pageformat.setPaper(paper);
        pageformat.setOrientation(this.pf.getOrientation());
        return pageformat;
    }

    private void hideEditor(Container c) {
        Component[] child = c.getComponents();
        if (child.length == 0) {
            return;
        }
        int i = 0;
        while (i < child.length) {
            if (child[i] instanceof ContentPanel) {
                ContentPanel cp = (ContentPanel)child[i];
                cp.submitEditor();
                if (cp.editor != null) {
                    cp.editor.setVisible(false);
                    cp.m_activeCell = null;
                }
            } else {
                this.hideEditor((Container)child[i]);
            }
            ++i;
        }
    }

    private void hideEditor() {
        PrintPage page = this.getCurrentPage();
        this.hideEditor(page);
    }

    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exp) {
            // empty catch block
        }
        System.setProperty("java.awt.im.style", "on-the-spot");
        this.initParameters();
        String dataServer = this.appRoot + "/reportServlet?action=1&fileName=" + this.fileName + "&srcType=" + this.srcType;
        if (this.reportParamsId != null) {
            dataServer = dataServer + "&reportParamsId=" + this.reportParamsId;
        }
        try {
            short layoutCol;
            URL url = new URL(dataServer);
            this.report = ReportUtils.read(url.openStream());
            PrintSetup setup = this.report.getPrintSetup();
            byte pageStyle = setup.getPagerStyle();
            if (pageStyle == 1 && (layoutCol = setup.getLayoutColNum()) > 1) {
                this.canSetAlign = false;
            }
            PageFormat savedPf = null;
            if (this.savePrintSetup) {
                try {
                    InetAddress ia = InetAddress.getLocalHost();
                    this.savePrintSetupKey = ia.getHostName() + ia.getHostAddress() + this.fileName + System.getProperty("user.name");
                    this.savePrintSetupUrl = this.appRoot + "/servlet/PrintSetupServlet";
                    String surl = this.savePrintSetupUrl + "?action=read&key=" + URLEncoder.encode(this.savePrintSetupKey);
                    URL aurl = new URL(surl);
                    Properties p = new Properties();
                    p.load(aurl.openStream());
                    String hasSetup = p.getProperty("setup");
                    if (hasSetup == null || hasSetup.equalsIgnoreCase("no")) {
                        String otherKey = ia.getHostName() + ia.getHostAddress() + this.fileName;
                        surl = this.savePrintSetupUrl + "?action=read&key=" + URLEncoder.encode(otherKey);
                        aurl = new URL(surl);
                        p = new Properties();
                        p.load(aurl.openStream());
                        hasSetup = p.getProperty("setup");
                    }
                    if (hasSetup != null && hasSetup.equalsIgnoreCase("yes")) {
                        String sa;
                        savedPf = new PageFormat();
                        savedPf.setOrientation(Integer.parseInt(p.getProperty("orientation")));
                        Paper paper = new Paper();
                        double width = Double.parseDouble(p.getProperty("width"));
                        double height = Double.parseDouble(p.getProperty("height"));
                        paper.setSize(width, height);
                        double x = Double.parseDouble(p.getProperty("x"));
                        double y = Double.parseDouble(p.getProperty("y"));
                        double w = Double.parseDouble(p.getProperty("w"));
                        double h = Double.parseDouble(p.getProperty("h"));
                        paper.setImageableArea(x, y, w, h);
                        savedPf.setPaper(paper);
                        this.savedPrinterName = p.getProperty("printerName");
                        if (this.savedPrinterName != null) {
                            this.savedPrinterName = new String(this.savedPrinterName.getBytes("iso8859-1"), "GBK");
                        }
                        if ((sa = p.getProperty("a")) != null) {
                            try {
                                this.savedAlign = Byte.parseByte(sa);
                            }
                            catch (Exception esa) {
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    savedPf = null;
                    e.printStackTrace();
                }
            }
            this.pf = savedPf != null ? savedPf : setup.getPageFormat();
            this.shrink = setup.getZoomMode();
            this.align = setup.getHAlign();
            this.vAlign = setup.getVAlign();
            if (this.savedAlign != -1) {
                this.align = this.savedAlign;
            }
            this.dispPane = new JScrollPane(20, 30);
            Container pane = this.getContentPane();
            pane.setLayout(new BorderLayout());
            this.hidePanel = new JPanel();
            pane.add(this.hidePanel);
            pane.add(this.dispPane);
            this.columns = setup.getTableColumnNum();
            this.addFunctionBar();
            this.createPageBuilder();
            this.initPrintWindow();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void initParameters() {
        this.appRoot = this.getParameter("appRoot", "");
        if (!this.appRoot.toLowerCase().startsWith("http")) {
            URL urlBase = this.getCodeBase();
            this.appRoot = urlBase.getProtocol() + "://" + urlBase.getHost() + ":" + urlBase.getPort() + this.appRoot;
        }
        this.fileName = this.getParameter("fileName", "");
        this.srcType = this.getParameter("srcType", "file");
        this.reportParamsId = this.getParameter("reportParamsId", null);
        String tmp = this.getParameter("columns", "0");
        try {
            this.columns = Integer.parseInt(tmp);
        }
        catch (Exception e) {
            // empty catch block
        }
        tmp = this.getParameter("savePrintSetup", "no");
        this.savePrintSetup = "yes".equalsIgnoreCase(tmp);
        tmp = this.getParameter("needSelectPrinter", "yes");
        this.needSelectPrinter = "yes".equalsIgnoreCase(tmp);
    }

    private void initPrintWindow() {
        BufferedImage bi = new BufferedImage(10, 10, 1);
        ControlUtils.displayG = bi.getGraphics();
        this.hidePanel.removeAll();
        this.gotoPageBox.removeAllItems();
        this.printBook = new Book();
        this.pageCounts = 0;
        int pageNo = 1;
        while (true) {
            PrintPage page = new PrintPage(this.report, this.pb, this.truePf, null, pageNo, null);
            try {
                page.create();
                if (this.canSetAlign) {
                    page.setAlign(this.align);
                    page.setVAlign(this.vAlign);
                }
            }
            catch (ReportError e) {
                break;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.hidePanel.add(page);
            this.printBook.append(page, this.pf);
            this.gotoPageBox.addItem(String.valueOf(pageNo));
            ++pageNo;
            ++this.pageCounts;
        }
        this.setCurrentPage(1);
        this.ratioBox.setSelectedIndex(3);
        this.getRootPane().setDefaultButton(this.printButton);
        this.printButton.requestFocus();
    }

    public void print() {
        Thread.currentThread().setContextClassLoader(new ClassLoader(){});
        if (this.job == null) {
            this.job = PrinterJob.getPrinterJob();
        }
        PrintReport printReport = this;
        PrintService[] pss = printReport.job.lookupPrintServices();
        if (pss.length == 0) {
            JOptionPane.showMessageDialog(this, MessageManager.getManager("noPrinter"));
            return;
        }
        if (this.savePrintSetup && this.savedPrinterName != null) {
            int i = 0;
            while (i < pss.length) {
                if (pss[i].getName().equals(this.savedPrinterName)) {
                    try {
                        this.job.setPrintService(pss[i]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ++i;
            }
        }
        PrintFrame.setPrintScale(this.printBook, this.shrinkScale);
        if (this.printedPages == 0) {
            this.job.setPageable(this.printBook);
        } else {
            Book book = new Book();
            if (this.printedPages == 1) {
                int i = 0;
                while (i < this.printBook.getNumberOfPages()) {
                    book.append((PrintPage)this.printBook.getPrintable(i), this.pf);
                    i += 2;
                }
            } else if (this.printedPages == 2) {
                int i = 1;
                while (i < this.printBook.getNumberOfPages()) {
                    book.append((PrintPage)this.printBook.getPrintable(i), this.pf);
                    i += 2;
                }
            }
            this.job.setPageable(book);
        }
        try {
            if (this.needSelectPrinter) {
                if (this.job.printDialog()) {
                    this.job.print();
                }
                if (!this.job.getPrintService().getName().equals(this.savedPrinterName)) {
                    this.savePrintSetup2Server();
                }
            } else {
                this.job.print();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        try {
            JSObject jsobject = JSObject.getWindow((Applet)this);
            jsobject.eval("javascript:try{ runqian_printOver(); }catch(e){}");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void savePrintSetup2Server() {
        if (!this.savePrintSetup) {
            return;
        }
        String surl = this.savePrintSetupUrl + "?action=write&key=" + URLEncoder.encode(this.savePrintSetupKey);
        if (this.job == null) {
            this.job = PrinterJob.getPrinterJob();
        }
        this.savedPrinterName = this.job.getPrintService().getName();
        surl = surl + "&printerName=" + URLEncoder.encode(this.savedPrinterName);
        surl = surl + "&orientation=" + this.pf.getOrientation();
        Paper paper = this.pf.getPaper();
        surl = surl + "&width=" + paper.getWidth();
        surl = surl + "&height=" + paper.getHeight();
        surl = surl + "&x=" + paper.getImageableX();
        surl = surl + "&y=" + paper.getImageableY();
        surl = surl + "&w=" + paper.getImageableWidth();
        surl = surl + "&h=" + paper.getImageableHeight();
        surl = surl + "&a=" + this.align;
        try {
            URL url = new URL(surl);
            InputStream is = url.openStream();
            is.read();
            is.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void setCurrentPage(int pageNo) {
        try {
            PrintPage oldPage = (PrintPage)this.printBook.getPrintable(this.currPageNo - 1);
            if (oldPage != null) {
                this.hidePanel.add(oldPage);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        PrintPage currPage = (PrintPage)this.printBook.getPrintable(pageNo - 1);
        this.dispPanel = new JPanel();
        this.dispPanel.add(currPage);
        this.dispPane.getViewport().setView(this.dispPanel);
        this.repaint();
        this.currPageNo = pageNo;
        this.pageMarkLabel.setText(this.mm.getMessage("pagemark") + pageNo + "/" + this.pageCounts);
        if (pageNo == 1) {
            this.firstPageButton.setEnabled(false);
            this.prevPageButton.setEnabled(false);
        } else {
            this.firstPageButton.setEnabled(true);
            this.prevPageButton.setEnabled(true);
        }
        if (pageNo == this.pageCounts) {
            this.lastPageButton.setEnabled(false);
            this.nextPageButton.setEnabled(false);
        } else {
            this.lastPageButton.setEnabled(true);
            this.nextPageButton.setEnabled(true);
        }
    }
}

