/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.view.mailhtml;

import com.runqian.base4.util.StringUtils;
import com.runqian.report4.control.ControlUtils;
import com.runqian.report4.model.expression.Variant2;
import com.runqian.report4.usermodel.IByteMap;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.util.ReportParser;
import com.runqian.report4.view.mailhtml.MailHtmlEncoder;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Locale;

public class MailHtmlCell {
    private String appmap;
    private short col;
    private boolean hasBackImage = false;
    private boolean isParamCell = false;
    private Locale locale;
    private IReport report;
    private int row;
    private float scale = 1.0f;
    private INormalCell srcCell;

    public MailHtmlCell(IReport report, int row, short col, Locale locale, String appmap, float scale) {
        this.report = report;
        this.row = row;
        this.col = col;
        this.locale = locale;
        this.appmap = appmap;
        this.scale = scale;
    }

    public void appendTo(StringBuffer sb, int color) {
        if ((color >> 24 & 0xFF) == 0) {
            sb.append("transparent");
            return;
        }
        sb.append('#');
        StringUtils.appendHexString(sb, color, 3);
    }

    private String getBorderStyle(byte style) {
        if (style == 83) {
            return "solid";
        }
        if (style == 80) {
            return "none";
        }
        if (style == 84) {
            return "double";
        }
        if (style == 85) {
            return "dotted";
        }
        if (style == 82) {
            return "dashed";
        }
        return "solid";
    }

    private String getBorderWidth(float w) {
        int iw = Math.round(w);
        return String.valueOf(iw);
    }

    private Font getFont(INormalCell cell) {
        String face = cell.getFontName();
        short size = cell.getFontSize();
        int fontStyle = 0;
        if (cell.isBold()) {
            ++fontStyle;
        }
        if (cell.isItalic()) {
            fontStyle += 2;
        }
        return new Font(face, fontStyle, size);
    }

    public String getLink() {
        INormalCell cell = this.report.getCell(this.row, this.col);
        if (cell == null) {
            return null;
        }
        String link = cell.getHyperlink();
        if (link == null || link.trim().length() == 0) {
            return null;
        }
        int pos = link.indexOf(":");
        if (pos > 0 && link.substring(0, pos).indexOf("?") < 0) {
            return link;
        }
        if (!link.startsWith("/")) {
            link = "/" + link;
        }
        link = this.appmap + link;
        return link;
    }

    public String getLinkStyle() {
        ReportParser parser = new ReportParser(this.report);
        StringBuffer sb = new StringBuffer(100);
        INormalCell cell = parser.getCell(this.row, this.col);
        sb.append("font-family:").append(cell.getFontName()).append(";");
        int fontsize = (int)((float)cell.getFontSize() * this.scale);
        sb.append("font-size:").append(fontsize).append("px;");
        sb.append("color:");
        this.appendTo(sb, cell.getForeColor());
        sb.append(";");
        String bold = cell.isBold() ? "bold" : "normal";
        sb.append("font-weight:").append(bold).append(";");
        String italic = cell.isItalic() ? "italic" : "normal";
        sb.append("font-style:").append(italic).append(";");
        String ul = cell.isUnderline() ? "underline" : "none";
        sb.append("text-decoration:").append(ul).append(";");
        return sb.toString();
    }

    public String getStyle() {
        ReportParser parser = new ReportParser(this.report);
        StringBuffer sb = new StringBuffer(500);
        if (this.row > 0 && this.col > 0) {
            INormalCell cell = parser.getCell(this.row, this.col);
            if (this.srcCell == null) {
                byte align = cell.getHAlign();
                sb.append("text-align:");
                if (align == -48) {
                    sb.append("left;");
                } else if (align == -47) {
                    sb.append("center;");
                } else if (align == -46) {
                    sb.append("right;");
                }
                sb.append("vertical-align:");
                byte valign = cell.getVAlign();
                if (valign == -32) {
                    sb.append("top;");
                } else if (valign == -31) {
                    sb.append("middle;");
                } else if (valign == -30) {
                    sb.append("bottom;");
                }
                int cellindent = parser.getCellIndent(this.row, this.col, this.scale);
                if (align == -47) {
                    sb.append("padding-left:").append(cellindent).append("px;");
                    sb.append("padding-right:").append(cellindent).append("px;");
                } else if (align == -48) {
                    sb.append("padding-left:").append(cellindent).append("px;");
                } else if (align == -46) {
                    sb.append("padding-right:").append(cellindent).append("px;");
                }
                sb.append("font-family:").append(cell.getFontName()).append(";");
                int fontsize = (int)((float)cell.getFontSize() * this.scale);
                sb.append("font-size:").append(fontsize).append("px;");
                sb.append("color:");
                this.appendTo(sb, cell.getForeColor());
                sb.append(";");
                String bold = cell.isBold() ? "bold" : "normal";
                sb.append("font-weight:").append(bold).append(";");
                String italic = cell.isItalic() ? "italic" : "normal";
                sb.append("font-style:").append(italic).append(";");
                String ul = cell.isUnderline() ? "underline" : "none";
                sb.append("text-decoration:").append(ul).append(";");
                if (!this.isParamCell) {
                    sb.append("border-left-style:").append(this.getBorderStyle(this.report.getLBStyle(this.row, this.col))).append(";");
                    sb.append("border-left-width:").append(this.getBorderWidth(this.report.getLBWidth(this.row, this.col))).append("px;");
                    sb.append("border-left-color:");
                    this.appendTo(sb, this.report.getLBColor(this.row, this.col));
                    sb.append(";");
                    sb.append("border-top-style:").append(this.getBorderStyle(this.report.getTBStyle(this.row, this.col))).append(";");
                    sb.append("border-top-width:").append(this.getBorderWidth(this.report.getTBWidth(this.row, this.col))).append("px;");
                    sb.append("border-top-color:");
                    this.appendTo(sb, this.report.getTBColor(this.row, this.col));
                    sb.append(";");
                    sb.append("border-right-style:").append(this.getBorderStyle(this.report.getRBStyle(this.row, this.col))).append(";");
                    sb.append("border-right-width:").append(this.getBorderWidth(this.report.getRBWidth(this.row, this.col))).append("px;");
                    sb.append("border-right-color:");
                    this.appendTo(sb, this.report.getRBColor(this.row, this.col));
                    sb.append(";");
                    sb.append("border-bottom-style:").append(this.getBorderStyle(this.report.getBBStyle(this.row, this.col))).append(";");
                    sb.append("border-bottom-width:").append(this.getBorderWidth(this.report.getBBWidth(this.row, this.col))).append("px;");
                    sb.append("border-bottom-color:");
                    this.appendTo(sb, this.report.getBBColor(this.row, this.col));
                    sb.append(";");
                }
                sb.append("background-color:");
                if (this.hasBackImage) {
                    sb.append("transparent");
                } else {
                    this.appendTo(sb, cell.getBackColor());
                }
                sb.append(";");
                if (cell.getTextWrap()) {
                    int fh = cell.getFontSize();
                    fh = (int)((float)fh * this.scale);
                    int lineh = (int)Math.ceil((double)fh * 1.28);
                    sb.append("line-height:").append(lineh).append("px;");
                }
                sb.append("word-break:keep-all;");
            } else {
                int cellindent;
                boolean indented = false;
                boolean fontsized = false;
                boolean bkcolored = false;
                boolean wraped = false;
                IByteMap map = cell.getPrivatePropertyMap();
                if (map != null) {
                    int k = 0;
                    while (k < map.size()) {
                        Object propValue = map.getValue(k);
                        if (propValue != null && propValue.toString().trim().length() != 0) {
                            byte prop = map.getKey(k);
                            switch (prop) {
                                case 22: {
                                    byte align = cell.getHAlign();
                                    sb.append("text-align:");
                                    if (align == -48) {
                                        sb.append("left;");
                                        break;
                                    }
                                    if (align == -47) {
                                        sb.append("center;");
                                        break;
                                    }
                                    if (align != -46) break;
                                    sb.append("right;");
                                    break;
                                }
                                case 23: {
                                    sb.append("vertical-align:");
                                    byte valign = cell.getVAlign();
                                    if (valign == -32) {
                                        sb.append("top;");
                                        break;
                                    }
                                    if (valign == -31) {
                                        sb.append("middle;");
                                        break;
                                    }
                                    if (valign != -30) break;
                                    sb.append("bottom;");
                                    break;
                                }
                                case 42: {
                                    int cellindent2 = parser.getCellIndent(this.row, this.col, this.scale);
                                    if (cellindent2 > 0) {
                                        byte halign = cell.getHAlign();
                                        if (halign == -47) {
                                            sb.append("padding-left:").append(cellindent2).append("px;");
                                            sb.append("padding-right:").append(cellindent2).append("px;");
                                        } else if (halign == -48) {
                                            sb.append("padding-left:").append(cellindent2).append("px;");
                                        } else if (halign == -46) {
                                            sb.append("padding-right:").append(cellindent2).append("px;");
                                        }
                                    }
                                    indented = true;
                                    break;
                                }
                                case 43: {
                                    sb.append("font-family:").append(cell.getFontName()).append(";");
                                    break;
                                }
                                case 44: {
                                    int fontsize = (int)((float)cell.getFontSize() * this.scale);
                                    sb.append("font-size:").append(fontsize).append("px;");
                                    fontsized = true;
                                    break;
                                }
                                case 52: {
                                    sb.append("color:");
                                    this.appendTo(sb, cell.getForeColor());
                                    sb.append(";");
                                    break;
                                }
                                case 45: {
                                    String bold = cell.isBold() ? "bold" : "normal";
                                    sb.append("font-weight:").append(bold).append(";");
                                    break;
                                }
                                case 46: {
                                    String italic = cell.isItalic() ? "italic" : "normal";
                                    sb.append("font-style:").append(italic).append(";");
                                    break;
                                }
                                case 47: {
                                    String ul = cell.isUnderline() ? "underline" : "none";
                                    sb.append("text-decoration:").append(ul).append(";");
                                    break;
                                }
                                case 62: {
                                    sb.append("border-top-style:").append(this.getBorderStyle(this.report.getTBStyle(this.row, this.col))).append(";");
                                    break;
                                }
                                case 66: {
                                    sb.append("border-top-width:").append(this.getBorderWidth(this.report.getTBWidth(this.row, this.col))).append("px;");
                                    break;
                                }
                                case 70: {
                                    sb.append("border-top-color:");
                                    this.appendTo(sb, this.report.getTBColor(this.row, this.col));
                                    sb.append(";");
                                    break;
                                }
                                case 63: {
                                    sb.append("border-bottom-style:").append(this.getBorderStyle(this.report.getBBStyle(this.row, this.col))).append(";");
                                    break;
                                }
                                case 67: {
                                    sb.append("border-bottom-width:").append(this.getBorderWidth(this.report.getBBWidth(this.row, this.col))).append("px;");
                                    break;
                                }
                                case 71: {
                                    sb.append("border-bottom-color:");
                                    this.appendTo(sb, this.report.getBBColor(this.row, this.col));
                                    sb.append(";");
                                    break;
                                }
                                case 60: {
                                    sb.append("border-left-style:").append(this.getBorderStyle(this.report.getLBStyle(this.row, this.col))).append(";");
                                    break;
                                }
                                case 64: {
                                    sb.append("border-left-width:").append(this.getBorderWidth(this.report.getLBWidth(this.row, this.col))).append("px;");
                                    break;
                                }
                                case 68: {
                                    sb.append("border-left-color:");
                                    this.appendTo(sb, this.report.getLBColor(this.row, this.col));
                                    sb.append(";");
                                    break;
                                }
                                case 61: {
                                    sb.append("border-right-style:").append(this.getBorderStyle(this.report.getRBStyle(this.row, this.col))).append(";");
                                    break;
                                }
                                case 65: {
                                    sb.append("border-right-width:").append(this.getBorderWidth(this.report.getRBWidth(this.row, this.col))).append("px;");
                                    break;
                                }
                                case 69: {
                                    sb.append("border-right-color:");
                                    this.appendTo(sb, this.report.getRBColor(this.row, this.col));
                                    sb.append(";");
                                    break;
                                }
                                case 53: {
                                    sb.append("background-color:");
                                    if (this.hasBackImage) {
                                        sb.append("transparent");
                                    } else {
                                        this.appendTo(sb, cell.getBackColor());
                                    }
                                    sb.append(";");
                                    bkcolored = true;
                                    break;
                                }
                                case 27: {
                                    if (cell.getTextWrap()) {
                                        int fh = cell.getFontSize();
                                        fh = (int)((float)fh * this.scale);
                                        int lineh = (int)Math.ceil((double)fh * 1.28);
                                        sb.append("line-height:").append(lineh).append("px;");
                                    }
                                    wraped = true;
                                }
                            }
                        }
                        ++k;
                    }
                }
                if (!indented && (cellindent = parser.getCellIndent(this.row, this.col, this.scale)) > 0) {
                    byte halign = cell.getHAlign();
                    if (halign == -47) {
                        sb.append("padding-left:").append(cellindent).append("px;");
                        sb.append("padding-right:").append(cellindent).append("px;");
                    } else if (halign == -48) {
                        sb.append("padding-left:").append(cellindent).append("px;");
                    } else if (halign == -46) {
                        sb.append("padding-right:").append(cellindent).append("px;");
                    }
                }
                if (!fontsized && (double)this.scale != 1.0) {
                    int fontsize = (int)((float)cell.getFontSize() * this.scale);
                    sb.append("font-size:").append(fontsize).append("px;");
                }
                if (!bkcolored && this.hasBackImage) {
                    sb.append("background-color:transparent;");
                }
                if (!wraped && (double)this.scale != 1.0 && cell.getTextWrap()) {
                    int fh = cell.getFontSize();
                    fh = (int)((float)fh * this.scale);
                    int lineh = (int)Math.ceil((double)fh * 1.28);
                    sb.append("line-height:").append(lineh).append("px;");
                }
            }
        } else if (this.row == 0) {
            int w = parser.getColWidth(this.col, this.scale);
            if (this.col == 0) {
                w = 0;
                short k = 1;
                while (k <= parser.getColCount()) {
                    if (parser.isColVisible(k)) {
                        w += parser.getColWidth(k, this.scale);
                    }
                    k = (short)(k + 1);
                }
            }
            sb.append("width:").append(w).append("px;");
        } else if (this.row > 0 && this.col == 0) {
            int h = parser.getRowHeight(this.row, this.scale);
            sb.append("height:").append(h).append("px;");
        }
        return sb.toString();
    }

    public String getText(boolean htmlEncode) {
        INormalCell cell = this.report.getCell(this.row, this.col);
        if (cell == null) {
            return "";
        }
        String text = cell.getDispValue();
        if (text == null) {
            text = this.getValue();
        }
        if (text == null || text.length() == 0) {
            return "";
        }
        byte type = cell.getCellType();
        if (type == -58) {
            return text;
        }
        if (cell.getTextWrap()) {
            ReportParser parser = new ReportParser(this.report);
            int w = parser.getMergedWidth(this.row, this.col, false);
            int indent = parser.getCellIndent(this.row, this.col);
            byte align = cell.getHAlign();
            if (align == -47) {
                indent *= 2;
            }
            if ((w = w - indent - 4) > 0) {
                FontMetrics fm = new BufferedImage(10, 10, 2).getGraphics().getFontMetrics(this.getFont(cell));
                ArrayList al = ControlUtils.wrapString(text, fm, (float)w * 1.0f);
                text = "";
                int i = 0;
                while (i < al.size()) {
                    String s = (String)al.get(i);
                    if (i < al.size() - 1 && !s.endsWith("\n")) {
                        s = s + "\n";
                    }
                    text = text + s;
                    ++i;
                }
            }
        }
        if (htmlEncode) {
            return MailHtmlEncoder.encode(text);
        }
        return text;
    }

    public String getText() {
        return this.getText(true);
    }

    public String getValue() {
        INormalCell cell = this.report.getCell(this.row, this.col);
        if (cell == null) {
            return "";
        }
        Object obj = cell.getValue();
        if (obj == null) {
            return "";
        }
        return Variant2.toString(obj);
    }

    void setHasBackImage(boolean b) {
        this.hasBackImage = b;
    }

    public void setIsParamCell(boolean isParamCell) {
        this.isParamCell = isParamCell;
    }

    void setSrcCell(INormalCell cell) {
        this.srcCell = cell;
    }
}

