/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.view.mailhtml;

import com.runqian.base4.resources.FormatUtils;
import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.Logger;
import com.runqian.base4.util.MacroResolver;
import com.runqian.base4.util.Sentence;
import com.runqian.base4.util.StringUtils;
import com.runqian.report4.control.CellPosition;
import com.runqian.report4.control.LeanLine;
import com.runqian.report4.dataset.DataSet;
import com.runqian.report4.dataset.Group;
import com.runqian.report4.dataset.Row;
import com.runqian.report4.dataset.ViewDataSetFactory;
import com.runqian.report4.input.ExcelNotation;
import com.runqian.report4.input.ExpTransform;
import com.runqian.report4.input.InputUtils;
import com.runqian.report4.input.Tree;
import com.runqian.report4.input.ViewTree;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.model.engine.ExtNormalCell;
import com.runqian.report4.model.engine2.ExtNCell;
import com.runqian.report4.model.engine2.ExtPRow;
import com.runqian.report4.model.engine2.ExtRow;
import com.runqian.report4.model.engine2.RowReport;
import com.runqian.report4.model.expression.Expression;
import com.runqian.report4.semantics.ComputedColInfo;
import com.runqian.report4.semantics.View;
import com.runqian.report4.usermodel.Area;
import com.runqian.report4.usermodel.BackGraphConfig;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.ICloneable;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.ViewDataSetConfig;
import com.runqian.report4.usermodel.graph.ImageValue;
import com.runqian.report4.usermodel.input.CheckBox;
import com.runqian.report4.usermodel.input.CustomEditStyle;
import com.runqian.report4.usermodel.input.DDCalendar;
import com.runqian.report4.usermodel.input.DDDataWindow;
import com.runqian.report4.usermodel.input.DDListBox;
import com.runqian.report4.usermodel.input.DDTree;
import com.runqian.report4.usermodel.input.DDTreeNode;
import com.runqian.report4.usermodel.input.DDViewDataWindow;
import com.runqian.report4.usermodel.input.DDViewTree;
import com.runqian.report4.usermodel.input.DDViewTreeNode;
import com.runqian.report4.usermodel.input.FlowVar;
import com.runqian.report4.usermodel.input.InputProperty;
import com.runqian.report4.usermodel.input.RadioBox;
import com.runqian.report4.usermodel.input.TableRelation;
import com.runqian.report4.usermodel.input.TableRelations;
import com.runqian.report4.usermodel.input.UpdateProperty;
import com.runqian.report4.usermodel.input.UploadFile;
import com.runqian.report4.util.ReportParser;
import com.runqian.report4.view.LicenseException;
import com.runqian.report4.view.ReportServlet;
import com.runqian.report4.view.ServerMsg;
import com.runqian.report4.view.mailhtml.MailDropDownDW;
import com.runqian.report4.view.mailhtml.MailGraphPool;
import com.runqian.report4.view.mailhtml.MailHtmlCell;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class MailHtmlReport {
    private String H = "400";
    private String W = "600";
    private String appRoot = null;
    private String appmap;
    private static int bindCodeCount;
    private String border = "";
    private boolean calendarJSImported = false;
    private Context context = null;
    private ArrayList emptyFlows = null;
    private boolean filterJSImported = false;
    private String htmlFileName;
    private boolean inNS = false;
    private boolean isInput;
    private boolean isNP = false;
    private boolean isRowInput;
    private boolean isScroll = false;
    boolean isSub = false;
    private Locale locale;
    private static long longtime;
    private String name;
    private boolean needCreateTree = false;
    private boolean needFilter = false;
    private boolean needLinkStyle = true;
    private String paramsId;
    private ReportParser parser;
    private File picFileDir = null;
    private Writer pw;
    private IReport report;
    private HttpServletRequest request;
    private float scale = 1.0f;
    private boolean selectJSImported = false;
    private boolean selectText = false;
    private Hashtable styles = new Hashtable();
    private boolean treeJSImported = false;
    private HashSet updatableCells;

    static {
        longtime = 416528L;
        bindCodeCount = 0;
    }

    public MailHtmlReport(IReport report, String fileName) throws Exception {
        this(report, fileName, "", null, false);
    }

    public MailHtmlReport(IReport report, String sName, String appmap, HttpServletRequest request) throws Exception {
        this(report, sName, appmap, request, false);
    }

    public MailHtmlReport(IReport report, String sName, String appmap, HttpServletRequest request, boolean isInput) throws Exception {
        this.report = report;
        this.appmap = appmap;
        this.request = request;
        this.name = sName;
        this.isInput = isInput;
        if (isInput) {
            if (report instanceof RowReport) {
                this.isRowInput = true;
            }
            if (!this.isRowInput) {
                this.updatableCells = InputUtils.getUpdatableCells(report, request);
            } else {
                this.emptyFlows = new ArrayList();
            }
        }
    }

    private void addVar(StringBuffer sb, int row, short col, ReportParser parser) {
        if (this.request == null) {
            return;
        }
        if (parser.isMerged(row, col) && !parser.isMergedFirstCell(row, col, true)) {
            return;
        }
        INormalCell cell = parser.getCell(row, col);
        String varName = cell.getVarName();
        if (varName == null || varName.trim().length() == 0) {
            return;
        }
        if (cell.getCellType() != -64) {
            return;
        }
        Object obj = cell.getValue();
        String varValue = "";
        if (obj != null) {
            varValue = obj.toString();
        }
        this.request.setAttribute(varName, (Object)varValue);
    }

    private void append(StringBuffer sb, String s) throws Exception {
        if (this.pw == null) {
            sb.append(s);
        } else {
            this.pw.write(s);
        }
    }

    public static String checkLLObject(ExtCellSet llo, HttpServletRequest request) throws LicenseException, Exception {
        long now;
        long end;
        long days;
        block23: {
            block26: {
                block25: {
                    block24: {
                        ++bindCodeCount;
                        String forceExport = System.getProperty("forceExport");
                        if (llo.getType() != 0) break block23;
                        if (forceExport == null) break block24;
                        if (forceExport.equalsIgnoreCase("true")) break block25;
                    }
                    if (!llo.checkDog()) break block26;
                }
                return "";
            }
            throw new LicenseException(ServerMsg.getMessage(request, "license.nodog"));
        }
        if (bindCodeCount % 200 == 0) {
            if (llo.getVersion() == 22) {
                String ip = "127.0.0.1";
                try {
                    ip = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Throwable th) {
                    // empty catch block
                }
                if (!llo.checkIP(ip)) {
                    throw new LicenseException(ServerMsg.getMessage(request, "license.ip", (Object)ip));
                }
                int[] codes = llo.getProperties();
                if (codes != null && codes.length > 0) {
                    int bindcode = ExtNormalCell.getBindCode();
                    boolean rightCode = false;
                    String lcCode = "";
                    int i = 0;
                    while (i < codes.length) {
                        if (bindcode == codes[i]) {
                            rightCode = true;
                        }
                        if (lcCode.length() > 0) {
                            lcCode = lcCode + ",";
                        }
                        lcCode = lcCode + codes[i];
                        ++i;
                    }
                    if (!rightCode) {
                        throw new LicenseException(ServerMsg.getMessage(request, "license.bindcode", (Object)String.valueOf(bindcode), (Object)lcCode));
                    }
                }
            }
            if (llo.getType() == 1) {
                String lcOSName = llo.getOSName();
                String osName = System.getProperty("os.name").toLowerCase();
                if (lcOSName.equalsIgnoreCase("other")) {
                    if (osName.indexOf("windows") >= 0 || osName.indexOf("linux") >= 0) {
                        throw new LicenseException(ServerMsg.getMessage(request, "license.other"));
                    }
                } else if (osName.indexOf(lcOSName.toLowerCase()) < 0) {
                    throw new LicenseException(ServerMsg.getMessage(request, "license.win_linux", (Object)lcOSName));
                }
            }
        }
        if ((days = ((end = (long)llo.getExpirationTime()) - (now = new Date().getTime())) / 86400000L) < 14L && days >= 4L) {
            Logger.info(ServerMsg.getMessage(request, "license.expire", (Object)String.valueOf(days)));
        }
        if (days < 4L && days > -1L) {
            return ServerMsg.getMessage(request, "license.expire", (Object)String.valueOf(days));
        }
        if (llo.getVersion() == 20 || llo.getVersion() == 21) {
            return llo.getPrompt() == null ? " " : llo.getPrompt();
        }
        return "";
    }

    private void generateHtml(String suffixName, int startRow, int endRow, short startCol, short endCol, StringBuffer sb) throws Exception {
        MailHtmlCell cell = null;
        this.append(sb, "<table id=\"" + this.name + suffixName + "\" cellSpacing=0 cellPadding=0");
        if (this.selectText) {
            this.append(sb, " selectText=yes");
        }
        if (this.isInput) {
            this.append(sb, " rowCount=" + this.parser.getRowCount() + " cols=" + this.parser.getColCount());
            this.append(sb, " submitCells=\"" + this.report.getSubmit() + "\"");
        }
        boolean hasBackImage = false;
        if (suffixName.length() == 0) {
            BackGraphConfig bgc = this.report.getBackGraphConfig();
            if (bgc != null) {
                byte[] bkImage;
                if (bgc.getDispMode() == 11 && (bkImage = bgc.getImageBytes()) != null) {
                    String graphId = MailGraphPool.createParamsId();
                    MailGraphPool.put(graphId, bkImage);
                    this.append(sb, " background=\"" + this.appRoot + "/reportServlet?action=" + 9 + "&graphId=" + graphId + "&time=" + new Date().getTime() + " no-repeat\"");
                    hasBackImage = true;
                }
            }
            if (this.isRowInput) {
                this.append(sb, " isli=true nextRowNo=" + (this.parser.getRowCount() + 1));
                ExtPRow prow0 = (ExtPRow)((RowReport)this.report).getExtRow0();
                String ndr = this.getNotDetailRows(prow0);
                this.append(sb, " ndr=\"" + ndr + "\"");
            }
        }
        int w = 0;
        short i = startCol;
        while (i <= endCol) {
            w += this.parser.getMergedWidth(0, i, false, this.scale);
            i = (short)(i + 1);
        }
        this.append(sb, " style=\"width:" + w);
        if (hasBackImage) {
            this.append(sb, ";background-repeat:no-repeat");
        }
        this.append(sb, ";table-layout:fixed;border-collapse:collapse\">\n");
        this.append(sb, "\t<colgroup>\n");
        short col = startCol;
        while (col <= endCol) {
            if (this.parser.isColVisible(col)) {
                cell = new MailHtmlCell(this.report, 0, col, this.locale, this.appmap, this.scale);
                this.append(sb, "\t\t<col style=\"" + cell.getStyle());
                if (hasBackImage) {
                    this.append(sb, ";background:none");
                }
                this.append(sb, "\"></col>\n");
            }
            col = (short)(col + 1);
        }
        this.append(sb, "\t</colgroup>\n");
        boolean selectCreated = false;
        String treeName = "";
        Hashtable<String, MailDropDownDW> editConfigs = new Hashtable<String, MailDropDownDW>();
        Hashtable<String, String> treeConfigs = new Hashtable<String, String>();
        Hashtable<String, String> relatedFilters = new Hashtable<String, String>();
        HashSet<String> jsHideFuncs = new HashSet<String>();
        StringBuffer sbRow = new StringBuffer();
        int row = startRow;
        while (row <= endRow) {
            block230: {
                if (!this.isInput && !this.parser.isRowVisible(row)) break block230;
                cell = new MailHtmlCell(this.report, row, 0, this.locale, this.appmap, this.scale);
                sbRow.append("\t<tr");
                if (this.isRowInput) {
                    sbRow.append(" id=").append(this.name).append("_row").append(row).append(" status=\"0\"");
                    ExtRow extrow = ((RowReport)this.report).getExtRow(row);
                    if (this.isDetail(extrow)) {
                        sbRow.append(" isDetail=true did=\"").append(((RowReport)this.report).getDetailID(row)).append("\"");
                        if (this.isDetailFirst(extrow)) {
                            int drows = 1;
                            drows = extrow instanceof ExtPRow ? extrow.getSubSize() + 1 : extrow.getParent().getSubSize() + 1;
                            sbRow.append(" isFirst=true drows=").append(drows);
                        }
                        if (extrow instanceof ExtPRow) {
                            sbRow.append(" pid=\"").append(this.getPRowId(extrow)).append("\"");
                        } else {
                            sbRow.append(" pid=\"").append(this.getPRowId(extrow.getParent())).append("\"");
                        }
                    } else {
                        sbRow.append(" pid=\"").append(this.getPRowId(extrow)).append("\"");
                        if (extrow instanceof ExtPRow) {
                            sbRow.append(" ndr=\"").append(this.getNotDetailRows((ExtPRow)extrow)).append("\"");
                        }
                    }
                }
                sbRow.append(" height=").append(this.parser.getRowHeight(row, this.scale)).append(" style=\"").append(cell.getStyle());
                if (!this.parser.isRowVisible(row)) {
                    sbRow.append(";display:none");
                }
                sbRow.append("\">\n");
                short col2 = startCol;
                while (col2 <= endCol) {
                    block232: {
                        String htmlEvent;
                        String tips;
                        String dsScript;
                        INormalCell srcCell;
                        INormalCell reportCell;
                        int height;
                        int width;
                        block233: {
                            block231: {
                                this.addVar(sb, row, col2, this.parser);
                                width = this.parser.getColWidth(col2, this.scale);
                                height = this.parser.getRowHeight(row, this.scale);
                                cell = new MailHtmlCell(this.report, row, col2, this.locale, this.appmap, this.scale);
                                reportCell = this.parser.getCell(row, col2);
                                srcCell = reportCell.getSrcCell();
                                cell.setHasBackImage(hasBackImage);
                                cell.setSrcCell(srcCell);
                                dsScript = "";
                                if (!this.parser.isMerged(row, col2)) break block231;
                                if (!this.parser.isMergedFirstCell(row, col2, false) && (!this.isInput || !this.parser.isMergedFirstCell(row, col2, true))) break block232;
                                sbRow.append("\t\t<td");
                                int colSpan = this.parser.getColSpan(row, col2, false);
                                int rowSpan = this.parser.getRowSpan(row, col2, false);
                                if (this.isInput && !this.inNS) {
                                    rowSpan = this.parser.getInputRowSpan(row, col2);
                                }
                                if (rowSpan > 1) {
                                    sbRow.append(" rowSpan=").append(rowSpan);
                                    height = this.parser.getMergedHeight(row, col2, false, this.scale);
                                }
                                if (colSpan > 1) {
                                    sbRow.append(" colSpan=").append(colSpan);
                                    width = this.parser.getMergedWidth(row, col2, false, this.scale);
                                }
                                break block233;
                            }
                            sbRow.append("\t\t<td");
                        }
                        byte dataType = reportCell.getCellType();
                        InputProperty ip = reportCell.getInputProperty();
                        int editStyle = 1;
                        String editConfig = "";
                        String cellName = ExcelNotation.toExcelNotation(row, col2);
                        String cellJSValid = "";
                        String cellDelayJSValid = "";
                        if (this.isInput) {
                            if (ip == null) {
                                ip = new InputProperty();
                            }
                            this.needFilter = false;
                            sbRow.append(" id=\"").append(this.name).append("_").append(cellName).append("\" colNo=").append(col2);
                            if (this.isRowInput && reportCell instanceof ExtNCell) {
                                sbRow.append(" sc=\"").append(((ExtNCell)reportCell).getSourceId()).append("\"");
                            }
                            if ((editStyle = ip.getEditStyle()) == 2) {
                                DDListBox lb = (DDListBox)ip.getEditConfig();
                                if (lb != null) {
                                    editConfig = lb.toString();
                                }
                                sbRow.append(" ddEdit=" + (lb.isEditable() ? 1 : 0));
                                sbRow.append(" ddNew=" + (lb.isInputNewValue() ? 1 : 0));
                                sbRow.append(" isMulti=" + (lb.isMultiSelect() ? 1 : 0));
                            }
                            String dwEditConfig = "";
                            if (editStyle == 3 || editStyle == 10) {
                                String firedCells;
                                MailDropDownDW dddw = null;
                                String filterExp = "";
                                if (editStyle == 3) {
                                    DDDataWindow ddwin = (DDDataWindow)ip.getEditConfig();
                                    sbRow.append(" ddEdit=" + (ddwin.isEditable() ? 1 : 0));
                                    sbRow.append(" ddNew=" + (ddwin.isInputNewValue() ? 1 : 0));
                                    sbRow.append(" isMulti=" + (ddwin.isMultiSelect() ? 1 : 0));
                                    filterExp = ddwin.getFilterExp();
                                    String filter_cells = ddwin.getFilterCellName();
                                    this.needFilter = filter_cells != null && filter_cells.trim().length() > 0;
                                    ArgumentTokenizer at_cells = new ArgumentTokenizer(filter_cells, ',');
                                    while (at_cells.hasMoreTokens()) {
                                        String acell = at_cells.nextToken().toUpperCase();
                                        if (this.isRowInput) {
                                            acell = MacroResolver.onlyRemoveBrace(acell, true);
                                            int delta = row - ((ExtNCell)reportCell).getSource().getRow();
                                            CellPosition cpos = ExcelNotation.toCellPosition(acell);
                                            acell = ExcelNotation.toExcelNotation(cpos.getRow() + delta, cpos.getCol());
                                        }
                                        firedCells = (firedCells = (String)relatedFilters.get(acell)) == null ? this.name + "_" + cellName : firedCells + "," + this.name + "_" + cellName;
                                        relatedFilters.put(acell, firedCells);
                                    }
                                    String dddwKey = this.toDddwKey(ddwin);
                                    dddw = (MailDropDownDW)editConfigs.get(dddwKey);
                                    if (dddw != null) {
                                        dwEditConfig = "ref:" + this.name + "_" + dddw.cellName;
                                        editConfig = dddw.editConfig;
                                    } else {
                                        dddw = MailHtmlReport.getDataWinEditConfig(this.context, ddwin, row, col2, this.name, this.request);
                                        editConfig = dddw.editConfig;
                                        dddw.cellName = cellName;
                                        editConfigs.put(dddwKey, dddw);
                                        if (this.needFilter) {
                                            dsScript = dddw.dsScript;
                                        }
                                    }
                                } else if (editStyle == 10) {
                                    DDViewDataWindow ddview = (DDViewDataWindow)ip.getEditConfig();
                                    sbRow.append(" ddEdit=" + (ddview.isEditable() ? 1 : 0));
                                    sbRow.append(" ddNew=" + (ddview.isInputNewValue() ? 1 : 0));
                                    sbRow.append(" isMulti=" + (ddview.isMultiSelect() ? 1 : 0));
                                    filterExp = ddview.getFilterExp();
                                    String filter_cells = ddview.getFilterCellName();
                                    this.needFilter = filter_cells != null && filter_cells.trim().length() > 0;
                                    ArgumentTokenizer at_cells = new ArgumentTokenizer(filter_cells, ',');
                                    while (at_cells.hasMoreTokens()) {
                                        String acell = at_cells.nextToken().toUpperCase();
                                        if (this.isRowInput) {
                                            acell = MacroResolver.onlyRemoveBrace(acell, true);
                                            int delta = row - ((ExtNCell)reportCell).getSource().getRow();
                                            CellPosition cpos = ExcelNotation.toCellPosition(acell);
                                            acell = ExcelNotation.toExcelNotation(cpos.getRow() + delta, cpos.getCol());
                                        }
                                        firedCells = (firedCells = (String)relatedFilters.get(acell)) == null ? this.name + "_" + cellName : firedCells + "," + this.name + "_" + cellName;
                                        relatedFilters.put(acell, firedCells);
                                    }
                                    String dddwKey = this.toDdviewKey(ddview);
                                    dddw = (MailDropDownDW)editConfigs.get(dddwKey);
                                    if (dddw != null) {
                                        dwEditConfig = "ref:" + this.name + "_" + dddw.cellName;
                                        editConfig = dddw.editConfig;
                                    } else {
                                        dddw = MailHtmlReport.getDataWinEditConfig(this.context, ddview, row, col2, this.name, this.request);
                                        editConfig = dddw.editConfig;
                                        dddw.cellName = cellName;
                                        editConfigs.put(dddwKey, dddw);
                                        if (this.needFilter) {
                                            dsScript = dddw.dsScript;
                                        }
                                    }
                                }
                                if (this.needFilter) {
                                    sbRow.append(" dataSet=\"").append(dddw.dsName).append("\"");
                                    if (this.isRowInput) {
                                        filterExp = MacroResolver.onlyRemoveBrace(filterExp, true);
                                    }
                                    filterExp = InputUtils.replaceEqual(filterExp, 0);
                                    filterExp = Sentence.replace(filterExp, "<>", "!=", 2);
                                    filterExp = Sentence.replace(filterExp, " and ", " && ", 3);
                                    filterExp = Sentence.replace(filterExp, " or ", " || ", 3);
                                    ExpTransform et = new ExpTransform(filterExp, this.report);
                                    ArrayList parts = et.getParts();
                                    int part = 0;
                                    while (part < parts.size()) {
                                        String expPart = (String)parts.get(part);
                                        if (("," + dddw.colNames + ",").indexOf(expPart.toLowerCase()) >= 0) {
                                            parts.set(part, expPart.toLowerCase());
                                        }
                                        ++part;
                                    }
                                    if (this.isRowInput) {
                                        et.toRowReportExp("'");
                                    } else if (this.inNS) {
                                        et.replaceExcelNotation("_parseValue( document.getElementById( '" + this.name + "_[EXCELNOTATION]' ) )", "document.getElementById( '" + this.name + "_[EXCELNOTATION]' ).attributes.getNamedItem( 'value' ).value");
                                    } else {
                                        et.replaceExcelNotation("_parseValue( document.getElementById( '" + this.name + "_[EXCELNOTATION]' ) )", "document.getElementById( '" + this.name + "_[EXCELNOTATION]' ).value");
                                    }
                                    sbRow.append(" filterExp=\"").append(et.toString()).append("\"");
                                }
                            }
                            boolean writable = ip.isWritable();
                            if (dataType == -64 || dataType == -58) {
                                ICloneable ddtree;
                                String cellvalue;
                                if (writable) {
                                    sbRow.append(" modifiable=true");
                                }
                                if (editStyle == 4 || editStyle == 5 || editStyle == 6 || editStyle == 8 || editStyle == 11 || editStyle == 7 || editStyle == 12 || dataType == -58) {
                                    writable = false;
                                }
                                boolean needValue = false;
                                if (writable) {
                                    if (reportCell.getTextWrap()) {
                                        editStyle = 0;
                                    }
                                    needValue = true;
                                    sbRow.append(" writable=true");
                                    int htmlEditStyle = editStyle;
                                    if (editStyle == 10) {
                                        htmlEditStyle = 3;
                                    }
                                    sbRow.append(" editStyle=\"").append(htmlEditStyle).append("\"");
                                    byte inputDataType = ip.getInputType();
                                    sbRow.append(" inputDataType=\"").append(inputDataType).append("\"");
                                }
                                if (editStyle == 2 || editStyle == 3 || editStyle == 10) {
                                    if (editConfig == null || editConfig.trim().length() == 0) {
                                        editConfig = "";
                                    }
                                    if (dwEditConfig.trim().length() == 0) {
                                        if (!this.needFilter) {
                                            sbRow.append(" editConfig=\"").append(editConfig).append("\"");
                                        } else {
                                            sbRow.append(" editConfig=\"\"");
                                        }
                                    } else {
                                        sbRow.append(" editConfig=\"").append(dwEditConfig).append("\"");
                                    }
                                }
                                if (this.isUpdatableCell(reportCell)) {
                                    needValue = true;
                                    sbRow.append(" updatable=true");
                                }
                                if (editStyle == 7) {
                                    needValue = false;
                                }
                                if ((cellvalue = cell.getValue()).indexOf("'") >= 0) {
                                    cellvalue = StringUtils.replace(cellvalue, "'", "&#039");
                                }
                                sbRow.append(" value='").append(cellvalue).append("'");
                                try {
                                    Double.parseDouble(cell.getValue());
                                    String dispStyle = reportCell.getFormat();
                                    if (dispStyle != null && dispStyle.trim().length() > 0) {
                                        dispStyle = dispStyle.trim();
                                        int digits = 0;
                                        int digitPos = dispStyle.indexOf(".");
                                        if (digitPos > 0) {
                                            digits = dispStyle.length() - digitPos - 1;
                                        }
                                        sbRow.append(" digits=\"").append(digits).append("\"");
                                    }
                                }
                                catch (Exception ee) {
                                    // empty catch block
                                }
                                if (this.isRowInput) {
                                    String flowExp;
                                    String autoCalc;
                                    ExtNCell ncell;
                                    cellJSValid = InputUtils.createRRCheckValidScript(this.report, row, col2, true);
                                    if (cellJSValid.length() > 0) {
                                        ncell = (ExtNCell)reportCell;
                                        sbRow.append(" dataValid=\"").append(this.name).append("_").append(ncell.getSourceId()).append("_valid()\"");
                                        if (ncell.getRow() != ncell.getRow().getSource()) {
                                            cellJSValid = "";
                                        }
                                    }
                                    if ((cellDelayJSValid = InputUtils.createRRCheckValidScript(this.report, row, col2, false)).length() > 0) {
                                        ncell = (ExtNCell)reportCell;
                                        sbRow.append(" _dv=\"").append(this.name).append("_").append(ncell.getSourceId()).append("_dv()\"");
                                        if (ncell.getRow() != ncell.getRow().getSource()) {
                                            cellDelayJSValid = "";
                                        }
                                    }
                                    if ((autoCalc = ip.getAutoCalc()) != null && autoCalc.trim().length() > 0) {
                                        ExpTransform et = new ExpTransform(autoCalc.trim(), this.report);
                                        et.toRowReportExp();
                                        sbRow.append(" calc='").append(et.toString()).append("'");
                                    }
                                    if ((flowExp = ip.getFlowExp()) != null && flowExp.trim().length() > 0) {
                                        sbRow.append(" flow='").append(flowExp).append("'");
                                        if (cellvalue.trim().length() == 0 && this.isSingleRowDetail((ExtNCell)reportCell)) {
                                            this.emptyFlows.add(cellName);
                                        }
                                    }
                                } else {
                                    cellJSValid = InputUtils.createCheckValidScript(this.report, this.name, row, col2, this.inNS);
                                    if (cellJSValid.length() > 0) {
                                        sbRow.append(" dataValid=\"").append(this.name).append("_").append(row).append("_").append(col2).append("_dataValid()\"");
                                    }
                                }
                                if (editStyle == 6) {
                                    DDCalendar ddc = (DDCalendar)ip.getEditConfig();
                                    if (ip.isWritable()) {
                                        if (ddc == null) {
                                            ddc = new DDCalendar();
                                        }
                                        String sepa = ddc.getSeparatorString();
                                        String vType = "day";
                                        switch (ddc.getType()) {
                                            case 12: {
                                                vType = "month";
                                                break;
                                            }
                                            case 13: {
                                                vType = "year";
                                                break;
                                            }
                                            case 14: {
                                                vType = "date";
                                                break;
                                            }
                                            case 15: {
                                                vType = "time";
                                            }
                                        }
                                        sbRow.append(" editStyle=\"").append(editStyle).append("\"");
                                        if (this.inNS) {
                                            sbRow.append(" onclick=\"_hideEditor( event ); _runqianCalendar().separator='").append(sepa).append("'; _runqianCalendar().type= '").append(vType).append("';_showCalendar( event );_setRowColBackColor(this)\"");
                                        } else {
                                            String dateFormat = MailHtmlReport.getDateFormt(vType, this.request.getLocale());
                                            sbRow.append(" onclick=\"_hideEditor(); _runqianCalendar.dateFormat='").append(dateFormat).append("'; _runqianCalendar.type= '").append(vType).append("';_showCalendar();_setRowColBackColor(this)\"");
                                        }
                                    }
                                }
                                if (editStyle == 8) {
                                    ddtree = (DDTree)ip.getEditConfig();
                                    if (ip.isWritable() && ddtree != null) {
                                        String treeKey = this.toTreeKey((DDTree)ddtree);
                                        treeName = (String)treeConfigs.get(treeKey);
                                        if (treeName == null) {
                                            treeName = "tree_" + this.name + row + col2;
                                            treeConfigs.put(treeKey, treeName);
                                            this.needCreateTree = true;
                                        } else {
                                            this.needCreateTree = false;
                                        }
                                        sbRow.append(" editStyle=\"").append(editStyle).append("\"");
                                        if (this.inNS) {
                                            sbRow.append(" onclick=\"_hideEditor( event ); tree_show( this, '").append(treeName).append("' );_setRowColBackColor(this)\"");
                                        } else {
                                            sbRow.append(" onclick=\"_hideEditor(); tree_show( this, '").append(treeName).append("' );_setRowColBackColor(this)\"");
                                        }
                                    }
                                }
                                if (editStyle == 11) {
                                    ddtree = (DDViewTree)ip.getEditConfig();
                                    if (ip.isWritable() && ddtree != null) {
                                        String treeKey = this.toViewTreeKey((DDViewTree)ddtree);
                                        treeName = (String)treeConfigs.get(treeKey);
                                        if (treeName == null) {
                                            treeName = "tree_" + this.name + row + col2;
                                            treeConfigs.put(treeKey, treeName);
                                            this.needCreateTree = true;
                                        } else {
                                            this.needCreateTree = false;
                                        }
                                        sbRow.append(" editStyle=\"").append(8).append("\"");
                                        if (this.inNS) {
                                            sbRow.append(" onclick=\"_hideEditor( event ); tree_show( this, '").append(treeName).append("' );_setRowColBackColor(this)\"");
                                        } else {
                                            sbRow.append(" onclick=\"_hideEditor(); tree_show( this, '").append(treeName).append("' );_setRowColBackColor(this)\"");
                                        }
                                    }
                                }
                                if (editStyle == 12) {
                                    CustomEditStyle ces = (CustomEditStyle)ip.getEditConfig();
                                    if (ip.isWritable() && ces != null) {
                                        String jsShow = ces.getJsFunctionShow();
                                        if (jsShow == null || jsShow.trim().length() == 0) {
                                            throw new Exception(ServerMsg.getMessage(this.request, "input.noShowFunc", (Object)cellName));
                                        }
                                        String jsHide = ces.getJsFunctionHide();
                                        if (jsHide != null && jsHide.trim().length() > 0) {
                                            jsHideFuncs.add(jsHide);
                                        }
                                        sbRow.append(" editStyle=\"").append(12).append("\"");
                                        if (this.inNS) {
                                            sbRow.append(" onclick=\"_hideEditor( event );").append(jsShow).append(";_setRowColBackColor(this)\"");
                                        } else {
                                            sbRow.append(" onclick=\"_hideEditor();").append(jsShow).append(";_setRowColBackColor(this)\"");
                                        }
                                    }
                                }
                            } else {
                                writable = false;
                            }
                            if (ip.isWritable() && editStyle == 7 && !this.isRowInput) {
                                ArrayList updates;
                                if (!ExtCellSet.get().getUploadEnabled()) {
                                    throw new Exception(ServerMsg.getMessage(this.request, "input.upload6"));
                                }
                                if (this.inNS) {
                                    // empty if block
                                }
                                if ((updates = ip.getUpdateList()) == null || updates.size() != 1) {
                                    throw new Exception(ServerMsg.getMessage(this.request, "input.upload1", (Object)cellName));
                                }
                                UpdateProperty up = (UpdateProperty)updates.get(0);
                                TableRelations trs = (TableRelations)up.getRelation();
                                String upDs = trs.getDataSourceName();
                                String upTable = trs.getTableName();
                                StringBuffer upKeys = new StringBuffer();
                                StringBuffer upKeyCells = new StringBuffer();
                                StringBuffer upOrigins = new StringBuffer();
                                StringBuffer upFields = new StringBuffer();
                                StringBuffer upValueCells = new StringBuffer();
                                int colCount = trs.getRelationCount();
                                int i2 = 0;
                                while (i2 < colCount) {
                                    TableRelation tr = trs.getRelation(i2);
                                    String fieldName = tr.getFieldName();
                                    String upValueCell = tr.getRelationParams().getParamExp(0).toUpperCase();
                                    if (upValueCell.startsWith("=")) {
                                        upValueCell = upValueCell.substring(1);
                                    }
                                    if (tr.isPrimaryKey()) {
                                        if (upKeys.length() > 0) {
                                            upKeys.append(",");
                                        }
                                        upKeys.append(fieldName);
                                        if (upKeyCells.length() > 0) {
                                            upKeyCells.append(",");
                                        }
                                        upKeyCells.append(upValueCell);
                                        CellPosition pos = ExcelNotation.toCellPosition(upValueCell);
                                        MailHtmlCell keyCell = new MailHtmlCell(this.report, pos.getRow(), pos.getCol(), this.locale, this.appmap, 1.0f);
                                        String origin = keyCell.getValue();
                                        if (upOrigins.length() > 0) {
                                            upOrigins.append(";");
                                        }
                                        upOrigins.append(upValueCell).append("=").append(origin);
                                    }
                                    if (upFields.length() > 0) {
                                        upFields.append(",");
                                    }
                                    upFields.append(fieldName);
                                    if (upValueCells.length() > 0) {
                                        upValueCells.append(",");
                                    }
                                    upValueCells.append(upValueCell);
                                    ++i2;
                                }
                                if (upKeys.length() == 0) {
                                    throw new Exception(ServerMsg.getMessage(this.request, "input.upload5", (Object)cellName));
                                }
                                String ext = "";
                                try {
                                    ArrayList alExt = ((UploadFile)ip.getEditConfig()).getExtNames();
                                    int i3 = 0;
                                    while (i3 < alExt.size()) {
                                        if (ext.length() > 0) {
                                            ext = ext + ",";
                                        }
                                        ext = ext + (String)alExt.get(i3);
                                        ++i3;
                                    }
                                }
                                catch (Exception eee) {
                                    ext = "*.*";
                                }
                                if (ext.length() == 0) {
                                    ext = "*.*";
                                }
                                sbRow.append(" ondblclick=\"_uploadFile( '" + this.appRoot + "/reportServlet?action=" + 13 + "', " + "document.getElementById( '" + this.name + suffixName + "' ), '" + upDs + "', '" + upTable + "', '" + upKeys.toString() + "', '" + upKeyCells.toString() + "', '" + upOrigins.toString() + "', '" + upFields.toString() + "', '" + upValueCells.toString() + "', '" + cellName + "', '" + ext + "' )\"");
                            } else if (this.inNS) {
                                if (writable) {
                                    sbRow.append(" onclick=\"_displayEditor( event )\"");
                                } else if (editStyle != 6 && editStyle != 8 && editStyle != 11 && editStyle != 12) {
                                    sbRow.append(" onclick=\"_hideEditor( event )\"");
                                }
                            } else if (writable) {
                                sbRow.append(" onclick=\"_displayEditor()\"");
                            } else if (editStyle != 6 && editStyle != 8 && editStyle != 11 && editStyle != 12) {
                                sbRow.append(" onclick=\"_hideEditor()\"");
                            }
                        }
                        sbRow.append(" class=\"").append(this.styles.get(srcCell)).append("\"");
                        String style = cell.getStyle();
                        if (!this.parser.isColVisible(col2)) {
                            style = style + "display:none";
                        }
                        if (style.length() > 0) {
                            sbRow.append(" style=\"").append(style).append("\"");
                        }
                        if ((tips = reportCell.getTip()) != null && tips.trim().length() > 0) {
                            sbRow.append(" title=\"").append(tips).append("\"");
                        }
                        if ((htmlEvent = reportCell.getHTMLEvent()) != null && htmlEvent.trim().length() > 0) {
                            sbRow.append(" ").append(htmlEvent);
                        }
                        sbRow.append(">");
                        if (reportCell.isVisible()) {
                            LeanLine leanline;
                            Object imagevalue;
                            Object imageBytes;
                            String link = cell.getLink();
                            if (link != null && link.trim().length() > 0) {
                                String target;
                                sbRow.append("<a href=\"").append(link).append("\"");
                                if (this.needLinkStyle) {
                                    sbRow.append(" style=\"").append(cell.getLinkStyle()).append("\"");
                                }
                                if ((target = reportCell.getHyperlinkWindow()) != null && target.trim().length() > 0) {
                                    sbRow.append(" target=\"").append(target.trim()).append("\"");
                                }
                                sbRow.append(">");
                            }
                            byte lean = reportCell.getDiagonalStyle();
                            if (dataType == -64 && lean == 80 || dataType == -58) {
                                if (this.isInput) {
                                    switch (editStyle) {
                                        case 2: 
                                        case 3: 
                                        case 10: {
                                            sbRow.append(this.lookupDisplay(editConfig, cell.getValue(), cell.getText()));
                                            break;
                                        }
                                        case 4: {
                                            String cbValue = cell.getValue();
                                            CheckBox checkbox = (CheckBox)ip.getEditConfig();
                                            if (checkbox == null) {
                                                throw new Exception(ServerMsg.getMessage(this.request, "checkbox.nocfg", (Object)String.valueOf(row), (Object)String.valueOf(col2)));
                                            }
                                            String cbText = checkbox.getLabel();
                                            byte cbLocation = checkbox.getLabelLocation();
                                            String cbOn = checkbox.getOnValue();
                                            String cbOff = checkbox.getOffValue();
                                            StringBuffer cbsb = new StringBuffer();
                                            if (this.inNS) {
                                                cbsb.append("<input type=checkbox onclick=\"_setRowColBackColor(this.parentNode);if( this.checked ) document.getElementById( '" + this.name + "_" + cellName + "' ).attributes.getNamedItem( 'value' ).value = '" + cbOn + "';else document.getElementById( '" + this.name + "_" + cellName + "' ).attributes.getNamedItem( 'value' ).value='" + cbOff + "';if(!autoCalcOnlyOnSubmit)try{" + this.name + "_autoCalc( '" + cellName + "' );}catch(ex){};document.getElementById( '" + this.name + "' ).changed = true;\"");
                                            } else {
                                                cbsb.append("<input type=checkbox onclick=\"_setRowColBackColor(this.parentElement);if( this.checked ) " + this.name + "_" + cellName + ".value = '" + cbOn + "';else " + this.name + "_" + cellName + ".value='" + cbOff + "';");
                                                if (!this.isRowInput) {
                                                    cbsb.append("if(!autoCalcOnlyOnSubmit)try{" + this.name + "_autoCalc( '" + cellName + "' );}catch(ex){};" + this.name + ".changed = true;");
                                                } else {
                                                    cbsb.append("_calcTbl(" + this.name + ",this.parentElement); var r = this.parentElement.parentElement; if( r.status=='0')r.status='1';if( r.status=='2')r.status='3';");
                                                }
                                                cbsb.append("\"");
                                            }
                                            if (cbValue.equals(cbOn)) {
                                                cbsb.append(" checked");
                                            }
                                            if (!ip.isWritable()) {
                                                cbsb.append(" disabled");
                                            }
                                            cbsb.append(">");
                                            if (cbText != null && cbText.trim().length() > 0) {
                                                if (cbLocation == 1) {
                                                    cbsb.insert(0, cbText);
                                                } else {
                                                    cbsb.append(cbText);
                                                }
                                            }
                                            sbRow.append(cbsb.toString());
                                            break;
                                        }
                                        case 5: {
                                            String rbValue = cell.getValue();
                                            RadioBox rb = (RadioBox)ip.getEditConfig();
                                            if (rb == null) {
                                                throw new Exception(ServerMsg.getMessage(this.request, "radiobox.nocfg", (Object)String.valueOf(row), (Object)String.valueOf(col2)));
                                            }
                                            ArrayList codes = rb.getCodeList();
                                            ArrayList disps = rb.getDispList();
                                            int cols = rb.getColumns();
                                            StringBuffer rbsb = new StringBuffer();
                                            int i4 = 0;
                                            while (i4 < codes.size()) {
                                                Object ocode = codes.get(i4);
                                                Object odisp = disps.get(i4);
                                                if (ocode != null) {
                                                    if (i4 > 0 && i4 % cols == 0) {
                                                        rbsb.append("<br>");
                                                    }
                                                    if (this.inNS) {
                                                        rbsb.append("<input type=radio name=" + this.name + "_" + cellName + "_rb" + " onclick=\"_setRowColBackColor(this.parentNode);if( this.checked ) document.getElementById( '" + this.name + "_" + cellName + "' ).attributes.getNamedItem( 'value' ).value = '" + ocode.toString() + "';else document.getElementById( '" + this.name + "_" + cellName + "' ).attributes.getNamedItem( 'value' ).value='';if(!autoCalcOnlyOnSubmit)try{" + this.name + "_autoCalc( '" + cellName + "' );}catch(ex){};document.getElementById( '" + this.name + "' ).changed = true;\"");
                                                    } else {
                                                        rbsb.append("<input type=radio name=" + this.name + "_" + cellName + "_rb" + " onclick=\"_setRowColBackColor(this.parentElement);if( this.checked ) " + this.name + "_" + cellName + ".value = '" + ocode.toString() + "';else " + this.name + "_" + cellName + ".value='';");
                                                        if (!this.isRowInput) {
                                                            rbsb.append("if(!autoCalcOnlyOnSubmit)try{" + this.name + "_autoCalc( '" + cellName + "' );}catch(ex){};" + this.name + ".changed = true;");
                                                        } else {
                                                            rbsb.append("_calcTbl(" + this.name + ",this.parentElement);var r = this.parentElement.parentElement; if( r.status=='0')r.status='1';if( r.status=='2')r.status='3';");
                                                        }
                                                        rbsb.append("\"");
                                                    }
                                                    if (rbValue.equals(ocode.toString())) {
                                                        rbsb.append(" checked");
                                                    }
                                                    if (!ip.isWritable()) {
                                                        rbsb.append(" disabled");
                                                    }
                                                    rbsb.append(">").append(odisp == null ? "" : odisp.toString());
                                                }
                                                ++i4;
                                            }
                                            sbRow.append(rbsb.toString());
                                            break;
                                        }
                                        case 9: {
                                            String pwd = cell.getValue();
                                            int stars = pwd.length();
                                            pwd = "";
                                            int star = 0;
                                            while (star < stars) {
                                                pwd = pwd + "*";
                                                ++star;
                                            }
                                            sbRow.append(pwd);
                                            break;
                                        }
                                        default: {
                                            String text = cell.getText();
                                            if (editStyle == 7 && text.length() == 0) {
                                                text = ServerMsg.getMessage(this.request, "upload.text");
                                            }
                                            sbRow.append(text);
                                        }
                                    }
                                } else {
                                    String text = cell.getText();
                                    sbRow.append(text);
                                }
                            } else if (dataType == -60) {
                                Object subValue = reportCell.getValue();
                                if (subValue != null && subValue instanceof IReport) {
                                    try {
                                        MailHtmlReport sub = new MailHtmlReport((IReport)subValue, this.name + "_sub_" + row + "_" + col2, this.appmap, this.request);
                                        sub.setIsSub(true);
                                        sub.setScale(this.scale);
                                        sbRow.append(sub.generateHtml());
                                    }
                                    catch (Exception e) {
                                    }
                                }
                            } else if (this.appRoot == null) {
                                imageBytes = null;
                                String fmt = "jpg";
                                if (dataType == -57 || dataType == -61) {
                                    imagevalue = reportCell.getValue();
                                    if (imagevalue != null && imagevalue instanceof ImageValue) {
                                        imageBytes = ((ImageValue)imagevalue).getValue();
                                        switch (((ImageValue)imagevalue).getImageType()) {
                                            case 2: {
                                                fmt = "gif";
                                                break;
                                            }
                                            case 3: {
                                                fmt = "png";
                                            }
                                        }
                                    }
                                } else if (lean != 80) {
                                    leanline = new LeanLine(this.parser, row, col2);
                                    imageBytes = leanline.toBytes(width, height);
                                } else {
                                    imageBytes = reportCell.getValue();
                                }
                                if (imageBytes != null && imageBytes instanceof byte[]) {
                                    try {
                                        if (this.picFileDir == null) {
                                            String tmp = StringUtils.replace(this.htmlFileName, "\\", "/");
                                            int pos = tmp.lastIndexOf("/");
                                            if (pos >= 0) {
                                                this.htmlFileName = tmp.substring(pos + 1);
                                                tmp = tmp.substring(0, pos + 1);
                                                this.picFileDir = new File(tmp + this.htmlFileName + "_files");
                                            } else {
                                                this.picFileDir = new File(this.htmlFileName + "_files");
                                            }
                                            if (!this.picFileDir.exists()) {
                                                this.picFileDir.mkdirs();
                                            }
                                        }
                                        String picName = this.htmlFileName.substring(0, this.htmlFileName.indexOf(".")) + "_" + row + "_" + col2 + "_" + fmt;
                                        File picFile = new File(this.picFileDir, picName);
                                        FileOutputStream fos = new FileOutputStream(picFile);
                                        fos.write((byte[])imageBytes);
                                        fos.flush();
                                        fos.close();
                                        int[] wh = this.parser.getImageWH((byte[])imageBytes, row, col2, this.scale);
                                        int ww = wh[0];
                                        int hh = wh[1];
                                        sbRow.append("<img src=\"cid:").append(picName).append("\" border=no width=").append(ww).append(" height=").append(hh).append(">");
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        throw new RuntimeException(e.getMessage());
                                    }
                                }
                            } else {
                                String graphId;
                                imageBytes = null;
                                String graphLink = null;
                                if (dataType == -57 || dataType == -61) {
                                    imagevalue = reportCell.getValue();
                                    if (imagevalue != null && imagevalue instanceof ImageValue) {
                                        imageBytes = ((ImageValue)imagevalue).getValue();
                                        graphLink = ((ImageValue)imagevalue).getHtml();
                                    }
                                } else if (lean != 80) {
                                    leanline = new LeanLine(this.parser, row, col2);
                                    imageBytes = leanline.toBytes(width, height - 2);
                                } else {
                                    imageBytes = reportCell.getValue();
                                }
                                if (dataType == -61) {
                                    if (imageBytes != null) {
                                        graphId = MailGraphPool.createParamsId();
                                        MailGraphPool.put(graphId, (byte[])imageBytes);
                                        sbRow.append("<img src=\"").append(this.appRoot).append("/reportServlet?action=").append(9).append("&graphId=").append(graphId).append("&time=").append(new Date().getTime()).append("\" width=").append(width).append(" height=").append(height).append(" border=no").append(" usemap=\"#").append(graphId).append("\" ismap>");
                                        if (graphLink != null && graphLink.trim().length() > 0) {
                                            graphLink = Sentence.replace(graphLink, "{APPMAP}", this.appRoot, 19);
                                            sbRow.append("<map name=\"").append(graphId).append("\">");
                                            sbRow.append(graphLink);
                                            sbRow.append("</map>");
                                        }
                                    }
                                } else if (imageBytes != null && imageBytes instanceof byte[]) {
                                    graphId = MailGraphPool.createParamsId();
                                    MailGraphPool.put(graphId, (byte[])imageBytes);
                                    int[] wh = this.parser.getImageWH((byte[])imageBytes, row, col2, this.scale);
                                    int ww = wh[0];
                                    int hh = wh[1];
                                    if (lean == 80 && this.parser.isMerged(row, col2) && reportCell.getAdjustSizeMode() == 49) {
                                        --hh;
                                    }
                                    sbRow.append("<img src=\"").append(this.appRoot).append("/reportServlet?action=").append(9).append("&graphId=").append(graphId).append("&time=").append(new Date().getTime()).append("\" width=").append(ww).append(" height=").append(hh).append(" border=no>");
                                } else if (this.isInput && !this.isRowInput && editStyle == 7 && imageBytes == null && dataType == -62) {
                                    sbRow.append("<img src=\"\" alt=\"").append(ServerMsg.getMessage(this.request, "upload.pic")).append("\" width=").append(width).append(" height=").append(height - 2).append(" border=no>");
                                }
                            }
                            if (link != null && link.trim().length() > 0) {
                                sbRow.append("</a>");
                            }
                        }
                        sbRow.append("</td>\n");
                        if (this.isInput && (editStyle == 2 || editStyle == 3 || editStyle == 10)) {
                            if (!this.selectJSImported) {
                                this.selectJSImported = true;
                            }
                            if (!selectCreated) {
                                selectCreated = true;
                            }
                            if (this.needFilter) {
                                if (!ExtCellSet.get().getSpecialInputEnabled()) {
                                    throw new Exception(ServerMsg.getMessage(this.request, "input.notFilter"));
                                }
                                if (!this.filterJSImported) {
                                    this.filterJSImported = true;
                                }
                                if (dsScript == null || dsScript.trim().length() > 0) {
                                    // empty if block
                                }
                            }
                        }
                        if (this.isInput && editStyle == 6 && !this.calendarJSImported) {
                            if (!ExtCellSet.get().getSpecialInputEnabled()) {
                                throw new Exception(ServerMsg.getMessage(this.request, "input.notCalendar"));
                            }
                            this.calendarJSImported = true;
                        }
                        if (this.isInput && (editStyle == 8 || editStyle == 11)) {
                            if (!ExtCellSet.get().getSpecialInputEnabled()) {
                                throw new Exception(ServerMsg.getMessage(this.request, "input.notTree"));
                            }
                            if (!this.treeJSImported) {
                                this.treeJSImported = true;
                            }
                            if (this.needCreateTree) {
                                Object tree;
                                if (editStyle == 8) {
                                    tree = new Tree((DDTree)ip.getEditConfig(), this.context, this.request.getContextPath(), treeName, this.request);
                                    ((Tree)tree).setInNS(this.inNS);
                                    sbRow.append(((Tree)tree).generateHtml());
                                }
                                if (editStyle == 11) {
                                    tree = new ViewTree((DDViewTree)ip.getEditConfig(), this.context, this.request.getContextPath(), treeName, this.request);
                                    ((ViewTree)tree).setInNS(this.inNS);
                                    sbRow.append(((ViewTree)tree).generateHtml());
                                }
                            }
                        }
                        if (!this.isInput || this.isRowInput) {
                            // empty if block
                        }
                    }
                    col2 = (short)(col2 + 1);
                }
                sbRow.append("\t</tr>\n");
                this.append(sb, sbRow.toString());
                sbRow.setLength(0);
            }
            ++row;
        }
        this.append(sb, "</table>");
    }

    public String generateHtml() throws Exception {
        int subPos;
        if (this.request != null) {
            this.locale = this.request.getLocale();
            this.appRoot = ReportServlet.getUrlPrefix(this.request);
            if (this.request.getHeader("user-agent").toLowerCase().indexOf("msie") < 0) {
                this.inNS = true;
            }
        } else {
            this.htmlFileName = this.name;
            this.name = "r1";
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        this.parser = new ReportParser(this.report);
        StringBuffer sb = new StringBuffer(3000);
        String versionInfo = "";
        String forceExport = System.getProperty("forceExport");
        try {
            ExtCellSet llo = ExtCellSet.get();
            if (!this.isSub) {
                if (!llo.getFreezedHeaderEnabled()) {
                    this.isScroll = false;
                    Logger.info(ServerMsg.getMessage(this.request, "license.noLockHeaderRight"));
                }
                versionInfo = MailHtmlReport.checkLLObject(llo, this.request);
                String lcInfo = "";
                if (versionInfo.length() == 0) {
                    lcInfo = llo.getPrompt();
                } else {
                    lcInfo = versionInfo;
                    versionInfo = "<div style=\"color:#000000; font-family:\u5b8b\u4f53; font-size:9pt; padding-top:3px\" class=" + this.name + ">" + MailHtmlReport.processLicenseInfo(versionInfo) + "</div>\n";
                }
            } else if (!llo.getSubReportEnabled()) {
                throw new LicenseException(ServerMsg.getMessage(this.request, "license.noSubReportRight"));
            }
        }
        catch (LicenseException e) {
            throw new Exception(e.getMessage());
        }
        String styleName = this.name;
        if (this.isSub && (subPos = styleName.indexOf("_sub_")) > 0) {
            styleName = styleName.substring(0, subPos);
        }
        HashSet<INormalCell> srcs = new HashSet<INormalCell>();
        int rr = this.report.getRowCount();
        short cc = this.report.getColCount();
        int row = 1;
        while (row <= rr) {
            short col = 1;
            while (col <= cc) {
                INormalCell cell = this.report.getCell(row, col);
                if (cell != null) {
                    srcs.add(cell.getSrcCell());
                }
                col = (short)(col + 1);
            }
            ++row;
        }
        if (!this.inNS) {
            this.append(sb, "<style>");
        } else {
            this.append(sb, "<style>\n");
        }
        Hashtable<String, String> tmpStyles = new Hashtable<String, String>();
        int classIndex = 1;
        Iterator it = srcs.iterator();
        while (it.hasNext()) {
            INormalCell cell = (INormalCell)it.next();
            String style = cell.getStyle();
            String styleClass = "";
            boolean styleExist = false;
            Iterator styleIt = tmpStyles.keySet().iterator();
            while (styleIt.hasNext()) {
                styleClass = (String)styleIt.next();
                String tmp = (String)tmpStyles.get(styleClass);
                if (!style.equals(tmp)) continue;
                styleExist = true;
                break;
            }
            if (!styleExist) {
                styleClass = this.name + "_" + classIndex;
                ++classIndex;
                tmpStyles.put(styleClass, style);
                if (this.inNS) {
                    this.append(sb, "\t." + styleClass + " { " + style + "}\n");
                } else {
                    this.append(sb, "\t." + styleName + "_s_" + styleClass + " { " + style + "}");
                }
            }
            if (this.inNS) {
                this.styles.put(cell, styleClass);
                continue;
            }
            this.styles.put(cell, styleName + "_s_" + styleClass);
        }
        if (!this.inNS) {
            this.append(sb, "</style>\n");
        } else {
            this.append(sb, "</style>\n");
        }
        if (!this.isScroll) {
            int rowCount = this.parser.getRowCount();
            short colCount = this.parser.getColCount();
            int startRow = 1;
            int endRow = rowCount;
            Area pageHeader = this.parser.getPageHeader();
            Area pageFooter = this.parser.getPageFooter();
            if (pageHeader != null) {
                startRow = pageHeader.getEndRow() + 1;
            }
            if (pageFooter != null) {
                endRow = pageFooter.getBeginRow() - 1;
            }
            this.generateHtml("", startRow, endRow, (short)1, colCount, sb);
        } else {
            this.append(sb, "<div id=\"" + this.name + "_scrollArea\" style=\"overflow:hidden;width:" + this.W + ";height:" + this.H);
            if (this.border != null && this.border.trim().length() > 0) {
                this.append(sb, ";" + this.border);
            }
            if (this.inNS) {
                this.append(sb, "\">\n");
            } else {
                this.append(sb, "\">\n");
            }
            Area title = this.parser.getTitleField();
            Area topHeader = this.parser.getTopHeader();
            Area leftHeader = this.parser.getLeftHeader();
            if (this.isRowInput) {
                leftHeader = null;
            }
            Area tableFooter = this.parser.getFooterField();
            this.processLeftHeaderCut(title, topHeader, leftHeader, tableFooter);
            int topStartRow = 0;
            int topEndRow = -1;
            Area data = this.parser.getDataField();
            int contentStartRow = data.getBeginRow();
            int contentEndRow = data.getEndRow();
            if (tableFooter != null) {
                contentEndRow = tableFooter.getEndRow();
            }
            short contentStartCol = 1;
            short contentEndCol = this.parser.getColCount();
            if (leftHeader != null) {
                contentStartCol = (short)(leftHeader.getEndCol() + 1);
            }
            this.append(sb, "<table  cellSpacing=0 cellPadding=0>\n");
            if (title != null || topHeader != null) {
                this.append(sb, "<tr>\n");
                if (title != null && topHeader != null) {
                    topStartRow = title.getBeginRow();
                    topEndRow = topHeader.getEndRow();
                } else if (title != null) {
                    topStartRow = title.getBeginRow();
                    topEndRow = title.getEndRow();
                } else {
                    topStartRow = topHeader.getBeginRow();
                    topEndRow = topHeader.getEndRow();
                }
                if (leftHeader != null) {
                    this.append(sb, "<td>\n");
                    this.generateHtml("_$_corner", topStartRow, topEndRow, leftHeader.getBeginCol(), leftHeader.getEndCol(), sb);
                    this.append(sb, "</td>\n");
                }
                this.append(sb, "<td>\n");
                this.append(sb, "<div id=\"" + this.name + "_topdiv\" style=\"overflow:hidden\">\n");
                this.generateHtml("_$_top", topStartRow, topEndRow, contentStartCol, contentEndCol, sb);
                this.append(sb, "</div>\n");
                this.append(sb, "</td>\n");
                this.append(sb, "</tr>\n");
            }
            this.append(sb, "<tr>\n");
            if (leftHeader != null) {
                this.append(sb, "<td valign=top>\n");
                this.append(sb, "<div id=\"" + this.name + "_leftdiv\" style=\"overflow:hidden\">\n");
                this.generateHtml("_$_left", contentStartRow, contentEndRow, leftHeader.getBeginCol(), leftHeader.getEndCol(), sb);
                this.append(sb, "</div>\n");
                this.append(sb, "</td>\n");
            }
            this.append(sb, "<td>\n");
            this.append(sb, "<div id=\"" + this.name + "_contentdiv\" style=\"overflow:auto\" onscroll=\"_reportScroll( '" + this.name + "' )\">\n");
            this.generateHtml("", contentStartRow, contentEndRow, contentStartCol, contentEndCol, sb);
            this.append(sb, "</div>\n");
            this.append(sb, "</td>\n");
            this.append(sb, "</tr>\n");
            this.append(sb, "</table>\n");
            this.append(sb, "</div>\n");
            this.append(sb, "<script language=javascript>\n");
            if (this.inNS) {
                this.append(sb, "\t_resizeScroll();\n");
                this.append(sb, "\twindow.onresize=_resizeScroll;\n");
            } else {
                this.append(sb, "\tif( document.body.oldOnload == null ) document.body.oldOnload = document.body.onload;\n");
                this.append(sb, "\tdocument.body.onload = _resizeScroll;\n");
            }
            this.append(sb, "</script>\n");
        }
        if (this.isInput && !this.isRowInput) {
            this.append(sb, "<script language=javascript>\n");
            this.append(sb, "\tfunction " + this.name + "_autoCalc( cellName ) {\n");
            this.append(sb, InputUtils.createAutoCalcScript(this.report, this.name, this.inNS, this.request));
            this.append(sb, "\t}\n\n");
            this.append(sb, "\t" + this.name + "_autoCalc( '' );\n");
            this.append(sb, "\tfunction " + this.name + "_checkValid() {\n");
            this.append(sb, InputUtils.createCheckValidScript(this.report, this.name, this.inNS));
            this.append(sb, "\t}\n\n");
            this.append(sb, "</script>\n");
        }
        if (this.isRowInput) {
            int count;
            this.append(sb, "<script language=javascript>\n");
            FlowVar var = this.report.getFlowVar();
            if (var != null && (count = var.getVarCount()) > 0) {
                int i = 0;
                while (i < count) {
                    String varName = var.getVarName(i);
                    String initValue = var.getVarInitValue(i);
                    byte type = var.getVarType(i);
                    if (type == 11) {
                        this.append(sb, "\tvar " + varName + " = \"" + initValue + "\";\n");
                    } else {
                        if (initValue.trim().length() == 0) {
                            initValue = "0";
                        }
                        this.append(sb, "\tvar " + varName + " = " + initValue + ";\n");
                    }
                    ++i;
                }
            }
            if (this.emptyFlows.size() > 0) {
                int i = 0;
                while (i < this.emptyFlows.size()) {
                    this.append(sb, "\t_calcCellFlow( " + this.name + ", " + this.name + "_" + (String)this.emptyFlows.get(i) + " );\n");
                    ++i;
                }
            }
            this.append(sb, "\ttry{\n");
            this.append(sb, "\t\tvar initLI = function(){ _initSelectACell( " + this.name + " );}\n");
            this.append(sb, "\t\tif( document.body.onload != null ) {\n");
            this.append(sb, "\t\t\tvar _onload = document.body.onload;\n");
            this.append(sb, "\t\t\tinitLI = function(){ _onload.call();_initSelectACell( " + this.name + " );}\n");
            this.append(sb, "\t\t}\n");
            this.append(sb, "\t\tdocument.body.onload = initLI;\n");
            this.append(sb, "\t}catch(e){}\n");
            this.append(sb, "</script>\n");
        }
        if (!this.isSub) {
            ++longtime;
        }
        if (this.pw != null) {
            this.pw.write(versionInfo);
            this.pw.flush();
            return "";
        }
        return sb.toString() + versionInfo;
    }

    public static MailDropDownDW getDataWinEditConfig(Context ctx, DDViewDataWindow ddview, int row, short col, String name, HttpServletRequest request) throws Exception {
        View view;
        String viewName = ddview.getViewName();
        if (viewName == null || viewName.trim().length() == 0) {
            throw new Exception(ServerMsg.getMessage(request, "dddw.noView", (Object)ExcelNotation.toExcelNotation(row, col)));
        }
        String code = ddview.getCodeColName();
        if (code == null || code.trim().length() == 0) {
            throw new Exception(ServerMsg.getMessage(request, "dddw.nocode", (Object)ExcelNotation.toExcelNotation(row, col)));
        }
        String disp = ddview.getDispColName();
        if (disp == null || disp.trim().length() == 0) {
            disp = code;
        }
        if ((view = ctx.getSemanticsManager().getView(viewName)) == null) {
            throw new Exception(ServerMsg.getMessage(request, "dddw.viewNotExist", (Object)viewName));
        }
        int calcCols = view.getComputedColCount();
        String calcExp = null;
        int i = 0;
        while (i < calcCols) {
            ComputedColInfo cci = view.getComputedColInfo(i);
            String title = cci.getColTitle().toUpperCase();
            if (disp.equalsIgnoreCase(title)) {
                calcExp = cci.getColExp();
                if (calcExp == null || calcExp.trim().length() >= 1) break;
                calcExp = null;
                break;
            }
            ++i;
        }
        MailDropDownDW dddw = new MailDropDownDW();
        StringBuffer configSb = new StringBuffer();
        String filter_cells = ddview.getFilterCellName();
        boolean isFilter = filter_cells != null && filter_cells.trim().length() > 0;
        Group group = MailHtmlReport.view2Group(ctx, view, code, disp, calcExp, ddview.getDsFilter(), ddview.getFilterExp(), ddview.getSortExpList(), ddview.getSortDescList(), isFilter);
        DataSet ds = group.getDataSet();
        int codeC = ds.getColNo(code);
        int dispC = ds.getColNo(disp);
        Expression dispExp = null;
        if (dispC < 0 && calcExp != null) {
            dispExp = new Expression(ds, ctx, calcExp);
        }
        if (!isFilter) {
            int rows = group.getRowCount();
            int i2 = 0;
            while (i2 < rows) {
                String scode;
                Row r = group.getRow(i2);
                Object oCode = r.getData(codeC);
                if (oCode != null && (scode = oCode.toString().trim()).length() != 0) {
                    Object oDisp = null;
                    if (dispC < 0) {
                        if (dispExp != null) {
                            oDisp = r.evaluate(dispExp, ctx);
                        }
                    } else {
                        oDisp = r.getData(dispC);
                    }
                    String sdisp = "";
                    if (oDisp == null) {
                        sdisp = scode;
                    } else {
                        sdisp = oDisp.toString().trim();
                        if (sdisp.length() == 0) {
                            sdisp = scode;
                        }
                    }
                    if (configSb.length() > 0) {
                        configSb.append(";");
                    }
                    configSb.append(scode).append(",").append(sdisp);
                }
                ++i2;
            }
        } else {
            String[] dsColNames = ds.getColNames();
            String colNames = "";
            String colTypes = "";
            int i3 = 1;
            while (i3 < dsColNames.length) {
                if (colNames.length() > 0) {
                    colNames = colNames + ",";
                }
                colNames = colNames + ds.getColName(i3).toLowerCase();
                Object value = ds.getData(1, i3);
                if (colTypes.length() > 0) {
                    colTypes = colTypes + ",";
                }
                colTypes = colTypes + MailHtmlReport.toFilterColType(value);
                ++i3;
            }
            dddw.dsName = name + "_ds" + row + col;
            StringBuffer sb = new StringBuffer();
            sb.append("var ").append(dddw.dsName).append(" = new _rqDataSet( '").append(code.toLowerCase()).append("', '").append(disp.toLowerCase()).append("' );\n");
            sb.append(dddw.dsName).append(".setColNames( '").append(colNames).append("' );\n");
            sb.append(dddw.dsName).append(".setColTypes( '").append(colTypes).append("' );\n");
            dddw.colNames = colNames;
            int rows = group.getRowCount();
            int i4 = 0;
            while (i4 < rows) {
                String scode;
                Row r = group.getRow(i4);
                Object oCode = r.getData(codeC);
                if (oCode != null && (scode = oCode.toString().trim()).length() != 0) {
                    Object oDisp = null;
                    if (dispC < 0) {
                        if (dispExp != null) {
                            oDisp = r.evaluate(dispExp, ctx);
                        }
                    } else {
                        oDisp = r.getData(dispC);
                    }
                    String sdisp = "";
                    if (oDisp == null) {
                        sdisp = scode;
                    } else {
                        sdisp = oDisp.toString().trim();
                        if (sdisp.length() == 0) {
                            sdisp = scode;
                        }
                    }
                    if (configSb.length() > 0) {
                        configSb.append(";");
                    }
                    configSb.append(scode).append(",").append(sdisp);
                    StringBuffer datas = new StringBuffer();
                    int j = 1;
                    while (j < dsColNames.length) {
                        String soo = "";
                        Object valueObj = r.getData(dsColNames[j]);
                        if (valueObj != null) {
                            soo = valueObj.toString();
                        }
                        if (datas.length() > 0) {
                            datas.append("\t");
                        }
                        datas.append(soo);
                        ++j;
                    }
                    sb.append(dddw.dsName).append(".appendData( '").append(datas.toString()).append("' );\n");
                }
                ++i4;
            }
            dddw.dsScript = sb.toString();
        }
        dddw.editConfig = configSb.toString();
        return dddw;
    }

    public static MailDropDownDW getDataWinEditConfig(Context ctx, DDDataWindow ddwin, int row, short col, String name, HttpServletRequest request) throws Exception {
        int i;
        String filter_cells;
        String dsName = ddwin.getDsName();
        if (dsName == null || dsName.trim().length() == 0) {
            throw new Exception(ServerMsg.getMessage(request, "dddw.noDs", (Object)ExcelNotation.toExcelNotation(row, col)));
        }
        DataSet ds = ctx.getDataSet(dsName);
        if (ds == null) {
            throw new Exception(ServerMsg.getMessage(request, "dddw.dsNotExist", (Object)ExcelNotation.toExcelNotation(row, col), (Object)dsName));
        }
        MailDropDownDW dddw = new MailDropDownDW();
        StringBuffer configSb = new StringBuffer();
        String code = ddwin.getCodeColName();
        if (code == null || code.trim().length() == 0) {
            throw new Exception(ServerMsg.getMessage(request, "dddw.nocode", (Object)ExcelNotation.toExcelNotation(row, col)));
        }
        String disp = ddwin.getDispColName();
        if (disp == null || disp.trim().length() == 0) {
            disp = code;
        }
        boolean isFilter = (filter_cells = ddwin.getFilterCellName()) != null && filter_cells.trim().length() > 0;
        Group group = ds.getRootGroup();
        String dsFilter = ddwin.getDsFilter();
        Expression filterExpression = null;
        if (dsFilter != null && dsFilter.trim().length() > 0) {
            filterExpression = new Expression(ds, ctx, dsFilter);
        }
        Expression selectExp = null;
        if (isFilter) {
            HashSet<String> set = new HashSet<String>();
            set.add(code.toUpperCase());
            set.add(disp.toUpperCase());
            String filterExp = ddwin.getFilterExp();
            if (filterExp != null && filterExp.trim().length() > 0) {
                ExpTransform et = new ExpTransform(filterExp, null);
                ArrayList al = et.getParts();
                i = 0;
                while (i < al.size()) {
                    set.add(((String)al.get(i)).toUpperCase());
                    ++i;
                }
            }
            String[] colNames = ds.getColNames();
            StringBuffer distinctCols = new StringBuffer();
            i = 0;
            while (i < colNames.length) {
                String colName = colNames[i].toUpperCase();
                if (set.contains(colName)) {
                    if (distinctCols.length() > 0) {
                        distinctCols.append(",");
                    }
                    distinctCols.append(colName);
                }
                ++i;
            }
            selectExp = new Expression(ds, ctx, "list(" + distinctCols.toString() + ")");
        } else {
            selectExp = new Expression(ds, ctx, code);
        }
        group = group.distinct(selectExp, null, null, filterExpression, null, ctx);
        if (ddwin.getSortExpList().size() > 0) {
            ArrayList<Expression> sortExp = new ArrayList<Expression>();
            ArrayList<Expression> sortDesc = new ArrayList<Expression>();
            ArrayList al = ddwin.getSortExpList();
            ArrayList al1 = ddwin.getSortDescList();
            i = 0;
            while (i < al.size()) {
                Expression exp1 = new Expression(ds, ctx, (String)al.get(i));
                sortExp.add(exp1);
                Expression exp2 = new Expression(ctx, String.valueOf((Boolean)al1.get(i)));
                sortDesc.add(exp2);
                ++i;
            }
            group = group.sort(sortExp, sortDesc, ctx);
        }
        if (!isFilter) {
            int rows = group.getRowCount();
            int i2 = 0;
            while (i2 < rows) {
                String scode;
                Row r = group.getRow(i2);
                Object oCode = r.getData(code);
                if (oCode != null && (scode = oCode.toString().trim()).length() != 0) {
                    Object oDisp = r.getData(disp);
                    String sdisp = "";
                    if (oDisp == null) {
                        sdisp = scode;
                    } else {
                        sdisp = oDisp.toString().trim();
                        if (sdisp.length() == 0) {
                            sdisp = scode;
                        }
                    }
                    if (configSb.length() > 0) {
                        configSb.append(";");
                    }
                    configSb.append(scode).append(",").append(sdisp);
                }
                ++i2;
            }
        } else {
            String[] dsColNames = ds.getColNames();
            String colNames = "";
            String colTypes = "";
            int i3 = 1;
            while (i3 < dsColNames.length) {
                if (colNames.length() > 0) {
                    colNames = colNames + ",";
                }
                colNames = colNames + ds.getColName(i3).toLowerCase();
                Object value = null;
                try {
                    value = ds.getData(1, i3);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (colTypes.length() > 0) {
                    colTypes = colTypes + ",";
                }
                colTypes = colTypes + MailHtmlReport.toFilterColType(value);
                ++i3;
            }
            dddw.dsName = name + "_ds" + row + col;
            StringBuffer sb = new StringBuffer();
            sb.append("var ").append(dddw.dsName).append(" = new _rqDataSet( '").append(code.toLowerCase()).append("', '").append(disp.toLowerCase()).append("' );\n");
            sb.append(dddw.dsName).append(".setColNames( '").append(colNames).append("' );\n");
            sb.append(dddw.dsName).append(".setColTypes( '").append(colTypes).append("' );\n");
            dddw.colNames = colNames;
            int rows = group.getRowCount();
            int i4 = 0;
            while (i4 < rows) {
                String scode;
                Row r = group.getRow(i4);
                Object oCode = r.getData(code);
                if (oCode != null && (scode = oCode.toString().trim()).length() != 0) {
                    Object oDisp = r.getData(disp);
                    String sdisp = "";
                    if (oDisp == null) {
                        sdisp = scode;
                    } else {
                        sdisp = oDisp.toString().trim();
                        if (sdisp.length() == 0) {
                            sdisp = scode;
                        }
                    }
                    if (configSb.length() > 0) {
                        configSb.append(";");
                    }
                    configSb.append(scode).append(",").append(sdisp);
                    StringBuffer datas = new StringBuffer();
                    int j = 1;
                    while (j < dsColNames.length) {
                        String soo = "";
                        Object valueObj = r.getData(dsColNames[j]);
                        if (valueObj != null) {
                            soo = valueObj.toString();
                        }
                        if (datas.length() > 0) {
                            datas.append("\t");
                        }
                        datas.append(soo);
                        ++j;
                    }
                    sb.append(dddw.dsName).append(".appendData( '").append(datas.toString()).append("' );\n");
                }
                ++i4;
            }
            dddw.dsScript = sb.toString();
        }
        dddw.editConfig = configSb.toString();
        return dddw;
    }

    static String getDateFormt(String type, Locale locale) {
        String format = FormatUtils.getTimeFormat(locale);
        if ("year".equals(type)) {
            return "yyyy";
        }
        if ("day".equals(type)) {
            return FormatUtils.getDateFormat(locale);
        }
        if ("time".equals(type)) {
            return format;
        }
        if ("date".equals(type)) {
            return FormatUtils.getDatetimeFormat(locale);
        }
        if ("month".equals(type)) {
            format = FormatUtils.getDateFormat(locale);
            if (format.indexOf("dd") > 0) {
                String tmp = format.substring(format.indexOf("d") - 1, format.lastIndexOf("d") + 1);
                format = Sentence.replace(format, tmp, "", 1);
            }
            if (format.indexOf("dd") == 0) {
                format = format.substring(3);
            }
        }
        return format;
    }

    private String getNotDetailRows(ExtPRow prow) throws Exception {
        int size = prow.getSubSize();
        StringBuffer ndr = new StringBuffer();
        int i = 0;
        while (i < size) {
            int rowno;
            byte rowtype;
            ExtRow row = prow.getSubRow(i);
            if (!this.isDetail(row) && (rowtype = this.report.getRowCell(rowno = row.getRow()).getRowType()) != -93 && rowtype != -92) {
                int extSize = row.getExtSize();
                int k = 0;
                while (k < extSize) {
                    if (ndr.length() > 0) {
                        ndr.append(",");
                    }
                    ndr.append(row.getExtRow(k).getRow());
                    ++k;
                }
            }
            ++i;
        }
        return ndr.toString();
    }

    private String getPRowId(ExtRow row) {
        if (row.getRow() < 1) {
            return this.name;
        }
        int no = row.getParent().getRow();
        if (no < 1) {
            return this.name;
        }
        return this.name + "_row" + no;
    }

    private boolean isDetail(ExtRow extrow) {
        if (extrow instanceof ExtPRow) {
            ExtPRow prow = (ExtPRow)extrow;
            if (prow.getRow() < 1) {
                return false;
            }
            int size = prow.getSubSize();
            if (size == 0) {
                return true;
            }
            int i = 0;
            while (i < size) {
                if (prow.getSubRow(i) instanceof ExtPRow) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return this.isDetail(extrow.getParent());
    }

    private boolean isDetailFirst(ExtRow extrow) {
        if (extrow instanceof ExtPRow) {
            ExtPRow prow = (ExtPRow)extrow;
            int size = prow.getSubSize();
            if (size == 0) {
                return true;
            }
            return prow.getRow() < prow.getSubRow(0).getRow();
        }
        if (extrow.getRow() > extrow.getParent().getRow()) {
            return false;
        }
        return extrow.getParent().getSubRow(0).getRow() == extrow.getRow();
    }

    private boolean isSingleRowDetail(ExtNCell cell) {
        int rows;
        ExtRow row = cell.getRow();
        if (!this.isDetail(row)) {
            return false;
        }
        if (!(row instanceof ExtPRow)) {
            row = row.getParent();
        }
        return (rows = row.getExtSize()) == 1;
    }

    private boolean isUpdatableCell(INormalCell cell) {
        String cellId = "";
        try {
            cellId = ((ExtNormalCell)cell).getSourceId();
        }
        catch (Exception e) {
            return false;
        }
        return this.updatableCells.contains(cellId);
    }

    private String lookupDisplay(String editConfig, String value, String disp) {
        if (editConfig == null) {
            return value;
        }
        if (value.indexOf(",") < 0) {
            ArgumentTokenizer at = new ArgumentTokenizer(editConfig, ';');
            while (at.hasMoreTokens()) {
                ArgumentTokenizer at1 = new ArgumentTokenizer(at.nextToken(), ',');
                String tmp = at1.nextToken();
                if (tmp == null || tmp.trim().length() == 0 || !(tmp = tmp.trim()).equals(value)) continue;
                return at1.nextToken();
            }
            return disp;
        }
        String sdisp = "";
        ArgumentTokenizer atValue = new ArgumentTokenizer(value, ',');
        while (atValue.hasMoreTokens()) {
            if (sdisp.length() > 0) {
                sdisp = sdisp + ",";
            }
            String svalue = atValue.nextToken().trim();
            boolean found = false;
            ArgumentTokenizer at = new ArgumentTokenizer(editConfig, ';');
            while (at.hasMoreTokens()) {
                ArgumentTokenizer at1 = new ArgumentTokenizer(at.nextToken(), ',');
                String tmp = at1.nextToken();
                if (tmp == null || tmp.trim().length() == 0 || !(tmp = tmp.trim()).equals(svalue)) continue;
                sdisp = sdisp + at1.nextToken().trim();
                found = true;
                break;
            }
            if (found) continue;
            sdisp = sdisp + svalue;
        }
        return sdisp;
    }

    private boolean process1(int startRow, int endRow, short startCol, short endCol, boolean cloned) {
        int i = startRow;
        while (i <= endRow) {
            short j = startCol;
            while (j <= endCol) {
                if (this.parser.isMergedFirstCell(i, j, true)) {
                    Area area = this.parser.getMergedArea(i, j);
                    int row1 = area.getBeginRow();
                    int row2 = area.getEndRow();
                    short col1 = area.getBeginCol();
                    short col2 = area.getEndCol();
                    if (col1 <= endCol && col2 > endCol) {
                        if (!cloned) {
                            IReport ir;
                            this.report = ir = (IReport)this.report.deepClone();
                            this.parser = new ReportParser(ir);
                            cloned = true;
                        }
                        Area merge1 = new Area(row1, col1, row2, endCol);
                        Area merge2 = new Area(row1, (short)(endCol + 1), row2, col2);
                        INormalCell cell1 = this.report.getCell(row1, col1);
                        INormalCell cell2 = (INormalCell)cell1.deepClone();
                        cell1.setMergedArea(merge1);
                        cell1.setValue(null);
                        cell1.setDispValue(null);
                        cell2.setMergedArea(merge2);
                        int row = row1;
                        while (row <= row2) {
                            short col = col1;
                            while (col <= endCol) {
                                this.report.setCell(row, col, cell1);
                                col = (short)(col + 1);
                            }
                            short col3 = (short)(endCol + 1);
                            while (col3 <= col2) {
                                this.report.setCell(row, col3, cell2);
                                col3 = (short)(col3 + 1);
                            }
                            ++row;
                        }
                    }
                }
                j = (short)(j + 1);
            }
            ++i;
        }
        return cloned;
    }

    private void processLeftHeaderCut(Area title, Area topHeader, Area leftHeader, Area footer) {
        boolean cloned = false;
        if (leftHeader == null) {
            return;
        }
        short startCol = leftHeader.getBeginCol();
        short endCol = leftHeader.getEndCol();
        if (title != null || topHeader != null) {
            int topStartRow = 0;
            int topEndRow = -1;
            if (title != null && topHeader != null) {
                topStartRow = title.getBeginRow();
                topEndRow = topHeader.getEndRow();
            } else if (title != null) {
                topStartRow = title.getBeginRow();
                topEndRow = title.getEndRow();
            } else {
                topStartRow = topHeader.getBeginRow();
                topEndRow = topHeader.getEndRow();
            }
            cloned = this.process1(topStartRow, topEndRow, startCol, endCol, cloned);
        }
        if (footer != null) {
            this.process1(footer.getBeginRow(), footer.getEndRow(), startCol, endCol, cloned);
        }
    }

    static String processLicenseInfo(String info) {
        String s = "<span style=\"display:none\">" + longtime + "</span>";
        StringBuffer newInfo = new StringBuffer(50);
        int i = 0;
        while (i < info.length()) {
            newInfo.append(info.substring(i, i + 1));
            if (i < info.length() - 1) {
                newInfo.append(s);
            }
            ++i;
        }
        return newInfo.toString();
    }

    public void setAppRoot(String approot) {
        this.appRoot = approot;
    }

    public void setBorder(String border) {
        this.border = border;
    }

    public void setContext(Context ctx) {
        this.context = ctx;
    }

    public void setInNS(boolean b) {
        this.inNS = b;
    }

    public void setIsNP(boolean b) {
        this.isNP = b;
    }

    void setIsSub(boolean b) {
        this.isSub = b;
    }

    public void setNeedLinkStyle(boolean b) {
        this.needLinkStyle = b;
    }

    public void setNeedScroll() {
        this.isScroll = true;
    }

    public void setParamsId(String paramsId) {
        this.paramsId = paramsId;
    }

    public void setPrintWriter(Writer pw) {
        this.pw = pw;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setSelectText(boolean b) {
        this.selectText = b;
    }

    public void setSize(String width, String height) {
        this.W = width;
        this.H = height;
    }

    private String toDddwKey(DDDataWindow ddwin) {
        String key = ddwin.getDsName() + ddwin.getCodeColName() + ddwin.getDispColName() + ddwin.getDsFilter();
        int count = ddwin.getSortExpList().size();
        if (count > 0) {
            int i = 0;
            while (i < count) {
                key = key + ddwin.getSortExpList().get(i) + String.valueOf((Boolean)ddwin.getSortDescList().get(i));
                ++i;
            }
        }
        return key;
    }

    private String toDdviewKey(DDViewDataWindow ddview) {
        String key = ddview.getViewName() + ddview.getCodeColName() + ddview.getDispColName() + ddview.getDsFilter();
        int count = ddview.getSortExpList().size();
        if (count > 0) {
            int i = 0;
            while (i < count) {
                key = key + ddview.getSortExpList().get(i) + String.valueOf((Boolean)ddview.getSortDescList().get(i));
                ++i;
            }
        }
        return key;
    }

    private static String toFilterColType(Object value) {
        if (value instanceof Number) {
            return "2";
        }
        return "1";
    }

    private String toTreeKey(DDTree ddtree) {
        StringBuffer sb = new StringBuffer(50);
        sb.append(ddtree.getRootTitle());
        sb.append(ddtree.getWidth());
        sb.append(ddtree.getHeight());
        sb.append(ddtree.isLoopLastNode());
        sb.append(ddtree.isOnlySelectLeaf());
        sb.append(ddtree.isMultiSelect());
        ArrayList nodes = ddtree.getNodes();
        int count = nodes.size();
        int i = 0;
        while (i < count) {
            DDTreeNode node = (DDTreeNode)nodes.get(i);
            sb.append(node.getDsName());
            sb.append(node.getCodeColName());
            sb.append(node.getDispColName());
            sb.append(node.getWhere());
            ++i;
        }
        return sb.toString();
    }

    private String toViewTreeKey(DDViewTree ddtree) {
        StringBuffer sb = new StringBuffer(50);
        sb.append(ddtree.getRootTitle());
        sb.append(ddtree.getWidth());
        sb.append(ddtree.getHeight());
        sb.append(ddtree.isLoopLastNode());
        sb.append(ddtree.isOnlySelectLeaf());
        sb.append(ddtree.isMultiSelect());
        ArrayList nodes = ddtree.getNodes();
        int count = nodes.size();
        int i = 0;
        while (i < count) {
            DDViewTreeNode node = (DDViewTreeNode)nodes.get(i);
            sb.append(node.getViewName());
            sb.append(node.getCodeColName());
            sb.append(node.getDispColName());
            sb.append(node.getWhere());
            ++i;
        }
        return sb.toString();
    }

    public static Group view2Group(Context ctx, View view, String code, String disp, String calcExp, String dsFilter, String filterExp, ArrayList sortExpList, ArrayList sortDescList, boolean isFilter) throws Exception {
        int i;
        int i2;
        ArrayList al;
        ExpTransform et;
        ViewDataSetFactory vdsf = new ViewDataSetFactory();
        ViewDataSetConfig vdsc = new ViewDataSetConfig();
        vdsc.setViewName(view.getViewName());
        HashSet<String> set = new HashSet<String>();
        set.add(code.toUpperCase());
        set.add(disp.toUpperCase());
        HashSet<String> distinctSet = new HashSet<String>();
        distinctSet.add(code.toUpperCase());
        distinctSet.add(disp.toUpperCase());
        if (calcExp != null) {
            et = new ExpTransform(calcExp, null);
            al = et.getParts();
            i2 = 0;
            while (i2 < al.size()) {
                set.add(((String)al.get(i2)).toUpperCase());
                ++i2;
            }
        }
        if (dsFilter != null) {
            et = new ExpTransform(dsFilter, null);
            al = et.getParts();
            i2 = 0;
            while (i2 < al.size()) {
                set.add(((String)al.get(i2)).toUpperCase());
                ++i2;
            }
        }
        if (filterExp != null && filterExp.trim().length() > 0) {
            et = new ExpTransform(filterExp, null);
            al = et.getParts();
            i2 = 0;
            while (i2 < al.size()) {
                set.add(((String)al.get(i2)).toUpperCase());
                distinctSet.add(((String)al.get(i2)).toUpperCase());
                ++i2;
            }
        }
        int cols = view.getColCount();
        String[] viewCols = new String[cols];
        i2 = 0;
        while (i2 < cols) {
            viewCols[i2] = view.getColInfo(i2).getColName();
            String title = view.getColInfo(i2).getColTitle();
            if (set.contains(viewCols[i2].toUpperCase()) || set.contains(title.toUpperCase())) {
                vdsc.addSelectedCol(title);
            }
            ++i2;
        }
        DataSet ds = vdsf.createDataSet(ctx, vdsc, true);
        Group group = ds.getRootGroup();
        Expression filter = null;
        if (dsFilter != null && dsFilter.trim().length() > 0) {
            filter = new Expression(ds, ctx, dsFilter);
        }
        Expression selectExp = null;
        if (isFilter) {
            String[] colNames = ds.getColNames();
            StringBuffer distinctCols = new StringBuffer();
            i = 0;
            while (i < colNames.length) {
                String colName = colNames[i].toUpperCase();
                if (distinctSet.contains(colName)) {
                    if (distinctCols.length() > 0) {
                        distinctCols.append(",");
                    }
                    distinctCols.append(colName);
                }
                ++i;
            }
            selectExp = new Expression(ds, ctx, "list(" + distinctCols.toString() + ")");
        } else {
            selectExp = new Expression(ds, ctx, code);
        }
        group = group.distinct(selectExp, null, null, filter, null, ctx);
        if (sortExpList != null && sortExpList.size() > 0) {
            ArrayList<Expression> sortExp = new ArrayList<Expression>();
            ArrayList<Expression> sortDesc = new ArrayList<Expression>();
            i = 0;
            while (i < sortExpList.size()) {
                Expression exp1 = new Expression(ds, ctx, (String)sortExpList.get(i));
                sortExp.add(exp1);
                Expression exp2 = new Expression(ctx, String.valueOf((Boolean)sortDescList.get(i)));
                sortDesc.add(exp2);
                ++i;
            }
            group = group.sort(sortExp, sortDesc, ctx);
        }
        return group;
    }
}

