/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.view.mailhtml;

import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.PrintSetup;
import com.runqian.report4.util.ReportParser;
import com.runqian.report4.view.ServerMsg;
import com.runqian.report4.view.mailhtml.MailHtmlReport;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;

public class MailHtmlReportPage {
    private String H = "400";
    private String W = "600";
    private String appmap;
    private String border = "";
    private boolean isScroll = false;
    private String name;
    private boolean needLinkStyle = true;
    private int pageNo;
    private Writer pw;
    private Object[] reports;
    private HttpServletRequest request;
    private float scale = 1.0f;

    public MailHtmlReportPage(String name, Object[] css, int pageNo, String appmap, HttpServletRequest request) {
        this.pageNo = pageNo;
        this.name = name;
        this.appmap = appmap;
        this.request = request;
        this.reports = css;
    }

    public String generateHtml() throws Exception {
        ReportParser parser = new ReportParser(this.getAReport(0));
        PrintSetup ps = parser.getReport().getPrintSetup();
        byte pagerStyle = ps.getPagerStyle();
        if (pagerStyle == 2 || pagerStyle == 0) {
            IReport rpt = this.getAReport(this.pageNo - 1);
            MailHtmlReport report = new MailHtmlReport(rpt, this.name, this.appmap, this.request);
            report.setScale(this.scale);
            report.setPrintWriter(this.pw);
            report.setNeedLinkStyle(this.needLinkStyle);
            if (this.isScroll) {
                report.setNeedScroll();
                report.setSize(this.W, this.H);
                report.setBorder(this.border);
            }
            return report.generateHtml();
        }
        if (pagerStyle == 1) {
            int layoutRow = ps.getLayoutRowNum();
            int layoutCol = ps.getLayoutColNum();
            int startPage = (this.pageNo - 1) * layoutRow * layoutCol;
            String[] pages = new String[layoutRow * layoutCol];
            int i = 0;
            while (i < pages.length) {
                IReport cs = null;
                try {
                    cs = this.getAReport(startPage + i);
                }
                catch (Exception e) {
                    break;
                }
                if (cs != null) {
                    MailHtmlReport report = new MailHtmlReport(cs, this.name + "_" + (i + 1), this.appmap, this.request);
                    report.setScale(this.scale);
                    report.setNeedLinkStyle(this.needLinkStyle);
                    if (layoutRow > 1 || layoutCol > 1) {
                        report.setIsSub(true);
                        report.setIsNP(true);
                    }
                    pages[i] = report.generateHtml();
                }
                ++i;
            }
            byte layoutIndex = ps.getLayout();
            StringBuffer html = new StringBuffer(1000);
            html.append("<table id=\"" + this.name + "\">\n");
            int i2 = 1;
            while (i2 <= layoutRow) {
                if (i2 > 1) {
                    html.append("<tr height=10><td colspan=" + (layoutCol * 2 - 1) + "></td></tr>\n");
                }
                html.append("<tr>\n");
                int j = 1;
                while (j <= layoutCol) {
                    if (j > 1) {
                        html.append("<td width=10></td>\n");
                    }
                    int index = 0;
                    if (layoutIndex == 0) {
                        index = (i2 - 1) * layoutCol + (j - 1);
                    } else if (layoutIndex == 1) {
                        index = (j - 1) * layoutRow + (i2 - 1);
                    }
                    html.append("<td>");
                    if (pages[index] != null) {
                        html.append(pages[index]);
                    }
                    html.append("</td>");
                    ++j;
                }
                html.append("</tr>\n");
                ++i2;
            }
            html.append("</table>");
            return html.toString();
        }
        return "";
    }

    private IReport getAReport(int index) throws Exception {
        IReport pageReport = null;
        if (this.reports instanceof String[]) {
            if (pageReport == null) {
                throw new Exception(ServerMsg.getMessage(this.request, "cache.nopage"));
            }
        } else {
            pageReport = (IReport)this.reports[index];
        }
        return pageReport;
    }

    public void setBorder(String border) {
        this.border = border;
    }

    public void setNeedLinkStyle(boolean b) {
        this.needLinkStyle = b;
    }

    public void setNeedScroll() {
        this.isScroll = true;
    }

    public void setPrintWriter(Writer pw) {
        this.pw = pw;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setSize(String width, String height) {
        this.W = width;
        this.H = height;
    }
}

