/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.view.paj;

import com.raq.dm.Record;
import com.raq.dm.Sequence;
import com.raq.dm.Table;
import com.raq.olap.model.GroupModelConfig;
import com.runqian.base4.util.Logger;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.usermodel.Area;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.Engine;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.util.ReportParser;
import com.runqian.report4.util.ReportUtils;
import com.runqian.report4.view.ServerMsg;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PajReport {
    private boolean exportEmptyLine = true;
    private ReportParser parser;

    public PajReport(IReport r) throws Exception {
        ExtCellSet lc = ExtCellSet.get();
        if (lc.getType() == 0) {
            if (lc.getExportEnabled()) {
                if (!lc.checkDog()) {
                    throw new Exception(ServerMsg.getMessage("license.nodog"));
                }
            } else {
                throw new Exception(ServerMsg.getMessage("license.noTextRight"));
            }
        }
        this.parser = new ReportParser(r);
    }

    public static void main(String[] a) {
        try {
            IReport report = ReportUtils.read("d:/1.raq");
            Engine engine = new Engine(report, new Context());
            report = engine.calc();
            PajReport r = new PajReport(report);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Table out() {
        return this.out(null);
    }

    public Table out(OutputStream out) {
        ObjectOutputStream oos = null;
        try {
            Area data;
            short cols = this.parser.getColCount();
            ArrayList<Object> titles = null;
            ArrayList records = new ArrayList();
            Area top = this.parser.getTopHeader();
            if (top != null) {
                int row = top.getBeginRow();
                while (row <= top.getEndRow()) {
                    if (this.parser.isRowVisible(row)) {
                        ArrayList<Object> curr = new ArrayList<Object>();
                        boolean allNull = true;
                        short col = 1;
                        while (col <= cols) {
                            if (col > cols || this.parser.isColVisible(col)) {
                                Object value = this.parser.getCell(row, col).getValue();
                                if (value != null) {
                                    allNull = false;
                                }
                                curr.add(value);
                            }
                            col = (short)(col + 1);
                        }
                        if (!allNull && titles == null) {
                            titles = curr;
                            break;
                        }
                    }
                    ++row;
                }
            }
            if ((data = this.parser.getDataField()) != null) {
                int row = data.getBeginRow();
                while (row <= data.getEndRow()) {
                    if (this.parser.isRowVisible(row)) {
                        ArrayList<Object> curr = new ArrayList<Object>();
                        boolean allNull = true;
                        short col = 1;
                        while (col <= cols) {
                            if (col > cols || this.parser.isColVisible(col)) {
                                Object value = this.parser.getCell(row, col).getValue();
                                if (value != null) {
                                    allNull = false;
                                }
                                curr.add(value);
                            }
                            col = (short)(col + 1);
                        }
                        if (!allNull) {
                            if (titles == null) {
                                titles = curr;
                            } else {
                                records.add(curr);
                            }
                        }
                    }
                    ++row;
                }
            }
            int size = titles.size();
            int i = size - 1;
            while (i >= 0) {
                if (titles.get(i) == null) {
                    titles.remove(i);
                    int j = 0;
                    while (j < records.size()) {
                        ((List)records.get(j)).remove(i);
                        ++j;
                    }
                }
                --i;
            }
            String[] fields = new String[titles.size()];
            int i2 = 0;
            while (i2 < titles.size()) {
                fields[i2] = titles.get(i2).toString();
                ++i2;
            }
            Table t = new Table(fields);
            int i3 = 0;
            while (i3 < records.size()) {
                t.insert(i3 + 1);
                Record r = t.getRecord(i3 + 1);
                List record = (List)records.get(i3);
                int j = 0;
                while (j < fields.length) {
                    r.set(j, record.get(j));
                    ++j;
                }
                ++i3;
            }
            GroupModelConfig config = new GroupModelConfig((Sequence)t, false);
            if (out != null) {
                oos = out instanceof ObjectOutputStream ? (ObjectOutputStream)out : new ObjectOutputStream(out);
                config.write(oos);
            }
            Table table = t;
            return table;
        }
        catch (Exception e) {
            Logger.debug(e);
            throw new RuntimeException(e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ex3) {
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex3) {
                }
            }
        }
    }

    public void setExportEmptyLine(boolean b) {
        this.exportEmptyLine = b;
    }

    public String toString() {
        return null;
    }
}

