/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.config;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class MetricRegistryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    MetricRegistryBeanDefinitionParser() {
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        String name = element.getAttribute("name");
        if (StringUtils.hasText((String)name)) {
            BeanDefinitionBuilder beanDefBuilder = this.build(SharedMetricRegistries.class, source);
            beanDefBuilder.setFactoryMethod("getOrCreate");
            beanDefBuilder.addConstructorArgValue((Object)name);
            return beanDefBuilder.getBeanDefinition();
        }
        return this.build(MetricRegistry.class, source).getBeanDefinition();
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    private BeanDefinitionBuilder build(Class<?> klazz, Object source) {
        BeanDefinitionBuilder beanDefBuilder = BeanDefinitionBuilder.rootBeanDefinition(klazz);
        beanDefBuilder.setRole(0);
        beanDefBuilder.getRawBeanDefinition().setSource(source);
        return beanDefBuilder;
    }
}

