/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.reporter;

import com.codahale.metrics.Clock;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteRabbitMQ;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import com.codahale.metrics.graphite.GraphiteUDP;
import com.codahale.metrics.graphite.PickledGraphite;
import com.rabbitmq.client.ConnectionFactory;
import com.ryantenney.metrics.spring.reporter.AbstractScheduledReporterFactoryBean;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;

public class GraphiteReporterFactoryBean
extends AbstractScheduledReporterFactoryBean<GraphiteReporter> {
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String PERIOD = "period";
    public static final String TRANSPORT = "transport";
    public static final String CHARSET = "charset";
    public static final String CLOCK_REF = "clock-ref";
    public static final String DURATION_UNIT = "duration-unit";
    public static final String RATE_UNIT = "rate-unit";
    public static final String BATCH_SIZE = "batch-size";
    public static final String CONNECTION_FACTORY_REF = "connection-factory-ref";
    public static final String EXCHANGE = "exchange";

    @Override
    public Class<GraphiteReporter> getObjectType() {
        return GraphiteReporter.class;
    }

    @Override
    protected GraphiteReporter createInstance() {
        GraphiteRabbitMQ graphite;
        GraphiteReporter.Builder reporter = GraphiteReporter.forRegistry((MetricRegistry)this.getMetricRegistry());
        if (this.hasProperty(CLOCK_REF)) {
            reporter.withClock(this.getPropertyRef(CLOCK_REF, Clock.class));
        }
        if (this.hasProperty(DURATION_UNIT)) {
            reporter.convertDurationsTo(this.getProperty(DURATION_UNIT, TimeUnit.class));
        }
        if (this.hasProperty(RATE_UNIT)) {
            reporter.convertRatesTo(this.getProperty(RATE_UNIT, TimeUnit.class));
        }
        reporter.filter(this.getMetricFilter());
        reporter.prefixedWith(this.getPrefix());
        String transport = this.getProperty(TRANSPORT, "tcp");
        Charset charset = Charset.forName(this.getProperty(CHARSET, "UTF-8"));
        if ("rabbitmq".equals(transport)) {
            ConnectionFactory connectionFactory = this.getPropertyRef(CONNECTION_FACTORY_REF, ConnectionFactory.class);
            String exchange = this.getProperty(EXCHANGE);
            graphite = new GraphiteRabbitMQ(connectionFactory, exchange);
        } else {
            String hostname = this.getProperty(HOST);
            int port = this.getProperty(PORT, Integer.TYPE);
            if ("tcp".equals(transport)) {
                graphite = new Graphite(hostname, port, SocketFactory.getDefault(), charset);
            } else if ("udp".equals(transport)) {
                graphite = new GraphiteUDP(hostname, port);
            } else if ("pickle".equals(transport)) {
                graphite = new PickledGraphite(hostname, port, SocketFactory.getDefault(), charset, this.getProperty(BATCH_SIZE, Integer.TYPE, 100).intValue());
            } else {
                throw new IllegalArgumentException("Invalid graphite transport: " + transport);
            }
        }
        return reporter.build((GraphiteSender)graphite);
    }

    @Override
    protected long getPeriod() {
        return this.convertDurationString(this.getProperty(PERIOD));
    }
}

