/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.reporter;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.palominolabs.metrics.newrelic.AllEnabledMetricAttributeFilter;
import com.palominolabs.metrics.newrelic.MetricAttributeFilter;
import com.palominolabs.metrics.newrelic.NewRelicReporter;
import com.ryantenney.metrics.spring.reporter.AbstractScheduledReporterFactoryBean;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRelicReporterFactoryBean
extends AbstractScheduledReporterFactoryBean<NewRelicReporter> {
    private static final Logger LOG = LoggerFactory.getLogger(NewRelicReporterFactoryBean.class);
    private static final String EMPTY_STRING = "";
    protected static final String PREFIX = "prefix";
    protected static final String PERIOD = "period";
    protected static final String DURATION_UNIT = "duration-unit";
    protected static final String RATE_UNIT = "rate-unit";
    protected static final String NAME = "name";
    protected static final String ATTRIBUTE_FILTER = "attribute-filter-ref";

    @Override
    protected long getPeriod() {
        return this.convertDurationString(this.getProperty(PERIOD));
    }

    @Override
    public Class<NewRelicReporter> getObjectType() {
        return NewRelicReporter.class;
    }

    @Override
    protected NewRelicReporter createInstance() throws Exception {
        String prefix = this.getProperty(PREFIX, String.class, EMPTY_STRING);
        MetricFilter metricFilter = this.getMetricFilter();
        TimeUnit duration = this.getProperty(DURATION_UNIT, TimeUnit.class, TimeUnit.MILLISECONDS);
        TimeUnit rateUnit = this.getProperty(RATE_UNIT, TimeUnit.class, TimeUnit.SECONDS);
        String name = this.getProperty(NAME, String.class, "NewRelic reporter");
        AllEnabledMetricAttributeFilter attributeFilter = this.hasProperty(ATTRIBUTE_FILTER) ? this.getPropertyRef(ATTRIBUTE_FILTER, MetricAttributeFilter.class) : new AllEnabledMetricAttributeFilter();
        LOG.debug("Creating instance of NewRelicReporter with name '{}', prefix '{}', rate unit '{}', duration '{}', filter '{}' and attribute filter '{}'", new Object[]{name, prefix, rateUnit, duration, metricFilter, attributeFilter.getClass().getSimpleName()});
        return NewRelicReporter.forRegistry((MetricRegistry)this.getMetricRegistry()).name(name).filter(metricFilter).attributeFilter((MetricAttributeFilter)attributeFilter).rateUnit(rateUnit).durationUnit(duration).metricNamePrefix(prefix).build();
    }
}

