/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.ext;

import com.sap.conn.jco.ext.ClientPassportManager;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.ServerDataProvider;
import com.sap.conn.jco.ext.ServerPassportManager;
import com.sap.conn.jco.ext.SessionReferenceProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public abstract class Environment {
    private static boolean sapVMC = false;
    private static boolean sapVM_DW = false;
    private static boolean sapVM_DWJ = false;
    private static boolean jstartup = false;
    private static boolean eclipse = false;
    private static boolean standalone = false;
    private static Environment self = null;
    private static String IMPLEMENTATION = "com.sap.conn.jco.rt.RuntimeEnvironment";

    protected abstract void setDestinationDataProvider(DestinationDataProvider var1);

    protected abstract void removeDestinationDataProvider(DestinationDataProvider var1);

    protected abstract boolean hasDestinationDataProviderBeenRegistered();

    protected abstract void setServerDataProvider(ServerDataProvider var1);

    protected abstract void removeServerDataProvider(ServerDataProvider var1);

    protected abstract boolean hasServerDataProviderBeenRegistered();

    protected abstract void setSessionReferenceProvider(SessionReferenceProvider var1);

    protected abstract void removeSessionReferenceProvider(SessionReferenceProvider var1);

    protected abstract boolean hasSessionReferenceProviderBeenRegistered();

    protected abstract void setClientPassportManager(ClientPassportManager var1);

    protected abstract void setServerPassportManager(ServerPassportManager var1);

    protected abstract void removeClientPassportManager(ClientPassportManager var1);

    protected abstract void removeServerPassportManager(ServerPassportManager var1);

    protected abstract boolean hasClientPassportManagerBeenRegistered();

    protected abstract boolean hasServerPassportManagerBeenRegistered();

    private static Environment getInstance() {
        if (self == null) {
            if (Environment.inJTS()) {
                try {
                    Class<?> serviceManagerClass = Class.forName("com.sap.vmc.service.core.ServiceManager");
                    Method loadLibraryMethod = serviceManagerClass.getMethod("loadLibrary", String.class);
                    loadLibraryMethod.invoke(null, "JCo");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                self = (Environment)Class.forName(IMPLEMENTATION).newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return self;
    }

    protected static void setInstance(Environment env) {
        if (!Environment.inJTS() || self != null) {
            throw new IllegalStateException("Trying to set Environment instance a second time or outside of JTS");
        }
        self = env;
    }

    public static final boolean inSAPVM() {
        return sapVMC;
    }

    public static final boolean inJTS() {
        return sapVM_DW || sapVM_DWJ;
    }

    public static final boolean inDW() {
        return sapVM_DW;
    }

    public static final boolean inDWJ() {
        return sapVM_DWJ;
    }

    public static final boolean inJStartup() {
        return jstartup;
    }

    public static final boolean inStandalone() {
        return standalone;
    }

    public static final boolean inEclipsePlugin() {
        return eclipse;
    }

    public static void registerDestinationDataProvider(DestinationDataProvider provider) {
        Environment.getInstance().setDestinationDataProvider(provider);
    }

    public static void registerServerDataProvider(ServerDataProvider provider) {
        Environment.getInstance().setServerDataProvider(provider);
    }

    public static void registerSessionReferenceProvider(SessionReferenceProvider provider) {
        Environment.getInstance().setSessionReferenceProvider(provider);
    }

    public static void unregisterDestinationDataProvider(DestinationDataProvider provider) {
        Environment.getInstance().removeDestinationDataProvider(provider);
    }

    public static void unregisterServerDataProvider(ServerDataProvider provider) {
        Environment.getInstance().removeServerDataProvider(provider);
    }

    public static void unregisterSessionReferenceProvider(SessionReferenceProvider provider) {
        Environment.getInstance().removeSessionReferenceProvider(provider);
    }

    public static void registerClientPassportManager(ClientPassportManager passportManager) {
        Environment.getInstance().setClientPassportManager(passportManager);
    }

    public static void unregisterClientPassportManager(ClientPassportManager passportManager) {
        Environment.getInstance().removeClientPassportManager(passportManager);
    }

    public static void registerServerPassportManager(ServerPassportManager passportManager) {
        Environment.getInstance().setServerPassportManager(passportManager);
    }

    public static void unregisterServePassportManager(ServerPassportManager passportManager) {
        Environment.getInstance().removeServerPassportManager(passportManager);
    }

    public static boolean isDestinationDataProviderRegistered() {
        return Environment.getInstance().hasDestinationDataProviderBeenRegistered();
    }

    public static boolean isServerDataProviderRegistered() {
        return Environment.getInstance().hasServerDataProviderBeenRegistered();
    }

    public static boolean isSessionReferenceProviderRegistered() {
        return Environment.getInstance().hasSessionReferenceProviderBeenRegistered();
    }

    public static boolean isClientPassportManagerRegistered() {
        return Environment.getInstance().hasClientPassportManagerBeenRegistered();
    }

    public static boolean isServerPassportManagerRegistered() {
        return Environment.getInstance().hasServerPassportManagerBeenRegistered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            Class<?> systemInfoClass = Class.forName("com.sap.vmc.core.SystemInfo");
            Method getEngineTypeM = systemInfoClass.getMethod("getEngineType", null);
            Integer result = (Integer)getEngineTypeM.invoke(null, (Object[])null);
            Field typeDWfield = systemInfoClass.getDeclaredField("TYPE_DW");
            int typeDW = typeDWfield.getInt(null);
            sapVM_DW = typeDW == result;
            Field typeDWJfield = systemInfoClass.getDeclaredField("TYPE_DWJ");
            int typeDWJ = typeDWJfield.getInt(null);
            sapVM_DWJ = typeDWJ == result;
            Field typeLITEfield = systemInfoClass.getDeclaredField("TYPE_LITE");
            int typeLITE = typeLITEfield.getInt(null);
            sapVMC = sapVM_DW || sapVM_DWJ || typeLITE == result;
        }
        catch (Throwable t) {
            sapVM_DW = false;
            sapVM_DWJ = false;
            sapVMC = false;
        }
        jstartup = System.getProperty("jstartup.mode") != null;
        standalone = !sapVMC && !jstartup;
        eclipse = false;
        if (standalone) {
            ClassLoader cl = Environment.class.getClassLoader();
            while (cl != null && !eclipse) {
                try {
                    if (!cl.getClass().getName().startsWith("org.eclipse.osgi")) continue;
                    eclipse = true;
                }
                catch (Throwable throwable) {}
                continue;
                finally {
                    cl = cl.getParent();
                }
            }
        }
    }
}

