/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoThroughput;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.monitor.JCoConnectionData;
import com.sap.conn.jco.monitor.JCoServerMonitor;
import com.sap.conn.jco.rt.DefaultServerManager;
import com.sap.conn.jco.rt.DefaultServerWorker;
import com.sap.conn.jco.rt.DefaultThroughput;
import com.sap.conn.jco.rt.JCoMiddleware;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.ServerConnection;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerCallHandlerFactory;
import com.sap.conn.jco.server.JCoServerContextInfo;
import com.sap.conn.jco.server.JCoServerErrorListener;
import com.sap.conn.jco.server.JCoServerExceptionListener;
import com.sap.conn.jco.server.JCoServerFunctionHandlerFactory;
import com.sap.conn.jco.server.JCoServerRequestHandlerFactory;
import com.sap.conn.jco.server.JCoServerSecurityHandler;
import com.sap.conn.jco.server.JCoServerState;
import com.sap.conn.jco.server.JCoServerStateChangedListener;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import com.sap.conn.jco.server.JCoServerThreadStarter;
import com.sap.conn.jco.server.JCoServerUnitIDHandler;
import com.sap.conn.jco.util.ObjectList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServer
implements JCoServer {
    static final JCoRuntime jcoRuntime = JCoRuntimeFactory.getRuntime();
    private ConfigurationState configurationState = ConfigurationState.VALID;
    private JCoMiddleware middleware = jcoRuntime.getMiddlewareInstance();
    private JCoMiddleware.ServerGroup mwServerGroup = this.middleware.getListenerGroupInterface();
    private DefaultServerManager serverManager;
    private RepositoryBox<JCoRepository> repositoryBox;
    private JCoServerThreadStarter runnableStarter;
    private JCoServerTIDHandler tidHandler;
    private JCoServerUnitIDHandler unitIDHandler;
    private JCoServerSecurityHandler securityHandler;
    private JCoServerCallHandlerFactory callHandlerFactory;
    private List<DefaultServerWorker> listeners = new ArrayList<DefaultServerWorker>();
    private int minWorkerCount = 0;
    private int maxWorkerCount = 0;
    private int currentWorkerCount = 0;
    private int currentRequestsInProcess = 0;
    private int connectionCount = 0;
    private List<ServerConnection> connections = new ArrayList<ServerConnection>();
    private String name;
    protected String connParams;
    private Properties properties;
    private int startupDelay;
    private int maxStartupDelay = -255;
    private long lastRegisterTime = 0L;
    private RequestQueue requestQueue = new RequestQueue();
    private DefaultServerWorker controller;
    private JCoServerState state = JCoServerState.STOPPED;
    private DefaultThroughput throughput = null;
    private ServerMonitor monitor = null;
    private ObjectList<JCoServerExceptionListener> serverExceptionListeners = new ObjectList();
    private ObjectList<JCoServerErrorListener> serverErrorListeners = new ObjectList();
    private ObjectList<JCoServerStateChangedListener> serverStateChangedListeners = new ObjectList();

    protected DefaultServer(Properties serverProperties) throws JCoException {
        this.update(serverProperties);
        if (!Environment.inJTS()) {
            this.serverManager = (DefaultServerManager)jcoRuntime.getJCoServerFactoryInstance();
        }
    }

    final void update(Properties serverProperties) throws JCoException {
        MappingRuleParser rulesParser;
        String repositoryDestination;
        DefaultServer.checkProperties(serverProperties);
        Properties outdated = this.properties;
        this.properties = (Properties)serverProperties.clone();
        String connCountValue = this.properties.getProperty("jco.server.connection_count");
        if (connCountValue != null) {
            int connCount = Integer.parseInt(connCountValue);
            this.setConnectionCount(connCount);
        }
        if ((repositoryDestination = this.properties.getProperty("jco.server.repository_destination")) != null) {
            JCoDestination rDest = JCoDestinationManager.getDestination(repositoryDestination);
            if (rDest == null) {
                throw new JCoException(101, "JCO_ERROR_CONFIGURATION", "Unable to find repository destination " + repositoryDestination);
            }
            try {
                this.setRepository(rDest.getRepository());
            }
            catch (JCoException e) {
                throw new JCoException(e.getGroup(), e.getKey(), "Unable to get repository", e);
            }
        }
        if ((rulesParser = MappingRuleParser.parse(this.properties)) != null) {
            while (rulesParser.hasNextRule()) {
                rulesParser.nextRule();
                String destination = rulesParser.getCurrentDestination();
                JCoDestination rDest = JCoDestinationManager.getDestination(destination);
                if (rDest == null) {
                    throw new JCoException(101, "JCO_ERROR_CONFIGURATION", "Unable to find repository destination " + destination + " specified by the repository mapping " + rulesParser.getCurrentRule());
                }
                JCoRepository repository = rDest.getRepository();
                while (rulesParser.hasNextSystem()) {
                    this.setRepositoryMappingRule(rulesParser.nextSystem(), repository);
                }
            }
        }
        if (outdated != null) {
            this.properties.setProperty("jco.server.group_key", outdated.getProperty("jco.server.group_key"));
        }
    }

    final void setServerKey(String key) {
        this.properties.put("jco.server.group_key", key);
        this.connParams = this.mwServerGroup.initialize(this.properties);
    }

    public final String getServerKey() {
        return this.properties.getProperty("jco.server.group_key");
    }

    final void setServerName(String serverName) {
        this.name = serverName;
    }

    public final String getServerName() {
        if (this.name == null) {
            this.name = this.properties.getProperty("jco.server.name");
        }
        return this.name;
    }

    @Override
    public String getGatewayHost() {
        return this.properties.getProperty("jco.server.gwhost");
    }

    @Override
    public String getGatewayService() {
        return this.properties.getProperty("jco.server.gwserv");
    }

    @Override
    public String getMySncName() {
        return this.properties.getProperty("jco.server.snc_myname");
    }

    @Override
    public String getProgramID() {
        return this.properties.getProperty("jco.server.progid");
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public String getSAPRouterString() {
        return this.properties.getProperty("jco.server.saprouter");
    }

    @Override
    public String getSncLibrary() {
        return this.properties.getProperty("jco.server.snc_lib");
    }

    @Override
    public boolean getSncMode() {
        return !this.properties.getProperty("jco.server.snc_mode", "0").equals("0");
    }

    @Override
    public int getSncQOP() {
        return Integer.parseInt(this.properties.getProperty("jco.server.snc_qop"));
    }

    @Override
    public String getRepositoryDestination() {
        return this.properties.getProperty("jco.server.repository_destination");
    }

    @Override
    public int getConnectionCount() {
        return this.connectionCount;
    }

    public int getCurrentConnectionCount() {
        return this.connections.size();
    }

    public int getCurrentServerRunnableCount() {
        return this.listeners.size();
    }

    public int getServeRunnableCount() {
        return this.getConnectionCount();
    }

    public int getMaxUsedServerRunnableCount() {
        return this.requestQueue.getMaxWorkingThreadsCount();
    }

    public int getMaxQueuedRequestsCount() {
        return this.requestQueue.getMaxQueuedRequestsCount();
    }

    final JCoMiddleware.ServerGroup getMiddlewareInterface() {
        return this.mwServerGroup;
    }

    RequestQueue getRequestQueue() {
        return this.requestQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(DefaultServerWorker listener) {
        List<DefaultServerWorker> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                DefaultServerManager srvManager = (DefaultServerManager)jcoRuntime.getJCoServerFactoryInstance();
                srvManager.addServer(this);
            }
            this.listeners.add(listener);
        }
    }

    void releaseListener(DefaultServerWorker worker) {
        worker.conn = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(DefaultServerWorker worker) {
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, "[JCoAPI] JCO.Server.removeListener in " + Thread.currentThread().getName());
        }
        List<DefaultServerWorker> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(worker);
        }
        worker.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(ServerConnection conn) {
        List<ServerConnection> list = this.connections;
        synchronized (list) {
            this.connections.remove(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        ServerConnection conn;
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, "[JCoAPI] JCO.Server.destroy group " + this.getServerKey());
        }
        List<DefaultServerWorker> list = this.listeners;
        synchronized (list) {
            if (this.listeners.size() > 0) {
                throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "jco server can only be released if all workers are stopped [" + this.listeners.size() + " are still running]");
            }
        }
        Object object = this.requestQueue;
        synchronized (object) {
            while (this.requestQueue.size() > 0) {
                conn = this.requestQueue.remove(0);
                if (!conn.isValid()) continue;
                this.controller.conn = conn;
                try {
                    this.controller.abort("Request cannot be dispatched. All listeners are stopped by the application.");
                }
                catch (Exception exception) {}
            }
            this.requestQueue.notifyAll();
        }
        object = this.connections;
        synchronized (object) {
            while (!this.connections.isEmpty()) {
                conn = this.connections.remove(this.connections.size() - 1);
                this.closeConnection(conn);
            }
        }
    }

    void markDeleted() {
        this.configurationState = ConfigurationState.DELETED;
    }

    void markChanged() {
        this.configurationState = ConfigurationState.CHANGED;
    }

    private void setState(JCoServerState newState) {
        if (this.state == newState) {
            return;
        }
        JCoServerState oldState = this.state;
        this.state = newState;
        this.fireServerStateChangeOccurred(oldState, newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increaseRequestsInProcess() {
        RequestQueue requestQueue = this.requestQueue;
        synchronized (requestQueue) {
            ++this.currentRequestsInProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decreaseRequestsInProcess() {
        RequestQueue requestQueue = this.requestQueue;
        synchronized (requestQueue) {
            --this.currentRequestsInProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerErrorListener(JCoServerErrorListener listener) {
        ObjectList<JCoServerErrorListener> objectList = this.serverErrorListeners;
        synchronized (objectList) {
            this.serverErrorListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerExceptionListener(JCoServerExceptionListener listener) {
        ObjectList<JCoServerExceptionListener> objectList = this.serverExceptionListeners;
        synchronized (objectList) {
            this.serverExceptionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerStateChangedListener(JCoServerStateChangedListener listener) {
        ObjectList<JCoServerStateChangedListener> objectList = this.serverStateChangedListeners;
        synchronized (objectList) {
            this.serverStateChangedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServerErrorListener(JCoServerErrorListener listener) {
        ObjectList<JCoServerErrorListener> objectList = this.serverErrorListeners;
        synchronized (objectList) {
            this.serverErrorListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServerExceptionListener(JCoServerExceptionListener listener) {
        ObjectList<JCoServerExceptionListener> objectList = this.serverExceptionListeners;
        synchronized (objectList) {
            this.serverExceptionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServerStateChangedListener(JCoServerStateChangedListener listener) {
        ObjectList<JCoServerStateChangedListener> objectList = this.serverStateChangedListeners;
        synchronized (objectList) {
            this.serverStateChangedListeners.remove(listener);
        }
    }

    public void check() throws JCoException {
        this.serverManager.getNumServerConnections(this.properties);
    }

    static void checkProperties(Properties serverProperties) {
        if (Environment.inJTS()) {
            serverProperties.setProperty("jco.server.connection_count", "1");
        } else {
            String value = serverProperties.getProperty("jco.server.gwhost");
            if (value == null || value.trim().length() == 0) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "gateway host (jco.server.gwhost) is " + (value == null ? "null" : "empty"));
            }
            value = serverProperties.getProperty("jco.server.gwserv");
            if (value == null || value.trim().length() == 0) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "gateway service (jco.server.gwserv) is " + (value == null ? "null" : "empty"));
            }
            value = serverProperties.getProperty("jco.server.progid");
            if (value == null || value.trim().length() == 0) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "program ID (jco.server.progid) is " + (value == null ? "null" : "empty"));
            }
            value = serverProperties.getProperty("jco.server.snc_mode");
            if ("1".equals(value) && (value = serverProperties.getProperty("jco.server.snc_qop")) != null) {
                int qop = 0;
                try {
                    qop = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "SNC QOP (jco.server.snc_qop) is not a number [" + value + "]");
                }
                if (qop < 0 || qop > 8) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "SNC QOP (jco.server.snc_qop) = " + value + " is not in the valid range [1..8]");
                }
            }
            value = serverProperties.getProperty("jco.server.connection_count");
            int count = -1;
            if (value != null) {
                try {
                    count = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    throw new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", "connection count (jco.server.connection_count) is not a number [" + value + "]");
                }
                if (count < 0 || count > 50) {
                    throw new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", "invalid connection count (jco.server.connection_count) " + value + ". Valid range is [1..50], recommended value is 2");
                }
            }
            if ((value = serverProperties.getProperty("jco.server.max_startup_delay")) != null) {
                try {
                    int maxDelay = Integer.parseInt(value);
                    if (maxDelay < 0) {
                        throw new NumberFormatException("negative max startup delay is not allowed");
                    }
                }
                catch (NumberFormatException ex) {
                    throw new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", "Invalid max startup delay [" + value + "]: " + ex.getMessage());
                }
            }
        }
    }

    protected void checkRuntimeConfiguration() throws JCoRuntimeException {
        StringBuilder error = new StringBuilder();
        if (this.callHandlerFactory == null) {
            error.append("call handler factory is null");
        } else if (!(this.callHandlerFactory instanceof JCoServerFunctionHandlerFactory) && !(this.callHandlerFactory instanceof JCoServerRequestHandlerFactory)) {
            error.append("not supported type of handler factory ").append(this.callHandlerFactory.getClass().getName()).append(" is neither JCoServerFunctionHandlerFactory nor JCoServerRequestHandlerFactory");
        } else if (this.callHandlerFactory instanceof JCoServerFunctionHandlerFactory && this.callHandlerFactory instanceof JCoServerRequestHandlerFactory) {
            error.append("not supported type of handler factory ").append(this.callHandlerFactory.getClass().getName()).append(" implements both JCoServerFunctionHandlerFactory and JCoServerRequestHandlerFactory");
        }
        if (this.repositoryBox == null) {
            if (error.length() > 0) {
                error.append(", ");
            }
            error.append("repository is not defined");
        }
        if (this.connectionCount <= 0 || this.connectionCount > 100) {
            if (error.length() > 0) {
                error.append(", ");
            }
            error.append("connection count [").append(this.connectionCount).append("] is invalid (allowed range is [1..100])");
        }
        if (Trace.isOn(8)) {
            StringBuilder trc = new StringBuilder();
            trc.append("[JCoAPI] JCoServer.start() on ").append(this.getServerKey()).append(", connection count ").append(this.connectionCount);
            if (error.length() > 0) {
                trc.append(". Unable to start the server due to wrong configuration:").append((CharSequence)error);
            }
            Trace.fireTrace(8, trc.toString());
        }
        if (error.length() > 0) {
            throw new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", error.insert(0, "Unable to start the server, because of ").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (Trace.isOn(8, true)) {
            Trace.fireTrace(8, "[JCoAPI] JCoServer.start() on server " + this.name + " with key [" + this.getServerKey() + "]");
        }
        if (this.configurationState != ConfigurationState.VALID) {
            StringBuilder buf = new StringBuilder("Server configuration ").append(this.name).append(" was ");
            if (this.configurationState == ConfigurationState.CHANGED) {
                buf.append("changed. Please get an updated instance of the server from the JCoServerFactory.");
            } else {
                buf.append("removed. Check your configuration");
            }
            if (Trace.isOn(8, true)) {
                Trace.fireTrace(8, "[JCoAPI] " + buf.toString());
            }
            throw new JCoRuntimeException(181, "JCO_ERROR_SERVER_DATA_INVALID", buf.toString());
        }
        RequestQueue requestQueue = this.getRequestQueue();
        synchronized (requestQueue) {
            if (this.state != JCoServerState.STOPPED) {
                throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "JCo server is currently running. Current server state is " + this.state.toString());
            }
            this.checkRuntimeConfiguration();
            if (!Environment.inJTS()) {
                String serverKey = DefaultServerManager.computeGroupKey(this.properties);
                if (this.serverManager.isAvailable(serverKey)) {
                    throw new JCoRuntimeException(106, "JCO_ERROR_RESOURCE", "a server with the same properties is running " + this.properties.toString());
                }
                if (this.controller == null) {
                    this.controller = new DefaultServerWorker(this);
                }
            }
            this.setState(JCoServerState.STARTED);
            this.start(this.minWorkerCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(int count) {
        RequestQueue requestQueue = this.getRequestQueue();
        synchronized (requestQueue) {
            for (int i = 0; i < count && this.state != JCoServerState.STOPPING && this.state != JCoServerState.STOPPED; ++i) {
                DefaultServerWorker worker = this.createServerWorkerInstance();
                worker.stopping = false;
                ++this.currentWorkerCount;
                this.addListener(worker);
                try {
                    this.runnableStarter.start(worker);
                    continue;
                }
                catch (Exception ex) {
                    this.fireServerExceptionOccurred(null, null, ex);
                    this.releaseListener(worker);
                    continue;
                }
                catch (Error e) {
                    this.fireServerErrorOccurred(null, null, e);
                    this.releaseListener(worker);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, "[JCoAPI] JCoServer.stop() on " + this.getServerKey());
        }
        RequestQueue requestQueue = this.getRequestQueue();
        synchronized (requestQueue) {
            if (this.state == JCoServerState.STOPPED || this.state == JCoServerState.STOPPING) {
                throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "JCo server is already stopped or wasn't started");
            }
            List<DefaultServerWorker> list = this.listeners;
            synchronized (list) {
                this.stop(this.currentWorkerCount);
            }
            this.setState(JCoServerState.STOPPING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(int count) {
        RequestQueue requestQueue = this.getRequestQueue();
        synchronized (requestQueue) {
            List<DefaultServerWorker> list = this.listeners;
            synchronized (list) {
                int idx = this.listeners.size();
                while (--idx >= 0 && count > 0) {
                    DefaultServerWorker worker = this.listeners.get(idx);
                    if (worker.stopping) continue;
                    worker.stopping = true;
                    --count;
                    --this.currentWorkerCount;
                }
            }
        }
        this.requestQueue.notifyAllListeners();
    }

    @Override
    public void setConnectionCount(int count) {
        if (count < 1 || count > 100) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "only values between 1 and 100 are allowed in JCoServer.setConnectionCount(), passed value " + count);
        }
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, "[JCoAPI] JCoServer.setConnectionCount(" + count + ")");
        }
        int workerCount = this.connectionCount = count;
        String workerCountValue = this.properties.getProperty("jco.server.worker_thread_count");
        if (workerCountValue != null) {
            workerCount = Integer.parseInt(workerCountValue);
            this.setWorkerCount(workerCount);
        } else if (workerCount > 0) {
            this.setWorkerCount(workerCount);
        }
        int workerCountMin = workerCount;
        String minWworkerCountValue = this.properties.getProperty("jco.server.worker_thread_min_count");
        if (minWworkerCountValue != null) {
            workerCountMin = Integer.parseInt(minWworkerCountValue);
            this.setMinWorkerCount(workerCountMin);
        } else {
            if (workerCountMin > workerCount) {
                workerCountMin = workerCount;
            }
            if (workerCountMin > 0) {
                this.setMinWorkerCount(workerCountMin);
            }
        }
    }

    public void setWorkerCount(int workerCount) {
        if (workerCount < 1 || workerCount > 100) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "only values between 1 and 100 are allowed for the count of worker threads in JCoServer, passed value " + workerCount);
        }
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, "[JCoAPI] JCoServer.setWorkerCount(" + workerCount + ")");
        }
        this.maxWorkerCount = workerCount;
        if (this.minWorkerCount > this.maxWorkerCount) {
            this.minWorkerCount = this.maxWorkerCount;
        }
    }

    public void setMinWorkerCount(int minWorkerCount) {
        if (minWorkerCount < 1 || minWorkerCount > this.maxWorkerCount) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "only values between 1 and max worker count [" + this.maxWorkerCount + "] are allowed for the min count of worker threads in JCoServer, passed value " + minWorkerCount);
        }
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, "[JCoAPI] JCoServer.setMinWorkerCount(" + minWorkerCount + ")");
        }
        this.minWorkerCount = minWorkerCount;
    }

    @Override
    public void release() {
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, "[JCoAPI] JCoServer.release on " + this.getServerKey());
        }
    }

    public int getActualConnectionCount() {
        return this.connectionCount;
    }

    Properties getProperties() {
        return this.properties;
    }

    public boolean getTrace() {
        String value = this.properties.getProperty("jco.server.trace");
        return value != null && value.equals("1");
    }

    public void setTrace(boolean trace) {
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, "[JCoAPI] DefaultServer.setTrace(" + trace + "), current state " + this.getTrace());
        }
        if (this.getTrace() == trace) {
            return;
        }
        this.properties.setProperty("jco.client.trace", trace ? "1" : "0");
        this.connParams = this.mwServerGroup.initialize(this.properties);
    }

    private int getMaxStartupDelay() {
        if (this.maxStartupDelay == -255) {
            return this.middleware.getMaxStartupDelay();
        }
        if (this.maxStartupDelay < 0) {
            String value = this.properties.getProperty("jco.server.max_startup_delay");
            if (value != null) {
                try {
                    this.maxStartupDelay = Integer.parseInt(value);
                }
                catch (Exception ex) {
                    if (Trace.isOn(4, true)) {
                        Trace.fireTrace(4, "[JCoAPI] JCoServer.getMaxStartupDelay: Value of property jco.server.max_startup_delay not an integer.");
                    }
                    this.maxStartupDelay = -1;
                }
            }
            if (this.maxStartupDelay < 0) {
                this.maxStartupDelay = -255;
                return this.middleware.getMaxStartupDelay();
            }
        }
        return this.maxStartupDelay;
    }

    void dispatch(ServerConnection conn) {
        this.requestQueue.addRequest(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int computeConnectionDelta() {
        int delta;
        List<ServerConnection> list = this.connections;
        synchronized (list) {
            int stateful = 0;
            Iterator<ServerConnection> it = this.connections.iterator();
            while (it.hasNext()) {
                if (it.next().getSessionId() == null) continue;
                ++stateful;
            }
            delta = this.connectionCount - (this.connections.size() - stateful);
        }
        return delta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjustConnectionCount() {
        block25: {
            if (this.state == JCoServerState.STOPPING) {
                RequestQueue requestQueue = this.requestQueue;
                synchronized (requestQueue) {
                    List<DefaultServerWorker> list = this.listeners;
                    synchronized (list) {
                        if (this.listeners.size() == 0) {
                            this.serverManager.releaseServer(this);
                            this.setState(JCoServerState.STOPPED);
                            return;
                        }
                    }
                }
                return;
            }
            long now = System.currentTimeMillis();
            if (now > this.lastRegisterTime + (long)(this.startupDelay * 1000)) {
                try {
                    int delta = this.computeConnectionDelta();
                    this.lastRegisterTime = now;
                    if (delta > 0) {
                        this.openConnections(delta);
                    } else if (delta < 0) {
                        this.closeConnections(-delta);
                    }
                }
                catch (Exception ex) {
                    if (!Trace.isOn(4)) break block25;
                    Trace.fireTrace(4, "[JCoAPI] exception in adjustConnectionCount", ex);
                }
            }
        }
        RequestQueue requestQueue = this.requestQueue;
        synchronized (requestQueue) {
            int niceToHave = this.currentRequestsInProcess - this.currentWorkerCount + 1;
            if (niceToHave > 0) {
                int couldBeStarted = this.maxWorkerCount - this.currentWorkerCount;
                if (couldBeStarted > niceToHave) {
                    this.start(niceToHave);
                } else {
                    this.start(couldBeStarted);
                }
            } else if (niceToHave < 0) {
                if (this.currentWorkerCount + niceToHave < this.minWorkerCount) {
                    if (this.currentWorkerCount > this.minWorkerCount) {
                        this.stop(this.currentWorkerCount - this.minWorkerCount);
                    }
                } else {
                    this.stop(-niceToHave);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openConnections(int count) {
        ServerConnection conn = null;
        for (int i = 0; i < count; ++i) {
            conn = this.openConnection();
            if (conn.isValid()) {
                List<ServerConnection> list = this.connections;
                synchronized (list) {
                    this.connections.add(conn);
                }
                if (this.state != JCoServerState.STARTED && this.state != JCoServerState.DEAD) continue;
                this.setState(JCoServerState.ALIVE);
                continue;
            }
            if (this.startupDelay <= 0) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnections(int count) {
        ServerConnection conn = null;
        int i = 0;
        while (i < count) {
            List<ServerConnection> list = this.connections;
            synchronized (list) {
                conn = this.getFreeConnection(true);
            }
            if (conn != null) {
                list = this.connections;
                synchronized (list) {
                    this.closeConnection(conn);
                }
            } else {
                if (!Trace.isOn(4)) break;
                Trace.fireTrace(4, "[JCoAPI] Server group: cannot find free handle to disconnect");
                break;
            }
            ++count;
        }
    }

    private ServerConnection getFreeConnection(boolean remove) {
        ServerConnection conn = null;
        Iterator<ServerConnection> it = this.connections.iterator();
        while (it.hasNext()) {
            conn = it.next();
            if ((conn.state & 4) != 0 || conn.getSessionId() != null || this.requestQueue.indexOf(conn) != -1) continue;
            if (remove) {
                it.remove();
            }
            return conn;
        }
        return null;
    }

    private void closeConnection(ServerConnection conn) {
        try {
            conn.disconnect();
        }
        catch (Exception ex) {
            this.fireServerExceptionOccurred(null, conn, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ServerConnection openConnection() {
        String lastErrorMsg = null;
        ServerConnection conn = null;
        try {
            try {
                conn = new ServerConnection(this);
                conn.accept();
                this.startupDelay = 0;
            }
            catch (JCoException ex) {
                switch (ex.getGroup()) {
                    case 129: {
                        ex = new JCoException(ex.getGroup(), ex.getKey(), "Server startup failed at " + new Date() + "." + JCoRuntime.CRLF + "This is caused by either a) erroneous server settings, b) the backend system has been shutdown, " + "c) network problems." + (this.startupDelay == 0 ? "" : " Will try next startup in " + this.startupDelay + " seconds.") + JCoRuntime.CRLF + ex.getMessage(), ex);
                        this.fireServerExceptionOccurred(null, conn, ex);
                        List<ServerConnection> list = this.connections;
                        synchronized (list) {
                            this.startupDelay = this.startupDelay == 0 ? 1 : this.startupDelay * 2;
                            this.maxStartupDelay = this.getMaxStartupDelay();
                            if (this.startupDelay > this.maxStartupDelay) {
                                this.startupDelay = this.maxStartupDelay;
                            }
                            if (this.state != JCoServerState.STARTED && this.state != JCoServerState.ALIVE) break;
                        }
                        this.setState(JCoServerState.DEAD);
                        break;
                    }
                    case 101: {
                        String message = "Server startup failed at " + new Date() + "." + JCoRuntime.CRLF + "This is caused by erroneous server settings. Server will be stopped." + JCoRuntime.CRLF + ex.getMessage();
                        if (Trace.isOn(4)) {
                            Trace.fireTrace(1, "[JCoAPI] " + message);
                        }
                        this.stop(1);
                        ex = new JCoException(ex.getGroup(), ex.getKey(), message);
                        this.fireServerExceptionOccurred(null, conn, ex);
                        if (this.state == JCoServerState.STOPPED || this.state == JCoServerState.STOPPING) break;
                        this.setState(JCoServerState.STOPPING);
                        break;
                    }
                    default: {
                        this.startupDelay = 0;
                        this.fireServerExceptionOccurred(null, conn, ex);
                    }
                }
                lastErrorMsg = new StringBuffer(ex.getKey()).append(": ").append(ex.getMessage()).toString();
                Object var7_4 = null;
                if (lastErrorMsg == null) return conn;
                if (!Trace.isOn(4)) return conn;
                Trace.fireTrace(4, "[JCoApi] JCoServer open connection failed: " + lastErrorMsg);
                return conn;
            }
            catch (Exception ex) {
                this.startupDelay = 0;
                this.fireServerExceptionOccurred(null, conn, ex);
                lastErrorMsg = ex.toString();
                Object var7_5 = null;
                if (lastErrorMsg == null) return conn;
                if (!Trace.isOn(4)) return conn;
                Trace.fireTrace(4, "[JCoApi] JCoServer open connection failed: " + lastErrorMsg);
                return conn;
            }
            catch (Error err) {
                this.startupDelay = 0;
                this.fireServerErrorOccurred(null, conn, err);
                lastErrorMsg = err.toString();
                Object var7_6 = null;
                if (lastErrorMsg == null) return conn;
                if (!Trace.isOn(4)) return conn;
                Trace.fireTrace(4, "[JCoApi] JCoServer open connection failed: " + lastErrorMsg);
                return conn;
            }
            Object var7_3 = null;
            if (lastErrorMsg == null) return conn;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (lastErrorMsg == null) throw throwable;
            if (!Trace.isOn(4)) throw throwable;
            Trace.fireTrace(4, "[JCoApi] JCoServer open connection failed: " + lastErrorMsg);
            throw throwable;
        }
        if (!Trace.isOn(4)) return conn;
        Trace.fireTrace(4, "[JCoApi] JCoServer open connection failed: " + lastErrorMsg);
        return conn;
    }

    final void processQueuedRequests() {
        this.requestQueue.processQueuedRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAlive() {
        List<ServerConnection> list = this.connections;
        synchronized (list) {
            return this.connections.size() > 0;
        }
    }

    @Override
    public JCoServerState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getMonitoredData(List<MonitoredConnectionData> monitoredData) {
        ServerConnection[] conns;
        List<ServerConnection> list = this.connections;
        synchronized (list) {
            conns = new ServerConnection[this.connections.size()];
            conns = this.connections.toArray(conns);
        }
        for (int i = 0; i < conns.length; ++i) {
            ServerConnection conn = conns[i];
            MonitoredConnectionData md = conn.getMonitoredData();
            monitoredData.add(md);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCoServerMonitor getMonitor() {
        DefaultServer defaultServer = this;
        synchronized (defaultServer) {
            if (this.monitor == null) {
                this.monitor = new ServerMonitor();
            }
        }
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireServerExceptionOccurred(DefaultServerWorker worker, ServerConnection conn, Exception exception) {
        if (this.serverExceptionListeners.size() > 0) {
            ObjectList<JCoServerExceptionListener> objectList = this.serverExceptionListeners;
            synchronized (objectList) {
                String connID = conn != null ? conn.getConnectionId() : "[GENERAL]";
                for (int i = 0; i < this.serverExceptionListeners.size(); ++i) {
                    JCoServerExceptionListener listener = this.serverExceptionListeners.get(i);
                    try {
                        listener.serverExceptionOccurred(this, connID, worker != null ? worker.getContext() : null, exception);
                        continue;
                    }
                    catch (Throwable th) {
                        Trace.fireTraceCritical("Error in " + listener.getClass().getName() + ".serverExceptionOccurred", th);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireServerErrorOccurred(DefaultServerWorker worker, ServerConnection conn, Error error) {
        if (this.serverErrorListeners.size() > 0) {
            ObjectList<JCoServerErrorListener> objectList = this.serverErrorListeners;
            synchronized (objectList) {
                String connID = conn != null ? conn.getConnectionId() : "[GENERAL]";
                for (int i = 0; i < this.serverErrorListeners.size(); ++i) {
                    JCoServerErrorListener listener = this.serverErrorListeners.get(i);
                    try {
                        listener.serverErrorOccurred(this, connID, worker != null ? worker.getContext() : null, error);
                        continue;
                    }
                    catch (Throwable th) {
                        Trace.fireTraceCritical("Error in " + listener.getClass().getName() + ".serverErrorOccurred", th);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireServerStateChangeOccurred(JCoServerState oldState, JCoServerState newState) {
        block8: {
            try {
                if (this.serverStateChangedListeners.size() <= 0) break block8;
                ObjectList<JCoServerStateChangedListener> objectList = this.serverStateChangedListeners;
                synchronized (objectList) {
                    for (int i = 0; i < this.serverStateChangedListeners.size(); ++i) {
                        JCoServerStateChangedListener listener = this.serverStateChangedListeners.get(i);
                        try {
                            listener.serverStateChangeOccurred(this, oldState, newState);
                            continue;
                        }
                        catch (Throwable th) {
                            Trace.fireTraceCritical("Error in " + listener.getClass().getName() + ".serverStateChangeOccurred", th);
                        }
                    }
                }
            }
            catch (Throwable th) {
                Trace.fireTraceCritical("throwable in fireServerStateChangeOccurred", th);
            }
        }
    }

    protected DefaultServerWorker createServerWorkerInstance() {
        return new DefaultServerWorker(this);
    }

    @Override
    public JCoServerCallHandlerFactory getCallHandlerFactory() {
        return this.callHandlerFactory;
    }

    @Override
    public JCoServerThreadStarter getServerThreadStarter() {
        return this.runnableStarter;
    }

    @Override
    public JCoServerSecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    @Override
    public void setCallHandlerFactory(JCoServerCallHandlerFactory callHandlerFactory) {
        this.callHandlerFactory = callHandlerFactory;
    }

    @Override
    public void setRepository(JCoRepository repository) {
        if (this.repositoryBox == null) {
            this.repositoryBox = new RepositoryBox<JCoRepository>(new JCoRepositoryIdProvider());
        }
        this.repositoryBox.setRepository(repository);
    }

    @Override
    public void setRepository(String SID, String client, JCoRepository repository) throws JCoRuntimeException {
        if (SID == null) {
            throw new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", "SID equals null is not allowed in JCoServer.setRepository(SID, client, repository)");
        }
        if ((SID = SID.trim()).length() != 3) {
            throw new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", "Illegal SID  [" + SID + "] is encountered in JCoServer.setRepository(SID, client, repository). SID should contain exactly 3 letters");
        }
        if (!(client == null || (client = client.trim()).length() == 3 && Character.isDigit(client.charAt(0)) && Character.isDigit(client.charAt(1)) && Character.isDigit(client.charAt(2)))) {
            throw new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", "Illegal client  [" + client + "] is encountered in JCoServer.setRepository(SID, client, repository). client should contain exactly 3 numbers");
        }
        String key = SID;
        if (client != null) {
            key = key + "(" + client + ")";
        }
        this.setRepositoryMappingRule(key, repository);
    }

    private void setRepositoryMappingRule(String key, JCoRepository repository) {
        if (this.repositoryBox == null) {
            this.repositoryBox = new RepositoryMapBox<JCoRepository>(new JCoRepositoryIdProvider());
        }
        this.repositoryBox = this.repositoryBox.setRepository(key, repository);
    }

    @Override
    public JCoRepository getRepository() {
        return this.repositoryBox.getRepository();
    }

    @Override
    public JCoRepository getRepository(JCoServerContextInfo serverCtx) {
        return this.repositoryBox.getRepository(serverCtx);
    }

    @Override
    public void setServerThreadStarter(JCoServerThreadStarter starter) {
        this.runnableStarter = starter;
    }

    @Override
    public void setSecurityHandler(JCoServerSecurityHandler securityManager) {
        this.securityHandler = securityManager;
    }

    @Override
    public JCoServerTIDHandler getTIDHandler() {
        return this.tidHandler;
    }

    @Override
    public void setTIDHandler(JCoServerTIDHandler tidManager) {
        this.tidHandler = tidManager;
    }

    @Override
    public JCoServerUnitIDHandler getUnitIDHandler() {
        return this.unitIDHandler;
    }

    @Override
    public void setUnitIDHandler(JCoServerUnitIDHandler unitIDHandler) {
        this.unitIDHandler = unitIDHandler;
    }

    @Override
    public DefaultThroughput getThroughput() {
        return this.throughput;
    }

    @Override
    public void removeThroughput() {
        this.setThroughput(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThroughput(JCoThroughput throughput) {
        try {
            this.throughput = (DefaultThroughput)throughput;
        }
        catch (ClassCastException e) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Illegal instance passed to setThroughput - use JCo.createThroughput()");
        }
        List<ServerConnection> list = this.connections;
        synchronized (list) {
            Iterator<ServerConnection> it = this.connections.iterator();
            while (it.hasNext()) {
                it.next().setThroughput(this.throughput);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MappingRuleParser {
        private String currentDestination;
        private String systems;
        private SortedMap<Integer, String> rules = null;
        private Iterator<Integer> keyIterator;
        private Integer currentRuleNumber;
        private String currentRule;

        public static MappingRuleParser parse(Properties properties) throws JCoException {
            TreeMap<Integer, String> rules = null;
            boolean oneLineRule = false;
            boolean multiLineRule = false;
            for (String string : properties.keySet()) {
                if (!string.startsWith("jco.server.repository_map")) continue;
                if (rules == null) {
                    rules = new TreeMap<Integer, String>();
                }
                if ("jco.server.repository_map".length() < string.length()) {
                    if (oneLineRule) {
                        throw new JCoException(101, "JCO_ERROR_CONFIGURATION", "Combination of repository mapping rules [" + string + "] and [" + "jco.server.repository_map" + "] is not allowed");
                    }
                    multiLineRule = true;
                    if (string.charAt("jco.server.repository_map".length()) != '.') {
                        throw new JCoException(101, "JCO_ERROR_CONFIGURATION", "Illegal property key " + string + ". Expected jco.server.repository_map.<number>.");
                    }
                    String ruleNumber = string.substring("jco.server.repository_map".length() + 1).trim();
                    try {
                        rules.put(Integer.valueOf(ruleNumber), properties.getProperty(string));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new JCoException(101, "JCO_ERROR_CONFIGURATION", "Unable to parse the repository rule [" + string + "]", nfe);
                    }
                }
                if (multiLineRule) {
                    throw new JCoException(101, "JCO_ERROR_CONFIGURATION", "Combination of repository mapping rules [" + string + "] and [" + "jco.server.repository_map" + ".x] is not allowed");
                }
                oneLineRule = true;
                StringTokenizer stoken = new StringTokenizer(properties.getProperty(string), ";");
                int ruleIdx = 1;
                while (stoken.hasMoreTokens()) {
                    rules.put(new Integer(ruleIdx), stoken.nextToken());
                    ++ruleIdx;
                }
            }
            if (rules != null) {
                return new MappingRuleParser(rules);
            }
            return null;
        }

        private MappingRuleParser(SortedMap<Integer, String> rules) {
            this.rules = rules;
            this.keyIterator = rules.keySet().iterator();
        }

        public boolean hasNextRule() {
            return this.keyIterator.hasNext();
        }

        public void nextRule() throws JCoException {
            Integer ruleNumber = this.keyIterator.next();
            this.currentRule = ((String)this.rules.get(ruleNumber)).trim();
            if (this.currentRuleNumber != null && ruleNumber - this.currentRuleNumber > 1) {
                throw new JCoException(101, "JCO_ERROR_CONFIGURATION", "Missing repository rule with number " + (ruleNumber + 1) + ".");
            }
            this.currentRuleNumber = ruleNumber;
            try {
                int i = this.currentRule.indexOf(61);
                this.currentDestination = this.currentRule.substring(i + 1).trim();
                this.systems = this.currentRule.substring(0, i).trim();
            }
            catch (Exception exc) {
                throw new JCoException(101, "JCO_ERROR_CONFIGURATION", "Unable to parse the repository rule " + this.currentRule, exc);
            }
        }

        public boolean hasNextSystem() {
            return this.systems != null && this.systems.length() > 0;
        }

        public String nextSystem() {
            String system;
            int i = this.systems.indexOf(44);
            if (i < 0) {
                system = this.systems.trim();
                this.systems = "";
            } else {
                system = this.systems.substring(0, i);
                this.systems = this.systems.substring(i + 1);
            }
            return system;
        }

        public String getCurrentDestination() {
            return this.currentDestination;
        }

        public String getCurrentRule() {
            return this.currentRule;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RepositoryMapBox<RepositoryType>
    extends RepositoryBox<RepositoryType> {
        private static final String DEFAULT_REPOSITORY = "%%DEFAULT";
        private Map<String, RepositoryType> map = new Hashtable<String, RepositoryType>();

        public RepositoryMapBox(IdProvider<RepositoryType> idProvider) {
            super(idProvider);
        }

        @Override
        public void setRepository(RepositoryType repository) {
            this.setRepository(null, repository);
        }

        @Override
        public RepositoryBox<RepositoryType> setRepository(String key, RepositoryType repository) throws JCoRuntimeException {
            RepositoryType removed;
            if (key == null) {
                key = DEFAULT_REPOSITORY;
            }
            if (repository != null) {
                removed = this.map.put(key, repository);
                if (removed != null && Trace.isOn(8)) {
                    Trace.fireTrace(8, "[JCoAPI] Repository " + this.idProvider.getID(removed) + " was replaced by " + this.idProvider.getID(repository) + " for system " + key, true);
                }
            } else {
                removed = this.map.remove(key);
                if (removed == null) {
                    throw new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", "Unable to remove the repository for the key " + key + ". There is no repository was defined before. " + this.mapToString());
                }
            }
            if (this.map.size() < 2 && this.getRepository() != null) {
                RepositoryBox<RepositoryType> result = new RepositoryBox<RepositoryType>(this.idProvider);
                result.setRepository(this.getRepository());
                return result;
            }
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public RepositoryType getRepository() {
            RepositoryType result = this.map.get(DEFAULT_REPOSITORY);
            if (result != null) {
                return result;
            }
            if (Trace.isOn(4)) {
                Trace.fireTrace(4, "[JCoAPI] No default repository found. " + this.mapToString(), true);
            }
            return null;
        }

        @Override
        public RepositoryType getRepository(JCoServerContextInfo ctx) {
            String sid = ctx.getConnectionAttributes().getSystemID();
            String client = ctx.getConnectionAttributes().getClient();
            RepositoryType result = this.map.get(sid + "(" + client + ")");
            if (result != null) {
                if (Trace.isOn(64)) {
                    String callFrom = ctx.getConnectionAttributes().getPartnerHost() + "|" + sid + "|" + client;
                    Trace.fireTrace(64, "[JCoAPI] Use repository " + this.idProvider.getID(result) + " matching the SID " + sid + " and client " + client + " for the call from " + callFrom);
                }
                return result;
            }
            result = this.map.get(sid);
            if (result != null) {
                if (Trace.isOn(64)) {
                    String callFrom = ctx.getConnectionAttributes().getPartnerHost() + "|" + sid + "|" + client;
                    Trace.fireTrace(64, "[JCoAPI] Use repository " + this.idProvider.getID(result) + " matching the SID " + sid + " for the call from " + callFrom);
                }
                return result;
            }
            result = this.map.get(DEFAULT_REPOSITORY);
            if (result != null) {
                if (Trace.isOn(64)) {
                    String callFrom = ctx.getConnectionAttributes().getPartnerHost() + "|" + sid + "|" + client;
                    Trace.fireTrace(64, "[JCoAPI] Use the clobal repository repository " + this.idProvider.getID(result) + " for the call from " + callFrom);
                }
                return result;
            }
            String callFrom = ctx.getConnectionAttributes().getPartnerHost() + "|" + sid + "|" + client;
            String error = "No repository found for the call from " + callFrom + ". " + this.mapToString();
            if (Trace.isOn(4)) {
                Trace.fireTrace(4, "[JCoAPI] " + error);
            }
            throw new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", error);
        }

        private String mapToString() {
            String definedReps = "Defined repositories: ";
            boolean first = true;
            for (String key : this.map.keySet()) {
                if (first) {
                    first = false;
                } else {
                    definedReps = definedReps + ",";
                }
                definedReps = definedReps + "[" + key + "," + this.idProvider.getID(this.map.get(key)) + "]";
            }
            return definedReps;
        }

        public String toString() {
            return "Repository box for " + this.mapToString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RepositoryBox<RepositoryType> {
        private RepositoryType r;
        IdProvider<RepositoryType> idProvider;

        public RepositoryBox(IdProvider<RepositoryType> idProvider) {
            this.idProvider = idProvider;
        }

        public void setRepository(RepositoryType repository) {
            this.r = repository;
        }

        public RepositoryType getRepository(JCoServerContextInfo ctx) {
            return this.r;
        }

        public RepositoryType getRepository() {
            return this.r;
        }

        public boolean isEmpty() {
            return this.r == null;
        }

        public RepositoryBox<RepositoryType> setRepository(String key, RepositoryType repository) throws JCoRuntimeException {
            RepositoryMapBox<RepositoryType> result = new RepositoryMapBox<RepositoryType>(this.idProvider);
            ((RepositoryBox)result).setRepository(null, this.r);
            ((RepositoryBox)result).setRepository(key, repository);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JCoRepositoryIdProvider
    implements IdProvider<JCoRepository> {
        JCoRepositoryIdProvider() {
        }

        @Override
        public String getID(JCoRepository rep) {
            return rep.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IdProvider<RepositoryType> {
        public String getID(RepositoryType var1);
    }

    class RequestQueue {
        private List<ServerConnection> queue = new LinkedList<ServerConnection>();
        private int currentFreeThreadCount = 0;
        private int maxQueuedRequests = 0;
        private int maxUsedThreadCount = 0;
        private int usedThreadCount = 0;

        RequestQueue() {
        }

        int getMaxQueuedRequestsCount() {
            return this.maxQueuedRequests;
        }

        int getMaxWorkingThreadsCount() {
            return this.maxUsedThreadCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addRequest(ServerConnection connRequest) {
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                this.queue.add(connRequest);
                if (this.currentFreeThreadCount <= 0 && this.queue.size() > this.maxQueuedRequests) {
                    this.maxQueuedRequests = this.queue.size();
                }
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyAllListeners() {
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                this.currentFreeThreadCount = 0;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processQueuedRequest() {
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                for (int i = 0; i < this.currentFreeThreadCount && this.queue.size() > 0; ++i) {
                    --this.currentFreeThreadCount;
                    this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ServerConnection getRequest() {
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                ServerConnection connRequestHandle = null;
                if (this.queue.size() > 0) {
                    connRequestHandle = this.queue.remove(0);
                    ++this.usedThreadCount;
                    if (this.usedThreadCount > this.maxUsedThreadCount) {
                        this.maxUsedThreadCount = this.usedThreadCount;
                    }
                    return connRequestHandle;
                }
                try {
                    ++this.currentFreeThreadCount;
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ServerConnection remove(int i) {
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                ServerConnection connRequestHandle = this.queue.remove(i);
                return connRequestHandle;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int indexOf(ServerConnection conn) {
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                int idx = this.queue.indexOf(conn);
                return idx;
            }
        }

        int size() {
            return this.queue.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void requestFinished() {
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                --this.usedThreadCount;
            }
        }

        int getFreeThreadCount() {
            return this.currentFreeThreadCount;
        }

        int getUsedThreadCount() {
            return this.usedThreadCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ServerMonitor
    implements JCoServerMonitor {
        ServerMonitor() {
        }

        @Override
        public int getStatelessConnectionCount() {
            return DefaultServer.this.getConnectionCount();
        }

        @Override
        public int getCurrentConnectionCount() {
            return DefaultServer.this.getCurrentConnectionCount();
        }

        @Override
        public int getUsedServerThreadCount() {
            return DefaultServer.this.getRequestQueue().getUsedThreadCount();
        }

        @Override
        public int getServerThreadCount() {
            return DefaultServer.this.getServeRunnableCount();
        }

        @Override
        public int getCurrentServerThreadCount() {
            return DefaultServer.this.getCurrentServerRunnableCount();
        }

        @Override
        public int getMaximumUsedServerThreadCount() {
            return DefaultServer.this.getMaxUsedServerRunnableCount();
        }

        @Override
        public List<? extends JCoConnectionData> getConnectionsData() {
            ArrayList<MonitoredConnectionData> monitoredData = new ArrayList<MonitoredConnectionData>();
            DefaultServer.this.getMonitoredData(monitoredData);
            return monitoredData;
        }

        @Override
        public JCoServerState getState() {
            return DefaultServer.this.getState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ConfigurationState {
        VALID,
        CHANGED,
        DELETED;

    }
}

