/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationList<T> {
    private List<T> availableDestinations = new LinkedList<T>();
    private T currentDestination;

    public DestinationList(T currentDestination) {
        if (currentDestination != null) {
            this.availableDestinations.add(currentDestination);
        }
        this.currentDestination = currentDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceCurrentDestination(T oldCurrentDestination, T destination) {
        DestinationList destinationList = this;
        synchronized (destinationList) {
            if (this.currentDestination == oldCurrentDestination && this.availableDestinations.contains(destination)) {
                this.currentDestination = destination;
            }
        }
    }

    public final T getCurrentDestination() {
        return this.currentDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDestination(T destinationToAdd) {
        DestinationList destinationList = this;
        synchronized (destinationList) {
            if (!this.availableDestinations.contains(destinationToAdd)) {
                this.availableDestinations.add(destinationToAdd);
            }
            if (this.currentDestination == null) {
                this.currentDestination = destinationToAdd;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDestination(T destinationToRemove) {
        DestinationList destinationList = this;
        synchronized (destinationList) {
            int idx = this.availableDestinations.indexOf(destinationToRemove);
            if (idx != -1) {
                this.availableDestinations.remove(idx);
            }
            if (this.currentDestination == destinationToRemove) {
                this.currentDestination = null;
            }
            if (this.currentDestination == null && this.availableDestinations.size() > 0) {
                this.currentDestination = this.availableDestinations.get(0);
            }
        }
    }

    public Iterator<T> iterator() {
        ArrayList<T> clonedAvailableDestinations = new ArrayList<T>();
        clonedAvailableDestinations.addAll(this.availableDestinations);
        return clonedAvailableDestinations.iterator();
    }

    public int size() {
        return this.availableDestinations.size();
    }
}

