/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.driver;

import com.sap.conn.jco.util.IntHashTable;
import com.sap.conn.rfc.api.GatewayRegInfo;
import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.api.RfcOptions;
import com.sap.conn.rfc.api.RfcRegisterInfo;
import com.sap.conn.rfc.driver.CpicDriver;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;

public final class RfcTypeRegisterCpic
extends CpicDriver {
    protected static final IntHashTable<RfcIoOpenCntl> niHandles = new IntHashTable(89, 5);
    private boolean flushed = false;
    private boolean readConvid = false;
    protected boolean registered;
    protected int[] reg_handle = new int[1];
    protected boolean tp_accepted;
    private RfcRegisterInfo register_info;

    public synchronized int listen(byte[] buffer, int bufsize, int[] bytes_read, int timeout) {
        int d_rc;
        int rc = 0;
        if (this.act_cntl.close_pending) {
            String text = "listen(RfcTypeRegisterCpic) :: Error : (close_pending)";
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc(text);
            }
            Trc.criticalTrace(this.act_cntl, text);
            return 1;
        }
        int cm_org_data_received = 0;
        int input_size = 0;
        int input_ptr = 0;
        int received_leng = 0;
        if (this.broken) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("listen :: Error : " + Integer.toString(10) + '\n');
            }
            return 10;
        }
        if (!this.readConvid && (rc = this.receiveConversationID(timeout)) != 0) {
            return rc;
        }
        rc = this.cpic_coxread(0, buffer, this.cmData);
        switch (rc) {
            case -1: {
                return rc;
            }
            case 10003: {
                return 17;
            }
        }
        this.cm_data_received = this.cmData[0];
        this.cm_status_received = this.cmData[1];
        received_leng = this.cmData[2];
        cm_org_data_received = this.cm_data_received;
        this.all_received = this.cm_status_received == 1;
        this.cm_retcode = rc;
        ++this.cm_data_received;
        ++this.cm_status_received;
        if (rc != 0) {
            this.deallocated = true;
        }
        if (rc != 0 && rc != 18) {
            this.get_cpic_error("CMRCV");
            return 5;
        }
        if (rc == 18 && (d_rc = this.deallocated_normal_ext(cm_org_data_received, buffer, received_leng)) != 0) {
            int ret;
            int n = ret = d_rc == 2 ? 33 : 10;
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("listen :: Error : " + Integer.toString(ret) + '\n');
            }
            return ret;
        }
        input_size = Math.min(buffer.length, received_leng);
        input_ptr = 0;
        if (this.accepted) {
            this.accepted = false;
            if (RfcUtilities.memcmp(buffer, 0, ebcdic_conncpic, 0, Math.min(ebcdic_conncpic.length, input_size)) == 0) {
                if (input_size < 75) {
                    this.broken = true;
                    this.setMessageTRC("CPIC-CALL: 'CMRCV'\n no login data received\n");
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("listen :: Error : " + Integer.toString(8) + '\n');
                    }
                    return 8;
                }
                if (RfcUtilities.memcmp(buffer, 45, ebcdic_trace, 0, 5) == 0) {
                    this.act_cntl.trace = true;
                }
                input_size -= 75;
                input_ptr += 75;
            } else if (buffer[input_ptr] == 84 || buffer[input_ptr] == -29) {
                if (!this.act_cntl.trace) {
                    String text = "trace is turned on by the connection from " + this.act_cntl.destination;
                    Trc.generalInfo(this.act_cntl, text);
                    Trc.ab_rfctrc(text);
                }
                this.act_cntl.traceSetByPartner = true;
                this.act_cntl.trace = true;
                ++input_ptr;
            } else if (this.act_cntl.trace && this.act_cntl.traceSetByPartner) {
                Trc.generalInfo(this.act_cntl, "trace is turned off by the connection from " + this.act_cntl.destination);
                this.act_cntl.trace = false;
            }
        }
        bytes_read[0] = --input_size;
        if (input_size <= 0) {
            this.broken = true;
            this.setMessage("CPIC-CALL: 'CMRCV'\n" + this.getMessage() + '\n');
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("listen :: Error : " + Integer.toString(8) + '\n');
            }
            return 8;
        }
        if (input_ptr > 0) {
            System.arraycopy(buffer, input_ptr, buffer, 0, input_size);
        }
        this.tOfLastIO = System.currentTimeMillis();
        return 0;
    }

    public int open(RfcOptions options) {
        return 1;
    }

    public RfcTypeRegisterCpic(RfcIoOpenCntl iocntl) {
        super(iocntl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int accept(RfcAcceptInfo acceptInfo) {
        int rc = this.registerConnection(acceptInfo);
        if (rc != 0) {
            return rc;
        }
        this.accepted = false;
        this.tOfLastIO = System.currentTimeMillis();
        IntHashTable<RfcIoOpenCntl> intHashTable = niHandles;
        synchronized (intHashTable) {
            niHandles.put(this.reg_handle[0], this.act_cntl);
        }
        rc = this.cosaccepttp(-2);
        if (rc != 0) {
            this.close();
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("accept(RfcTypeRegisterCpic) :: Error : " + rc);
            }
            this.get_rg_info("Connect to SAP gateway failed", this.register_info);
            return 5;
        }
        return 0;
    }

    public int check(RfcAcceptInfo acceptInfo) {
        int rc = this.registerConnection(acceptInfo);
        if (rc == 0) {
            this.close();
        }
        return rc;
    }

    private int registerConnection(RfcAcceptInfo acceptInfo) {
        this.register_info = (RfcRegisterInfo)acceptInfo;
        int rc = 0;
        this.accepted = false;
        this.deallocated = true;
        this.registered = true;
        this.tp_accepted = false;
        this.act_cntl.snc = this.register_info.usesSNC();
        StringBuilder gwhost = new StringBuilder(256);
        String sapRouter = this.register_info.getSAPRouter();
        if (sapRouter != null && sapRouter.length() > 0) {
            gwhost.append(sapRouter);
            if (!sapRouter.endsWith("/H/")) {
                gwhost.append("/H/");
            }
        }
        gwhost.append(this.register_info.getGatewayHost());
        rc = this.SAP_CMREGTP3(this.register_info.getProgramID(), gwhost.toString(), this.register_info.getGatewayService(), this.reg_handle, this.register_info.getSNCMyName(), this.register_info.getSNCLibrary(), this.register_info.getSNCQuality(), this.register_info.usesSNC());
        if (rc != 0) {
            this.registered = false;
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("accept(RfcTypeRegisterCpic) :: Error : " + rc);
            }
            this.get_rg_info("Connect to SAP gateway failed", this.register_info);
            return 5;
        }
        return 0;
    }

    public synchronized int read(byte[] buffer, int bufsize, int[] bytes_read) {
        int rc = 0;
        if (this.act_cntl.close_pending) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("wflush(RFCTypeRegisterCpic) :: read : (close_pending)");
            }
            return 1;
        }
        if (rc != 0) {
            return rc;
        }
        return this.coxread(buffer, bufsize, bytes_read, 0);
    }

    public synchronized int write(byte[] buffer, int buffersize, boolean last) {
        this.flushed = false;
        return super.write(buffer, buffersize, last);
    }

    public synchronized int wflush() {
        int rc = 0;
        if (!this.deallocated && this.server_mode) {
            if (!this.act_cntl.isStateful() && !this.act_cntl.reg_exclusiv && this.act_cntl.unresp_call == 0 || this.act_cntl.close_pending) {
                rc = this.CMDEAL();
                if (rc != 0) {
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("wflush(RFCTypeRegisterCpic) in CMDEAL:: Error : " + rc);
                    }
                    return rc;
                }
                this.deallocated = true;
                this.tp_accepted = false;
                this.accepted = false;
                this.act_cntl.identified = false;
                rc = this.cosaccepttp(-2);
                if (rc != 0) {
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("wflush(RFCTypeRegisterCpic) in cosaccepttp:: Error : " + rc);
                    }
                    return rc;
                }
            } else if (!this.act_cntl.inCallback && !this.flushed) {
                rc = this.SAP_CMLISTEN3();
                if (rc != 0) {
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("wflush(RFCTypeRegisterCpic) in SAP_CMLISTEN3:: Error : " + Integer.toString(rc));
                    }
                    return rc;
                }
                this.flushed = true;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int receiveConversationID(int waitTime) {
        int rc = 0;
        int loops = 0;
        do {
            rc = this.SAP_CMACCPTP3(this.reg_handle[0], waitTime);
            if (!this.act_cntl.trace) continue;
            Trc.ab_rfctrc(new StringBuilder(200).append("receiveConversationID: SAP_CMACCPTP3(waitTime=").append(waitTime).append(", conv_id=").append(Trc.convIDToString(this.conv_id)).append(", reg_handle=").append(this.reg_handle[0]).append(") returns: ").append(String.valueOf(rc)).append("\n").toString());
        } while (rc == 10001 && loops++ < 100);
        if (rc != 0) {
            this.deallocated = true;
            switch (rc) {
                case 18: {
                    this.registered = false;
                    rc = 23;
                    break;
                }
                case 10003: {
                    this.registered = true;
                    rc = 17;
                    break;
                }
                case 20: {
                    this.registered = false;
                    this.get_cpic_error("SAP_CMACCPTP3");
                    rc = 5;
                    break;
                }
                default: {
                    this.registered = true;
                    this.get_cpic_error("SAP_CMACCPTP3");
                    RfcIoOpenCntl cntl = niHandles.get(this.reg_handle[0]);
                    Trc.criticalTrace(this.act_cntl.hrfc, "ERROR: receiveConversationID: SAP_CMACCPTP3(waitTime=" + waitTime + ", reg_handle=" + this.reg_handle[0] + ") returns: " + String.valueOf(rc) + " after " + loops + " attempts: rfc handle is [" + (cntl == null ? "null" : String.valueOf(cntl.hrfc)) + "]");
                    rc = 3;
                }
            }
            if (!this.registered) {
                IntHashTable<RfcIoOpenCntl> intHashTable = niHandles;
                synchronized (intHashTable) {
                    niHandles.remove(this.reg_handle[0]);
                }
            }
        } else {
            this.deallocated = false;
            this.readConvid = true;
            this.act_cntl.updateConvID();
        }
        return rc;
    }

    int cosaccepttp(int wtime) {
        int rc = 0;
        if (wtime == -2 || !this.tp_accepted) {
            this.act_cntl.systnr = null;
            this.act_cntl.sysid = null;
            this.act_cntl.target = null;
            this.act_cntl.kernel_rel = null;
            this.act_cntl.partner_rel = null;
            this.act_cntl.partner_type = '\u0000';
            this.act_cntl.userid = null;
            this.act_cntl.cuserid = null;
            this.act_cntl.lang = null;
            this.act_cntl.mandt = null;
            this.act_cntl.th_client_id = null;
            this.act_cntl.rfc_uuid_set = false;
            this.act_cntl.rfc_uuid = null;
            this.deallocated = true;
            this.readConvid = false;
            do {
                rc = this.SAP_CMACCPTP3(this.reg_handle[0], wtime);
                if (!this.act_cntl.trace) continue;
                Trc.ab_rfctrc("cosaccepttp: SAP_CMACCPTP3(waitTime=" + wtime + ", conv_id=" + Trc.convIDToString(this.conv_id) + ", reg_handle=" + this.reg_handle[0] + ") returns: " + String.valueOf(rc) + "\n");
            } while (rc == 10001);
            if (rc != 0) {
                this.registered = false;
                if (rc == 18) {
                    this.get_cpic_error("SAP_CMACCPTP3");
                    return 23;
                }
                this.get_cpic_error("SAP_CMACCPTP3");
                return 5;
            }
            this.tOfLastIO = System.currentTimeMillis();
            this.server_mode = true;
            this.accepted = true;
            this.tp_accepted = true;
        }
        return 0;
    }

    private String get_rg_info(String text, RfcRegisterInfo register_info) {
        StringBuilder errbuf = new StringBuilder(128);
        String ptr = RfcTypeRegisterCpic.SAP_CMPERR();
        String msg = null;
        this.clearMessage();
        errbuf.append(text).append("\nConnect parameters: ");
        errbuf.append(register_info.toParametersString()).append('\n');
        if (ptr != null) {
            errbuf.append(ptr);
        } else {
            errbuf.append("No specific info available");
        }
        msg = errbuf.toString();
        this.setMessage(msg);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RfcIoOpenCntl getNextListener() {
        int[] regHandle = new int[1];
        int rc = RfcTypeRegisterCpic.SAP_CMGETNEXTHDL(regHandle);
        if (rc == 0) {
            RfcIoOpenCntl cntl = null;
            if (regHandle[0] != -1) {
                IntHashTable<RfcIoOpenCntl> intHashTable = niHandles;
                synchronized (intHashTable) {
                    cntl = niHandles.get(regHandle[0]);
                }
                if (cntl == null) {
                    Trc.criticalTrace(null, "handle null for SAP_CMGETNEXTHDL(" + regHandle[0] + ")");
                }
            }
            return cntl;
        }
        Trc.criticalTrace(null, "rc " + rc + " from SAP_CMGETNEXTHDL");
        return null;
    }

    public static int waitForRequest(long timeout) {
        int rc = RfcTypeRegisterCpic.SAP_CMLISTEN((int)timeout);
        switch (rc) {
            case 10001: {
                return 7;
            }
            case 0: {
                return 4;
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        int rc = 0;
        if (!this.deallocated) {
            rc = this.CMDEAL();
            if (rc != 0) {
                Trc.criticalTrace(this.act_cntl, "Returned " + rc + " from CMDEAL");
            }
            this.deallocated = true;
        }
        this.readConvid = false;
        if (this.registered) {
            rc = this.SAP_CMUNREGTP3(this.reg_handle[0]);
            if (rc != 0) {
                Trc.criticalTrace(this.act_cntl, "Returned " + rc + " from SAP_CMUNREGTP3");
            }
            this.registered = false;
        }
        IntHashTable<RfcIoOpenCntl> intHashTable = niHandles;
        synchronized (intHashTable) {
            niHandles.remove(this.reg_handle[0]);
        }
        this.tOfLastIO = System.currentTimeMillis();
    }

    public synchronized void abort() {
        this.close();
    }

    public static int getNumServerConnections(RfcAcceptInfo acceptInfo) throws RfcException {
        RfcRegisterInfo register_info = (RfcRegisterInfo)acceptInfo;
        register_info.checkParameters();
        int[] numberRegTPs = RfcTypeRegisterCpic.execute_SAP_CMNOREGTP(register_info);
        return numberRegTPs[0];
    }

    public static GatewayRegInfo getGatewayRegInfo(RfcIoOpenCntl cntl) throws RfcException {
        GatewayRegInfo gwInfo = null;
        try {
            RfcTypeRegisterCpic rfcRegistered = (RfcTypeRegisterCpic)cntl.getChannel();
            int[] numberRegTPs = RfcTypeRegisterCpic.execute_SAP_CMNOREGTP(rfcRegistered.register_info);
            gwInfo = new GatewayRegInfo(numberRegTPs[0], numberRegTPs[1], numberRegTPs[2], numberRegTPs[3]);
        }
        catch (ClassCastException e) {
            gwInfo = null;
        }
        return gwInfo;
    }

    private static int[] execute_SAP_CMNOREGTP(RfcRegisterInfo regInfo) throws RfcException {
        int rc;
        int[] numberRegTPs = new int[4];
        String gwhost = regInfo.getGatewayHost();
        String sapRouter = regInfo.getSAPRouter();
        if (sapRouter != null && sapRouter.length() > 0) {
            StringBuilder gwhostBuf = new StringBuilder(256);
            gwhostBuf.append(sapRouter);
            if (!sapRouter.endsWith("/H/")) {
                gwhostBuf.append("/H/");
            }
            gwhostBuf.append(regInfo.getGatewayHost());
            gwhost = gwhostBuf.toString();
        }
        if ((rc = RfcTypeRegisterCpic.SAP_CMNOREGTP(regInfo.getProgramID(), gwhost, regInfo.getGatewayService(), numberRegTPs)) != 0) {
            String message = null;
            int group = 0;
            if (rc == 1) {
                message = "Error in JNI operation. See default error log";
                group = 108;
            } else {
                message = RfcTypeRegisterCpic.SAP_CMPERR();
                group = 102;
            }
            throw new RfcException(1, message, group, 0L, false, null);
        }
        return numberRegTPs;
    }
}

